// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ScLine.hh
//   System call line.
//   This is a struct.
//   This is a concrete class.
//
// File Created:	10 Apr 1995		Michael Chastain
// Last Reviewed:	15 Oct 1995		Michael Chastain
// Last Edited:		04 Nov 1995		Michael Chastain

#if !defined(SC_LINE_HH)
#define SC_LINE_HH

#include <MmScr.hh>
#include <MmType.hh>
#include <MsLine.hh>
#include <WhList.hh>

class	CxFetch;
class	EvBase;
class	EvSci;
class	PrProc;
class	WhString;



class	ScLine
{
    // Argument location.
    public:
	enum	TyArg
	{
	    tyArgMem,				// Args in memory.
	    tyArgNone,				// No args at all.
	    tyArgReg				// Args in registers.
	};

    // How to smash.
    public:
	enum	TySmash
	{
	    tySmashCant,			// Cannot smash.
	    tySmashDef,				// Default: r0 = -1.
	    tySmashFile,			// 'execve' 'uselib'.
	    tySmashMmap,			// 'mmap'.
	    tySmashMpi0,			// r0 = unsigned(-1) >> 1.
	    tySmashNop,				// No operation needed.
	    tySmashPair,			// r0 = -1, r1 = -1.
	    tySmashReplay,			// Must replay with same args.
	    tySmashWrite,			// 'write'.
	    tySmashZero				// r0 = 0.
	};

    // Datasets.
    public:
	enum	TyDs
	{
	    tyDsNone,				// No datasets.
	    tyDsExecve,				// Dataset for 'execve'.
	    tyDsUselib				// Dataset for 'uselib'.
	};

    // Typedefs for combiners.
    private:
	typedef void		FnFetch		( CxFetch &,
						  EvBase &	   );

    // Initializer.
    public:
	void			initFromSce	( MmWord, MmWord   );

    // String interface.
    public:
	void			fmtStrEvSci	( WhString &,
						  const EvSci &	   ) const;

    // Process interface.
    public:
	void			fetchSci	( const PrProc &,
						  bool &, bool &,
						  WhList<MmWord> & ) const;

	void			fetchSco	( const PrProc &, bool &,
						  WhList <MmWord> &,
						  WhList <MmWord> &,
						  MmScr &	   ) const;

	void			fetchSeg	( CxFetch &,
						  EvBase &	   ) const;

	void			fetchDs  	( CxFetch &,
						  EvBase &	   ) const;

	void			smashProc	( PrProc &, bool   ) const;

    // Instance data.
    private:
	const char *		pstrName_;	// Name of syscall.
	bool			fKnown_;	// Syscall is known.
	TyArg			tyArg_;		// Argument location.
	int			iArgArg_;	// Argument location.
	const char *		pstrTyArg_;	// Argument types.
	TySmash			tySmash_;	// How to smash.
	TyDs			tyDs_;		// Dataset type.
	MmScr::TyScr		tyScr_;		// Scr type.
	const MsLine *		plmsLine_;	// List of MsLine's.
	int			nmsLine_;	// # of MsLine's.
	FnFetch *		pfnFetchIn_;	// Fetch segins  (combiner).
	FnFetch *		pfnFetchOut_;	// Fetch segouts (combiner).
};



#endif
