// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: TraceArg.cc
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Feb 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#include <stdio.h>
#include <string.h>

#include <ErPtr.hh>
#include <TraceArg.hh>



// Constructor.
TraceArg::TraceArg( const char * argv [ ] )
    : fError_		( false		)
    , fHelp_		( false		)
    , strNameSelf_	(		)
    , strNameTrace_	( "x1.trace"	)
    , argv_		( argv		)
    , iargTarget_	( 0		)
{
    // Check arguments.
    if ( argv == 0 )
	ErPtr( );

    // Collect name.
    strNameSelf_.appStrRaw( argv[0] );

    // Collect flags.
    int iargFlag;
    for ( iargFlag = 1; argv[iargFlag] != 0; ++iargFlag )
    {
	// Grab the flag arg.
	const char * pcFlag = argv[iargFlag];

	// Recognize flags.
	if      ( ::strcmp( pcFlag, "--" ) == 0 ) { ++iargFlag; break;      }
	else if ( ::strcmp( pcFlag, "-h" ) == 0 ) { fHelp_    = true;       }
	else if ( ::strcmp( pcFlag, "-o" ) == 0 )
	{
	    if ( argv[++iargFlag] == 0 )
	    {
		fError_ = true;
		return;
	    }
	    else
	    {
		strNameTrace_ = WhString( argv[iargFlag] );
	    }
	}
	else if ( pcFlag[0] == '-' )
	{
	    fError_ = true;
	    return;
	}
	else
	{
	    break;
	}
    }

    // Record target arguments.
    iargTarget_ = iargFlag;

    // Require at least one more argument.
    if ( !fHelp_ && argv[iargFlag] == 0 )
	fError_ = true;
}



// Show usage.
void TraceArg::showUsage( const char * pcVersion ) const
{
    ::printf(
	"%.*s version %s (" __DATE__ ").\n"
	"Usage: %.*s [flags ...] program [argument ...]\n"
	"         -h           show this usage message\n"
	"         -o file      output to file (default 'x1.trace')\n"
	,
	getNameSelf( ).count( ), getNameSelf( ).address( ),
	pcVersion,
	getNameSelf( ).count( ), getNameSelf( ).address( ) );
}
