// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: TraceArg.hh
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Feb 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#if !defined(TRACE_ARG_HH)
#define TRACE_ARG_HH

#include <WhString.hh>



class	TraceArg
{
    // Constructor.
    public:
				TraceArg	( const char * [ ] );

    // Usage interface.
    public:
	void			showUsage	( const char *	   ) const;

    // Accessors.
    public:
	bool			isError		(		   ) const;
	bool			hasHelp		(		   ) const;
	const WhString &	getNameSelf	(		   ) const;
	const WhString &	getNameTrace	(		   ) const;
	const char * *		getTargetArgv	(		   ) const;

    // Instance data.
    private:
	bool			fError_;	// Args have error.
	bool			fHelp_;		// '-h'.
	WhString		strNameSelf_;	// Name of self.
	WhString		strNameTrace_;	// Name of trace file.
	const char * *		argv_;		// Original 'argv'.
	int			iargTarget_;	// First arg of target.
};



// Inline methods.

inline bool TraceArg::isError( ) const
{
    return fError_;
}

inline bool TraceArg::hasHelp( ) const
{
    return fHelp_;
}

inline const WhString & TraceArg::getNameSelf( ) const
{
    return strNameSelf_;
}

inline const WhString & TraceArg::getNameTrace( ) const
{
    return strNameTrace_;
}

inline const char * * TraceArg::getTargetArgv( ) const
{
    return argv_ + iargTarget_;
}



#endif
