// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: TySegLix.hh
//   Enumeration of all types of segments.
//
// Constraints:
//   These values are saved into files.
//   Their range must be dense (for fast validity checking).
//
// File Created:	10 Apr 1995		Michael Chastain
// Last Edited:		16 Nov 1995		Michael Chastain

#if !defined(TY_SEG_LIX_HH)
#define TY_SEG_LIX_HH



enum	TySegLix
{
	tySegNil		= 0,
	tySeg1MmByte,
	tySeg1Selection,
	tySeg4MmWord8,
	tySegAny,
	tySegArea,
	tySegArpreq,
	tySegArpreqOld,
	tySegAsyncStruct,
	tySegAudioBufInfo,
	tySegAx25ParmsStruct,
	tySegBrk,
	tySegCdromBlk,
	tySegCdromMsf,
	tySegCdromMultisession,
	tySegCdromReadAudio,
	tySegCdromSubchnl,
	tySegCdromTi,
	tySegCdromTocentry,
	tySegCdromTochdr,
	tySegCdromVolctrl,
	tySegConsolefontdesc,
	tySegCoprBuffer,
	tySegCoprDebugBuf,
	tySegCoprMsg,
	tySegCountInfo,
	tySegCycladesMonitor,
	tySegDirent,
	tySegFlock,
	tySegFloppyDriveParams,
	tySegFloppyDriveStruct,
	tySegFloppyFdcState,
	tySegFloppyMaxErrors,
	tySegFloppyRawCmd,
	tySegFloppyStruct,
	tySegFloppyWriteErrors,
	tySegFormatDescr,
	tySegHdDriveid,
	tySegHdGeometry,
	tySegIfconf,
	tySegIfreq,
	tySegIoctlCommand,
	tySegIpcKludge,
	tySegIpxConfigData,
	tySegItimerval,
	tySegKbdiacrs,
	tySegKbentry,
	tySegKbkeycode,
	tySegKbsentry,
	tySegListCdromFrame,
	tySegListDirent,
	tySegListExecAddr,
	tySegListGidT,
	tySegListIfreq,
	tySegListInsn,
	tySegListIovec,
	tySegListKernelSym,
	tySegListMmByte,
	tySegListMmShort,
	tySegListMmWord,
	tySegListSembuf,
	tySegListUnipair,
	tySegLpStats,
	tySegMasterConfig,
	tySegMidiInfo,
	tySegMmAddr,
	tySegMmByte,
	tySegMmByte8,
	tySegMmByte16,
	tySegMmByte48,
	tySegMmByte8192,
	tySegMmByteTabsz,
	tySegMmLoff,
	tySegMmShortTabsz,
	tySegMmWord,
	tySegMmWord2,
	tySegMmWord8,
	tySegModRoutines,
	tySegModifyLdtLdtS,
	tySegMpuCommandRec,
	tySegMsgbuf,
	tySegMsghdr,
	tySegMsginfo,
	tySegMsqidDs,
	tySegMtconfiginfo,
	tySegMtget,
	tySegMtop,
	tySegMtpos,
	tySegNewStat,
	tySegNewUtsname,
	tySegNrParmsStruct,
	tySegOldStat,
	tySegOldUtsname,
	tySegOldoldUtsname,
	tySegPatmgrInfo,
	tySegPidT,
	tySegPppCompStats,
	tySegPppIdle,
	tySegPppOptionData,
	tySegPppStats,
	tySegRlimit,
	tySegRtentry,
	tySegRusage,
	tySegSbiInstrument,
	tySegSccModem,
	tySegSccStat,
	tySegSemidDs,
	tySegSeminfo,
	tySegSemun,
	tySegSeqEventRec,
	tySegSerialMultiportStruct,
	tySegSerialStruct,
	tySegShmInfo,
	tySegShmidDs,
	tySegShminfo,
	tySegSigaction,
	tySegSigcontextStruct,
	tySegSigsetT,
	tySegSiocSgReq,
	tySegSiocVifReq,
	tySegSlaveConfig,
	tySegSlavingRequest,
	tySegSockaddrAx25,
	tySegStatfs,
	tySegStrCount,
	tySegStrNul,
	tySegSymbolTable,
	tySegSynthInfo,
	tySegSysinfo,
	tySegTermio,
	tySegTermios,
	tySegTimeT,
	tySegTimeval,
	tySegTimex,
	tySegTimezone,
	tySegTms,
	tySegTtyStruct,
	tySegUidT,
	tySegUmsdosIoctl,
	tySegUnimapdesc,
	tySegUnimapinit,
	tySegUstat,
	tySegUtimbuf,
	tySegVm86Struct,
	tySegVtConsize,
	tySegVtMode,
	tySegVtSizes,
	tySegVtStat,
	tySegWinsize
};



#endif
