// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhFlatIn.hh
//   Input buffer.
//   This is a concrete class.
//
// File Created:	25 Oct 1995		Michael Chastain
// Last Edited:		08 Nov 1995		Michael Chastain

#if !defined(WH_FLAT_IN)
#define WH_FLAT_IN

#include <MmType.hh>
#include <WhList.hh>

class	WhImage;
class	WhString;



class	WhFlatIn
{
    // Life cycle methods.
    public:
    				WhFlatIn	( char * &, int	   );
				WhFlatIn	( WhImage * &	   );
				~WhFlatIn	(		   );
	void			finalize	(		   );

    // Forbidden copiers.
    private:
    				WhFlatIn	( const WhFlatIn & );
	void			operator =	( const WhFlatIn & );

    // Accessors.
    public:
	int			countLeft	(		   ) const;
	bool			isAtEnd		(		   ) const;

    // Readers.
    public:
	void			getAddr		( MmAddr &	   );
	void			getBool		( bool &	   );
	void			getCcs		( const char * &   );
	void			getChar		( char &	   );
	void			getInt		( int &		   );
	void			getListChar	( WhList<char>   & );
	void			getListWord	( WhList<MmWord> & );
	void			getString	( WhString &	   );
	void			getWord		( MmWord &	   );

    // Instance data.
    private:
	int			icData_;	// Read position.
	const char *		pcData_;	// Address.
	int			ncData_;	// Count.
	char *			pcOwn_;		// Owned data.
	WhImage *		pimageOwn_;	// Owned image.
};



// Inline methods.

inline int WhFlatIn::countLeft( ) const
{
    return icData_ < ncData_ ? ncData_ - icData_ : 0;
}

inline bool WhFlatIn::isAtEnd( ) const
{
    return icData_ >= ncData_;
}



#endif
