// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhImage.hh
//   An mmap'ed image of a file.
//   This is an external resource handler class.
//
// File Created:	25 Oct 1995		Michael Chastain
// Last Edited:		29 Oct 1995		Michael Chastain

#if !defined(WH_IMAGE_HH)
#define WH_IMAGE_HH

#include <WhString.hh>



class	WhImage
{
    // Life cycle methods.
    public:
				WhImage		( const WhString & );
	bool			isError		(		   ) const;
	const WhString &	getError	(		   ) const;
				~WhImage	(		   );
	void			finalize	(		   );

    // Accessors.
    public:
	const char *		address		(		   ) const;
	int			count		(		   ) const;

    // Forbidden copiers.
    private:
				WhImage		( const WhImage &  );
	void			operator =	( const WhImage &  );

    // Instance data.
    private:
    	bool			fImage_;	// Is bound.
    	WhString		strError_;	// Error string.
    	int			fdImage_;	// File descriptor.
    	const char *		pcImage_;	// Address.
    	int			ncImage_;	// Count.
};



// Inline methods.

inline bool WhImage::isError( ) const
{
    return strError_.count( ) > 0;
}

inline const WhString & WhImage::getError( ) const
{
    return strError_;
}



#endif
