// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhList.hh
//   List template.
//   This is a template.
//
// File Created:	23 Jan 1994		Michael Chastain
// Last Reviewed:	24 Apr 1995		Michael Chastain
// Last Edited:		14 Nov 1995		Michael Chastain

#if !defined(WH_LIST_HH)
#define WH_LIST_HH

#include <ErRange.hh>



template <class T> class WhList
{
    // Life cycle methods.
    public:
				WhList		(		   );
				WhList		( const WhList<T>& );
	void			operator =	( const WhList<T>& );
				~WhList		(		   );

    // Accessors.
    public:
	const T &		operator []	( int		   ) const;
	const T *		address		(		   ) const;
	int			count		(		   ) const;

    // Mutators.
    public:
	T *			addrNonConst	(		   );
	void			clear		(		   );
	void			clear		( int		   );
	void			remove		( int		   );
	void			setCount	( int		   );

    // Appenders.
    public:
	void			appendArray	( const T *, int   );

	// g++ 2.6.3: compiler gives 'cannot inline' errors if I move this out.
	void			appendVal	( T data	   )
				{
				    if ( nData_ >= nDataMax_ )
					expand( 1 );
				    pData_[nData_] = data;
				    ++nData_;
				};

    // Helpers.
    private:
	void			expand		( int		   );

    // Instance data.
    private:
	int			nData_;		// # data items.
	int			nDataMax_;	// # items allocated.
	T *			pData_;		// The data.
};



// Inline methods.

template <class T> inline WhList<T>::WhList( )
    : nData_	( 0 )
    , nDataMax_	( 0 )
    , pData_	( 0 )
{
    ;
}

template <class T> inline const T & WhList<T>::operator [] ( int iData ) const
{
    if ( iData < 0 || iData >= nData_ )
	ErRange( );
    return pData_[iData];
}

template <class T> inline const T * WhList<T>::address( ) const
{
    return pData_;
}

template <class T> inline int WhList<T>::count( ) const
{
    return nData_;
}

template <class T> inline T * WhList<T>::addrNonConst( )
{
    return pData_;
}

template <class T> inline void WhList<T>::clear( )
{
    nData_ = 0;
}



#endif
