#include <stdio.h>
#include <string.h>
#include <ncurses.h>
#include "mkmk.h"

extern int lib;

void
init_curses()
{
  initscr();
  cbreak();
  noecho(); 
  wrefresh(stdscr);
}

void 
credits()
{
  printw("Mkmk %s (linux)\nCopyright 1993 Free Software Foundation, Inc...\n\n\n\n",VERSION);
}

void 
boundary_input(char *string, char *prompt,char *defaults, int ACCEPT_NONE, 
	       char *teststr)
{
  int curx,cury;
  int length=0;
  char x;
  
  curx=stdscr->_curx;
  cury=stdscr->_cury;
  move(3,0);
  clrtoeol();
  printw("%s", teststr);
  stdscr->_curx=curx;
  stdscr->_cury=cury;
  printw("[%s] (%s",prompt,defaults); 
  wrefresh(stdscr);
  
  insch(')'); 
  stdscr->_curx=stdscr->_curx-strlen(defaults);  
  wrefresh(stdscr);
  
  do
    {
      x=getch();
      switch (x)
	{
	case '\n':
	  if(length==0)
	    if((strcmp(defaults,"none"))==0 && ACCEPT_NONE)
	      {
		strcpy(string," ");
		stdscr->_curx=stdscr->_curx+strlen(defaults);   
		break;
	      }
	    else if(ACCEPT_NONE==0)
	      { 
		x=0; 
		break; 
	      } 

	    else
	      {
		strcpy(string,defaults);
		stdscr->_curx=stdscr->_curx+strlen(defaults);   
		break; 
	      }
	  break;
	case 127:
	  if (length)
	    {	  
	      clrtoeol();
	      stdscr->_curx=stdscr->_curx-1; 
	      delch();
	      insch(')');
	      string[length--]=0;
	      wrefresh(stdscr);
	    }
	  if(length%50==0 && length > 0)
	    {
	      delch();
	      stdscr->_cury=stdscr->_cury-1; 
	      stdscr->_curx=stdscr->_curx+50; 
	      insch(')'); 
	      wrefresh(stdscr);
	    }
	  break;
	default:
	  if(length==0)
	    {
	      clrtoeol();
	      wrefresh(stdscr);
	      string[length++]=x; 
	      string[length]=0;
	      insch(x); 
	      stdscr->_curx=stdscr->_curx+1; 
	      wrefresh(stdscr);
	      insch(')'); 
	      break; 
	    }   
	  if(length%50==0)
	    {	    
	      delch();
	      stdscr->_cury=stdscr->_cury+1;  
	      stdscr->_curx=stdscr->_curx-50; 
	      insch(')'); 
	      wrefresh(stdscr);
	    }

	  string[length++]=x; 
	  string[length]=0;
	  insch(x); 
	  stdscr->_curx=stdscr->_curx+1; 
	  break;
	}
    } while ((length < 1000)  && (x != '\n'));
  stdscr->_curx=stdscr->_curx+2; 
  printw("\n");
  wrefresh(stdscr);
}



