#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 2001 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fhist -nk functionality
#

work=/tmp/$$
PAGER=cat
export PAGER

no_result()
{
	set +x
	echo 'NO RESULT test of the fhist -nk functionality' 1>&2
	cd $here
	rm -rf $work
	exit 2
}
fail()
{
	set +x
	echo 'FAILED test of the fhist -nk functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the fhist -nk functionality
#
# The file should be the same when it is checked out as when it went in.
#
cat > test.in << 'fubar'
/*
 * Delete - program to delete files
 * [# Edit, Date #]
 */
fubar
if test $? -ne 0 ; then no_result; fi
$bin/fhist -nk -cr test.in -mkp -r
if test $? -ne 0 ; then fail; fi
$bin/fhist -nk test.in -o test.out
if test $? -ne 0 ; then fail; fi

diff test.in test.out
if test $? -ne 0 ; then fail; fi

rm -r FHIST test.out
if test $? -ne 0 ; then no_result; fi


#
# As a double-check, test the fhist keyword functionality.  The file
# should be the different when it is checked out than when it went in.
#
$bin/fhist -cr test.in -mkp -r
if test $? -ne 0 ; then fail; fi
$bin/fhist test.in -o test.out
if test $? -ne 0 ; then fail; fi

diff test.in test.out > LOG 2>&1
if test $? -ne 1 ; then cat LOG; fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
