/*
 * k_compat.h -- A header file containing definitions to allow the driver
 * that links with it to be backward and forward compatable with a number
 * of linux kernels.
 *
 * Copyright (c) 1999 The Laitram Corporation
 *
 * This file allows the SST-5136-DN driver, written by Mark Sutton
 * and Copyright (c) The Laitram Corporation to compile and run
 * without modification across a range of Linux kernel versions.
 *
 * It is a derivitave work of a similar file contained in the
 * Linux pcmcia-cs distribution by David Hinds <dhinds@hyper.stanford.edu>.
 * Copyright (c) David A. Hinds
 * 
 * The Linux pcmcia-cs package is covered under the Mozilla Public
 * License, the text of which can be found at:
 * http://www.mozilla.org/MPL/
 *
 * Since this file is so heavily derived from that file, it is also
 * covered under the Mozilla Public License.
 *
 * The entire remainder of the ss5136dn package is covered under the
 * GNU Library General Public License, as outlined in other files
 * the ss5136dn distribution.
 */

#include "kernelversioninfo.h"

#define VERSION(v,p,s)		(((v)<<16)+(p<<8)+s)

#include<asm/segment.h>
#undef get_user

#if (LINUX_VERSION_CODE < VERSION(2,1,4)) && !defined(__alpha__)
#define FS_SIZE_T		int
#define U_FS_SIZE_T		int
#else
#if (LINUX_VERSION_CODE < VERSION(2,1,60))
#define FS_SIZE_T		long
#define U_FS_SIZE_T		unsigned long
#else
#define FS_SIZE_T		ssize_t
#define U_FS_SIZE_T		size_t
#endif
#endif
#if (LINUX_VERSION_CODE < VERSION(2,1,31))
#define FS_RELEASE_T		void
#else
#define FS_RELEASE_T		int
#endif

#if (LINUX_VERSION_CODE < VERSION(2,1,0))
#define copy_from_user		memcpy_fromfs
#define copy_to_user		memcpy_tofs
#else
#include <asm/uaccess.h>
#endif

#if (LINUX_VERSION_CODE < VERSION(2,1,45))
#define F_INODE(file)		((file)->f_inode)
#else
#define F_INODE(file)		((file)->f_dentry->d_inode)
#endif

#if (LINUX_VERSION_CODE < VERSION(2,1,60))
#define IRQ_MAP(irq, dev)	irq2dev_map[irq] = dev
#define FOPS(i,f,b,c,p)		(i,f,b,c)
#define FPOS			(file->f_pos)
#else
#define IRQ_MAP(irq, dev)	while (0)
#define FOPS(i,f,b,c,p)		(f,b,c,p)
#define FPOS			(*ppos)
#endif

#if (LINUX_VERSION_CODE > VERSION(2,1,117))
#define NULL_FLUSH              NULL,
#else
#define NULL_FLUSH
#endif

#if (LINUX_VERSION_CODE < VERSION(2,2,0))
#define SS5136DN_MAJOR 120
#else
#define SS5136DN_MAJOR 183
#endif

