/*
 * ss5136dn.h -- Linux device driver for the S.S Technologies 5136-DN ISA bus
 * CAN-Network interface card.  Header file: Version 1.3.
 *
 * Copyright (c) 1997,1998, 1999, 2000 The Laitram Corporation.
 * All rights reserved.
 *
 * Author: Mark Sutton (mes)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details. It is contained in
 * the file "COPYING" in the root directory of this distribution.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * Revision history:
 * -Initial writing (Version 0.01) May 5, 1997 (mes)
 * -Allow easy selection of 16k or 32k card memory aperature (Version 0.02)
 *  May 15, 1997 (mes)
 * -Give user level hook to do a hard reset of the card (Version 0.03)
 *  May 15, 1997 (mes)
 *
 * Version 0.04 Placed driver and user level code under the LGPL.
 * Added functions for deallocation and "tidy" of card memory to allow
 * dynamic re-assignment of card memory while running.
 * June 29, 1998. (mes)
 *
 * Version 0.05 Fixed bug that caused 5136-DN-PRO board to not work reliably.
 * Added capability to module loader to load encrypted modules.  Driver
 * now identifies whether board is a standard or a "pro" and adjusts some
 * paramaters slightly for the different boards.  User code can poll for what
 * type of board is installed.
 * July 21, 1998 (mes)
 *
 * Version 1.0 Cleaned up module loader based on new information from
 * engineers at SST.  Added the folowing programs to package:  devset (for
 * software setting macid and baud rate on devices), devqry (for quering a
 * device about it's input and output size and other paramaters), and 
 * devwho (for finding all devices on a network).
 * October 23, 1998 (mes)
 *
 * Version 1.1 Added a PCMCIA driver to the package.
 * January 7, 1999 (mes)
 *
 * Version 1.2 Modified to run correctly on 2.2.x kernels as well as 2.0.x
 * Should also compile and run correctly on 2.1.x series kernels.
 * March 5, 1999 (mes)
 * 
 * Version 1.3 Changed Major Number of device since SUSE inadvertantly usurped
 * the major number 144 for Encapsulated PPP.
 * Made a fix for determining kernel version when kernel version number has
 * a "-" in it.  Eg. RedHat 6.1 comes with 2.2.12-20.
 * March 14, 2000
 */

/* General-Purpose #defines */

#define SS5136DN_VERSION "1.3"

/* #define SS5136DN_WINDOW32K   */

#define CANDECRYPT

/*-----------------------------------------------------
    5136-DN hardware definitions
-----------------------------------------------------*/

#define SS5136DN_PORTBASE 0x250 /* This one has to match card switches */
#define SS5136DN_MEMBASE 0xd0000 /* This one is "PNP", driver attempts to set this.  DOES NOT test for conflict, however */

/* control/status register offsets (from base I/O port)  */
#define BCR0 0
#define BCR1 1
#define BCR2 2
#define BCR7 7

/* BCR0 register bits */
#define IRQV40 1
#define NOVPOLL 2
#define PCINT 4
#define IRQENA 8
#define BANKSEL 0x70
#define BANKSELMASK 0x8fu
#define MEMENABLE 0x80u
#define SS5136DN_PAGEMASK BANKSELMASK
#define SS5136DN_MEMENABLEMASK MEMENABLE
#define SS5136DN_CINTMASK IRQV40

/* BCR1 register bits  */
#define MEMSEL 0x1f
#define MEMSELMASK 0xe0u
#define WORDACCESS 0x40
#define WIN16K 0x80u

/* BCR2 register bits  */
#define INTSEL 7
#define INTSELMASK 0xf8u
#define LEDOFF 0x20
#define WDINHIBIT 0x40
#define V40RUN 0x80u
#define SS5136DN_PROCENABLEMASK V40RUN
#define SS5136DN_WDENABLEMASK WDINHIBIT
#define SS5136DN_HLTHMASK LEDOFF

/* other hardware constants  */
#define PORTMIN 0x200
#define PORTMAX 0x3f8
#define SEGMIN 0x8000u
#define SEGMAX 0xf800u
#define NOIRQ 0
#define IRQMIN 2
#define IRQMAX 7
#ifdef SS5136DN_WINDOW32K
#define PAGESIZEINBYTES 0x8000
#define PAGESIZEINSHORTS 0x4000
#define PAGESIZEINWORDS 0x2000
#define MAXPAGES 3
#else
#define PAGESIZEINBYTES 0x4000
#define PAGESIZEINSHORTS 0x2000
#define PAGESIZEINWORDS 0x1000
#define MAXPAGES 7
#endif
/* Application module values  */

#define DN 0x4e44
#define ER 0x5245
#define PRO 2
#define REGULAR 1

/* Application module locations */

#ifdef SS5136DN_WINDOW32K
#define DATA_BASE 0x4000
#define APPINTPAGE 1
#else
#define DATA_BASE 0
#define APPINTPAGE 3
#endif
#define MODULE_TYPE 0
#define PAGE_SIZE_LOCATION 2
#define MESSAGE 0X40

/* Driver status bits */

#define SS5136DN_BUSY 1

/* Device specific error codes */

#define EBADORIGIN 200
#define ECARDMEMOUTOFRANGE 201

/* IOCTL definitions */

#include <linux/ioctl.h>

#define SS5136DN_WRITEREG _IOW('x', 1, void *)
#define SS5136DN_READREG _IOR('x', 1, void *)
#define SS5136DN_MEMENABLE _IOW('x', 2, void)
#define SS5136DN_MEMDISABLE _IOW('x', 3, void)
#define SS5136DN_PROCENABLE _IOW('x', 4, void)
#define SS5136DN_PROCDISABLE _IOW('x', 5, void)
#define SS5136DN_STROBECINT _IOW('x', 6, void)
#define SS5136DN_PAGECHANGE _IOW('x', 7, long)
#define SS5136DN_WDENABLE _IOW('x', 8, void)
#define SS5136DN_WDDISABLE _IOW('x', 9, void)
#define SS5136DN_HLTHRED _IOW('x', 10, void)
#define SS5136DN_HLTHGREEN _IOW('x', 11, void)
#define SS5136DN_SETCARDMEMPTR _IOW('x', 12, void)
#define SS5136DN_SHUTDOWN _IOW('x', 13, void)
#define SS5136DN_CLINT _IOW('x', 14, void)
#define SS5136DN_BIGRESET _IOW('x', 15, void)
#define SS5136DN_REPORT_APERATURE _IOW('x', 16, void)
#define SS5136DN_REPORT_CARDTYPE _IOW('x', 17, void)

/* Typedefs */

typedef struct
{
  unsigned char value;
  unsigned short port;
} portiopair;

