/*
 * devset.c -- A simple utility used to reset the macid or baud rate of a
 * devicenet device.
 *
 * Copyright (c) 1997,1998 The Laitram Corporation.
 * All rights reserved.
 *
 * Author: Mark Sutton (mes)
 *
 * NOTE: The structures "DNS_SCANNER_CFG" and "DNS_DEVICE_CFG" and a number
 * of constants, are taken from example code Written by Geoff Jones and 
 * Copyright (c) 1996 S-S Technologies Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details. It is contained in
 * the file "COPYING" in the root directory of this distribution.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 *  Version 1.2
 *  July 13, 1999 (mes)
 *
 */

/* #define DEBUG  */

#include <stdio.h>
#include <fcntl.h>
#include <sys/termios.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>

#include "../ss5136dn.h"
#include "dnuser.h"
#ifdef DEBUG
FILE * dbgfile;
#endif

extern int dni;
extern DNS_SCANNER_CFG ScannerCfg;
extern DNS_DEVICE_CFG DeviceCfg;
extern cardmemel * CardMemHead, * curmemp;

/* List of device configs, must malloc each one, use macid for index */
extern DNS_DEVICE_CFG * DevicesList[64];

int main()
{

  unsigned short scannerspeed = BAUD500K;
  unsigned short scannermak = 0;
  unsigned short newbaud;
  int intrback,foo,i,inmac,cardtype;
  unsigned int newmac,ocdmask1,ocdmask2;
  unsigned char devin1,devin2,devin3,devin4;
  unsigned char stata,statb;
  unsigned short smcout,bktmpin1,bktmpin2,queuein,queueout;
  float bktemperature;
  unsigned int festoout;
  char dstatus,fooch,incommand[200],choice[200];
  char inflags,outflags;
  short tmpsht;
  explicit_request ereq;
  explicit_response eresp;

  if((dni = open("/dev/ss5136dn0", O_RDWR)) < 0) {
    printf("Open device failed value returned was %i\n",dni);
    exit(-1);
  }

  if ((ioctl(dni,SS5136DN_REPORT_APERATURE)) != PAGESIZEINBYTES) {
    printf("There is a memory aperature mismatch between the driver and this program! \n");
    printf("Recompile either this program or the driver so that the settings match!\n");
    exit(-1);
  }
  for (i=0;i<64;i++)
    {
      DevicesList[i]=NULL;
    }
  cardtype = ioctl(dni,SS5136DN_REPORT_CARDTYPE);
  if (cardtype == PRO)
    {
      if (PAGESIZEINBYTES == 0x8000) {
	if ((ldappmod32p("dnscan.ss2")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
      else {
	if ((ldappmod16p("dnscan.ss2")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
    }
  else
    {
      if (PAGESIZEINBYTES == 0x8000) {
	if ((ldappmod32p("dnscan.ss1")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
      else {
	if ((ldappmod16p("dnscan.ss1")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
    }
  initCardMemList();

  printf("Enter the macid for the scanner (default 0): ");
  gets(choice);
  sscanf(choice,"%i",&inmac);
  if ((inmac < 0) || (inmac > 63)) 
    {
      scannermak = 0;
    }
  else
    {
      scannermak = (unsigned char)inmac;
    }
  printf("Using macid %i \n",(int)scannermak);
  printf("Enter the baud rate to use (125, 250, or default=500): ");
  gets(choice);
  if (strstr(choice,"500")) scannerspeed = BAUD500K;
  if (strstr(choice,"250")) scannerspeed = BAUD250K;
  if (strstr(choice,"125")) scannerspeed = BAUD125K;
  printf("Using a baud rate of ");
  if (scannerspeed == BAUD500K) printf("500 kbaud.\n");
  if (scannerspeed == BAUD250K) printf("250 kbaud.\n");
  if (scannerspeed == BAUD125K) printf("125 kbaud.\n");
  foo=GoOnline(scannermak,scannerspeed);
  printf("GoOnline returned %x\n",foo);
  foo=StartScan();
  printf("StartScan returned %x\n",foo);
  /*  foo=IOActive();
  printf("IOActive returned %x\n",foo);
  */

  printf("Enter the macid of the device to set: ");
  scanf("%i",&inmac);
  printf("Quering macid %i\n",inmac);

  (void *)DevicesList[inmac]=malloc(sizeof(DNS_DEVICE_CFG));
  
  (*DevicesList[inmac]).MacId = (unsigned short)inmac;
  (*DevicesList[inmac]).VendorId = 0;
  (*DevicesList[inmac]).DeviceType = 0; 
  (*DevicesList[inmac]).ProductCode = 0;
  (*DevicesList[inmac]).Reserved1 = 0;
  (*DevicesList[inmac]).Reserved2 = 0;
  (*DevicesList[inmac]).Reserved3 = 0;
  /* enable poll and strobe connections */
  (*DevicesList[inmac]).Flags = DNS_EXP;
  (*DevicesList[inmac]).ExplicitSize = 16;
  (*DevicesList[inmac]).ExplicitOffset = allocCardMem(16);
  (*DevicesList[inmac]).Io1Interval = 0;
  /* poll request size  */
  (*DevicesList[inmac]).Output1Size = 0;
  /* poll request Offset */
  (*DevicesList[inmac]).Output1Offset = 0;
  (*DevicesList[inmac]).Output1LocalPathOffset = 0;
  (*DevicesList[inmac]).Output1RemotePathOffset = 0;
  /* poll response size */
  (*DevicesList[inmac]).Input1Size = 0; 
  /* poll response offset */
  (*DevicesList[inmac]).Input1Offset = 0;
  (*DevicesList[inmac]).Input1LocalPathOffset = 0;
  (*DevicesList[inmac]).Input1RemotePathOffset = 0;
  (*DevicesList[inmac]).Io2Interval = 0;
  /* strobe request size */
  (*DevicesList[inmac]).Output2Size = 0;
  /* strobe request offset */
  (*DevicesList[inmac]).Output2Offset = 0;
  (*DevicesList[inmac]).Output2LocalPathOffset = 0;
  (*DevicesList[inmac]).Output2RemotePathOffset = 0;
  /* strobe response size */
  (*DevicesList[inmac]).Input2Size = 0;
  /* strobe response Offset */
  (*DevicesList[inmac]).Input2Offset = 0;
  (*DevicesList[inmac]).Input2LocalPathOffset = 0;
  (*DevicesList[inmac]).Input2RemotePathOffset = 0;

  foo=AddDevice(DevicesList[inmac],0);
  if (foo != 0)
    {
      printf("Unable to scan device %i\n",inmac);
      exit(0);
    }

  foo=GetDevice(DevicesList[inmac]);

  printf("Vendor ID of device %i = %x\n",inmac,(*DevicesList[inmac]).VendorId);
  printf("Device type of device %i = %x\n",inmac,(*DevicesList[inmac]).DeviceType);
  printf("Product Code of device %i = %x\n",inmac,(*DevicesList[inmac]).ProductCode);
  foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(CONTROLTOP+(inmac*DCONSIZE)));
  foo=read(dni,&inflags,1);
  outflags = inflags | DCTL_EXPITRLCK;
  foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(CONTROLTOP+(inmac*DCONSIZE)));
  foo=write(dni,&outflags,1);

  newbaud = 10;
  printf("Pick the parameter to set: \n");
  printf("b = baud rate, m = macid.  \no = Open circuit detection (InterlinkBT IM-16-0053 only) \nEnter choice: ");
  gets(incommand);
  gets(incommand);
  switch(incommand[0]){
  case 'b':
    do
      {
	printf("Enter the new baud rate for device %i: ",inmac);
	gets(choice);
	if (strstr(choice,"500")) newbaud = BAUD500K;
	if (strstr(choice,"250")) newbaud = BAUD250K;
	if (strstr(choice,"125")) newbaud = BAUD125K;
	if (newbaud == 10)
	  {
	    printf("Baud rate must be 500, 250, or 125.\n");
	  }
      } while(newbaud == 10);

    ereq.ExplicitSize=0x2;
    ereq.ExplicitService=0x10;
    ereq.ExplicitClass=0x3;
    ereq.ExplicitInstance=1;
    ereq.ServiceData[0]=2;
    ereq.ServiceData[1]=newbaud;

    foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);

    if (eresp.ExplicitService != 0x90)
      {
	printf("Baud rate reset unsuccessfull.\n");
      }
    else
      {
	printf("Baud rate reset successfull.\n");
      }
    break;
  case 'm':
    do
      {
	printf("Enter the new macid for (old) %i: ",inmac);
	scanf("%i",&newmac);
	if ((newmac < 0) || (newmac > 63) || (newmac == scannermak))
	  {
	    printf("Macid must be between 0 and 63 and not the same as the scanner!\n");
	  }
      } while((newmac < 0) || (newmac > 63) || (newmac == scannermak));

    ereq.ExplicitSize=0x2;
    ereq.ExplicitService=0x10;
    ereq.ExplicitClass=0x3;
    ereq.ExplicitInstance=1;
    ereq.ServiceData[0]=1;
    ereq.ServiceData[1]=(unsigned char)newmac;

    foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);

    if (eresp.ExplicitService != 0x90)
      {
	printf("Macid reset unsuccessfull.\n");
      }
    else
      {
	printf("Macid reset successfull.\n");
      }
    break;
  case 'o':
    do {
      printf("Please enter two masks in hex to represent which bits you want to have \n");
      printf("open circuit detection turned on for for each word on the input block.  \n0 = OCD on, 1 = OCD off, for example,\nto turn OCD off for all bits \nenter ff\n");
      printf("Enter first half mask (hex): ");
      scanf("%x",&ocdmask1);
      if ((ocdmask1 < 0) || (ocdmask1 > 0xff))
	{
	  printf("Invalid mask.\n");
	}
    } while ((ocdmask1 < 0) || (ocdmask1 > 0xff));
    do {
      printf("Enter second half mask (hex): ");
      scanf("%x",&ocdmask2);
      if ((ocdmask2 < 0) || (ocdmask2 > 0xff))
	{
	  printf("Invalid mask.\n");
	}
    } while ((ocdmask2 < 0) || (ocdmask2 > 0xff));
    ereq.ExplicitSize=0x3;
    ereq.ExplicitService=0x10;
    ereq.ExplicitClass=0x4;
    ereq.ExplicitInstance=25;
    ereq.ServiceData[0]=0x65;
    ereq.ServiceData[1]=(unsigned char)ocdmask1;
    ereq.ServiceData[2]=(unsigned char)ocdmask2;

    foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);

    break;
  default:
    printf("That is not a valid selection.\n");
    break;
  }

  /*  tmpsht=inmac;
      foo=DeleteDevice(&tmpsht);  */
  foo=StopScan();
  foo=GoOffline();
  CleanupCardMemList();
}









