/*
 * devwho.c -- This program attempts to find all devices on a devicenet
 * network that support polled I/O (the most common type).  It then can
 * bring them on line and let you communicate with them.
 *
 * Copyright (c) 1997,1998 The Laitram Corporation.
 * All rights reserved.
 *
 * Author: Mark Sutton (mes)
 *
 * NOTE: The structures "DNS_SCANNER_CFG" and "DNS_DEVICE_CFG" and a number
 * of constants, are taken from example code Written by Geoff Jones and 
 * Copyright (c) 1996 S-S Technologies Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details. It is contained in
 * the file "COPYING" in the root directory of this distribution.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 *  Version 1.2
 *  March 9, 1999 (mes)
 *
 */

/* #define DEBUG  */

#include <stdio.h>
#include <fcntl.h>
#include <sys/termios.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>

#include "../ss5136dn.h"
#include "dnuser.h"
#ifdef DEBUG
FILE * dbgfile;
#endif

extern int dni;
extern DNS_SCANNER_CFG ScannerCfg;
extern DNS_DEVICE_CFG DeviceCfg;
extern cardmemel * CardMemHead, * curmemp;

/* List of device configs, must malloc each one, use macid for index */
extern DNS_DEVICE_CFG * DevicesList[64];

int main()
{

  unsigned short scannerspeed = BAUD500K;
  unsigned short scannermak = 0;
  int intrback,foo,i,inmac,cardtype,outint,lowermac,uppermac,bitno,wordno;
  unsigned char devin1,devin2,devin3,devin4,outbyte,bitmask;
  unsigned char stata,statb;
  unsigned short smcout,bktmpin1,bktmpin2,queuein,queueout;
  float bktemperature;
  unsigned int festoout;
  char dstatus,fooch,incommand[200],choice[200];
  char inflags,outflags;
  short tmpsht;
  explicit_request ereq;
  explicit_response eresp;

  if((dni = open("/dev/ss5136dn0", O_RDWR)) < 0) {
    printf("Open device failed value returned was %i\n",dni);
    exit(-1);
  }

  if ((ioctl(dni,SS5136DN_REPORT_APERATURE)) != PAGESIZEINBYTES) {
    printf("There is a memory aperature mismatch between the driver and this program! \n");
    printf("Recompile either this program or the driver so that the settings match!\n");
    exit(-1);
  }
  for (i=0;i<64;i++)
    {
      DevicesList[i]=NULL;
    }
  cardtype = ioctl(dni,SS5136DN_REPORT_CARDTYPE);
  if (cardtype == PRO)
    {
      if (PAGESIZEINBYTES == 0x8000) {
	if ((ldappmod32p("dnscan.ss2")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
      else {
	if ((ldappmod16p("dnscan.ss2")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
    }
  else
    {
      if (PAGESIZEINBYTES == 0x8000) {
	if ((ldappmod32p("dnscan.ss1")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
      else {
	if ((ldappmod16p("dnscan.ss1")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
    }
  initCardMemList();

  printf("Enter the macid for the scanner (default 0): ");
  gets(choice);
  sscanf(choice,"%i",&inmac);
  if ((inmac < 0) || (inmac > 63)) 
    {
      scannermak = 0;
    }
  else
    {
      scannermak = (unsigned char)inmac;
    }
  printf("Using macid %i \n",(int)scannermak);
  printf("Enter the baud rate to use (125, 250, or default=500): ");
  gets(choice);
  if (strstr(choice,"500")) scannerspeed = BAUD500K;
  if (strstr(choice,"250")) scannerspeed = BAUD250K;
  if (strstr(choice,"125")) scannerspeed = BAUD125K;
  printf("Using a baud rate of ");
  if (scannerspeed == BAUD500K) printf("500 kbaud.\n");
  if (scannerspeed == BAUD250K) printf("250 kbaud.\n");
  if (scannerspeed == BAUD125K) printf("125 kbaud.\n");
  foo=GoOnline(scannermak,scannerspeed);
  printf("GoOnline returned %x\n",foo);
  foo=StartScan();
  printf("StartScan returned %x\n",foo);

  printf("Enter the lowest macid to check (default 0): ");
  gets(choice);
  sscanf(choice,"%i",&lowermac);
  if ((lowermac < 0) || (lowermac > 63)) 
    {
      lowermac = 0;
    }
  printf("Enter the highest macid to check (default 15): ");
  gets(choice);
  sscanf(choice,"%i",&uppermac);
  if ((uppermac < 0) || (uppermac > 63)) 
    {
      uppermac = 15;
    }
  
  for (inmac=lowermac;inmac<=uppermac;inmac++)
    {
      if (inmac != scannermak)
	{
	  printf("Quering macid %i\n",inmac);
      
	  (void *)DevicesList[inmac]=malloc(sizeof(DNS_DEVICE_CFG));
      
	  (*DevicesList[inmac]).MacId = (unsigned short)inmac;
	  (*DevicesList[inmac]).VendorId = 0;
	  (*DevicesList[inmac]).DeviceType = 0; 
	  (*DevicesList[inmac]).ProductCode = 0;
	  (*DevicesList[inmac]).Reserved1 = 0;
	  (*DevicesList[inmac]).Reserved2 = 0;
	  (*DevicesList[inmac]).Reserved3 = 0;
	  /* enable explicit message connections */
	  (*DevicesList[inmac]).Flags = DNS_EXP;
	  (*DevicesList[inmac]).ExplicitSize = 16;
	  (*DevicesList[inmac]).ExplicitOffset = allocCardMem(16);
          (*DevicesList[inmac]).Io1Interval = 0;
	  /* poll request size  */
	  (*DevicesList[inmac]).Output1Size = 0;
	  /* poll request Offset */
	  (*DevicesList[inmac]).Output1Offset = 0;
          (*DevicesList[inmac]).Output1LocalPathOffset = 0;
	  (*DevicesList[inmac]).Output1RemotePathOffset = 0;
	  /* poll response size */
	  (*DevicesList[inmac]).Input1Size = 0; 
	  /* poll response offset */
	  (*DevicesList[inmac]).Input1Offset = 0;
	  (*DevicesList[inmac]).Input1LocalPathOffset = 0;
	  (*DevicesList[inmac]).Input1RemotePathOffset = 0;
	  (*DevicesList[inmac]).Io2Interval = 0;
	  /* strobe request size */
	  (*DevicesList[inmac]).Output2Size = 0;
	  /* strobe request offset */
	  (*DevicesList[inmac]).Output2Offset = 0;
	  (*DevicesList[inmac]).Output2LocalPathOffset = 0;
	  (*DevicesList[inmac]).Output2RemotePathOffset = 0;
	  /* strobe response size */
	  (*DevicesList[inmac]).Input2Size = 0;
	  /* strobe response Offset */
	  (*DevicesList[inmac]).Input2Offset = 0;
	  (*DevicesList[inmac]).Input2LocalPathOffset = 0;
	  (*DevicesList[inmac]).Input2RemotePathOffset = 0;

	  foo=AddDevice(DevicesList[inmac],0);
	  if (foo != 0)
	    {
	      printf("Unable to scan device %i\n",inmac);
	      (*DevicesList[inmac]).ExplicitSize = 0;
	      foo = deallocCardMem((*DevicesList[inmac]).ExplicitOffset);
	      free(DevicesList[inmac]);
	      (DevicesList[inmac])=NULL;
	    }
	  else
	    {
	      foo=GetDevice(DevicesList[inmac]);
	  
	      printf("Vendor ID of device %i = %x\n",inmac,(*DevicesList[inmac]).VendorId);
	      printf("Device type of device %i = %x\n",inmac,(*DevicesList[inmac]).DeviceType);
	      printf("Product Code of device %i = %x\n",inmac,(*DevicesList[inmac]).ProductCode);
	      foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(CONTROLTOP+(inmac*DCONSIZE)));
	      foo=read(dni,&inflags,1);
	      outflags = inflags | DCTL_EXPITRLCK;
	      foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(CONTROLTOP+(inmac*DCONSIZE)));
	      foo=write(dni,&outflags,1);
	  
	      /*  Begin block to query for polled input  */
	      ereq.ExplicitSize=0x2;
	      ereq.ExplicitService=0x4b;
	      ereq.ExplicitClass=0x3;
	      ereq.ExplicitInstance=1;
	      ereq.ServiceData[0]=2;
	      ereq.ServiceData[1]=scannermak;
	      
	      /*  printf("Sending master/slave connection request.\n");  */
	      foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);
	      if (eresp.ExplicitService != 0xcb)
		{
		  printf("This device does not support polled I/O.\n");
		  (*DevicesList[inmac]).Output1Size = 0;
		  (*DevicesList[inmac]).Input1Size = 0;
		}
	      else
		{
		  ereq.ExplicitSize=1;
		  ereq.ExplicitService=0x0e;
		  ereq.ExplicitClass=0x5;
		  ereq.ExplicitInstance=2;
		  ereq.ServiceData[0]=7;
		  
		  foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);
	      
		  if (eresp.ExplicitService != 0x8e)
		    {
		      printf("This device does not support polled input.\n");
		      (*DevicesList[inmac]).Input1Size = 0;
		    }
		  else
		    {
		      printf("This device reports that it has %x bytes of polled input.\n",(int)eresp.ServiceData[0]);
		      (*DevicesList[inmac]).Input1Size = (unsigned short)eresp.ServiceData[0];		  
		    }
		  ereq.ExplicitSize=1;
		  ereq.ExplicitService=0x0e;
		  ereq.ExplicitClass=0x5;
		  ereq.ExplicitInstance=2;
		  ereq.ServiceData[0]=8;
	      
		  foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);
	      
		  if (eresp.ExplicitService != 0x8e)
		    {
		      printf("This device does not support polled output.\n");
		      (*DevicesList[inmac]).Output1Size = 0;
		    }
		  else
		    {
		      printf("This device reports that it has %x bytes of polled output.\n",(int)eresp.ServiceData[0]);
		      (*DevicesList[inmac]).Output1Size = (unsigned short)eresp.ServiceData[0];
		    }
		}
	      ereq.ExplicitSize=1;
	      ereq.ExplicitService=0x4c;
	      ereq.ExplicitClass=0x3;
	      ereq.ExplicitInstance=1;
	      ereq.ServiceData[0]=2;
	      
	      foo = sendDeviceExplicit(0,inmac,&ereq,&eresp);
	    }
	}
      else
	{
	  printf("Skipping Scanner's macid, %i\n",inmac);
	}
    }
  /* End block to query for polled input  */
  printf("Summary: \n");
  printf("Devices supporting polled I/O found at: \n");
  for (inmac=lowermac;inmac<=uppermac;inmac++)
    {
      if (((DevicesList[inmac])!=NULL) && (inmac != scannermak)) printf(" %i ",inmac);
    }
  printf("\n");
  printf("Begin scanning all active devices (y, n)?: ");
  gets(choice);
  if ((choice[0] == 'Y') || (choice[0] == 'y'))
    {
      for (inmac=lowermac;inmac<=uppermac;inmac++)
	{
	  if(((DevicesList[inmac])!=NULL) && (inmac != scannermak))
	     {
	       tmpsht = (unsigned short)inmac;
	       foo = RemoveDevice(&tmpsht);
	       (*DevicesList[inmac]).Flags = DNS_P;
	       (*DevicesList[inmac]).ExplicitSize = 0;
	       foo = deallocCardMem((*DevicesList[inmac]).ExplicitOffset);
	       if ((*DevicesList[inmac]).Output1Size > 0)
		 {
		   (*DevicesList[inmac]).Output1Offset = allocCardMem((*DevicesList[inmac]).Output1Size);
		    foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[inmac]).Output1Offset));
		    outbyte = 0;
		    for (i=0;i<(*DevicesList[inmac]).Output1Size;i++)
		      {
			foo=write(dni,&outbyte,1);
		      }
		 }
	       if ((*DevicesList[inmac]).Input1Size > 0)
		 {
		   (*DevicesList[inmac]).Input1Offset = allocCardMem((*DevicesList[inmac]).Input1Size);
		 }
	       foo = AddDevice(DevicesList[inmac],0); 
	     }
	}
      printf("Effect devices at a bit level or a byte level?\n");
      printf("1 = bit, >1 = byte (choice): ");
      gets(choice);
      sscanf(choice,"%i",&foo);
      if (foo >1)
	{
	  do
	    {
	      printf("Enter the macid of the device to affect ( >63 to quit): ");
	      gets(choice);
	      sscanf(choice,"%i",&inmac);
	      if (inmac > 63) exit(0);
	      if (inmac < 0) exit(0);
	      if (DevicesList[inmac] != NULL)
		{
		  printf("'r' = read the inputs, 'w' = write to the outputs\n");
		  printf("Select: ");
		  gets(choice);
		  switch(choice[0]){
		  case 'r':
		    if ((*DevicesList[inmac]).Input1Size >0)
		      {
			printf("Device %i input values: ",inmac);
			foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[inmac]).Input1Offset));
			for (i=0;i<(int)((*DevicesList[inmac]).Input1Size);i++)
			  {
			    foo=read(dni,&devin1,1);
			    printf("%x ",(int)devin1);
			  }
			printf("\n");
		      }
		    else
		      {
			printf("Device %i has no inputs.\n",inmac);
		      }
		    break;
		  case 'w':
		    if ((*DevicesList[inmac]).Output1Size >0)
		      {
			printf("Device %i has %i output bytes.\n",inmac,(int)((*DevicesList[inmac]).Output1Size));
			foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[inmac]).Output1Offset));
			for (i=0;i<(int)((*DevicesList[inmac]).Output1Size);i++)
			  {
			    printf("Enter a hex value for byte %i:",i);
			    gets(choice);
			    sscanf(choice,"%x",&outint);
			    outbyte = (unsigned char)outint;
			    foo=write(dni,&outbyte,1);
			  }
		      }
		    else
		      {
			printf("Device %i has no outputs.\n",inmac);
		      }
		    break;
		  default:
		    printf("That is not a valid choice.\n");
		    break;
		  }
		}
	      else
		{
		  printf("Device %i is not in the scan list.\n",inmac);
		}
	    } while ((inmac > -1) && (inmac < 64));
	}
      else
	{
	  do
	    {
	      printf("Enter the macid of the device to affect ( >63 to quit): ");
	      gets(choice);
	      sscanf(choice,"%i",&inmac);
	      if (inmac > 63) exit(0);
	      if (inmac < 0) exit(0);
	      if (DevicesList[inmac] != NULL)
		{
		  printf("'r' = read the inputs, 'w' = write to the outputs\n");
		  printf("Select: ");
		  gets(choice);
		  switch(choice[0]){
		  case 'r':
		    if ((*DevicesList[inmac]).Input1Size >0)
		      {
			do
			  {
			    printf("The device has %i inputs.\n",(int)((*DevicesList[inmac]).Input1Size));
			    printf("Enter the input BYTE to read (lowest is 0): ");
			    gets(incommand);
			    sscanf(incommand,"%i",&wordno);
			    if ((wordno < 0) || (wordno > (((*DevicesList[inmac]).Input1Size) -1)))
			      {
				printf("That word value is out of range.\n");
			      }
			  } while ((wordno < 0) || (wordno > (((*DevicesList[inmac]).Input1Size) -1)));
			foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[inmac]).Input1Offset)+wordno);
			do 
			  {
			    printf("Enter bit number (0 - 7) to query for input byte %i: ",wordno);
			    gets(incommand);
			    sscanf(incommand,"%i",&bitno);
			    if ((bitno < 0) || (bitno > 7))
			      {
				printf("Bit value must be between 0 and 7!\n");
			      }
			  } while((bitno < 0) || (bitno > 7));
			foo=read(dni,&devin1,1);
			bitmask = 1;
			bitmask = bitmask << bitno;
			if ((devin1 & bitmask) != 0)
			  {
			    printf("Bit %i on byte %i is on.\n",bitno,wordno);
			  }
			else
			  {
			    printf("Bit %i on byte %i is off.\n",bitno,wordno);
			  }
		      }
		    else
		      {
			printf("Device %i has no inputs.\n",inmac);
		      }
		    break;
		  case 'w':
		    if ((*DevicesList[inmac]).Output1Size >0)
		      {
			do
			  {
			    printf("The device has %i outputs.\n",(int)((*DevicesList[inmac]).Output1Size));
			    printf("Enter the input BYTE to read (lowest is 0): ");
			    gets(incommand);
			    sscanf(incommand,"%i",&wordno);
			    if ((wordno < 0) || (wordno > (((*DevicesList[inmac]).Output1Size) -1)))
			      {
				printf("That word value is out of range.\n");
			      }
			  } while ((wordno < 0) || (wordno > (((*DevicesList[inmac]).Input1Size) -1)));
			foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[inmac]).Output1Offset)+wordno);
			do 
			  {
			    printf("Enter bit number (0 - 7) to to affect for byte %i: ",wordno);
			    gets(incommand);
			    sscanf(incommand,"%i",&bitno);
			    if ((bitno < 0) || (bitno > 7))
			      {
				printf("Bit value must be between 0 and 7!\n");
			      }
			  } while((bitno < 0) || (bitno > 7));
			foo=read(dni,&devin1,1);
			bitmask = 1;
			bitmask = bitmask << bitno;
			do
			  {
			    printf("Set bit to 1 or 0: ");
			    gets(incommand);
			    sscanf(incommand,"%i",&outint);
			    if ((outint < 0) || (outint > 1))
			      {
				printf("You can only set a bit to 0 or 1!\n");
			      }
			  } while ((outint < 0) || (outint > 1));
			if (outint == 0)
			  {
			    outbyte = devin1 & ~(bitmask);
			  }
			else
			  {
			    outbyte = devin1 | bitmask;
			  }
			foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[inmac]).Output1Offset)+wordno);
			foo=write(dni,&outbyte,1);
		      }
		    else
		      {
			printf("Device %i has no outputs.\n",inmac);
		      }
		    break;
		  default:
		    printf("That is not a valid choice.\n");
		    break;
		  }
		}
	      else
		{
		  printf("Device %i is not in the scan list.\n",inmac);
		}
	    } while ((inmac > -1) && (inmac < 64));
	}	  
    }
  foo=StopScan();
  foo=GoOffline();
  CleanupCardMemList();
}





