/*
 * dntst.c -- A simple example program showing how to use the ss5136dn
 * Linux driver with the dnscan.bin application module loaded into
 * the SST CAN bus/devicenet boards.
 *
 * The use of the board is, by nature, dependant on the configuration of the
 * devices connected to the DeviceNet network.  Use this program as a template
 * and modify it to communicate with your devices.
 *
 * Copyright (c) 1997,1998 The Laitram Corporation.
 * All rights reserved.
 *
 * Author: Mark Sutton (mes)
 *
 * NOTE: The structures "DNS_SCANNER_CFG" and "DNS_DEVICE_CFG" and a number
 * of constants, are taken from example code Written by Geoff Jones and 
 * Copyright (c) 1996 S-S Technologies Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details. It is contained in
 * the file "COPYING" in the root directory of this distribution.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 *  Version 1.1
 *  March 9, 1999 (mes)
 *
 */

/* #define DEBUG  */

#include <stdio.h>
#include <fcntl.h>
#include <sys/termios.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>

#include "../ss5136dn.h"
#include "dnuser.h"
#ifdef DEBUG
FILE * dbgfile;
#endif

#define SCANNERMAK 0
#define SCANNERSPEED BAUD500K

extern int dni;
extern DNS_SCANNER_CFG ScannerCfg;
extern DNS_DEVICE_CFG DeviceCfg;
extern cardmemel * CardMemHead, * curmemp;

/* List of device configs, must malloc each one, use macid for index */
extern DNS_DEVICE_CFG * DevicesList[64];

int main()
{

  int intrback,foo,i,cardtype;
  unsigned char devin1,devin2,devin3,devin4;
  unsigned char stata,statb;
  unsigned short smcout,bktmpin1,bktmpin2,queuein,queueout;
  float bktemperature;
  unsigned int festoout;
  char dstatus,fooch,incommand[200],choice[200];
  short tmpsht;

  if((dni = open("/dev/ss5136dn0", O_RDWR)) < 0) {
    printf("Open device failed value returned was %i\n",dni);
    exit(-1);
  }

  if ((ioctl(dni,SS5136DN_REPORT_APERATURE)) != PAGESIZEINBYTES) {
    printf("There is a memory aperature mismatch between the driver and this program! \n");
    printf("Recompile either this program or the driver so that the settings match!\n");
    exit(-1);
  }
  for (i=0;i<64;i++)
    {
      DevicesList[i]=NULL;
    }
  cardtype = ioctl(dni,SS5136DN_REPORT_CARDTYPE);
  if (cardtype == PRO)
    {
      if (PAGESIZEINBYTES == 0x8000) {
	if ((ldappmod32p("dnscan.ss2")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
      else {
	if ((ldappmod16p("dnscan.ss2")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
    }
  else
    {
      if (PAGESIZEINBYTES == 0x8000) {
	if ((ldappmod32p("dnscan.ss1")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
      else {
	if ((ldappmod16p("dnscan.ss1")) == -1)
	  {
	    printf("Module load failed!\n");
	    exit(-1);
	  }
      }
    }
  initCardMemList();
  fnWait(50000);
  foo=GoOnline(SCANNERMAK,SCANNERSPEED);
  printf("GoOnline returned %x\n",foo);
  foo=StartScan();
  printf("StartScan returned %x\n",foo);
  /*  foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+0x2a);    
  tmpsht=QE;
  foo=write(dni,&tmpsht,2);
  foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+0x2a); 
  foo=read(dni,&tmpsht,2);
  printf("Card interupt control word = %i\n",tmpsht);
  */
  (void *)DevicesList[1]=malloc(sizeof(DNS_DEVICE_CFG));
  
  /* SMC Model EX120-SDN1  */
  (*DevicesList[1]).MacId = 1;
  (*DevicesList[1]).VendorId = 7;
  (*DevicesList[1]).DeviceType = 16;
  /*  (*DevicesList[1]).VendorId = 0;
  (*DevicesList[1]).DeviceType = 0;  */
  (*DevicesList[1]).ProductCode = 0;
  (*DevicesList[1]).Reserved1 = 0;
  (*DevicesList[1]).Reserved2 = 0;
  (*DevicesList[1]).Reserved3 = 0;
  /* enable poll and strobe connections */
  (*DevicesList[1]).Flags = DNS_P;
  (*DevicesList[1]).ExplicitSize = 0;
  (*DevicesList[1]).ExplicitOffset = 0;
  (*DevicesList[1]).Io1Interval = 0;
  /* poll request size  */
  (*DevicesList[1]).Output1Size = 2;
  /* poll request Offset */
  (*DevicesList[1]).Output1Offset = allocCardMem(2);
  (*DevicesList[1]).Output1LocalPathOffset = 0;
  (*DevicesList[1]).Output1RemotePathOffset = 0;
  /* poll response size */
  (*DevicesList[1]).Input1Size = 2; 
  /* poll response offset */
  (*DevicesList[1]).Input1Offset = allocCardMem(2);
  (*DevicesList[1]).Input1LocalPathOffset = 0;
  (*DevicesList[1]).Input1RemotePathOffset = 0;
  (*DevicesList[1]).Io2Interval = 0;
  /* strobe request size */
  (*DevicesList[1]).Output2Size = 0;
  /* strobe request offset */
  (*DevicesList[1]).Output2Offset = 0;
  (*DevicesList[1]).Output2LocalPathOffset = 0;
  (*DevicesList[1]).Output2RemotePathOffset = 0;
  /* strobe response size */
  (*DevicesList[1]).Input2Size = 0;
  /* strobe response Offset */
  (*DevicesList[1]).Input2Offset = 0;
  (*DevicesList[1]).Input2LocalPathOffset = 0;
  (*DevicesList[1]).Input2RemotePathOffset = 0;
  
  /*  foo=AddDevice(DevicesList[1]);  */

  (void *)DevicesList[2]=malloc(sizeof(DNS_DEVICE_CFG));
  
  /* Turck Model CDN-IM-16-0003  */
  (*DevicesList[2]).MacId = 2;
  (*DevicesList[2]).VendorId = 48;
  (*DevicesList[2]).DeviceType = 7;
  /*  (*DevicesList[2]).VendorId = 0;
  (*DevicesList[2]).DeviceType = 0;  */
  (*DevicesList[2]).ProductCode = 0;
  (*DevicesList[2]).Reserved1 = 0;
  (*DevicesList[2]).Reserved2 = 0;
  (*DevicesList[2]).Reserved3 = 0;
  /* enable poll and strobe connections */
  (*DevicesList[2]).Flags = DNS_P | DNS_ST;
  (*DevicesList[2]).ExplicitSize = 0;
  (*DevicesList[2]).ExplicitOffset = 0;
  (*DevicesList[2]).Io1Interval = 0;
  /* poll request size  */
  (*DevicesList[2]).Output1Size = 0;
  /* poll request Offset */
  (*DevicesList[2]).Output1Offset = 0;
  (*DevicesList[2]).Output1LocalPathOffset = 0;
  (*DevicesList[2]).Output1RemotePathOffset = 0;
  /* poll response size */
  (*DevicesList[2]).Input1Size = 4; 
  /* poll response offset */
  (*DevicesList[2]).Input1Offset = allocCardMem(4);
  (*DevicesList[2]).Input1LocalPathOffset = 0;
  (*DevicesList[2]).Input1RemotePathOffset = 0;
  (*DevicesList[2]).Io2Interval = 0;
  /* strobe request size */
  (*DevicesList[2]).Output2Size = 1;
  /* strobe request offset */
  (*DevicesList[2]).Output2Offset = allocCardMem(1);
  (*DevicesList[2]).Output2LocalPathOffset = 0;
  (*DevicesList[2]).Output2RemotePathOffset = 0;
  /* strobe response size */
  (*DevicesList[2]).Input2Size = 4;
  /* strobe response Offset */
  (*DevicesList[2]).Input2Offset = allocCardMem(4);
  (*DevicesList[2]).Input2LocalPathOffset = 0;
  (*DevicesList[2]).Input2RemotePathOffset = 0;

  /*  foo=AddDevice(DevicesList[2]);
  printf("Add device returned %x\n",foo);   */
  (void *)DevicesList[4]=malloc(sizeof(DNS_DEVICE_CFG));
  
  /* Lutze Model DIOPLEX-LS/DN  */
  (*DevicesList[4]).MacId = 4;
  (*DevicesList[4]).VendorId = 53;
  (*DevicesList[4]).DeviceType = 7;
  /*  (*DevicesList[4]).VendorId = 0;
  (*DevicesList[4]).DeviceType = 0;  */
  (*DevicesList[4]).ProductCode = 0;
  (*DevicesList[4]).Reserved1 = 0;
  (*DevicesList[4]).Reserved2 = 0;
  (*DevicesList[4]).Reserved3 = 0;
  /* enable poll and strobe connections */
  (*DevicesList[4]).Flags = DNS_P | DNS_ST;
  (*DevicesList[4]).ExplicitSize = 0;
  (*DevicesList[4]).ExplicitOffset = 0;
  (*DevicesList[4]).Io1Interval = 0;
  /* poll request size  */
  (*DevicesList[4]).Output1Size = 0;
  /* poll request Offset */
  (*DevicesList[4]).Output1Offset = 0;
  (*DevicesList[4]).Output1LocalPathOffset = 0;
  (*DevicesList[4]).Output1RemotePathOffset = 0;
  /* poll response size */
  (*DevicesList[4]).Input1Size = 3; 
  /* poll response offset */
  (*DevicesList[4]).Input1Offset = allocCardMem(3);
  (*DevicesList[4]).Input1LocalPathOffset = 0;
  (*DevicesList[4]).Input1RemotePathOffset = 0;
  (*DevicesList[4]).Io2Interval = 0;
  /* strobe request size */
  (*DevicesList[4]).Output2Size = 1;
  /* strobe request offset */
  (*DevicesList[4]).Output2Offset = allocCardMem(1);
  (*DevicesList[4]).Output2LocalPathOffset = 0;
  (*DevicesList[4]).Output2RemotePathOffset = 0;
  /* strobe response size */
  (*DevicesList[4]).Input2Size = 3;
  /* strobe response Offset */
  (*DevicesList[4]).Input2Offset = allocCardMem(3);
  (*DevicesList[4]).Input2LocalPathOffset = 0;
  (*DevicesList[4]).Input2RemotePathOffset = 0;

  /*  foo=AddDevice(DevicesList[4]);  */

  (void *)DevicesList[12]=malloc(sizeof(DNS_DEVICE_CFG));
  /* Beckoff BK5200 Device Net Coupler with thermcouple and assorted modules
     NOTE: I/O size and other params change with 
     addition/deletion/re-arangement of modules. */
  (*DevicesList[12]).MacId = 12;
  (*DevicesList[12]).VendorId = 0;
  (*DevicesList[12]).DeviceType = 0;
  (*DevicesList[12]).ProductCode = 0;
  (*DevicesList[12]).Reserved1 = 0;
  (*DevicesList[12]).Reserved2 = 0;
  (*DevicesList[12]).Reserved3 = 0;
  /* enable poll and strobe connections */
  (*DevicesList[12]).Flags = DNS_P;
  (*DevicesList[12]).ExplicitSize = 0;
  (*DevicesList[12]).ExplicitOffset = 0;
  (*DevicesList[12]).Io1Interval = 0;
  /* poll request size  */
  (*DevicesList[12]).Output1Size = 1;
  /* poll request Offset */
  (*DevicesList[12]).Output1Offset = allocCardMem(1);
  (*DevicesList[12]).Output1LocalPathOffset = 0;
  (*DevicesList[12]).Output1RemotePathOffset = 0;
  /* poll response size */
  (*DevicesList[12]).Input1Size = 6; 
  /* poll response offset */
  (*DevicesList[12]).Input1Offset = allocCardMem(6);
  (*DevicesList[12]).Input1LocalPathOffset = 0;
  (*DevicesList[12]).Input1RemotePathOffset = 0;
  (*DevicesList[12]).Io2Interval = 0;
  /* strobe request size */
  (*DevicesList[12]).Output2Size = 0;
  /* strobe request offset */
  (*DevicesList[12]).Output2Offset = 0;
  (*DevicesList[12]).Output2LocalPathOffset = 0;
  (*DevicesList[12]).Output2RemotePathOffset = 0;
  /* strobe response size */
  (*DevicesList[12]).Input2Size = 0;
  /* strobe response Offset */
  (*DevicesList[12]).Input2Offset = 0;
  (*DevicesList[12]).Input2LocalPathOffset = 0;
  (*DevicesList[12]).Input2RemotePathOffset = 0;

  (void *)DevicesList[18]=malloc(sizeof(DNS_DEVICE_CFG));
  /* Festo custom pnumatic valve module  */
  (*DevicesList[18]).MacId = 18;
  (*DevicesList[18]).VendorId = 0;
  (*DevicesList[18]).DeviceType = 0;
  (*DevicesList[18]).ProductCode = 0;
  (*DevicesList[18]).Reserved1 = 0;
  (*DevicesList[18]).Reserved2 = 0;
  (*DevicesList[18]).Reserved3 = 0;
  /* enable poll and strobe connections */
  (*DevicesList[18]).Flags = DNS_P;
  (*DevicesList[18]).ExplicitSize = 0;
  (*DevicesList[18]).ExplicitOffset = 0;
  (*DevicesList[18]).Io1Interval = 0;
  /* poll request size  */
  (*DevicesList[18]).Output1Size = 4;
  /* poll request Offset */
  (*DevicesList[18]).Output1Offset = allocCardMem(4);
  (*DevicesList[18]).Output1LocalPathOffset = 0;
  (*DevicesList[18]).Output1RemotePathOffset = 0;
  /* poll response size */
  (*DevicesList[18]).Input1Size = 4; 
  /* poll response offset */
  (*DevicesList[18]).Input1Offset = allocCardMem(4);
  (*DevicesList[18]).Input1LocalPathOffset = 0;
  (*DevicesList[18]).Input1RemotePathOffset = 0;
  (*DevicesList[18]).Io2Interval = 0;
  /* strobe request size */
  (*DevicesList[18]).Output2Size = 0;
  /* strobe request offset */
  (*DevicesList[18]).Output2Offset = 0;
  (*DevicesList[18]).Output2LocalPathOffset = 0;
  (*DevicesList[18]).Output2RemotePathOffset = 0;
  /* strobe response size */
  (*DevicesList[18]).Input2Size = 0;
  /* strobe response Offset */
  (*DevicesList[18]).Input2Offset = 0;
  (*DevicesList[18]).Input2LocalPathOffset = 0;
  (*DevicesList[18]).Input2RemotePathOffset = 0;

/*  foo=AddDevice(DevicesList[1],3);
  printf("Add device returned %x\n",foo);   */
  foo=AddDevice(DevicesList[2],3);
  printf("Add device returned %x\n",foo);
  foo=AddDevice(DevicesList[4],3);
  printf("Add device returned %x\n",foo);
  foo=AddDevice(DevicesList[12],3);
  printf("Add device returned %x\n",foo);
/*  foo=AddDevice(DevicesList[18],3);
  printf("Add device returned %x\n",foo);  */
#ifdef DEBUG
  dbgfile=fopen("dbgdump.txt","w");
  
  foo=GetDevice(DevicesList[1]);
  printf("Get device returned %x\n",foo);
  foo=GetDevice(DevicesList[2]);
  printf("Get device returned %x\n",foo);
  foo=GetDevice(DevicesList[4]);
  printf("Get device returned %x\n",foo);
  foo=GetDevice(DevicesList[12]);
  printf("Get device returned %x\n",foo); 
  /* NUMBER 1  */  
  fprintf(dbgfile,"(*DevicesList[1]).MacId = %x\n",(*DevicesList[1]).MacId);
  fprintf(dbgfile,"(*DevicesList[1]).VendorId = %x\n",(*DevicesList[1]).VendorId);
  fprintf(dbgfile,"(*DevicesList[1]).DeviceType = %x\n",(*DevicesList[1]).DeviceType);
  fprintf(dbgfile,"(*DevicesList[1]).ProductCode = %x\n",(*DevicesList[1]).ProductCode);
  fprintf(dbgfile,"(*DevicesList[1]).Reserved1 = %x\n",(*DevicesList[1]).Reserved1);
  fprintf(dbgfile,"(*DevicesList[1]).Reserved2 = %x\n",(*DevicesList[1]).Reserved2);
  fprintf(dbgfile,"(*DevicesList[1]).Reserved3 = %x\n",(*DevicesList[1]).Reserved3);
  /* enable poll and strobe connections */
  fprintf(dbgfile,"(*DevicesList[1]).Flags = %x\n",(*DevicesList[1]).Flags);
  fprintf(dbgfile,"(*DevicesList[1]).ExplicitSize = %x\n",(*DevicesList[1]).ExplicitSize);
  fprintf(dbgfile,"(*DevicesList[1]).ExplicitOffset = %x\n",(*DevicesList[1]).ExplicitOffset);
  fprintf(dbgfile,"(*DevicesList[1]).Io1Interval = %x\n",(*DevicesList[1]).Io1Interval);
  /* poll request size  */
  fprintf(dbgfile,"(*DevicesList[1]).Output1Size = %x\n",(*DevicesList[1]).Output1Size);
  /* poll request Offset */
  fprintf(dbgfile,"(*DevicesList[1]).Output1Offset = %x\n",(*DevicesList[1]).Output1Offset);
  fprintf(dbgfile,"(*DevicesList[1]).Output1LocalPathOffset = %x\n",(*DevicesList[1]).Output1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[1]).Output1RemotePathOffset = %x\n",(*DevicesList[1]).Output1RemotePathOffset);
  /* poll response size */
  fprintf(dbgfile,"(*DevicesList[1]).Input1Size = %x\n",(*DevicesList[1]).Input1Size);
  /* poll response offset */
  fprintf(dbgfile,"(*DevicesList[1]).Input1Offset = %x\n",(*DevicesList[1]).Input1Offset);
  fprintf(dbgfile,"(*DevicesList[1]).Input1LocalPathOffset = %x\n",(*DevicesList[1]).Input1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[1]).Input1RemotePathOffset = %x\n",(*DevicesList[1]).Input1RemotePathOffset);
  fprintf(dbgfile,"(*DevicesList[1]).Io2Interval = %x\n",(*DevicesList[1]).Io2Interval);
  /* strobe request size */
  fprintf(dbgfile,"(*DevicesList[1]).Output2Size = %x\n",(*DevicesList[1]).Output2Size);
  /* strobe request offset */
  fprintf(dbgfile,"(*DevicesList[1]).Output2Offset = %x\n",(*DevicesList[1]).Output2Offset);
  fprintf(dbgfile,"(*DevicesList[1]).Output2LocalPathOffset = %x\n",(*DevicesList[1]).Output2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[1]).Output2RemotePathOffset = %x\n",(*DevicesList[1]).Output2RemotePathOffset);
  /* strobe response size */
  fprintf(dbgfile,"(*DevicesList[1]).Input2Size = %x\n",(*DevicesList[1]).Input2Size);
  /* strobe response Offset */
  fprintf(dbgfile,"(*DevicesList[1]).Input2Offset = %x\n",(*DevicesList[1]).Input2Offset);
  fprintf(dbgfile,"(*DevicesList[1]).Input2LocalPathOffset = %x\n",(*DevicesList[1]).Input2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[1]).Input2RemotePathOffset = %x\n",(*DevicesList[1]).Input2RemotePathOffset);
  /* NUMBER 2  */  
  fprintf(dbgfile,"(*DevicesList[2]).MacId = %x\n",(*DevicesList[2]).MacId);
  fprintf(dbgfile,"(*DevicesList[2]).VendorId = %x\n",(*DevicesList[2]).VendorId);
  fprintf(dbgfile,"(*DevicesList[2]).DeviceType = %x\n",(*DevicesList[2]).DeviceType);
  fprintf(dbgfile,"(*DevicesList[2]).ProductCode = %x\n",(*DevicesList[2]).ProductCode);
  fprintf(dbgfile,"(*DevicesList[2]).Reserved1 = %x\n",(*DevicesList[2]).Reserved1);
  fprintf(dbgfile,"(*DevicesList[2]).Reserved2 = %x\n",(*DevicesList[2]).Reserved2);
  fprintf(dbgfile,"(*DevicesList[2]).Reserved3 = %x\n",(*DevicesList[2]).Reserved3);
  /* enable poll and strobe connections */
  fprintf(dbgfile,"(*DevicesList[2]).Flags = %x\n",(*DevicesList[2]).Flags);
  fprintf(dbgfile,"(*DevicesList[2]).ExplicitSize = %x\n",(*DevicesList[2]).ExplicitSize);
  fprintf(dbgfile,"(*DevicesList[2]).ExplicitOffset = %x\n",(*DevicesList[2]).ExplicitOffset);
  fprintf(dbgfile,"(*DevicesList[2]).Io1Interval = %x\n",(*DevicesList[2]).Io1Interval);
  /* poll request size  */
  fprintf(dbgfile,"(*DevicesList[2]).Output1Size = %x\n",(*DevicesList[2]).Output1Size);
  /* poll request Offset */
  fprintf(dbgfile,"(*DevicesList[2]).Output1Offset = %x\n",(*DevicesList[2]).Output1Offset);
  fprintf(dbgfile,"(*DevicesList[2]).Output1LocalPathOffset = %x\n",(*DevicesList[2]).Output1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[2]).Output1RemotePathOffset = %x\n",(*DevicesList[2]).Output1RemotePathOffset);
  /* poll response size */
  fprintf(dbgfile,"(*DevicesList[2]).Input1Size = %x\n",(*DevicesList[2]).Input1Size);
  /* poll response offset */
  fprintf(dbgfile,"(*DevicesList[2]).Input1Offset = %x\n",(*DevicesList[2]).Input1Offset);
  fprintf(dbgfile,"(*DevicesList[2]).Input1LocalPathOffset = %x\n",(*DevicesList[2]).Input1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[2]).Input1RemotePathOffset = %x\n",(*DevicesList[2]).Input1RemotePathOffset);
  fprintf(dbgfile,"(*DevicesList[2]).Io2Interval = %x\n",(*DevicesList[2]).Io2Interval);
  /* strobe request size */
  fprintf(dbgfile,"(*DevicesList[2]).Output2Size = %x\n",(*DevicesList[2]).Output2Size);
  /* strobe request offset */
  fprintf(dbgfile,"(*DevicesList[2]).Output2Offset = %x\n",(*DevicesList[2]).Output2Offset);
  fprintf(dbgfile,"(*DevicesList[2]).Output2LocalPathOffset = %x\n",(*DevicesList[2]).Output2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[2]).Output2RemotePathOffset = %x\n",(*DevicesList[2]).Output2RemotePathOffset);
  /* strobe response size */
  fprintf(dbgfile,"(*DevicesList[2]).Input2Size = %x\n",(*DevicesList[2]).Input2Size);
  /* strobe response Offset */
  fprintf(dbgfile,"(*DevicesList[2]).Input2Offset = %x\n",(*DevicesList[2]).Input2Offset);
  fprintf(dbgfile,"(*DevicesList[2]).Input2LocalPathOffset = %x\n",(*DevicesList[2]).Input2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[2]).Input2RemotePathOffset = %x\n",(*DevicesList[2]).Input2RemotePathOffset);
  /* NUMBER 4  */  
  fprintf(dbgfile,"(*DevicesList[4]).MacId = %x\n",(*DevicesList[4]).MacId);
  fprintf(dbgfile,"(*DevicesList[4]).VendorId = %x\n",(*DevicesList[4]).VendorId);
  fprintf(dbgfile,"(*DevicesList[4]).DeviceType = %x\n",(*DevicesList[4]).DeviceType);
  fprintf(dbgfile,"(*DevicesList[4]).ProductCode = %x\n",(*DevicesList[4]).ProductCode);
  fprintf(dbgfile,"(*DevicesList[4]).Reserved1 = %x\n",(*DevicesList[4]).Reserved1);
  fprintf(dbgfile,"(*DevicesList[4]).Reserved2 = %x\n",(*DevicesList[4]).Reserved2);
  fprintf(dbgfile,"(*DevicesList[4]).Reserved3 = %x\n",(*DevicesList[4]).Reserved3);
  /* enable poll and strobe connections */
  fprintf(dbgfile,"(*DevicesList[4]).Flags = %x\n",(*DevicesList[4]).Flags);
  fprintf(dbgfile,"(*DevicesList[4]).ExplicitSize = %x\n",(*DevicesList[4]).ExplicitSize);
  fprintf(dbgfile,"(*DevicesList[4]).ExplicitOffset = %x\n",(*DevicesList[4]).ExplicitOffset);
  fprintf(dbgfile,"(*DevicesList[4]).Io1Interval = %x\n",(*DevicesList[4]).Io1Interval);
  /* poll request size  */
  fprintf(dbgfile,"(*DevicesList[4]).Output1Size = %x\n",(*DevicesList[4]).Output1Size);
  /* poll request Offset */
  fprintf(dbgfile,"(*DevicesList[4]).Output1Offset = %x\n",(*DevicesList[4]).Output1Offset);
  fprintf(dbgfile,"(*DevicesList[4]).Output1LocalPathOffset = %x\n",(*DevicesList[4]).Output1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[4]).Output1RemotePathOffset = %x\n",(*DevicesList[4]).Output1RemotePathOffset);
  /* poll response size */
  fprintf(dbgfile,"(*DevicesList[4]).Input1Size = %x\n",(*DevicesList[4]).Input1Size);
  /* poll response offset */
  fprintf(dbgfile,"(*DevicesList[4]).Input1Offset = %x\n",(*DevicesList[4]).Input1Offset);
  fprintf(dbgfile,"(*DevicesList[4]).Input1LocalPathOffset = %x\n",(*DevicesList[4]).Input1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[4]).Input1RemotePathOffset = %x\n",(*DevicesList[4]).Input1RemotePathOffset);
  fprintf(dbgfile,"(*DevicesList[4]).Io2Interval = %x\n",(*DevicesList[4]).Io2Interval);
  /* strobe request size */
  fprintf(dbgfile,"(*DevicesList[4]).Output2Size = %x\n",(*DevicesList[4]).Output2Size);
  /* strobe request offset */
  fprintf(dbgfile,"(*DevicesList[4]).Output2Offset = %x\n",(*DevicesList[4]).Output2Offset);
  fprintf(dbgfile,"(*DevicesList[4]).Output2LocalPathOffset = %x\n",(*DevicesList[4]).Output2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[4]).Output2RemotePathOffset = %x\n",(*DevicesList[4]).Output2RemotePathOffset);
  /* strobe response size */
  fprintf(dbgfile,"(*DevicesList[4]).Input2Size = %x\n",(*DevicesList[4]).Input2Size);
  /* strobe response Offset */
  fprintf(dbgfile,"(*DevicesList[4]).Input2Offset = %x\n",(*DevicesList[4]).Input2Offset);
  fprintf(dbgfile,"(*DevicesList[4]).Input2LocalPathOffset = %x\n",(*DevicesList[4]).Input2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[4]).Input2RemotePathOffset = %x\n",(*DevicesList[4]).Input2RemotePathOffset);
  /* NUMBER 12  */  
  fprintf(dbgfile,"(*DevicesList[12]).MacId = %x\n",(*DevicesList[12]).MacId);
  fprintf(dbgfile,"(*DevicesList[12]).VendorId = %x\n",(*DevicesList[12]).VendorId);
  fprintf(dbgfile,"(*DevicesList[12]).DeviceType = %x\n",(*DevicesList[12]).DeviceType);
  fprintf(dbgfile,"(*DevicesList[12]).ProductCode = %x\n",(*DevicesList[12]).ProductCode);
  fprintf(dbgfile,"(*DevicesList[12]).Reserved1 = %x\n",(*DevicesList[12]).Reserved1);
  fprintf(dbgfile,"(*DevicesList[12]).Reserved2 = %x\n",(*DevicesList[12]).Reserved2);
  fprintf(dbgfile,"(*DevicesList[12]).Reserved3 = %x\n",(*DevicesList[12]).Reserved3);
  /* enable poll and strobe connections */
  fprintf(dbgfile,"(*DevicesList[12]).Flags = %x\n",(*DevicesList[12]).Flags);
  fprintf(dbgfile,"(*DevicesList[12]).ExplicitSize = %x\n",(*DevicesList[12]).ExplicitSize);
  fprintf(dbgfile,"(*DevicesList[12]).ExplicitOffset = %x\n",(*DevicesList[12]).ExplicitOffset);
  fprintf(dbgfile,"(*DevicesList[12]).Io1Interval = %x\n",(*DevicesList[12]).Io1Interval);
  /* poll request size  */
  fprintf(dbgfile,"(*DevicesList[12]).Output1Size = %x\n",(*DevicesList[12]).Output1Size);
  /* poll request Offset */
  fprintf(dbgfile,"(*DevicesList[12]).Output1Offset = %x\n",(*DevicesList[12]).Output1Offset);
  fprintf(dbgfile,"(*DevicesList[12]).Output1LocalPathOffset = %x\n",(*DevicesList[12]).Output1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[12]).Output1RemotePathOffset = %x\n",(*DevicesList[12]).Output1RemotePathOffset);
  /* poll response size */
  fprintf(dbgfile,"(*DevicesList[12]).Input1Size = %x\n",(*DevicesList[12]).Input1Size);
  /* poll response offset */
  fprintf(dbgfile,"(*DevicesList[12]).Input1Offset = %x\n",(*DevicesList[12]).Input1Offset);
  fprintf(dbgfile,"(*DevicesList[12]).Input1LocalPathOffset = %x\n",(*DevicesList[12]).Input1LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[12]).Input1RemotePathOffset = %x\n",(*DevicesList[12]).Input1RemotePathOffset);
  fprintf(dbgfile,"(*DevicesList[12]).Io2Interval = %x\n",(*DevicesList[12]).Io2Interval);
  /* strobe request size */
  fprintf(dbgfile,"(*DevicesList[12]).Output2Size = %x\n",(*DevicesList[12]).Output2Size);
  /* strobe request offset */
  fprintf(dbgfile,"(*DevicesList[12]).Output2Offset = %x\n",(*DevicesList[12]).Output2Offset);
  fprintf(dbgfile,"(*DevicesList[12]).Output2LocalPathOffset = %x\n",(*DevicesList[12]).Output2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[12]).Output2RemotePathOffset = %x\n",(*DevicesList[12]).Output2RemotePathOffset);
  /* strobe response size */
  fprintf(dbgfile,"(*DevicesList[12]).Input2Size = %x\n",(*DevicesList[12]).Input2Size);
  /* strobe response Offset */
  fprintf(dbgfile,"(*DevicesList[12]).Input2Offset = %x\n",(*DevicesList[12]).Input2Offset);
  fprintf(dbgfile,"(*DevicesList[12]).Input2LocalPathOffset = %x\n",(*DevicesList[12]).Input2LocalPathOffset);
  fprintf(dbgfile,"(*DevicesList[12]).Input2RemotePathOffset = %x\n",(*DevicesList[12]).Input2RemotePathOffset);
  fclose(dbgfile);
#endif
  
  /*  foo=IOActive();
  printf("IOActive returned %x\n",foo);  */
  foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(4*16)));  
  foo=read(dni,&dstatus,1);
  printf("Lutze device status code is: %x\n",(int)dstatus);

  do {
    printf("Enter a command, h for list of commands, q to quit: ");
    gets(incommand);
    switch(incommand[0]){
    case 'r':
      printf("l = Lutze, t = Turck, s = SMC, b = Beckoff, f = festo\n");
      printf("Read which device: ");
      gets(choice);
      switch(choice[0]){
      case 'l':
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[4]).Input1Offset));
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(4*16)));  
	foo=read(dni,&dstatus,1);
	printf("Lutze polled input bytes one and two and status code: %x %x %x   \n",(int)devin1,(int)devin2,(int)dstatus);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[4]).Input2Offset));
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(4*16)));  
	foo=read(dni,&dstatus,1);
	printf("Lutze strobed input bytes one and two and status code: %x %x %x   \n",(int)devin1,(int)devin2,(int)dstatus);
	break;
      case 't':
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[2]).Input1Offset));
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=read(dni,&devin3,1);
	foo=read(dni,&devin4,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(2*16)));  
	foo=read(dni,&dstatus,1);
	printf("Turck polled input bytes one through 4 and status code: %x %x %x   \n",(int)devin1,(int)devin2,(int)dstatus);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[2]).Input2Offset));
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=read(dni,&devin3,1);
	foo=read(dni,&devin4,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(2*16)));  
	foo=read(dni,&dstatus,1);
	printf("Turck strobed input bytes one through 4 and status code: %x %x %x   \n",(int)devin1,(int)devin2,(int)dstatus);
	break;
      case 'f':
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[18]).Input1Offset));
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=read(dni,&devin3,1);
	foo=read(dni,&devin4,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(18*16)));  
	foo=read(dni,&dstatus,1);
	printf("Festo polled input bytes one through 4 and status code: %x %x %x %x %x   \n",(int)devin1,(int)devin2,(int)devin3,(int)devin4,(int)dstatus);
	break;
      case 's':
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[1]).Input1Offset));
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(1*16)));  
	foo=read(dni,&dstatus,1);
	printf("SMC input bytes one and two and status code: %x %x %x   \n",(int)devin1,(int)devin2,(int)dstatus);
	break;
      case 'b':
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[12]).Input1Offset));
	foo=read(dni,&bktmpin1,2);
	foo=read(dni,&bktmpin2,2);
	foo=read(dni,&devin1,1);
	foo=read(dni,&devin2,1);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+(STATUSTOP+(12*16)));  
	foo=read(dni,&dstatus,1);
	bktemperature=((float)bktmpin1/10.0);
	printf("Beckoff thermocouple input #1 reads %f degrees C \n",bktemperature);
	bktemperature=((float)bktmpin2/10.0);
	printf("Beckoff thermocouple input #2 reads %f degrees C \n",bktemperature);
	printf("Beckoff relay input bytes one and two and status code: %x %x %x   \n",(int)devin1,(int)devin2,(int)dstatus);
	break;
      default:
	printf("That is not a valid choice\n");
	break;
      }
      break;
    case 'w':
      printf("s = SMC, b = Beckoff, f=festo\n");
      printf("Write to which device: ");
      gets(choice);
      switch(choice[0]){
      case 's':
	printf("Enter value to write to SMC manifold:");
	gets(choice);
	sscanf(choice,"%i",&smcout);
	printf("Sending this value to smc: %i\n",smcout);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[1]).Output1Offset));
	foo=write(dni,&smcout,2);
	break;
      case 'f':
	printf("Enter value to write to Festo manifold:");
	gets(choice);
	sscanf(choice,"%i",&festoout);
	printf("Sending this value to Festo: %u\n",festoout);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[18]).Output1Offset));
	foo=write(dni,&festoout,4);
	break;
      case 'b':
	printf("Enter value to write to Beckoff output relays manifold:");
	gets(choice);
	sscanf(choice,"%i",&smcout);
	printf("Sending this value to beckoff: %i\n",smcout);
	foo=ioctl(dni,SS5136DN_SETCARDMEMPTR,DATA_BASE+((*DevicesList[12]).Output1Offset));
	foo=write(dni,&smcout,2);
	break;
      default:
	printf("That is not a valid choice\n");
	break;
      }
      break;
    case 'h':
      printf("Choices:\n");
      printf("r = read a device's inputs.\n");
      printf("w = write to a device's outputs.\n");
      printf("h = get help (print this message).\n");
      printf("q = quit.\n");
      break;
    case 'q':
      break;
    default:
      printf("That is not a valid selection.\n");
      break;
    }
  } while(incommand[0] != 'q');

  foo=GetDevice(DevicesList[1]);
  printf("Get device returned %x\n",foo);
  printf("Product code returned was %i\n",(*DevicesList[4]).ProductCode);
  printf("Vendor ID returned was %i\n",(*DevicesList[4]).VendorId);
  printf("Device Type returned was %i\n",(*DevicesList[4]).DeviceType);
  /*  foo=IOIdle();  */
  tmpsht=1;
  foo=DeleteDevice(&tmpsht);
  printf("DeleteDevice returned %x\n",foo);
  tmpsht=2;
  foo=DeleteDevice(&tmpsht);
  printf("DeleteDevice returned %x\n",foo);
  tmpsht=4;
  foo=DeleteDevice(&tmpsht);
  printf("DeleteDevice returned %x\n",foo);
  tmpsht=12;
  foo=DeleteDevice(&tmpsht);
  printf("DeleteDevice returned %x\n",foo);
  foo=StopScan();
  printf("StopScan returned %x\n",foo);
  foo=GoOffline();
  printf("GoOffline returned %x\n",foo);
  CleanupCardMemList();
}


