/*
 * dnuser.h -- Header file for User level function library for the ss5136dn 
 * card.
 *
 * Copyright (c) 1997 The Laitram Corporation.
 * All rights reserved.
 *
 * Author: Mark Sutton (mes)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details. It is contained in
 * the file "COPYING" in the root directory of this distribution.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 *  Version 0.03 (Version number parallel's that of driver.)
 *  May 15, 1997 (mes)
 *
 * Version 0.04 Placed driver and user level code under the LGPL.
 * Added functions for deallocation and "tidy" of card memory to allow
 * dynamic re-assignment of card memory while running.
 * June 29, 1998. (mes)
 *
 * Version 0.05 Fixed bug that caused 5136-DN-PRO board to not work reliably.
 * Added capability to module loader to load encrypted modules.  Driver
 * now identifies whether board is a standard or a "pro" and adjusts some
 * paramaters slightly for the different boards.  User code can poll for what
 * type of board is installed.
 * July 21, 1998 (mes)
 *
 * Version 1.0 Cleaned up module loader based on new information from
 * engineers at SST.  Added the folowing programs to package:  devset (for
 * software setting macid and baud rate on devices), devqry (for quering a
 * device about it's input and output size and other paramaters), and 
 * devwho (for finding all devices on a network.
 * October 23, 1998 (mes)
 */

/* Application header module locations */

#define KERNELIDLOC 0x6
#define KERNELREVLOC 0x8
#define MODIDLOC 0xa
#define MODREVLOC 0xc
#define CARDIDLOC 0x12
#define CARDSERIALLOC 0x22
#define IRQSTATUSALOC 0x2c
#define IRQSTATUSBLOC 0x2d
#define COMMANDREG 0x80
#define COMMANDPARAMSLOC 0x82
#define COMMANDERR 0X8000
#define STATUSTOP 0x1c0
#define CONTROLTOP 0x5c0 /* No, this is NOT refering to panty-hose! */
#define EVENTTOP 0x180
#define ENQUEUE 0x9c0

/* command timeouts (in sec)  */

#define INIT_TIMEOUT 7
#define CMD_TIMEOUT 2
#define DEVONLINEWAIT 180
/* DNS_CMD_ID commands  */

#define ONLINE 1
#define OFFLINE 2
#define ADD_DEVICE 3
#define GET_DEVICE 4
#define DELETE_DEVICE 5
#define START_SCAN 6
#define STOP_SCAN 7
#define IO_ACTIVE 8
#define IO_IDLE 9


/* Connection Flags  */

#define DNS_EXP 0x01
#define DNS_P   0x02
#define DNS_ST  0x04
#define DNS_RES 0x08
#define DNS_COS 0x10
#define DNS_CYC 0x20
#define DNS_AKS 0x40

/* Device control flags */

#define DCTL_EXPITRLCK 0x01
#define DCTL_IN1ITRLCK 0x02
#define DCLT_IN2ITRLCK 0x04
#define DCLT_OUT1ITRLCK 0x08
#define SCLT_OUT2ITRLCK 0x10

/* Event queue control flags */

#define EQE_DSTATUS 1
#define EQE_IO1 4
#define EQE_IO2 8
#define EQE_EXPLICIT 16

/* Logical IRQ's */

#define CM 0x1
#define BS 0X2
#define QE 0x4

/* Miscelaneous constansts */

#define DCONSIZE 16
#define EQFLAGOFF 14
#define EVFLAGOFF 3
#define BAUD125K 0
#define BAUD250K 1
#define BAUD500K 2

/*-------------------------
   Card memory allocation link-list element
-------------------------*/
typedef struct
{
  unsigned short blockadd;
  unsigned short blocksize;
  unsigned char freeyn;
  void * prev;
  void * next;
} cardmemel;

/*--------------------------
   Scaner config data
--------------------------*/
typedef struct
{
	unsigned short MacId;
	unsigned short BaudRate;
	unsigned short StrobeInterval;
	unsigned short Reserved;
	unsigned short Flags;
	unsigned short ExplicitRequestSize;
	unsigned short ExplicitRequestOffset;
	unsigned short ExplicitResponseSize;
	unsigned short ExplicitResponseOffset;
	unsigned short Io1Interval;
	unsigned short Output1Size;
	unsigned short Output1Offset;
	unsigned short Output1PathOffset;
	unsigned short Input1Size;
	unsigned short Input1Offset;
	unsigned short Input1PathOffset;
	unsigned short Io2Interval;
	unsigned short Output2Size;
	unsigned short Output2Offset;
	unsigned short Output2PathOffset;
	unsigned short Input2Size;
	unsigned short Input2Offset;
	unsigned short Input2PathOffset;
} DNS_SCANNER_CFG;

/*--------------------------
   Device config data
--------------------------*/
typedef struct
{
	unsigned short MacId;
	unsigned short VendorId;
	unsigned short DeviceType;
	unsigned short ProductCode;
	unsigned short Reserved1;
	unsigned short Reserved2;
	unsigned short Reserved3;
	unsigned short Flags;
	unsigned short ExplicitSize;
	unsigned short ExplicitOffset;
	unsigned short Io1Interval;
	unsigned short Output1Size;
	unsigned short Output1Offset;
	unsigned short Output1LocalPathOffset;
	unsigned short Output1RemotePathOffset;
	unsigned short Input1Size;
	unsigned short Input1Offset;
	unsigned short Input1LocalPathOffset;
	unsigned short Input1RemotePathOffset;
	unsigned short Io2Interval;
	unsigned short Output2Size;
	unsigned short Output2Offset;
	unsigned short Output2LocalPathOffset;
	unsigned short Output2RemotePathOffset;
	unsigned short Input2Size;
	unsigned short Input2Offset;
	unsigned short Input2LocalPathOffset;
	unsigned short Input2RemotePathOffset;
} DNS_DEVICE_CFG;

typedef struct
{
  unsigned char ControlFlags;
  unsigned char Io1EventFlags;
  unsigned char Io2EventFlags;
  unsigned char ExplicitEventFlags;
  unsigned char Reserved[10];
  unsigned short EventQueueEnableFlags;
} device_control;

typedef struct
{
  unsigned char StatusCode;
  unsigned char StatusFlags;
  unsigned char Io1EventFlags;
  unsigned char Io2EventFlags;
  unsigned char ExplicitEventFlags;
  unsigned char Reserved[11];
} DEVICE_STATUS;

typedef struct
{
  unsigned short ExplicitSize;
  unsigned short ExplicitService;
  unsigned short ExplicitClass;
  unsigned short ExplicitInstance;
  unsigned char ServiceData[8];
} explicit_request;

typedef struct
{
  unsigned short ExplicitSize;
  unsigned short ExplicitService;
  unsigned char ServiceData[12];
} explicit_response;

/*------------------------------------------------------------------------
                        Function prototypes
-----------------------------------------------------------------------*/

void fnWait(long i);

int ldappmod32p(char * modulename);

int ldappmod16p(char * modulename);

void initCardMemList(void);

void CleanupCardMemList(void);

int TidyCardMemList(void);

unsigned short allocCardMem(unsigned short size);

int deallocCardMem(unsigned short memloc);

int QueryInterrupt(int flags);

int CardCommand(unsigned short incommand, unsigned int timeout);

int GoOnline(unsigned short scannerid, unsigned short scannerbaud);

int GoOffline(void);

int StartScan(void);

int StopScan(void);

int IOActive(void);

int IOIdle(void);

int GetDevice( DNS_DEVICE_CFG * DeviceDescrip );

int DeleteDevice(short * ddevice);

int RemoveDevice(short * ddevice);

int SimpleAddDevice( DNS_DEVICE_CFG * DeviceDescrip);

int AddDevice( DNS_DEVICE_CFG * DeviceDescrip, int maxfailures);

void EnableEventQueueing(unsigned short macid, unsigned short flags);

void DisableEventQueueing(unsigned short macid, unsigned short flags);

int sendDeviceExplicit(int dbg, int macid, explicit_request *req, explicit_response *retresp);
