/*
 * ss5136_cs.h -- Linux device driver for the S.S Technologies 5136-DN-PCM 
 * PCMCIA CAN-Network interface card.  Header file: Version 0.3.
 *
 * Copyright (c) 1997,1998,1999 The Laitram Corporation.
 * All rights reserved.
 *
 * Author: Mark Sutton (mes)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details. It is contained in
 * the file "COPYING" in the root directory of this distribution.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * Revision history:
 * -Initial writing (Version 0.1) Jan. 4, 1999 (mes)  Version 0.1 based
 * on version 1.0 of the ISA card driver.
 *
 * -Version 0.2 March 9, 1999 (mes)
 * Version 0.2 is based on version 1.2 of ss5136dn.c,
 * the driver for the ISA version of the SST card.
 * This version makes the driver more independant of kernel version.
 *
 * -Version 0.3 March 14, 2000 (mes)
 * Changed major number from 144 to 183 since SUSE usurped 144 for their
 * encapsulated PPP driver.
 */


#if (LINUX_VERSION_CODE < VERSION(2,2,0))
#define SS5136DN_MAJOR 120
#else
#define SS5136DN_MAJOR 183
#endif

/* General-Purpose #defines */

#define SS5136DN_VERSION "1.3"

/* Note: There is NO 32K window mode in the PCMCIA card.  Use 16K only!   */

#define CANDECRYPT

/*-----------------------------------------------------
    5136-DN-PCM hardware definitions
-----------------------------------------------------*/

#define SS5136DN_PORTBASE 0x250 /* Note, this value and the one in
                                   ss5136dn.h that the user applications
                                   include MUST match.  Also, the PCMCIA
                                   card supports a much narrower range of 
                                   choices for this value than the ISA
                                   version.  Valid choices are,
                                   0x250, 0x258, 0x280, 0x288 */
#define SS5136DN_IOSIZE 0x4 

#define SS5136DN_MEMBASE 0xd0000 /* This value must also match the one
                                    in ss5136dn.h that the user applications
                                    include.  Valid values are: 0xd0000,
                                    0xd4000, 0xc8000, 0xcc000 */

#define SS5136DN_MEMSIZE 0x4000

/* control/status register offsets (from base I/O port)  */
#define BCR0 0
#define BCR1 1
#define BCR2 2
#define BCR7 7

/* BCR0 register bits */
#define IRQV40 1
#define NOVPOLL 2
#define PCINT 4
#define IRQENA 8
#define BANKSEL 0x70
#define BANKSELMASK 0x8fu
#define MEMENABLE 0x80u
#define SS5136DN_PAGEMASK BANKSELMASK
#define SS5136DN_MEMENABLEMASK MEMENABLE
#define SS5136DN_CINTMASK IRQV40

/* BCR1 register bits  */
#define MEMSEL 0x1f
#define MEMSELMASK 0xe0u
#define WORDACCESS 0x40
#define WIN16K 0x80u

/* BCR2 register bits  */
#define INTSEL 7
#define INTSELMASK 0xf8u
#define LEDOFF 0x20
#define WDINHIBIT 0x40
#define V40RUN 0x80u
#define SS5136DN_PROCENABLEMASK V40RUN
#define SS5136DN_WDENABLEMASK WDINHIBIT
#define SS5136DN_HLTHMASK LEDOFF

/* other hardware constants  */
#define PORTMIN 0x200
#define PORTMAX 0x3f8
#define SEGMIN 0x8000u
#define SEGMAX 0xf800u
#define NOIRQ 0
#define IRQMIN 2
#define IRQMAX 7
#define PAGESIZEINBYTES 0x4000
#define PAGESIZEINSHORTS 0x2000
#define PAGESIZEINWORDS 0x1000
#define MAXPAGES 7
/* Application module values  */

#define DN 0x4e44
#define ER 0x5245
#define PRO 2
#define REGULAR 1

/* Application module locations */

#define DATA_BASE 0
#define APPINTPAGE 3
#define MODULE_TYPE 0
#define PAGE_SIZE_LOCATION 2
#define MESSAGE 0X40

/* Driver status bits */

#define SS5136DN_BUSY 1

/* Device specific error codes */

#define EBADORIGIN 200
#define ECARDMEMOUTOFRANGE 201

/* IOCTL definitions */

#include <linux/ioctl.h>

#define SS5136DN_WRITEREG _IOW('x', 1, void *)
#define SS5136DN_READREG _IOR('x', 1, void *)
#define SS5136DN_MEMENABLE _IOW('x', 2, void)
#define SS5136DN_MEMDISABLE _IOW('x', 3, void)
#define SS5136DN_PROCENABLE _IOW('x', 4, void)
#define SS5136DN_PROCDISABLE _IOW('x', 5, void)
#define SS5136DN_STROBECINT _IOW('x', 6, void)
#define SS5136DN_PAGECHANGE _IOW('x', 7, long)
#define SS5136DN_WDENABLE _IOW('x', 8, void)
#define SS5136DN_WDDISABLE _IOW('x', 9, void)
#define SS5136DN_HLTHRED _IOW('x', 10, void)
#define SS5136DN_HLTHGREEN _IOW('x', 11, void)
#define SS5136DN_SETCARDMEMPTR _IOW('x', 12, void)
#define SS5136DN_SHUTDOWN _IOW('x', 13, void)
#define SS5136DN_CLINT _IOW('x', 14, void)
#define SS5136DN_BIGRESET _IOW('x', 15, void)
#define SS5136DN_REPORT_APERATURE _IOW('x', 16, void)
#define SS5136DN_REPORT_CARDTYPE _IOW('x', 17, void)

/* Typedefs */

typedef struct
{
  unsigned char value;
  unsigned short port;
} portiopair;



