
proc window.serverwin {args} {
    set base .serverwin

    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 582x412+55+113
    wm maxsize $base 785 570
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "dirc"
    wm iconname $base "\[0\] server window"
    
    entry $base.entry \
        -selectbackground #000086 -selectforeground #fefefe
    frame $base.in \
        -borderwidth 2 -height 75 -width 125
    text $base.in.text \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe \
        -state disabled -width 14 -wrap word \
        -yscrollcommand {.serverwin.in.scroll set}
    scrollbar $base.in.scroll \
        -command {.serverwin.in.text yview} -orient vert -width 8 -borderwidth 1
    bind $base.entry <Return> { set a [.serverwin.entry get]
                                hist.add .serverwin $a
                                toserver $a
                                .serverwin.entry delete 0 end}
    bind $base.entry <Up> { hist.up .serverwin.entry .serverwin }
    bind $base.entry <Down> { hist.down .serverwin.entry .serverwin }
    pgupdnbnd $base in
    
    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.entry \
        -in .serverwin -anchor n -expand 0 -fill x -side bottom 
    pack $base.in \
        -in .serverwin -anchor center -expand 1 -fill both -side bottom 
    pack $base.in.text \
        -in .serverwin.in -anchor n -expand 1 -fill both -side left 
    pack $base.in.scroll \
        -in .serverwin.in -anchor n -expand 0 -fill y -side right 
}

proc window.chanwin {base args} {
    if {$base == ""} {
        set base .chanwin
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 474x342+60+139
    wm maxsize $base 785 570
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "joining channel"
    frame $base.fn \
        -borderwidth 2 -height 2 -relief groove -width 67
    scrollbar $base.fn.scroll \
        -borderwidth 1 -command "$base.fn.nicks yview" -orient vert -width 8
    listbox $base.fn.nicks \
        -height 14 -relief flat -selectbackground #000086 \
        -selectforeground #fefefe -width 10 \
        -yscrollcommand "$base.fn.scroll set" -font {Helvetica -12}
    entry $base.entry \
        -borderwidth 1
    frame $base.ft \
        -borderwidth 1 -height 138 -width 166
    scrollbar $base.ft.scroll \
        -borderwidth 1 -command "$base.ft.text yview" -width 8
    text $base.ft.text \
        -borderwidth 1 -height 17 -selectbackground #000086 \
        -selectforeground #fefefe -state disabled -width 66 -wrap word \
        -yscrollcommand "$base.ft.scroll set" -font {Helvetica -12}
	
    menu $base.np -tearoff 0 
    menu $base.np.info -tearoff 0 
    menu $base.np.ban -tearoff 0 
    menu $base.np.nuke -tearoff 0
    menu $base.np.oper -tearoff 0 
    menu $base.np.oper.lines -tearoff 0 
    bind $base.fn.nicks <ButtonRelease-3> "RightPopup $base $base.np %X %Y"
    bind $base.fn.nicks <Double-Button-1> "QuerySelection $base"
    pgupdnbnd $base ft

    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.fn \
        -in $base -anchor ne -expand 0 -fill y -side right 
    pack $base.fn.scroll \
        -in $base.fn -anchor center -expand 0 -fill y -side right 
    pack $base.fn.nicks \
        -in $base.fn -anchor center -expand 0 -fill both -side left 
    pack $base.entry \
        -in $base -anchor n -expand 0 -fill x -side bottom 
    pack $base.ft \
        -in $base -anchor n -expand 1 -fill both -side left 
    pack $base.ft.scroll \
        -in $base.ft -anchor center -expand 0 -fill y -side right 
    pack $base.ft.text \
        -in $base.ft -anchor nw -expand 1 -fill both -side top 
}

proc window.query {base} {
    if {$base == ""} {
        set base .query
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 378x251+96+162
    wm maxsize $base 785 570
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Query"
    frame $base.ft \
        -borderwidth 0 -height 75 -relief groove -width 125
    text $base.ft.text \
        -borderwidth 1 -height 1 -selectbackground #000086 \
        -selectforeground #fefefe -state disabled -width 1 -wrap word \
	-yscrollcommand "$base.ft.scroll set"
    scrollbar $base.ft.scroll \
        -borderwidth 1 -orient vert -width 8 -command "$base.ft.text yview"
    entry $base.entry \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe
    pgupdnbnd $base ft
    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.ft \
        -in $base -anchor nw -expand 1 -fill both -side top 
    pack $base.ft.text \
        -in $base.ft -anchor center -expand 1 -fill both -side left 
    pack $base.ft.scroll \
        -in $base.ft -anchor center -expand 0 -fill y -side right 
    pack $base.entry \
        -in $base -anchor sw -expand 0 -fill x -side bottom 
}

proc window.chanlist {args} {
    set base .serverwin.chanlist
    if {[winfo exists $base]} {wm deiconify $base; return}
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 461x290+75+110
    wm maxsize $base 1009 738
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Channel list"
    wm iconname $base "Channel list"
    
    frame $base.a \
        -borderwidth 2 -height 75 -width 125
    button $base.a.s_name \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text channels \
	-command {sortchanlist 0}
    button $base.a.s_users \
        -borderwidth 1 -font {Helvetica -12} -justify left -padx 9 -pady 3 \
        -text users -command {sortchanlist 1}
    button $base.a.s_topics \
        -borderwidth 1 -font {Helvetica -12} -justify left -padx 9 -pady 3 \
        -text topics -command {sortchanlist 2}
    frame $base.b \
        -borderwidth 2 -height 75 -relief groove -width 125
    listbox $base.b.chans \
        -borderwidth 1 -font fixed -selectbackground #000086 \
        -selectforeground #fefefe -yscrollcommand "$base.b.yscroll set"
    scrollbar $base.b.yscroll \
        -borderwidth 1 -orient vert -width 9 -command "$base.b.chans yview"
    button $base.b_join \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text join \
        -command joinselected
    bind $base.b.chans <Double-Button-1> {joinselected}
    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.a \
        -in $base -anchor center -expand 0 -fill both -side top 
    pack $base.a.s_name \
        -in $base.a -anchor nw -expand 0 -fill none -side left 
    pack $base.a.s_users \
        -in $base.a -anchor n -expand 0 -fill none -side left 
    pack $base.a.s_topics \
        -in $base.a -anchor ne -expand 1 -fill x -side left 
    pack $base.b \
        -in $base -anchor center -expand 1 -fill both -side top 
    pack $base.b.chans \
        -in $base.b -anchor w -expand 1 -fill both -side left 
    pack $base.b.yscroll \
        -in $base.b -anchor center -expand 0 -fill y -side right 
    pack $base.b_join \
        -in $base -anchor center -expand 0 -fill x -side bottom 
}

proc window.main {args} {
global server serverport mynick ident realname

    wm focusmodel . passive
    wm geometry . 416x326+72+137
    wm overrideredirect . 0
    wm resizable . 0 0
    wm deiconify .
    wm title . "dirc - configuration"
    wm iconname . "dirc"
    frame .a \
        -borderwidth 2 -height 75 -relief groove -width 125
    label .a.l1 \
        -borderwidth 1 -font {Helvetica -12} -text {nickname:}
    entry .a.u_nick \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe
    label .a.l2 \
        -borderwidth 1 -font {Helvetica -12} -justify left -text {ident:}
    entry .a.u_ident \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe
    label .a.l3 \
        -borderwidth 1 -font {Helvetica -12} -text {realname:}
    entry .a.u_realname \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe
    frame .b \
        -borderwidth 2 -height 75 -relief groove -width 125
    listbox .b.servers \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe \
	-font {Helvetica -12} -yscrollcommand ".b.scroll set"
    scrollbar .b.scroll \
        -borderwidth 1 -orient vert -command ".b.servers yview"
    entry .b.entry \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe
    button .b.add \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text {<< add} \
	-command { set bla [.b.entry get]
	           if {$bla!=""} {.b.servers insert end $bla}
	           .b.entry delete 0 end }
    button .b.remove \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 \
        -text {>> remove} \
	-command { set bla [.b.servers curselection]
	           if {$bla!=""} {.b.servers delete $bla} }
    button .b.connect \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text connect \
	-command { set mynick [.a.u_nick get]
                   set ident [.a.u_ident get]
 		   set realname [.a.u_realname get]
		   set bla [.b.entry get]
		   if {$bla==""} { catch [set bla [.b.servers get [.b.servers curselection]]]}
		   if {$bla!=""} {
                       set bla [split $bla ":"]
                       set server [lindex $bla 0]
                       set serverport [lindex $bla 1]
                       if {$serverport==""} {set serverport 6667}
                       connect
		       }
		}
    label .b.l1 \
        -borderwidth 1 -font {Helvetica -12} -text {server list:}
    label .b.l2 \
        -borderwidth 1 -font {Helvetica -12} -text {add a new server:}
    ###################
    # SETTING GEOMETRY
    ###################
    place .a \
        -x 15 -y 25 -width 385 -height 65 -anchor nw -bordermode ignore 
    place .a.l1 \
        -x 5 -y 10 -width 65 -height 18 -anchor nw -bordermode ignore 
    place .a.u_nick \
        -x 75 -y 10 -width 131 -height 20 -anchor nw -bordermode ignore 
    place .a.l2 \
        -x 245 -y 10 -width 41 -height 18 -anchor nw -bordermode ignore 
    place .a.u_ident \
        -x 285 -y 10 -width 91 -height 20 -anchor nw -bordermode ignore 
    place .a.l3 \
        -x 5 -y 35 -width 66 -height 18 -anchor nw -bordermode ignore 
    place .a.u_realname \
        -x 75 -y 35 -width 301 -height 20 -anchor nw -bordermode ignore 
    place .b \
        -x 15 -y 100 -width 385 -height 205 -anchor nw -bordermode ignore 
    place .b.servers \
        -x 10 -y 25 -width 168 -height 166 -anchor nw -bordermode ignore 
    place .b.scroll \
        -x 175 -y 25 -width 13 -height 167 -anchor nw -bordermode ignore 
    place .b.entry \
        -x 205 -y 25 -width 166 -height 20 -anchor nw -bordermode ignore 
    place .b.add \
        -x 205 -y 55 -width 75 -height 20 -anchor nw -bordermode ignore 
    place .b.remove \
        -x 205 -y 80 -width 75 -height 20 -anchor nw -bordermode ignore 
    place .b.connect \
        -x 285 -y 55 -width 87 -height 44 -anchor nw -bordermode ignore 
    place .b.l1 \
        -x 10 -y 5 -anchor nw -bordermode ignore 
    place .b.l2 \
        -x 205 -y 5 -width 105 -height 18 -anchor nw -bordermode ignore 
}

proc window.banlist {base} {
    if {[winfo exists $base]} { wm deiconify $base; return }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 425x244+105+125
    wm maxsize $base 1009 738
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "banlist"
    frame $base.a \
        -borderwidth 2 -height 75 -width 125
    frame $base.a.a \
        -borderwidth 2 -height 75 -width 125
    button $base.a.a.s_mask \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text mask \
	-width 27 -command "sortbanlist 0 $base"
    button $base.a.a.s_setby \
        -borderwidth 1 -font {Helvetica -12} -justify left -padx 9 -pady 3 \
        -text {set by} -width 10 -command "sortbanlist 1 $base"
    button $base.a.a.s_time \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text time/date \
        -width 10 -command "sortbanlist 2 $base"
    listbox $base.a.bans \
        -borderwidth 1 -font fixed -selectbackground #000086 \
        -selectforeground #fefefe -yscrollcommand "$base.a.scroll set"
    scrollbar $base.a.scroll \
        -borderwidth 1 -width 9 -command "$base.a.bans yview"
    frame $base.b \
        -borderwidth 2 -height 75 -width 125
    button $base.b.unban \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text unban \
	-command "unbanlist $base"
    button $base.b.close \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text close \
        -width 7 -command "killwin $base"
    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.a \
        -in $base -anchor center -expand 1 -fill both -side top 
    pack $base.a.a \
        -in $base.a -anchor center -expand 0 -fill x -side top 
    pack $base.a.a.s_mask \
        -in $base.a.a -anchor ne -expand 0 -fill both -side left 
    pack $base.a.a.s_setby \
        -in $base.a.a -anchor center -expand 0 -fill both -side left 
    pack $base.a.a.s_time \
        -in $base.a.a -anchor center -expand 1 -fill both -side left 
    pack $base.a.bans \
        -in $base.a -anchor center -expand 1 -fill both -side left 
    pack $base.a.scroll \
        -in $base.a -anchor center -expand 0 -fill y -side right 
    pack $base.b \
        -in $base -anchor center -expand 0 -fill x -side top 
    pack $base.b.unban \
        -in $base.b -anchor center -expand 1 -fill x -side left 
    pack $base.b.close \
        -in $base.b -anchor center -expand 0 -fill both -side right 
}

proc window.modes {base c} {
global wins
    if {[winfo exists $base]} { wm deiconify $base; return }
    
    set cc [crypt [string tolower $c]]
    foreach a {n t i s p m} {set wins(mw,$cc,$a) "0"}
    
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 259x238+101+140
    wm maxsize $base 259 238
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Modes for $c"
    wm iconname $base "[string tolower $c] modes"
    
    button $base.ok \
        -borderwidth 1 -foreground #000000 -padx 9 -pady 3 -text Set \
	-command "setmodewinmodes $base $c"
    button $base.ca \
        -borderwidth 1 -padx 9 -pady 3 -text Close -command "killwin $base"
    frame $base.a \
        -borderwidth 2 -height 75 -relief groove -width 125 
    checkbutton $base.a.m_i \
        -borderwidth 1 -text {Invite only (+i)} -variable wins(mw,$cc,i)
    checkbutton $base.a.m_t \
        -borderwidth 1 -text {Only ops set topic (+t)} -variable wins(mw,$cc,t)
    checkbutton $base.a.m_m \
        -borderwidth 1 -text {Moderated (+m)} -variable wins(mw,$cc,m)
    checkbutton $base.a.m_n \
        -borderwidth 1 -text {No msgs from outside (+n)} -variable wins(mw,$cc,n)
    frame $base.a.k \
        -borderwidth 2 -height 75 -width 125 
    label $base.a.k.l1 \
        -borderwidth 1 -text Key: 
    entry $base.a.k.key \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe 
    frame $base.a.l \
        -borderwidth 2 -height 75 -width 125 
    label $base.a.l.l1 \
        -borderwidth 1 -text Limit: 
    entry $base.a.l.limit \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe 
    checkbutton $base.a.m_p \
        -borderwidth 1 -text {Private (+p)} -variable wins(mw,$cc,p)
    checkbutton $base.a.m_s \
        -borderwidth 1 -text {Secret (+s)} -variable wins(mw,$cc,s)
    frame $base.t \
        -borderwidth 2 -height 75 -relief groove -width 125 
    label $base.t.l1 \
        -borderwidth 1 -text Topic: 
    entry $base.t.topic \
        -borderwidth 1 -selectbackground #000086 -selectforeground #fefefe 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.ok \
        -x 10 -y 205 -width 175 -height 25 -anchor nw -bordermode ignore 
    place $base.ca \
        -x 190 -y 205 -width 60 -height 25 -anchor nw -bordermode ignore 
    place $base.a \
        -x 10 -y 50 -width 240 -height 150 -anchor nw -bordermode ignore 
    place $base.a.m_i \
        -x 10 -y 10 -anchor nw -bordermode ignore 
    place $base.a.m_t \
        -x 10 -y 30 -anchor nw -bordermode ignore 
    place $base.a.m_m \
        -x 10 -y 50 -anchor nw -bordermode ignore 
    place $base.a.m_n \
        -x 10 -y 70 -anchor nw -bordermode ignore 
    place $base.a.k \
        -x 5 -y 115 -width 125 -height 30 -anchor nw -bordermode ignore 
    place $base.a.k.l1 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.a.k.key \
        -x 40 -y 5 -width 80 -height 20 -anchor nw -bordermode ignore 
    place $base.a.l \
        -x 135 -y 115 -width 100 -height 30 -anchor nw -bordermode ignore 
    place $base.a.l.l1 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.a.l.limit \
        -x 45 -y 5 -width 50 -height 20 -anchor nw -bordermode ignore 
    place $base.a.m_p \
        -x 115 -y 90 -anchor nw -bordermode ignore 
    place $base.a.m_s \
        -x 10 -y 90 -anchor nw -bordermode ignore 
    place $base.t \
        -x 10 -y 5 -width 240 -height 40 -anchor nw -bordermode ignore 
    place $base.t.l1 \
        -x 5 -y 10 -anchor nw -bordermode ignore 
    place $base.t.topic \
        -x 50 -y 10 -width 181 -height 20 -anchor nw -bordermode ignore 
updatemodewin $c
}

proc updatemodewin {c} {
global wins
set cc [crypt [string tolower $c]]
set w "$wins(w,$cc).modes"
if {![winfo exists $w]} {return}
foreach a {n t i s p m} {set wins(mw,$cc,$a) $wins(mb,$cc,$a)}
foreach a {a.k.key a.l.limit t.topic} {$w.$a delete 0 [string length [$w.$a get]]}
$w.a.k.key insert end $wins(mb,$cc,k)
$w.a.l.limit insert end $wins(mb,$cc,l)
$w.t.topic insert end $wins(t,$cc)
}

proc setmodewinmodes {w c} {
global wins
set cc [crypt [string tolower $c]]
set d ""
set p ""
foreach a {n t i s p m} {
 if {$wins(mw,$cc,$a)==1 && $wins(mb,$cc,$a)!=1} {set d "$d+$a"}
 if {$wins(mw,$cc,$a)==0 && $wins(mb,$cc,$a)!=0} {set d "$d-$a"}
 }
set k [$w.a.k.key get]
scan $k "%s" k ;# key tek kelime
set curk $wins(mb,$cc,k)
if {$k!=$curk} {
  if {$k=="" && $curk!=""} {set d "$d-k";set p "$p $curk"}
  if {$k!="" && $curk==""} {set d "$d+k";set p "$p $k"}
  if {$k!="" && $curk!=""} {set d "$d+k";set p "$p $k";toserver "/c $c -k $curk"}
  }
set l [$w.a.l.limit get]
if {$l!=$wins(mb,$cc,l)} {
 if {$l=="" || $l=="0"} {set d "$d-l"} else {set d "$d+l"; set p "$p $l"}
 }
toserver "/c $c $d$p"
set t [$w.t.topic get]
if {$t!=$wins(t,$cc)} {toserver "/t $c :$t"}
}

proc joinselected {args} {
set n [.serverwin.chanlist.b.chans curselection]
if {$n!=""} { scan [.serverwin.chanlist.b.chans get $n] "%s " c
	      toserver "/j $c" }
}

proc unbanlist {w} {
scan [wm title $w] "%s " c
set n [$w.a.bans curselection]
if {$n!=""} { scan [$w.a.bans get $n] "%s " m
	      toserver "/c $c -b $m" }
}

proc toggle {v} {
if {$v==0} {return 1} else {return 0}
}

proc instext2 {w tag args} {
$w configure -state normal
$w insert end [join $args] $tag
$w configure -state disabled
$w see end
}

proc instext {w tag args} {
global beep wins logdir chans querys
set args [join $args]

set logname ""
if {$logdir!=""} {
  set t [string trimleft $args "\n"]
  if {[string match ".serverwin.chan_*" $w]} {
    foreach a $chans {
      set p $wins(w,[crypt $a])
      if {$w=="$p.ft.text"} {set logname "log.[string tolower $a]"; break}
      }
   }
  if {[string match ".serverwin.query_*" $w]} {
    foreach a $querys {
      set p $wins(q,$a)
      if {$w=="$p.ft.text"} {set logname "log.[string tolower [decrypt $a]]"; break}
      }
    }
  if {$w==".serverwin.in.text"} {set logname "log.server"}
  if {[string range $t 0 7]=="\[NOTICE\]"} {set logname "log.notices"; set t [string range $t 9 end]}
if {$logname==""} {puts "not logged: $args"}
if {$logname!="" && $t!=""} {
  set f [open "$logdir$logname" a+]
  puts $f "\[[clock format [clock seconds] -format {%d/%m %H:%M:%S}]\] $t"
  close $f
  }
}

if {$tag==""} { set tag "normal" }
set tx ""; set tg ""; set b "bold"; set u "under"; set in "inverse"
set bold 0; set under 0; set inverse 0; set url 0;
for {set i 0} {$i<[string length $args]} {incr i} {
 set char [string index $args $i]
 
 if {$char=="\x02"} { ## bold
   if {$bold==1} {set tg $b}  
   if {$under==1} {set tg $tg$u}
   if {$inverse==1} {set tg $tg$in}
   if {$url==1} {set tg "url"}
   if {$tg==""} {set tg $tag}
   instext2 $w $tg $tx
   set bold [toggle $bold]
   set char ""; set tx ""; set tg ""
   }
 if {$char=="\x1f"} { ## under
   if {$bold==1} {set tg $b}  
   if {$under==1} {set tg $tg$u}
   if {$inverse==1} {set tg $tg$in}
   if {$url==1} {set tg "url"}
   if {$tg==""} {set tg $tag}
   instext2 $w $tg $tx
   set under [toggle $under]
   set char ""; set tx ""; set tg ""
   }
 if {$char=="\x16"} { ## inverse
   if {$bold==1} {set tg $b}  
   if {$under==1} {set tg $tg$u}
   if {$inverse==1} {set tg $tg$in}
   if {$url==1} {set tg "url"}
   if {$tg==""} {set tg $tag}
   instext2 $w $tg $tx
   set inverse [toggle $inverse]
   set char ""; set tx ""; set tg ""
   }
 if {$char=="\a"} { ## beep
   if {$beep==1} {bell}
   set char ""
   }
 if {$char==" "} { ## url catching
   if {$url==1} {
     set url 0
     instext2 $w "url" $tx
     set tx ""; set tg ""
     }
   if {$url==0} {
     set a "[string tolower [string range $args [expr "$i+1"] [string length $args]]]"
     if {[string match "http://*" $a]} {set url 1}
     if {[string match "ftp://*" $a]} {set url 1}
     if {[string match "www.*" $a]} {set url 1}
     if {[string match "ftp.*" $a]} {set url 1}
     if {$url==1} {
       set tx "$tx "; set char ""
       if {$bold==1} {set tg $b}  
       if {$under==1} {set tg $tg$u}
       if {$inverse==1} {set tg $tg$in}
       if {$tg==""} {set tg $tag}
       instext2 $w $tg $tx
       set tx ""; set tg ""
       }
     }
   }
 if {$char=="\x0f"} { ## reset
   if {$bold==1} {set tg $b}  
   if {$under==1} {set tg $tg$u}
   if {$inverse==1} {set tg $tg$in}
   if {$url==1} {set tg "url"}
   if {$tg==""} {set tg $tag}
   instext2 $w $tg $tx
   set bold 0; set under 0; set inverse 0
   set char ""; set tx ""; set tg ""
   }
 set tx "$tx$char"
 }
if {$bold==1} {set tg $b}  
if {$under==1} {set tg $tg$u}
if {$inverse==1} {set tg $tg$in}
if {$url==1} {set tg "url"}
if {$tg==""} {set tg $tag}
instext2 $w $tg $tx
}


proc quickwin.yes {idx} {
global nukes gotip chans rightklinereason rightzlinereason rightkillreason
global rightkickreason
set base ".serverwin.quickwin"
set s $idx

set nsize [array size nukes]
if {$s==[expr "$nsize+8"]} {$base.a.l delete 0 end; return}

set e [string trimright [string trimleft [$base.b.t.entry get] " "] " "]

set vn ""
set vn [$base.a.l curselection]
if {$vn==""} {return}
set v [$base.a.l get $vn]
set nick ""; set id ""; set ip ""
set a [split $v "@"]; set nickid [dindex 0 $a]; set ip [dindex 1 $a]
set a [split $nickid "!"]; set nick [dindex 0 $a]; set id [dindex 1 $a]
if {$s<$nsize} { ;# nuke
  set cn [crypt $nick]
  set a 0; catch "set a $gotip($cn,0)"
  if {$a==0} {set a 2} else {set a 3}
  set gotip($cn,0) $a
  set gotip($cn,3) $s
  RealNuke $nick $id $ip
  }
if {$s==[expr "$nsize+1"]} {Query $nick}
if {$s==[expr "$nsize+2"]} {foreach a $chans {toserver "/c [decrypt $a] +o $nick"}}
if {$s==[expr "$nsize+3"]} {foreach a $chans {toserver "/c [decrypt $a] -o $nick"}}
if {$s==[expr "$nsize+4"]} {
  if {$e==""} {set e $rightkickreason}
  foreach a $chans {toserver "/kick [decrypt $a] $nick $e"}}
if {$s==[expr "$nsize+5"]} {foreach a $chans {toserver "/c [decrypt $a] -o+b $nick *!*@$ip"}}
if {$s==[expr "$nsize+6"]} {foreach a $chans {toserver "/c [decrypt $a] -o+b $nick *!$id@[GetMaskFromIP $ip]"}}
if {$s==[expr "$nsize+7"]} {$base.a.l delete $vn}
if {$s==[expr "$nsize+9"]} {
  if {$e==""} {set e $rightkillreason}
  toserver "/kill $nick $e"}
if {$s==[expr "$nsize+10"]} {
  if {$e==""} {set e $rightklinereason}
  toserver "/kline *!*@$ip $e"}
if {$s==[expr "$nsize+11"]} {
  if {$e==""} {set e $rightklinereason}
  toserver "/kline *!*@[GetMaskFromIP $ip] $e"}
if {$s==[expr "$nsize+12"]} {
  if {$e==""} {set e $rightzlinereason}
  toserver "/zline $ip $e"}
if {$s==[expr "$nsize+13"]} {
  if {$e==""} {set e $rightzlinereason}
  toserver "/zline [GetMaskFromIP $ip] $e"}
}

proc window.quickwin {args} {
global nukes
    set base .serverwin.quickwin
    if {[winfo exists $base]} {wm deiconify $base; return}

    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 301x251+87+169
    wm maxsize $base 785 570
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Quick Access Window"
    wm iconname $base "dirc: QuickAccess"
    frame $base.a \
        -borderwidth 2 -height 105 -width 125 
    listbox $base.a.l \
        -borderwidth 1 -height 5 -selectbackground #000086 \
        -selectforeground #fefefe -width 24 -yscrollcommand "$base.a.s set"
    scrollbar $base.a.s \
        -borderwidth 1 -orient vert -width 9 -command "$base.a.l yview"
    frame $base.b \
        -borderwidth 2 -height 75 -width 48 
    scrollbar $base.b.s \
        -borderwidth 1 -orient vert -width 9 -command "$base.b.t yview"
    text $base.b.t \
        -height 1 -relief flat -width 1 -yscrollcommand "$base.b.s set" \
	-state disabled
    frame $base.c -borderwidth 2 -height 53 -width 125 
    button $base.c.close \
        -borderwidth 1 -font {Helvetica -12} -padx 9 -pady 3 -text Close \
        -width 10 -command "wm withdraw $base"
	
    pack $base.a -anchor n -expand 0 -fill both -side left 
    pack $base.a.l -anchor center -expand 1 -fill both -side left 
    pack $base.a.s -anchor center -expand 0 -fill y -side right 
    pack $base.b -anchor center -expand 1 -fill both -side top 
    pack $base.b.s -anchor center -expand 0 -fill y -side right 
    pack $base.b.t -anchor center -expand 1 -fill both -side left 
    pack $base.c -anchor s -expand 0 -fill both -side bottom 
    pack $base.c.close -anchor center -expand 1 -fill both -side right 

wm protocol $base WM_DELETE_WINDOW "wm withdraw $base"
set nsize [array size nukes]
$base.b.t configure -state normal
for {set i 0} {$i<$nsize} {incr i} { quickwin.ins [lindex $nukes($i) 0] $i }
quickwin.ins "Query" [expr "$i+1"]
quickwin.ins "Op in all chans" [expr "$i+2"]
quickwin.ins "Deop in all chans" [expr "$i+3"]
quickwin.ins "Kick in all chans" [expr "$i+4"]
quickwin.ins "*!*@ip ban in all chans" [expr "$i+5"]
quickwin.ins "*!ident@host ban in all chans" [expr "$i+6"]
quickwin.ins "Remove" [expr "$i+7"]
quickwin.ins "Remove All" [expr "$i+8"]
$base.b.t insert end "  "
quickwin.ins "Kill" [expr "$i+9"]
quickwin.ins "*!*@ip K-Line" [expr "$i+10"]
quickwin.ins "*!*@*.host K-Line" [expr "$i+11"]
quickwin.ins "ip Z-Line" [expr "$i+12"]
quickwin.ins "*.host Z-Line" [expr "$i+13"]
entry $base.b.t.entry -borderwidth 1 -font {Helvetica -8} \
                      -selectbackground #000086 -selectforeground #fefefe
$base.b.t window create end -window $base.b.t.entry -stretch 1
$base.b.t configure -state disabled
}

proc quickwin.ins {title idx} {
set base .serverwin.quickwin
button $base.b.t.b$idx -borderwidth 1 -font {Helvetica -8} -padx 1 -pady 1 \
      -text $title -command "quickwin.yes $idx" -cursor top_left_arrow \
      -justify right
 $base.b.t window create end -window $base.b.t.b$idx -stretch 1
}

proc pgupdnbnd {base tw} {
bind $base.entry <Shift-Prior> "$base.$tw.text see 0.0"
bind $base.entry <Shift-Next> "$base.$tw.text see end"
bind $base.entry <Prior> "$base.$tw.text yview scroll -1 pages"
bind $base.entry <Next> "$base.$tw.text yview scroll 1 pages"
bind $base.entry <Home> "$base.entry icursor 0"
bind $base.entry <End> "$base.entry icursor end"
}

proc wnumbind {c base} {
global wins usedsk chans
set bs ""
for {set x 1} {$x<10} {incr x} {if {[lsearch $usedsk $x]==-1} {set bs $x; break}}
foreach a $chans {
 set b [crypt $a]
 set w $wins(w,$b)
 set s $wins(s,$b)
 bind $base.entry <Control-$s> "wm deiconify $w; focus $w.entry"
 puts "\n*$c*[bind $base]*"
 bind $base.entry <Control-0> "wm deiconify .serverwin; focus .serverwin.entry"
 if {$bs!=""} { bind $w.entry <Control-$bs> "wm deiconify $base; focus $base.entry" }
 }
bind .serverwin.entry <Control-$bs> "wm deiconify $base; focus $base.entry"
if {$bs!=""} {set wins(s,[crypt $c]) $bs; lappend usedsk $bs}
}

proc wnumunbind {c base} {
global wins usedsk chans
set k $wins(s,[crypt $c])
foreach a $chans {
 set b [crypt $a]
 set w $wins(w,$b)
 bind $w.entry <Control-$k> {}
 }
bind .serverwin.entry <Control-$k> {}
set n [lsearch $usedsk $k]
if {$n!=-1} {lreplace $usedsk $n $n}
}
