# country.tcl by Jay Monk <jaym@utdallas.edu>
# COMMANDS
# country <node>    (dcc or public)

# Do not use pico to edit this file, it'll break
# up the long lines.. and this file has some LONG lines!

bind dcc - country dcc_country
bind msg - country msg_country
bind pub - !country pub_country

proc dcc_country {hand idx arg} {
  global country symbol
  if {$arg == "" || [llength $arg] > 1} {
    putdcc $idx "Correct usage: .country <node>"
    putdcc $idx "      Example: .country .[lindex $symbol [rand [llength $country]]]"
    return 0
  }
  set this [lsearch -exact $symbol [string trimleft [string toupper $arg] .]]
  if {$this > -1} {
    putdcc $idx "Country name for .[string trimleft [string toupper $arg] .] is [lindex $country $this]"
    return 0
  } else {
    putdcc $idx "No country name found for .[string trimleft [string toupper $arg] .]"
    return 0
  }
}

proc msg_country {nick uhost hand arg} {
  global country symbol botnick
  if {$arg == "" || [llength $arg] > 1} {
    putserv "NOTICE $nick :Correct usage: /msg $botnick country <node>"
    putserv "NOTICE $nick :      Example: /msg botnick country .[lindex $symbol [rand [llength $country]]]"
    return 0
  }
  set this [lsearch -exact $symbol [string trimleft [string toupper $arg] .]]
  if {$this > -1} {
    putserv "NOTICE $nick :Country name for .[string trimleft [string toupper $arg] .] is [lindex $country $this]"
    return 1
  } else {
    putserv "NOTICE $nick :No country name found for .[string trimleft [string toupper $arg] .]"
    return 0
  }
}

proc pub_country {nick uhost hand channel arg} {
  global country symbol botnick
  if {$arg == "" || [llength $arg] > 1} {
    putserv "NOTICE $nick :Correct usage: !country <node>"
    putserv "NOTICE $nick :      Example: !country .[lindex $symbol [rand [llength $country]]]"
    return 0
  }
  set this [lsearch -exact $symbol [string trimleft [string toupper $arg] .]]
  if {$this > -1} {
    putserv "PRIVMSG $channel :Country name for .[string trimleft [string toupper $arg] .] is [lindex $country $this]"
    return 1
  } else {
    putserv "PRIVMSG $channel :No country name found for .[string trimleft [string toupper $arg] .]"
    return 0
  }
}

set country {
 "AFGHANISTAN" "ALBANIA" "ALGERIA" "AMERICAN SAMOA"
 "ANDORRA" "ANGOLA" "ANGUILLA" "ANTARCTICA"
 "ANTIGUA AND BARBUDA" "ARGENTINA" "ARMENIA" "ARUBA"
 "AUSTRALIA" "AUSTRIA" "AZERBAIJAN" "BAHAMAS"
 "BAHRAIN" "BANGLADESH" "BARBADOS" "BELARUS"
 "BELGIUM" "BELIZE" "BENIN" "BERMUDA"
 "BHUTAN" "BOLIVIA" "BOSNIA" "BOTSWANA"
 "BOUVET ISLAND" "BRAZIL" "BRITISH INDIAN OCEAN TERRITORY" "BRUNEI DARUSSALAM"
 "BULGARIA" "BURKINA FASO" "BURUNDI" "BYELORUSSIAN SSR"
 "CAMBODIA" "CAMEROON" "CANADA" "CAP VERDE"
 "CAYMAN ISLANDS" "CENTRAL AFRICAN REPUBLIC" "CHAD" "CHILE"
 "CHINA" "CHRISTMAS ISLAND" "COCOS (KEELING) ISLANDS" "COLOMBIA"
 "COMOROS" "CONGO" "COOK ISLANDS" "COSTA RICA"
 "COTE D'IVOIRE" "CROATIA" "HRVATSKA" "CUBA"
 "CYPRUS" "CZECHOSLOVAKIA" "DENMARK" "DJIBOUTI"
 "DOMINICA" "DOMINICAN REPUBLIC" "EAST TIMOR" "ECUADOR"
 "EGYPT" "EL SALVADOR" "EQUATORIAL GUINEA" "ESTONIA"
 "ETHIOPIA" "FALKLAND ISLANDS" "MALVINAS" "FAROE ISLANDS"
 "FIJI" "FINLAND" "FRANCE" "FRENCH GUIANA"
 "FRENCH POLYNESIA" "FRENCH SOUTHERN TERRITORIES" "GABON" "GAMBIA"
 "GEORGIA" "GERMANY" "DEUTSCHLAND" "GHANA"
 "GIBRALTAR" "GREECE" "GREENLAND" "GRENADA"
 "GUADELOUPE" "GUAM" "GUATEMALA" "GUINEA"
 "GUINEA BISSAU" "GYANA" "HAITI" "HEARD AND MC DONALD ISLANDS"
 "HONDURAS" "HONG KONG" "HUNGARY" "ICELAND"
 "INDIA" "INDONESIA" "IRAN" "IRAQ"
 "IRELAND" "ISRAEL" "ITALY" "JAMAICA"
 "JAPAN" "JORDAN" "KAZAKHSTAN" "KENYA"
 "KIRIBATI" "NORTH KOREA" "SOUTH KOREA" "KUWAIT"
 "KYRGYZSTAN" "LAOS" "LATVIA" "LEBANON"
 "LESOTHO" "LIBERIA" "LIBYAN ARAB JAMAHIRIYA" "LIECHTENSTEIN"
 "LITHUANIA" "LUXEMBOURG" "MACAU" "MACEDONIA"
 "MADAGASCAR" "MALAWI" "MALAYSIA" "MALDIVES"
 "MALI" "MALTA" "MARSHALL ISLANDS" "MARTINIQUE"
 "MAURITANIA" "MAURITIUS" "MEXICO" "MICRONESIA"
 "MOLDOVA" "MONACO" "MONGOLIA" "MONTSERRAT"
 "MOROCCO" "MOZAMBIQUE" "MYANMAR" "NAMIBIA"
 "NAURU" "NEPAL" "NETHERLANDS" "NETHERLANDS ANTILLES"
 "NEUTRAL ZONE" "NEW CALEDONIA" "NEW ZEALAND" "NICARAGUA"
 "NIGER" "NIGERIA" "NIUE" "NORFOLK ISLAND"
 "NORTHERN MARIANA ISLANDS" "NORWAY" "OMAN" "PAKISTAN"
 "PALAU" "PANAMA" "PAPUA NEW GUINEA" "PARAGUAY"
 "PERU" "PHILIPPINES" "PITCAIRN" "POLAND"
 "PORTUGAL" "PUERTO RICO" "QATAR" "REUNION"
 "ROMANIA" "RUSSIAN FEDERATION" "RWANDA" "SAINT KITTS AND NEVIS"
 "SAINT LUCIA" "SAINT VINCENT AND THE GRENADINES" "SAMOA" "SAN MARINO"
 "SAO TOME AND PRINCIPE" "SAUDI ARABIA" "SENEGAL" "SEYCHELLES"
 "SIERRA LEONE" "SINGAPORE" "SLOVENIA" "SOLOMON ISLANDS"
 "SOMALIA" "SOUTH AFRICA" "SPAIN" "SRI LANKA"
 "ST. HELENA" "ST. PIERRE AND MIQUELON" "SUDAN" "SURINAME"
 "SVALBARD AND JAN MAYEN ISLANDS" "SWAZILAND" "SWEDEN" "SWITZERLAND"
 "CANTONS OF HELVETIA" "SYRIAN ARAB REPUBLIC" "TAIWAN" "TAJIKISTAN"
 "TANZANIA" "THAILAND" "TOGO" "TOKELAU"
 "TONGA" "TRINIDAD AND TOBAGO" "TUNISIA" "TURKEY"
 "TURKMENISTAN" "TURKS AND CAICOS ISLANDS" "TUVALU" "UGANDA"
 "UKRAINIAN SSR" "UNITED ARAB EMIRATES" "UNITED KINGDOM" "GREAT BRITAIN"
 "UNITED STATES OF AMERICA" "UNITED STATES MINOR OUTLYING ISLANDS" "URUGUAY" "SOVIET UNION"
 "UZBEKISTAN" "VANUATU" "VATICAN CITY STATE" "VENEZUELA"
 "VIET NAM" "VIRGIN ISLANDS (US)" "VIRGIN ISLANDS (UK)" "WALLIS AND FUTUNA ISLANDS"
 "WESTERN SAHARA" "YEMEN" "YUGOSLAVIA" "ZAIRE"
 "ZAMBIA" "ZIMBABWE" "COMMERCIAL ORGANIZATION (US)" "EDUCATIONAL INSTITUTION (US)"
 "NETWORKING ORGANIZATION (US)" "MILITARY (US)" "NON-PROFIT ORGANIZATION (US)" "GOVERNMENT (US)"
 "KOREA - DEMOCRATIC PEOPLE'S REPUBLIC OF" "KOREA - REPUBLIC OF" "LAO PEOPLES' DEMOCRATIC REPUBLIC" "RUSSIA"
 "SLOVAKIA" "CZECH"
}

set symbol {
 AF AL DZ AS AD AO AI AQ AG AR AM AW AU AT AZ BS BH BD BB BY BE
 BZ BJ BM BT BO BA BW BV BR IO BN BG BF BI BY KH CM CA CV KY CF
 TD CL CN CX CC CO KM CG CK CR CI HR HR CU CY CS DK DJ DM DO TP
 EC EG SV GQ EE ET FK FK FO FJ FI FR GF PF TF GA GM GE DE DE GH
 GI GR GL GD GP GU GT GN GW GY HT HM HN HK HU IS IN ID IR IQ IE
 IL IT JM JP JO KZ KE KI KP KR KW KG LA LV LB LS LR LY LI LT LU
 MO MK MG MW MY MV ML MT MH MQ MR MU MX FM MD MC MN MS MA MZ MM
 NA NR NP NL AN NT NC NZ NI NE NG NU NF MP NO OM PK PW PA PG PY
 PE PH PN PL PT PR QA RE RO RU RW KN LC VC WS SM ST SA SN SC SL
 SG SI SB SO ZA ES LK SH PM SD SR SJ SZ SE CH CH SY TW TJ TZ TH
 TG TK TO TT TN TR TM TC TV UG UA AE UK GB US UM UY SU UZ VU VA
 VE VN VI VG WF EH YE YU ZR ZM ZW COM EDU NET MIL ORG GOV KP KR
 LA SU SK CZ
}

