# seen1.0.tcl version 0.03 (28 - 03 - 1996)
# will ONLY work with eggdrop version 1.0 BETA or newer :)
# no MSG supported :)
# 
# author : tnz (lice@ee.petra.ac.id)
#
# list buffer is 100
# 

bind join - * join_log
bind pub - seen pub_seen

proc join_log {nick uhost hand channel} {
   global nick_list time_list host_list chan_list

   if {[llength nick_list] == 200} {
      set nick_list [lreplace ${nick_list} 0 0]
      set time_list [lreplace ${time_list} 0 0]
      set host_list [lreplace ${host_list} 0 0]
      set chan_list [lreplace ${chan_list} 0 0]
   }

   set the_nick [string tolower $nick]
   set idx [lsearch -exact ${nick_list} ${the_nick}]
   
   if {$idx != -1} {
      set nick_list [lreplace ${nick_list} $idx $idx]
      set time_list [lreplace ${time_list} $idx $idx]
      set host_list [lreplace ${host_list} $idx $idx]
      set chan_list [lreplace ${chan_list} $idx $idx]
   }
      
   lappend nick_list [list ${the_nick}]
   lappend time_list [list [unixtime]]
   lappend host_list [list ${uhost}]
   lappend chan_list [list $channel]
}

proc pub_seen {nick uhost hand channel args} {
   global nick_list time_list host_list chan_list

   set the_args [string tolower $args]
   set idx [lsearch -exact ${nick_list} ${the_args}]

   if {$idx != -1} {
      set when_join [lindex ${time_list} $idx]
      set when_time [ctime $when_join]
      set host_name [lindex ${host_list} $idx]
      set the_nick [lindex ${nick_list} $idx]
      set the_date [date]
      set the_time [time]
      set the_chan [lindex ${chan_list} $idx]

      putserv "PRIVMSG $channel :Last time I saw $the_nick on $the_chan $when_time"

      if {[onchan $the_nick $channel]} {
         putserv "PRIVMSG $channel :\002$the_nick\002 is on \002$channel\002 right now"
      }
      if {[onchansplit $the_nick $channel]} {
         putserv "NOTICE $nick :\002$the_nick was just on $channel, but got NETSPLIT"
      }

   } {
      putserv "PRIVMSG $channel :\002Sorry, no info for $args"
   }
}

if {![info exists set_seen_running]} {
   set nick_list ""
   set time_list ""
   set host_list ""
   set chan_list ""

   set set_seen_running 1
}




