
#include <stdio.h>
#include <unistd.h>   /* R_OK */
#include <sys/dir.h>  /* MAXFNAMLEN */

char *en_crypt(),*de_crypt(); /* external, in crypt.c */

/* defines for encoding and decoding */
#define KEYLEN  24+1          /* size of keys */ 
#define MAXKEYS 30            /* number of keys we keep track of */
#define HUGE 1024             /* big size for buffers */
#define SECKEY  "secret"      /* secret key file,  should be a variable */
#define LINELEN 65            /* must be less than 90,  line wrap */
                              /* why? irc message length limits */

/* keys database */
char keys[MAXKEYS][KEYLEN];            /* the actual keys */
unsigned int  sers[MAXKEYS];           /* serial numbers  */

/* globals for irc interface */
int nickvalid = 0;             /* tells if 'nick' has valid data */
char *nick,ournick[50];        /* dest nick and our nick         */

/* strings sent to ircII script */
#define S_TOSCREEN   "TSCREEN:"
#define S_TONICK     "TNICKNM:"
#define S_TOCHAN     "TCHANNL:"
/* output routines */
#define TO_SCREEN(str)    (printf("%s %s\n",S_TOSCREEN,(str)))
#define TO_SCRKEY(str)    (printf("%s K<%s> %s\n",S_TOSCREEN,\
  (nickvalid)?nick:"???",(str)))
#define TO_SCRENC(str)    (printf("%s E<%s> %s\n",S_TOSCREEN,\
  (nickvalid)?nick:"???",(str)))
#define TO_REMOTE(str)    ((nickvalid)?\
  printf("%s %s %s\n",S_TONICK,nick,(str)):\
  printf("%s %s\n",S_TOCHAN,(str)))


/* find_path()
 * return path to file if can find it.
 * look in current dir first, then in $KEYDIR then in
 * ./pubkeys directory.
 * if not found.. return null
 */
char *find_path(name)
char *name;
{
  char *path;
  static char fname[MAXNAMLEN];

  if(access(name,R_OK)==0) return(name);
  if(path=(char *)getenv("KEYDIR")) {
    sprintf(fname,"%s/%s",path,name);
    if(access(fname,R_OK)==0) return(fname);
  }
  sprintf(fname,"pubkeys/%s",name);
  if(access(fname,R_OK)==0) return(fname);
  return(0);
}

/* casecmp(a,b)
     a,b - null terminated strings.
       does a non-case sensitive compare
 */
#define To_lower(a)    (isupper(a)?tolower(a):(a))

casecmp(a,b)
char *a,*b;
{
  while(*a && *b) 
    if(To_lower(*a) != To_lower(*b)) 
      return (*b-*a);   /* doesnt really matter if they are diff cases here*/
    else {
      a++,b++;
    }
  return(0);
}

/* asctobin(str,len)
     str - ascii string (null terminated)
     len - int *,   RETURN length of binary block
     returns:  char * to binary block data in static storage.
       coding:
         high nybble - 'a'=0 to 'p'=15
         low nybble  - 'A'=0 to 'P'=15
      NULL returned for bad encoding. 
 */
char *asctobin(str,len)
char *str;
int *len;
{
  static char buf[HUGE];
  char a,b;
  int i;

  for(i=0;;) {
    a= *str++;
    while(a==' '||a=='\n') a= *str++;
    b= *str++;
    if(a=='\0' || b=='\0') {
      *len=i;
      return(buf);
    }
    if (a<'a'||a>'p' || b<'A'||b>'P') 
      return(0);
    buf[i++] = ((a-'a')<<4)|(b-'A');
  }
}

/* bintoasc(str,len)
      str - a pointer to a binary block
      len - length of binary block in bytes
      return - char * to a string that is ascii, null-terminated
        coding -
           high nybble  'a'=0 to 'p'=15
           low nybble   'A'=0 to 'P'=15
 */
char *bintoasc(str,len)
int len;
char *str;
{
  static char buf[HUGE];
  int i;
  
  for(i=0;len-- >0;str++) {
    buf[i++]=((*str&0xf0)>>4) + 'a';
    buf[i++]=(*str&0xf) + 'A'; 
    if((rand()&0x03) == 0) buf[i++]=' ';  /* wow, now it has spaces! */
  }
  buf[i]='\0';
  return(buf);
}

/* encode(str)
     str - an ascii null-terminated string 
     encoding:
       CLIPPER:xxxx:yyyyyyyyyyyyy
          xxxx - serial number of key used
          yyyyy- ascii coded, encrypted text message
     Note: only prints LINELEN characters per message. does 
           line wrap.
     return - nothing, prints results to remote
 */
encode(str)
char *str;
{
  int l,ser,a,i;
  char buf[HUGE];
  char tmp[LINELEN+5]; 
  char *p;

  set_key(keys[0]);          /* use our key and our serial number */
  a=strlen(str);
  while (a>LINELEN) {         /* do line wrap */
    for(i=LINELEN;i>0;i--)
      if(isspace(str[i])) break;
    if(i==0) 
      i=LINELEN;             /* couldnt break at a space */
    else
      i++;                   /* put spaces on the same line */
    strncpy(tmp,str,i);     
    tmp[i]='\0';
    p=en_crypt(tmp,i+2,&l);
    sprintf(buf,"CLIPPER:%d:%s",sers[0],bintoasc(p,l));
    TO_REMOTE(buf);
    a-=i;                    /* skip over what we just outputed */
    str+=i;
  } 
  p=en_crypt(str ,a+1,&l);   /* add 1 so we get the NULL too */
  sprintf(buf,"CLIPPER:%d:%s",sers[0],bintoasc(p,l));
  TO_REMOTE(buf);
}

/*  decode(str)
      str - ascii string, null terminated
       coding:  see encode()
       error codes are returned as human readable strings.

        CLIPPER:xxxx:yyyyyy
            x - ascii serial number
            y - ascii encoded binary data, crypted
        SKPJACK:xxxx:yyyy:zzzz
            x - nick name of destination
            y - serial number of key being received
            z - ascii encoded binary data,  encrypted with rsa
                in 'nick's public key ,  contains the key
                needed to read messages from nick
       returned - nothing,  results output to screen
 */
decode(str)
char *str;
{
  char *p;      /* lots of chars */
  char buf[HUGE];
  int i,ser,l,a,itsakey=0,len;
  
  if(strncmp(str,"SKPJACK:",8)==0) 
    itsakey=1;                          /* someones sending a key */
  else if(strncmp(str,"CLIPPER:",8))   
      return(0);                    /* not encoded */
  for(i=8;str[i]!=':'&&str[i]!='\0';i++);  /* jump past ser # */
  if(str[i]!=':') {
    TO_SCRENC("*Badly Formed*");
    return(0);
  }
  str[i++]='\0';
  ser=atoi(str+8);                          /* this is ser # */

  if(itsakey && casecmp(str+8,ournick)==0) {      /* new key sent to us */
    ser=atoi(str+i);
    for(;str[i]!=':'&&str[i]!='\0';i++) ;
    if(str[i++]!=':') {
      TO_SCRKEY("*Newkey: badly formed*");
      return(0);
    }
    p=asctobin(str+i,&len);
    if(!p)  {
      TO_SCRKEY("*new key: bad coding*");
      return(0);
    }
    memcpy(buf,p,len);         /* copy binary data */
    p=find_path(SECKEY);
    if (!p)  {
      TO_SCRKEY("*Newkey: 'secret' not found!*");
      return(0);
    }
    if(do_rsa(p,buf,len,HUGE)<0)  {
      TO_SCRKEY("*new key: couldnt decrypt (rsa)*");
      return(0);
    }
    for(i=0;i<MAXKEYS;i++) 
      if(sers[i]==0 || sers[i]==ser) break;
    if(i==MAXKEYS) {
      TO_SCRKEY("*new key: out of table entries*");
      return(0);
    }
    if(sers[i]==ser) {
                    /* *never* receive a key we already have */
                    /* this could be a trick                 */
      TO_SCRKEY("*new key: already have it!*");
      return(0);
    }
    sers[i]= ser;
    memcpy(keys[i],buf,KEYLEN);
    TO_SCRKEY("*New Key installed*");
    return(0);
  }
  if (itsakey) {
    sprintf(buf,"*Saw key for %s*",str+8);
    TO_SCRKEY(buf);
    return(0);
  }

  /* else its a message , try to decode */  

  a=key(ser);                               /* find the key */
  if(a==-1) {
    TO_SCRENC("*Dont Have the Key*");
    return(0);
  }
  set_key(keys[a]);
  p=asctobin(str+i,&len);                   /* decrypt it */
  if(!p) { 
    TO_SCRENC("*Bad Encoding*");
    return(0);
  }
  TO_SCRENC(de_crypt(p,len,&l));
  return(0);
}

/*  key(ser)
      ser = serial number 
      returned - index to the key with serial number ser, else -1 
 */
int key(ser)
int ser;
{
  int i;

  for(i=0;i<MAXKEYS;i++)
    if(ser == sers[i]) return(i);
  return(-1);
}

/* sendkey(line)
     line - char *,  everything after  /key on the command line
       parsed to 'nick' and the optional 'filename'
       filename is set to nick if it doesnt exist.
     returned - nothing,  outputs to remote (errors to screen)
    encodes our key and serial number with nick's public
    key and sends it over the current channel for him
    to receive 
 */
sendkey(line)     /* handle  /key nick [filename]   */
char *line;
{
  char *file,*p;
  char buf[1024];
  int len;

  while(*line==' ') line++;
  nick=line;
  while(*line!=' '&&*line!='\0'&&*line!='\n') line++; 
  if(*line=='\n') *line='\0';
  if(*line=='\0') 
    file=nick;
  else {
    *line++='\0';
    file=line;
    while(*line!=' '&&*line!='\0'&&*line!='\n') line++; 
    *line='\0';
  }
  if(*nick=='\0') {
    TO_SCREEN("*ERROR*  nick missing,  /key nick [file]");
    return;
  }

  memcpy(buf,keys[0],KEYLEN);
  p=find_path(file);
  if(!p) {
    sprintf(buf,"*Error* public key file '%s' not found",file);
    TO_SCREEN(buf);
    return(0);
  }
  len=do_rsa(p,buf,KEYLEN,1024);
  if(len<0)  {
    sprintf(buf,"*ERROR* public key file corrupt for %s",file);
    TO_SCREEN(buf);
    return(0);                 /* couldnt send it, RSA failed */
  }
  p=bintoasc(buf,len);
  sprintf(buf,"SKPJACK:%s:%d:%s",
          nick,sers[0],p);
  nickvalid=1;                 /* send it to their nick */
  TO_REMOTE(buf);
}

/* everything above this line (excluding some #include's and #defines)
   is for encoding and decoding messages.
 */
main(argc, argv)
  int argc;
  char **argv;
{
  int i;

  /* pick random  key -> K                */
  /* encrypt  crypt(K,K) -> serial number */
  /* pick random  L                       */
  /* encrypt  crypt(L,K) -> our DES key   */

  srand(time(0));
  for(i=0;i<KEYLEN;i++)
    keys[0][i]= (char)((rand()&0xff00)>>8);
  set_key(keys[0]);
  en_crypt(keys[0],KEYLEN,&i);
  sers[0] = (int) *((int *)keys[0]);  /* pick serial number */
  /* if(sers[0]<0) sers[0]=-sers[0];     /* problem with negative ser #'s */
  for(i=0;i<KEYLEN;i++)
    keys[0][i]= (char)((rand()&0xff00)>>8);
  en_crypt(keys[0],KEYLEN,&i);

  strcpy(ournick,"*invalid*");      /* dont know yet */

  do_it();
}

/* gets messages from ircII, sends em back to ircII
   messages can be from either user, or remote users
   and to local screen or to remote users.
   to distinguish, client stuff passes it to use with
   special headers:
        optionally preceeded by:
          !nick!       nickname of sending party for
                       CLIPPER: and SKIPJACK: 
                       nickname of destination for key SENDKEY: 
                       CRYPTME:
        to us from remote users
          CLIPPER:     encrypted message
          SKPJACK:     key exchange
        to us from local user
          CRYPTME:     to be encrypted 
          SENDKEY:     send key to another user
          QUITDIE:     shut down.. die, etc.
          OURNICK:     tell us what our current nick is
        to ircII
          TSCREEN:     to users screen
          TCHANNL:     to current channel 
          TNICKNM:     to specified (following) nickname
 */

#define NUMTOK 6 
char *tok[NUMTOK] = { 
     "CLIPPER:","SKPJACK:","CRYPTME:","SENDKEY:","QUITDIE:","OURNICK:", 
};

do_it()         /* main loop here */
{
  char buf[1024],*str;
  char temp[1024];
  int i;
 
  while(1) {
    if(gets(buf)==NULL)    /* input line from irc */
      return;
    str=buf;
    nickvalid=0;
    if(*str == '!') {
      nick= ++str;
      while(*str!='!' && *str!='\0') str++;
      if (*str!='\0') 
        *str++='\0';
      nickvalid=1;
    } else nick="!dunno!";
    for(i=0;i<NUMTOK;i++)
      if(strncmp(str,tok[i],8)==0) break;
    switch(i) {
      case  0:      /* encrypted message */
      case  1:      /* new key sent to us */
           decode(str);
           break; 
      case  2:      /* message to be encrypted */
           encode(str+8);
           break;
      case  3:      /* send a key to a user */
           sendkey(str+8);
           break;
      case  4:      /* get out of dodge, and quick */
           return;
      case  5:      /* update ournick */
           strcpy(ournick,str+8);
           break;

      case NUMTOK:
      default:      /* no prefix, encrypt it  */
          encode(str);
          break;
    }
    fflush(stdout);
  }
} 

