/*
 * hash2.h: function header file for hash.c
 *
 * Written by Scott H Kilau
 *
 * CopyRight(c) 1997
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT
 *
 * @(#)$Id: hash2.h,v 1.0 1995/01/24 11:21:40 shk $
 */

#ifndef _HASH2_H_
#define _HASH2_H_

#include "struct.h"
#include "whowas.h"

void	add_nicklist_to_channellist(NickList *, ChannelList *);
void	add_whowas_userhost_channel _((WhowasList *, WhowasWrapList *));

WhowasList *find_userhost_channel _((char *, char *, int, WhowasWrapList *));

void	clear_whowas_hash_table _((WhowasWrapList *));
int	remove_oldest_whowas_hashlist _((WhowasWrapList *, time_t, int));

WhowasList *next_userhost_channel _((WhowasWrapList *, WhowasList *));

NickList *find_nicklist_in_channellist(char *, ChannelList *, int);
NickList *next_nicklist(ChannelList *, NickList *);

void	clear_nicklist_hashtable(ChannelList *);
void	show_nicklist_hashtable(ChannelList *);

void show_whowas_hashtable(WhowasWrapList *cptr, char *);
WhowasList *next_userhost(WhowasWrapList *cptr, WhowasList *nptr);
int show_wholeft_hashtable(WhowasWrapList *cptr, time_t ltime, int *total, int *hook, char *);

/* Added to sort a hash'd nicklist and them remove the sorted list */
extern NickList *sorted_nicklist(ChannelList *);
extern void clear_sorted_nicklist(NickList **);

#endif
