/*
 * irc_std.h: header to define things used in all the programs ircii
 * comes with
 *
 * hacked together from various other files by matthew green
 * copyright(c) 1993 
 *
 * See the copyright file, or do a help ircii copyright 
 *
 * @(#)$Id: irc_std.h,v 1.20.2.1 1995/10/25 19:03:59 glen Exp $
 */

#ifndef __irc_std_h
#define __irc_std_h

#undef _
#undef const
#undef volatile
#ifdef __STDC__
# define _(a) a
#else
# define _(a) ()
# define const
# define volatile
#endif

#ifndef __GNUC__
#define __inline                /* delete gcc keyword */
#define __A(x)
#define __N
#else
#define __A(x)
/*__attribute__ ((format (printf, x, x + 1))) */
#define __N    __attribute__ ((noreturn))
#endif

#ifdef __GNUC__
#  ifndef HAVE_ALLOCA_H
#    define alloca __builtin_alloca
#  endif
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else
#   ifndef alloca
char *alloca();
#   endif
#  endif
# endif
#endif


# include <errno.h>
extern	int	errno;

#ifndef NBBY
# define NBBY	8		/* number of bits in a byte */
#endif /* NBBY */

#ifndef NFDBITS
# define NFDBITS	(sizeof(long) * NBBY)	/* bits per mask */
#endif /* NFDBITS */

#undef FD_SET
#define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))

#undef FD_CLR
#define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))

#undef FD_ISSET
#define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))

#undef FD_ZERO
#define FD_ZERO(p)	memset((void *)(p), 0, sizeof(*(p)))

#ifndef	FD_SETSIZE
#define FD_SETSIZE	32
#endif


#ifdef HAVE_SYS_SYSLIMITS_H
# include <sys/syslimits.h>
#endif
   
#include <limits.h>
   
typedef RETSIGTYPE sigfunc _((int));
sigfunc *my_signal _((int, sigfunc *, int));

#include <string.h>
#include <stdlib.h>
#undef index
#define index strchr

#ifndef MAXPATHLEN
#define MAXPATHLEN  PATHSIZE
#endif

#ifndef HAVE_STRERROR
#ifndef SYS_ERRLIST_DECLARED
extern  char    *sys_errlist[];
#endif
#define strerror(x) sys_errlist[x]
#endif

#ifdef HAVE_BSDGETTIMEOFDAY
#define gettimeofday BSDgettimeofday
#endif

#ifdef GETTOD_NOT_DECLARED
extern	int	gettimeofday(struct timeval *tv, struct timezone *tz);
#endif

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

/* we need an unsigned 32 bit integer for dcc, how lame */

#ifdef UNSIGNED_LONG32

typedef		unsigned long		u_32int_t;

#else
# ifdef UNSIGNED_INT32

typedef		unsigned int		u_32int_t;

# else

typedef		unsigned long		u_32int_t;

# endif /* UNSIGNED_INT32 */
#endif /* UNSIGNED_LONG32 */

#ifdef __STDC__
#define BUILT_IN_COMMAND(x) \
	void x (char *command, char *args, char *subargs)
#else
#define BUILT_IN_COMMAND(x) \
	void x (command, args, subargs) char *command, *args, *subargs;
#endif


#if defined(_AIX)
int getpeername _((int s, struct sockaddr *, int *));
int getsockname _((int s, struct sockaddr *, int *));
int socket _((int, int, int));
int bind _((int, struct sockaddr *, int));
int listen _((int, int));
int accept _((int, struct sockaddr *, int *));
int recv _((int, void *, int, unsigned int));
int send _((int, void *, int, unsigned int));
int gettimeofday _((struct timeval *, struct timezone *));
int gethostname _((char *, int));
int setsockopt _((int, int, int, void *, int));
int setitimer _((int, struct itimerval *, struct itimerval *));
int ioctl _((int, int, ...));

#endif

#endif /* __irc_std_h */

