/*
 * Module/dll handling code written by Colten Edwards.
 * Copyright 1997
 */
 
#ifndef _MODULE_H
#define _MODULE_H


#ifdef WANT_DLL
#include "struct.h"
#define COMMAND_PROC	0x0001		/* New /command proc */
#define ALIAS_PROC	0x0002		/* new $alias proc */
#define CTCP_PROC	0x0004		/* new ctcp proc */
#define VAR_PROC	0x0008		/* new variable */
#define HOOK_PROC	0x0010		/* new numeric proc */
#define RAW_PROC	0x0020		/* new raw irc proc */

typedef int (Irc_PackageInitProc)  _((IrcCommandDll **interp));
typedef char *(Irc_PackageVersionProc)  _((IrcCommandDll **interp));

typedef struct _package_installed {
	struct _package_installed *next;
	char    *name;
	char    *version;
#if defined(__osf__)
	ldr_module_t handle;
#elif defined(HPUX)
	shl_t handle;
#else
	void	*handle;
#endif
	Irc_PackageInitProc *cleanup;
} Packages;
                                
Packages *find_module _((char *));
int add_module_proc _((int, char *, char *, char *, int, int, void *, void *));
int remove_package _((char *));
int remove_module_procs _((int, char *, char *, char *));

extern IrcVariableDll *dll_variable;
extern BuiltInDllFunctions *dll_functions;
extern NumericFunction *numeric_dll;
extern IrcCommandDll *dll_commands;
extern CtcpEntryDll *dll_ctcp;

#endif

#endif
