/*
 * ircII: a new irc client.  I like it.  I hope you will too!
 *
 * Written By Michael Sandrof
 * Copyright(c) 1990 
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

const char irc_version[] = "BitchX-72";

/*
 * INTERNAL_VERSION is the number that the special alias $V returns.
 * Make sure you are prepared for floods, pestilence, hordes of locusts, 
 * and all sorts of HELL to break loose if you change this number.
 * Its format is actually YYYYMMDD, for the _release_ date of the
 * client..
 */
const char internal_version[] = "19970701";

#include "irc.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#ifdef USING_CURSES
#include <curses.h>
#endif
#include <stdarg.h>

#include "status.h"
#include "dcc.h"
#include "names.h"
#include "vars.h"
#include "input.h"
#include "alias.h"
#include "output.h"
#include "ircterm.h"
#include "exec.h"
#include "screen.h"
#include "log.h"
#include "server.h"
#include "hook.h"
#include "keys.h"
#include "ircaux.h"
#include "edit.h"
#include "window.h"
#include "history.h"
#include "exec.h"
#include "notify.h"
#include "numbers.h"
#include "mail.h"
#include "debug.h"
#include "newio.h"
#include "timer.h"
#include "whowas.h"
#include "misc.h"
#include "tcl_bx.h"

int	irc_port = IRC_PORT,			/* port of ircd */
	strip_ansi_in_echo,
	current_on_hook = -1,			/* used in the send_text()
						 * routine */
	use_flow_control = USE_FLOW_CONTROL,	/* true: ^Q/^S used for flow
						 * cntl */
	current_numeric,			/* this is negative of the
						 * current numeric! */
	dumb = 0,				/* if true, IRCII is put in
						 * "dumb" mode */
	no_fork = 0,				/* if true, IRCII won't with
						 * -b or -e */
	bflag = 1,
	
	use_input = 1,				/* if 0, stdin is never
						 * checked */
	key_pressed = 0,
	waiting_out = 0,				/* used by /WAIT command */
	waiting_in = 0,				/* used by /WAIT command */
	who_mask = 0,				/* keeps track of which /who
						 * switchs are set */
	background = 0;
	
char	*zero	= "0";
char	*one	= "1";
char	space[]	= " ";
char	oper_command = 0;	/* true just after an oper() command is
				 * given.  Used to tell the difference
				 * between an incorrect password generated by
				 * an oper() command and one generated when
				 * connecting to a new server */
char	global_all_off[2];		/* lame kludge to get around lameness */
	struct	in_addr	MyHostAddr;		/* The local machine address */
	struct	in_addr LocalHostAddr;
char	*LocalHostName = NULL;
extern	char	*last_away_nick;

extern int split_watch;

char	*invite_channel = NULL,		/* last channel of an INVITE */
	*ircrc_file = NULL,		/* full path .ircrc file */
	*bircrc_file = NULL,		/* full path .ircrc file */
	*my_path = NULL,		/* path to users home dir */
	*irc_path = NULL,		/* paths used by /load */
	*irc_lib = NULL,		/* path to the ircII library */
	*ircservers_file = NULL,	/* name  of server file */
	nickname[NICKNAME_LEN + 1],		/* users nickname */
	hostname[NAME_LEN + 1],			/* name of current host */
	realname[REALNAME_LEN + 1],		/* real name of user */
	username[NAME_LEN + 1],			/* usernameof user */
	*forwardnick = NULL,			/* used for /forward */
	*send_umode = NULL,			/* sent umode */
	*args_str = NULL,		/* list of command line args */
	*last_notify_nick = NULL,	/* last detected nickname */
	empty_string[] = "",			/* just an empty string */
	*who_name = NULL,		/* extra /who switch info */
	*who_file = NULL,		/* extra /who switch info */
	*who_server = NULL,		/* extra /who switch info */
	*who_host = NULL,		/* extra /who switch info */
	*who_nick = NULL,		/* extra /who switch info */
	*who_real = NULL,		/* extra /who switch info */
	*cannot_open = NULL,		/* extra /who switch info */
	*auto_str = NULL,		/* auto response str */
	*cut_buffer = NULL;		/* global cut_buffer */

	int away_set = 0;			/* set if there is an away
						 * message anywhere */
	int quick_startup = 0;		/* set if we ignore .ircrc */
	int cpu_saver = 0;
	
#ifdef TDEBUG
	int cx_line = 0;
	char cx_file[BIG_BUFFER_SIZE/4];		/* debug file info */
	char cx_function[BIG_BUFFER_SIZE/4];
#endif

time_t	idle_time = 0,
	start_time;
fd_set	readables, writables;
int	child_dead = 0;

	
	RETSIGTYPE	cntl_c ();
	RETSIGTYPE	sig_user1 ();
	RETSIGTYPE	coredump ();


static	void	quit_response _((char *, char *));
static	void	show_version _((void));
static	char	*parse_args _((char **, int));
extern void dumpcmd _((char *, char *, char *));

static	volatile int	cntl_c_hit = 0;

	char	version[] = _VERSION_;
	
static		char	switch_help[] =
#ifdef WINNT
"Usage: BitchX [switches] [nickname] [server list] \n\
  The [nickname] can be at most 9 characters long\n\
  The [server list] is a whitespace separate list of server name\n\
  The [switches] may be any or all of the following\n\
   -c <channel>\tjoins <channel> on startup\n\
   -b\t\tload bx-rc  or irc-rc after connecting to a server\n\
   -p <port>\tdefault server connection port (usually 6667)\n\
   -d\t\truns BitchX in \"dumb\" terminal mode\n\
   -q\t\tdoes not load ~/irc-rc\n\
   -r file\tload file as list of servers\n\
   -n nickname\tnickname to use\n\
   -a\t\tadds default servers and command line servers to server list\n\
   -x\t\truns BitchX in \"debug\" mode\n\
   -v\t\ttells you about the client's version\n";
#else
"Usage: BitchX [switches] [nickname] [server list] \n\
  The [nickname] can be at most 9 characters long\n\
  The [server list] is a whitespace separate list of server name\n\
  The [switches] may be any or all of the following\n\
   -c <channel>\tjoins <channel> on startup\n\
   -b\t\tload .bitchxrc  or .ircrc after connecting to a server\n\
   -p <port>\tdefault server connection port (usually 6667)\n\
   -f\t\tyour terminal uses flow controls (^S/^Q), so BitchX shouldn't\n\
   -F\t\tyour terminal doesn't use flow control (default)\n\
   -d\t\truns BitchX in \"dumb\" terminal mode\n\
   -q\t\tdoes not load ~/.ircrc\n\
   -r file\tload file as list of servers\n\
   -n nickname\tnickname to use\n\
   -a\t\tadds default servers and command line servers to server list\n\
   -x\t\truns BitchX in \"debug\" mode\n\
   -v\t\ttells you about the client's version\n";
#endif

static		char	switch_help_l[] =

#ifdef WINNT
"   -l <file>\tloads <file> in place of your irc-rc\n\
   -L <file>\tloads <file> in place of your irc-rc and expands $ expandos\n";
#else
"   -l <file>\tloads <file> in place of your .ircrc\n\
   -L <file>\tloads <file> in place of your .ircrc and expands $ expandos\n";
#endif

static char	switch_help_b[] =
	"   -B\t\tforce BitchX to fork and return you to shell\n";




/* irc_exit: cleans up and leaves */
RETSIGTYPE irc_exit_old _((int unused))
{
	irc_exit(1,NULL, NULL);
}

/* This is needed so that the fork()s we do to read compressed files dont
 * sit out there as zombies and chew up our fd's while we read more.
 */
RETSIGTYPE child_reap (int sig)
{
	child_dead++;
}

RETSIGTYPE nothing _((int sig))
{
      /* nothing to do! */
}
                           
RETSIGTYPE sigpipe _((int unused))
{
static int sigpipe_hit = 0;
	sigpipe_hit++;
}
          

/* irc_exit: cleans up and leaves */
void irc_exit (int really_quit, char *reason, char *format, ...)
{
	char buffer[BIG_BUFFER_SIZE];
	int old_window_display = window_display;
	
	if (format)
	{
		va_list arglist;
		va_start(arglist, format);
		vsprintf(buffer, format, arglist);
		va_end(arglist);
	}
	else
		sprintf(buffer, "%s -- just do it.",irc_version);

	do_hook(EXIT_LIST, "%s", reason ? reason : buffer);
	close_server(-1, reason? reason : buffer);
	put_it(buffer);
	logger(curr_scr_win, NULL, 0);
	if (get_int_var(MSGLOG_VAR))
		log_toggle(0, NULL);

	clean_up_processes();
	if (!dumb)
	{
		cursor_to_input();	/* Needed so that ircII doesn't gobble
					 * the last line of the kill. */
#ifndef WINNT
		term_cr();
#endif
		term_clear_to_eol();
		term_reset();
	}

	/* Debugging sanity. */
	window_display = 0;
	dumpcmd(NULL, NULL, NULL);
	set_lastlog_size(curr_scr_win, NULL, 0);
	set_history_size(curr_scr_win, NULL, 0);
	remove_channel(NULL, 0);
/*	really_free(0);*/
	free_display(curr_scr_win);
	free_hold(curr_scr_win);
	free_lastlog(curr_scr_win);
	free_formats(curr_scr_win);
	window_display = old_window_display;
	clear_bindings();
	clear_sets();
	destroy_call_stack();

	if (really_quit)
	{
		fprintf(stdout, "\r");
		fflush(stdout);
		exit(0);
	}
}

#ifndef BITCHX_DEBUG
volatile segv_recurse = 0;
/* sigsegv: something to handle segfaults in a nice way */
/* this needs to be changed to *NOT* use printf(). */
RETSIGTYPE coredump(int sig)
{
	if (segv_recurse)
		_exit(1);
	segv_recurse = 1;
	panic_dump_call_stack();
	
#ifdef TDEBUG
	putlog(LOG_ALL, "*", "Error logged. %s at (%d)  %s", cx_file, cx_line, cx_function?cx_function:empty_string);
#endif
	printf("\n\r\n\rIRCII has been terminated by a SIG%s\n\r", signals[sig]);
	printf("Please inform panasync (edwac@sk.sympatico.ca) of this\n\r");
	printf("with as much detail as possible about what you were doing when it happened.\n\r");
	printf("Please include the version of IRCII (%s) and type of system in the report.\n\r", irc_version);
	fflush(stdout);
	irc_exit(1, "Hmmmm... BitchX error!!!! unusual :)");
}
#endif

/*
 * quit_response: Used by irc_io when called from irc_quit to see if we got
 * the right response to our question.  If the response was affirmative, the
 * user gets booted from irc.  Otherwise, life goes on. 
 */
static	void quit_response(char *dummy, char *ptr)
{
	int	len;

	if ((len = strlen(ptr)) != 0)
		if (!my_strnicmp(ptr, "yes", len))
			irc_exit(1, NULL, "IRC][ %s:  Rest in peace", irc_version);
}

/* irc_quit: prompts the user if they wish to exit, then does the right thing */
void irc_quit(char key, char * ptr)
{
	static	int in_it = 0;

	if (in_it)
		return;
	in_it = 1;
	add_wait_prompt("Do you really want to quit? ", quit_response, empty_string, WAIT_PROMPT_LINE);
	in_it = 0;
}

/*
 * cntl_c: emergency exit.... if somehow everything else freezes up, hitting
 * ^C five times should kill the program. 
 */
RETSIGTYPE cntl_c _((int unused))
{

	if (cntl_c_hit++ >= 4)
		irc_exit(1, "User abort with 5 Ctrl-C's", NULL);
	else if (cntl_c_hit > 1)
		kill(getpid(), SIGALRM);
}

RETSIGTYPE sig_user1 _((int unused))
{
	bitchsay("Got SIGUSR1, closing DCC connections and EXECed processes");
	close_all_dcc();
	close_all_exec();
}

/* shows the version of irc */
static	void show_version(void)
{
	printf("BitchX version %s (%s)\n\r", irc_version, internal_version);
	exit (0);
}

#ifndef RAND_MAX
#define RAND_MAX 2147483647
#endif

void display_bitchx(int j) 
{
int i = strip_ansi_in_echo;
	strip_ansi_in_echo = 0; 
	if (j == -1)
	        i = (int) (11.0*rand()/RAND_MAX);
	else
		i = j;
#ifdef WINNT
	put_it("[40m");
#else
	put_it("(U[40m");
#endif
	switch(i)
	{
		case 0:
put_it("[0m[0;25;37;40m  [34m [0m[21C[34m[0m[25C[34m[1;44m[0;34;40m0m");
put_it("[0m---------------------  [34m[1;44m[0;34;40m[0m ------[30;47m[panasync][0m------ [34m [1;44mܱ[0;34;40m  [0m-----------");
put_it("[34m [0m[7C[34mܲ    ܲ[1;44m[0;34;40m[0m[8C[34m[0m[11C[34m   [1;44m۲ [0;34;40m  ");
put_it("[34m[1;44m[0;34;40m[1;44m[0;34;40m[0m[5C[34m[1;44m [47m[44m[0;34;40m   [0m[9C[34m[1;44m [0;34;40m[1;44m[0;34;40m[0m[5C[34m[1;44m۲[47m۲[44m [0;34;40m ");
put_it("[34m[1;44m[0;34;40m     [1;44mܲ[0;34;40m[1;44m۲[0;34;40m[0m    [34m[1;44m۲[0;34;40m[1;44m[47m۰[44m [0;34;40m [0m");
put_it("[34m[1;44m ۲۰[0;34;40m[1;44m[0;34;40m [1;44m [0;34;40m[1m[44m۲߲[47m[44m [0;34;40m[1;44m[0;34;40m[1;44m [0;34;40m [1;44m[47m۱[44m[0;34;40m  ");
put_it("[34m [1;44m[47m[44m[0;34;40m[1;44m۲ [47m[44m[0;34;40m [1;44m ݰ[0;34;40m [1;47m[44m[47m[44m[0;34;40m");
put_it("[34m [1;44m [0;34;40m [1;44m[0;34;40m [1;44m[0;34;40m   [1;44m [47m[44m [0;34;40m [1;44m[47m[44m[0;34;40m");
put_it("[1;34m [0;34;40m[1;44m۲۲[0;34;40m[1;44m [0;34;40m [1;44m[47m[44m[0;34;40m[1;44m[0;34;40m[1;44m[0;34;40m [1;44m۲[0;34;40m ");
put_it("[1;34m [0;34;40m[1;44m[47m[44m۲ [0;34;40m[1m   [0;34;40m[1;44m۲ [0;34;40m [1;44m۲[0;34;40m [1;44m[47m[44m[0;34;40m[1m [0;34;40m [1m ");
put_it("[0;34m  ߲[1;44m ߲[0;34;40m [35m[1;45m[0;34;40m[5C  [1;44m ۲ [0;34;40m [1;44m[0;34;40m  [36m [34m");
put_it("[1;35;45m[0;35;40m [0m            [35m [0m[5C[34m[1;44m [0;34;40m[1;44m[0;34;40m[0m [34m [1;44m[0;34;40m [1;44m[0;34;40m  [36m [1;46m    ܲݰ[0;34;40m ");
put_it("[1;35;45m [0;35;40m[1;45m[0;35;40m[1;45m [0;35;40m[0m [35m [0m  [34m[1;44m۲[0;34;40m[0m [34m[1;44m[0;34;40m  [5C[36m[1;46m [0;36;40m");
put_it("[35m[1;45m   [0;35;40m[0m [35m [1;45m[0;35;40m[0m  [34m[1;47m[44m[0;34;40m [1;44m۲[47m[44m[0;34;40m[0m [36m  [1;46m [0;36;40m");
put_it("[35m[1;45m۲[0;35;40m [1;45m[0;35;40m[0m   [34m[1;44m[0;34;40m[1;44mܰ[0;34;40m[0m   [36m[1;46m[0;36;40m[1;46m ܲ۲[0;36;40m[1;46m [0;36;40m");
put_it("[1;35;45m [0;35;40m[0m  [35m[1;45m߰[0;35;40m [0m [34m[1;44m[0;34;40m[1;44m[0;34;40m[0m  [36m [1;46m۲ [0;36;40m [0m [36m");
put_it("[35m[1;45m۲ [0;35;40m[0m  [35m[1;45m[0;35;40m[0m  [34m[1;44m ۰[0;34;40m[0m [34m[1;44m[0;34;40m[0m  [36m[1;46m۲[0;36;40m[0m   [36m[1;46mܲ[0;36;40m");
put_it("[1;35;45m [0;35;40m[1;45mܲ۲[0;35;40m[0m [34m[1;44m[47m[44m۲[0;34;40m[0m [1;34;44m۲[0;34;40m[0m  [36m[1;46m   [0;36;40m[1;46m [0;36;40m");
put_it("[1;35;45m     [0;35;40m[0m  [34m[1;44m[0;34;40m[0m [34m[1;44m[47m[44m[0;34;40m[0m  [36m[1;46m       ߰[0;36;40m");
put_it("[0m------------------------ [34m[1;44m[0;34;40m[0m ----- [34m[1;44m[0m --------[30;47m[dh(ts&lead)][0m----------");
			break;
		case 1:
put_it("::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
put_it(":::[1;31m:.[0m.[1;31m.[14C[0m.[1;35m.:[0m:::::::::::::::::[1;31m:.[0m.[14C[1;35m.[0m.[1;35m.:[0m:::::::::::::::::");
put_it(":::::::[1;31m:.[11C[35m:[0m:::::::::::::::::::::::[1;31m:[11C[35m.:[0m:::::::::::::::::::::");
put_it(":::::::::[1;31m:.[10C[35m`:[0m:::::::::::::::::::[1;31m:'[10C[35m.:[0m:::[1;31m:\"[0m`````````````````\"");
put_it(":::::::::::[1;31m:.[10C[35m`:[0m:::::::::::::::[1;31m:'[10C[35m.:[0m::::[1;31m: [35mB[0;35mitch[1mX [0mby [1;32mp[0;32manasync[36m!");
put_it("[37m:::::::::::::[1;31m:.[10C[35m`:[0m:::::::::::[1;31m:'[10C[35m.:[0m:::::::[1;31m:.[0m..................");
put_it(":::::::::::::::[1;31m:.[10C[35m`:[0m:::::::[1;31m:'[10C[35m.:[0m:::::::::::::::::::::::::::::");
put_it("::[1;31m:\"[0m\"````\"[1;35m\":[0m::[1;31m:'[36m.g$[0;36m$S[32m$'[6C[1;35m`:[0m:::[1;31m:'[11C[35m\":[0m::[1;31m:\"[0m\"```[1;35m\":[0m::::::::::::::::::::");
put_it("[1;31m'[36ms#S[0;36m$$$\"[1m$$[0;36mS#[32mn.[1;31m` [36m$$[0;36m$$[32mS\". [1;36ms#S[0;36m$$[32m$ [1;35m`[31m:'   [36m.g#[0;36mS$$[1m\"$[0;36m$S#[32mn. [1;36ms#S[0;36m$$[32m$ [1;35m`[0m\"[1;35m\":[0m::::::::::::::::");
put_it(" [1;36m$$[0;36m$$$[32m$[1;36m_,$[0;36m$[32m$S'[1;30mrE[36m.g#[0;36mS$$[32m$ [1;36m$$[0;36m$$$$ss[32mn    [1;36m$$[0;36m$$$[32m$ [1;36m$[0;36m$$[32m$$$ [1;36m$$[0;36m$$$$[1m\"$[0;36m$S#[32mn.[1;35m`:[0m::::::::::::");
put_it(" [1;36m$[0;36m$$$$[32m$[1;36m`\"$[0;36m$SSn[32m. [1;36m$$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36mgg#[0;36mS[32m$ [1;36m$[0;36m$$$$[32m$ [1;36mggg[0;36mgg[32mn [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;35m:[0m:[1;31m::\"[0m````````");
put_it(" [1;36m$[0;36m$$$$[32m$  [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$$[0;36m$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$$[0;36m$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;35m:[0m:[1;31m: [37mG[0mreets [1mT[0mo[1;30m");
put_it(" [36m$[0;36m$$$$[32m$  [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;35m:[0m:[1;31m: [36mT[0;36mrench[1;30m,");
put_it(" [36m$[0;36m$$$$[32m$ [1;36m,$[0;36m$$$[32m$$ [1;36m$[0;36m$$$$[32m$$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$[32m$$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$[32m$$ [1;36m$[0;36m$$$[32m$$ [1;36m$[0;36m$$$[32m$$ [1;35m:[0m:[1;31m: [36mL[0;36mifendel[1;30m,");
put_it(" [36m$[0;36m$$$$$ss$$$[32m$S' [1;36m$[0;36m$$$[32m$$$ [1;36m`S[0;36m$$$$s$$[32m$S' [1;36m`S[0;36m$$$$s$$$[32m$S' [1;36m$[0;36m$$[32m$$$ [1;36m$[0;36m$$[32m$$$ [1;35m:[0m:[1;31m: [36mJ[0;36mondala[1mR[30m,");
put_it("[31m.[0m............[1;35m.:[31m:[11C[35m.[0m......[1;35m.:[31m:.[11C[35m:[31m:.[0m.....[1;31m:[0m.......[1;35m:[0m:[1;31m: [36mZ[0;36mircon[1;30m,");
put_it("[0m:::::::::::::[1;31m:'[10C[35m.:[0m:::::::::::[1;31m:.[10C[35m`:[0m::::::[1;31m:\"[0m``````[1;31m`' [36mO[0;36mtiluke[1;30m,");
put_it("[0m:::::::::::[1;31m:'[10C[35m.:[0m:::::::::::::::[1;31m:.[10C[35m`:[0m:::[1;31m: [36mH[0;36mappy[1mC[0;36mrappy[1;30m, [36mY[0;36mak[1;30m,");
put_it("[0m:::::::::[1;31m:'[10C[35m.:[0m:::::::::::::::::::[1;31m:.[10C[35m`:[0m:[1;31m: [36mM[0;36masonry[1;30m, [36mB[0;36muddha[1mX[30m..");
put_it("[0m:::::::[1;31m:'[11C[35m:[0m:::::::::::::::::::::::[1;31m:[11C[35m`:[31m:.[0m...................");
put_it(":::[1;31m:\"[0m\"[1;31m'[14C[0m`[1;35m\":[0m:::::::::::::::::[1;31m:\"[0m'[14C[1;35m`[0m\"[1;35m\":[0m:::::::::::::::::");
put_it("::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::[0m");
			break;
		case 2:
put_it(" [1;35ml$[0;35m$[31mS'[1;30m.:[0m::[1m:... [35m`[0;35m\"~^\"[31m'  [1;35m`\"[0;35ml[31m' [1;30m..:[0m:::::::::::.[1;35m`[0;35m\"[31m\"[37m.:[1m:..[5C[35m\"[0;35m|[7C[1;30m.[0m.[1;30m.:[0m:[1m:.[35m`S$$[0;35m$[31ml");
put_it(" [1;35m$[0;35m$[31m$ [1;30m:[0m::::::::[1m:.[9C[0;31m| [1;30m:[0m:::::::::::::::::::::::[1m:[5C[0;31m:[5C[1;30m.:[0m:::::::[1m:.[35m`$[0;35m$[31m$");
put_it(" [1;35m$[0;35m$[31m$ [1;30m:[0m::::::::::[1m:.[7C[0;35m.  [1;30m`:[0m:::::::::::::::::::[1m:'[6C[0;31m.   [1;30m.:[0m::::::::::[1m: [35m$[0;35m$[31m$");
put_it(" [1;35m$[0;35m$[31ml [1;30m:[0m::::::::::::[1m:.[10C[30m`:[0m:::::::::::::::[1m:'[10C[30m.:[0m::::::::::::[1m: [35ml[0;35m$[31m$");
put_it(" [1;35m$[0;35m$[31m| [1;30m:[0m::::::::::::::[1m:.[10C[30m`:[0m:::::::::::[1m:'[10C[30m.:[0m::::::::::::::[1m: [35ml[0;35m$[31m'");
put_it(" [1;35m$[0;35m$[31m'[1;30m.:[0m::::::::::::::::[1m:.[10C[30m`:[0m:::::::[1m:'[10C[30m.:[0m::::::::::::::::[1m: [0;35ml[31m'[35m_");
put_it(" [1m$[0;35mg [1;30m:[0m::::[1m:\"[0m\"````\"[1;30m\":[0m::[1m:'[36m.g$[0;36m$S[32m$'[6C[1;30m`:[0m:::[1m:'[11C[30m\":[0m::[1m:\"[0m\"```[1;30m\":[0m:::::::[1m: [0;31m| [35mL");
put_it(" [1ml[0;31m\"[1;30m.:[0m:[1m:'[36ms#S[0;36m$$$\"[1m$$[0;36mS#[32mn.[1;37m` [36m$$[0;36m$$[32mS\". [1;36ms#S[0;36m$$[32m$ [1;30m`[37m:'   [36m.g#[0;36mS$$[1m\"$[0;36m$S#[32mn. [1;36ms#S[0;36m$$[32m$ [1;30m`[0m\"[1;30m\":[0m::::[1m: [0;31m:[1;35m,[0;31m$");
put_it(" [35m| [1;30m:[0m::[1m: [36m$$[0;36m$$$[32m$[1;36m_,$[0;36m$[32m$S'[1;30mrE[36m.g#[0;36mS$$[32m$ [1;36m$$[0;36m$$$$ss[32mn    [1;36m$$[0;36m$$$[32m$ [1;36m$[0;36m$$[32m$$$ [1;36m$$[0;36m$$$$[1m\"$[0;36m$S#[32mn.[1;30m`:[37m:'[35m,$[0;31m$");
put_it("[1;35m_[0;35m,L[1;30m`:[0m:[1m: [36m$[0;36m$$$$[32m$[1;36m`\"$[0;36m$SSn[32m. [1;36m$$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36mgg#[0;36mS[32m$ [1;36m$[0;36m$$$$[32m$ [1;36mggg[0;36mgg[32mn [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;30m:[37m: [35m$[0;35m$[31m$");
put_it("[1;35m`\"$[0;31mn[1;30m\":[37m: [36m$[0;36m$$$$[32m$  [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$$[32m$ [1;30m:[37m: [35m$[0;35m$[31m$");
put_it(" [1;35m$$[0;35m'[31mL[1;30m:[37m: [36m$[0;36m$$$$[32m$ [1;36m,$[0;36m$$$[32m$$ [1;36m$[0;36m$$$$[32m$$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$[32m$$ [1;36m$[0;36m$$$$[32m$ [1;36m$[0;36m$$$[32m$$ [1;36m$[0;36m$$$[32m$$ [1;36m$[0;36m$$$[32m$$ [1;30m:[37m: [35m$[0;35m$[31m$");
put_it(" [1;35m$[0;31m$[35m.[31m\"[1;30m:[37m: [36m$[0;36m$$$$$ss$$$[32m$S' [1;36m$[0;36m$$$[32m$$$ [1;36m`S[0;36m$$$$s$$[32m$S' [1;36m`S[0;36m$$$$s$$$[32m$S' [1;36m$[0;36m$$[32m$$$ [1;36m$[0;36m$$[32m$$$ [1;30m:[37m: [35m$[0;35m$[31m$");
put_it(" [1;35m$[0;35m$[31m. [1;30m:[37m:.[0m............[1;30m.:[37m:[11C[30m.[0m....[1m. [32mB[0;32mitch[1mX [37mb[0my [1;36mP[0;36manasync[1;34m! [30m.[0m..[1m:[0m.......[1;30m:[37m: [35m$[0;35m$[31m$");
put_it(" [1;35m$[0;35m$[31m| [1;30m:[0m::::::::::::::[1m:'[10C[30m.:[0m:::::::::::[1m:.[11C[30m:[0m:::::::::::::[1m:'[35m.[0;35m$$[31m$");
put_it(" [1;35m$[0;35m$[31ml.[1;30m`:[0m:::::::::::[1m:'[10C[30m.:[0m:[1m:'[30m\":[0m::::::::::[1m:.[10C[30m`:[0m:::::::::::[1m: [35ml[0;35m$$[31m$");
put_it(" [1;35m$[0;35m$$[31ml [1;30m`:[0m::::::::[1m:'[10C[30m.:[0m:::[1m: [0;31m|[1;30m`:[0m:::::::::::[1m:.[10C[30m`:[0m::::::::[1m:'[35m,$[0;35m$[31m$$");
put_it(" [1;35m$[0;35m$S[31m$s,._[1;30m`\"\":[0m:[1m:'[11C[30m:[0m:::[1m:'[35m_a[0;35ml[31m-[1;30m`:[0m::::::::::::[1m:[11C[30m`:[0m::[1m:\"\"'[35m,S$[0;35m$[31m$$$");
put_it(" [1;35m$[0;35m$$S$$$[31m$$SS#ss,.__[9C[1;30m`\":[0m:[1m:[35m`$[0;35m$[31ms.[35m_[31m_[1;30m`\":[0m:::::[1m:\"[0m'  [1;35m__[0;35m_.[1m,[0;35m,,[1mss[0;35ms##SSSS$$$$[31m$S\"`");
put_it(" [1;35m`\"[0;35mS$$$$$$$$$$$$$$$$$$$$$$$$$SSSSSS[31m$'[35m~\"\"\"\"\"\"\"\"\"~~~~~~~~\"\"\"\"\"\"\"\"\"\"\"\"```[31m```'[0m");
			break;
		case 3:
put_it("[0;1;44m                                                         [0;34m[35m[1;45m[40m[0;34m");
put_it("[44m [1;46m[5C[44m            [46m[5C[0;34m[44m [40m[1;46m[5C[44m       [0;34m[35m[1m[0;34m[35m[1;45m[40m[0;34m");
put_it("[44m [1;46m[5C[40m    [0;34m[1;46m[5C[5C[0;34m[1;44m[40m        [0;34m[1;46m[5C[40m   [0;35m[1;45m[40m[0;34m[35m[1;45m[0;35m[1m[0;34m");
put_it("[44m [1m[5C[5C[0;34m[1;44m[5C[5C[5C[5C[46m[5C[44m[5C[0;35m[1;45m[40m[0;34m[35m[34m");
put_it("[44m [1m[5C[5C[5C[5C[5C[5C[0;34m[1;44m[5C[5C[0;34m[35m[1m[0;34m");
put_it("[44m [1m[5C[5C[5C[5C[5C[5C[5C[5C[5C [0;34m[35m [34m[1;35m[0;34m");
put_it("[44m [1m[5C[5C[5C[5C[5C[5C[5C[5C[5C [0;34m[35m[1;45m[0;35m[34m[1;35m[45m۲[0;35m[34m");
put_it("[44m  [5C[30m[5C[1;34m[5C [0;34m        [44m [40m        [1;44m[5C[0;34m[5C[1;35m[45m [1C[0;34m [1;35;45m  [0;35m");
put_it("[44m                                                    [34;40m[1;35m[45m [0;35m[34m [1;35;45m[0;35m[34m");
put_it("[44m[1;35m[45m  [1C[0;34m [1;35;45m[0;35m[34m");
put_it("[44m[1;35m[0;35m[34m");
put_it("[0m");
			break;
		case 4:
put_it("                                                                   ,");
put_it("                                           .                     ,$");
put_it("                 .                                              ,$'");
put_it("                                           .        .          ,$'");
put_it("                 :      ,g$p,              .         $,       ,$'");
put_it("               y&$       `\"` .,.           $&y       `$,     ,$'");
put_it("               $$$     o oooy$$$yoo o      $$$        `$,   ,$' -acidjazz");
put_it("         .     $$$%%yyyp, gyp`$$$'gyyyyyyp, $$$yyyyp,   `$, ,$'     .");
put_it("       . yxxxx $$$\"`\"$$$ $$$ $$$ $y$\"`\"$$$ $$$\"`\"$$$ xxx`$,$'xxxxxxy .");
put_it("         $     $$7   l$$ $$$ $$$ $$7   \"\"\" $$7   ly$     .$'       $");
put_it("         $     $$b   dy$ $$$ $y$ $$b   $$$ $$b   d$$    ,$`$,      $");
put_it("       . $xxxx $$$uuu$$$ $$$ $$$ $$$uuu$$$ $$$   $$$ x ,$'x`$, xxxx$ .");
put_it("         .           \"\"\" \"\"\" \"\"\"       \"\"\"       \"\"\"  ,$'   `$,    .");
put_it("           b i t c h    -      x                     ,$'     `$,");
put_it("                                                     $'       `$,");
put_it("                                                    '          `$,");
put_it("                                                                `$,");
put_it("                                                                 `$");
put_it("                                                                   `");

			break;
		case 5:
put_it("[24C[1;30m[0m  [1;30m[0m");
put_it("[23C[1;30m[0m [1;30m[0m [1;30m[0m[24C[1;31m     [0m");
put_it("[23C[1;30m[0m [1;30m[37m [30m[0m [1;30m[0m[21C[1;31m[41m[40m [0m");
put_it("[23C[1;30m[0m [1;30m[0m[22C[1;31m[41m[40m   [0m");
put_it("[20C[1;30m   [0m [1;30m[33m  [0;31m[1;37m  [0m[19C[1;31m[41m[40m[0m");
put_it("[11C[1;33m          [30m    [33m  [30;41m[33;43m[30;41m[37;40m  [0m[16C[34m[1;31;44m[40m[41m[40m[0m");
put_it("[13C[1;33m       [0m [1;30m    [0;31m[1;30;41m[33;43m[37;40m[0m[14C[34m[1;44m۲[31m[40m[0m");
put_it("[22C[32m  [1;30m  [0;31m[1;30;41m[37;40m[42m[40m [0;32m [37m[7C[34m[1;44m۲[0;34m [37m");
put_it("[7C[32m [1;37m   [0m [32m[37m[4C[32m[1;37;42m[40m[0;32m[37m  [34m[1;44m۲[0;34m[37m");
put_it("[32m [37m[6C[32m [1;42m [0;32m    [37m [32m   [1;37m[0;32m[1;37m[0;32m[34m[1;44m۲[0;34m[37m");
put_it("[9C[32m[1;42m [0;32m [37m [32m [37m[3C[32m    [37m  [32m[37m [1m[0;32m[1;34;42m[0;32m[34m[37m");
put_it(" [32m [37m[7C[32m[1;42m [0m [32m[37m [32m [37m[3C[32m[37m [32m   [37m  [32m[37m [1m [0;32m[1;37m[44m[34m [0;32m[1;34;44m[0;32m[1;30m [0m  [1;30mby panasync[0m");
put_it("[8C [32m[1;42m [37;40m [0;32m [37m [32m  [37m  [32m[1;37m  [0;32m[37m  [32m[1;37m  [0;32m[1;34;44m[0;32m[34m[32m[1;37m [0m");
put_it("[7C[32m[1;42m  [0;32m[1;37m [0;32m [1;42m [0;32m[37m [32m[1;42m [0;32m[1;34;44m[42m[0;32m[1;37m[0;32m[1;37m[0m");
put_it("  [32m [37m[28C[34m[1;44m[0;34m[1;37m  [0m");
put_it("[8C[1m*[30mSpark it Up[37m*[0m[8C[34m[1;44m[0;34m[37m[5C[1m[0m [1m [0m");
put_it("[27C[34m[1;44m[0;34m[37m[10C[1m [0m");
put_it("[26C[34m[1;44m[0;34m[37m  [1;30m[Joker][0m[5C[1m[0m");
put_it("[27C[1;34m [0;34m[1;44m[0;34m[37m[18C[1m  [0m");
put_it("[15C[1m [0m[11C[1;34m  [0m[24C[1m[0m");
put_it(" ");
			break;
		case 6:
put_it(" ");
put_it(" ");
put_it("[5C[1;36m [0;36;40m[0m[8C[1;36m[0m[10C[36m[0m[21C[1;47m[40m[0m  [36m[0m");
put_it("[6C[36m[1;46m[40m[46m[40m[47m[40m[0m[5C[36m[1;46m[0;36;40m[1;46mܲ[40m[47m[40m[0m     [1m[0m[1;47m[40m[0m [36m[1;46m[40m[0m");
put_it("[7C[36m[1m[47m[40m[0m  [36m[1;46m[40m[0m    [1m[0;36;40m[1;46m[40m[47m[40m[0m  [1;36m[0m[5C[1;47m [40m[47m[40m[0m [1;47m߱[40m[0m [1;36;46m[40m[47m[40m[0m");
put_it("   [36m[1;46m߱[40m[0;36;40m[1;46m߲[40m[0m [1;47mܲ[40m[0m [1;36;46m߱[40m[0m[8C[1;47m߱[0m [6C[36m[1;46m߱[40m[0m [1;36m[0m  [1;47m[0m");
put_it("   [1;47m[0m [1m[0m [36m[0m[1m[0m  [36m[1m[0m [1m[0m [1;47m[40m[0;36;40m[1m[0m [36m[1;46m[40m[46m[40m[0m[1m[36m[0m[1;47mܱ[40m[0m [1;47m[0m");
put_it("   [1;47m[40m[0m[1;47m[40m[0m [1;47m[33m[37;40m[0m [1;36;46m[40m[47m[40m[0m  [1;47m[40m[0m [1;47m[40m[0;36;40m[1;46m[40m[0m [36m[1;46m[40m[47m[40m[0m[1;47m[33m[37m[40m[30m[0m[1;47m[40m[0m ");
put_it("  [1;47m[0m [1m[0m [1;47m[40m[47m[40m[0m [1;47m[40m[47m[40m[0;36;40m[1;46m߱[40m[0m[1m[47m[40m[47mܲ[40m[0m [1;36;46m[40m[46m[40m[0m  [1;36;46m[40m[0m [1;47m߱[30;40m  [0m[1m[47m[40m[0m ");
put_it("  [1;47m[0m [1m[0m[1m[0m[1;47m[40m[0;36;40m[1;37m[36m[0m [1;30m[0m[6C[1m[0m   [36m[0m [1;36;46m[40m[46m[0;36;40m[1;46m[0;36;40m[1m[37m[0m[1m[0m [1m[0m ");
put_it("   [1m[0m[1;47m[40m[0m[1m[30m  [0m[1;47m߱[40m[0m[34m[1m[44m[40m[44m[40m[44m[40m[0m    [1m[47m[40m[30m [0m[1;47m[40m[47m߱[40m[30m [0m [1;47m[0m");
put_it("   [1m[30m  [0m[1;47m[40m[47m۲[40m[0m[1;47m[40m[0m [34m[1;44mܱ[40m[0m  [34m[1;44m[40m[30m [0m [34m[1;44m[40m[0m[1m[47m߲[40m[32;47m[37;40m[0m[1;47mܲ[40m[30m [0m[1;47m[40m[0m [1;47m[0m");
put_it("  [1;47m[0m [1m[47m[40m[30m [0m[1;47m߲[40m[0mp[34m[1;44m޲[47m[44m[40m[47m[40m[0m [1;30m[0m [34m[1;44m[40m[30m  [0m [34m[1;44m[40m[47m[40m[0mX[1m[30m [0m[1;47m[40m[47m[40m[0m[1;47m[40m[0m [1;47m[0m");
put_it("  [1;47m[0m [34m[1;44m߱[40m[47m[40m[0m [34m[1;44m[40m[0m [34m[1;44m[40m[47m[40m[0m [1;47m[0m");
put_it("[29C[34m[1m[0m [34m[1;44m[0;34;40m[0m [34m[1;44m[0;34;40m[1m[0;34;40m [0m");
put_it("[11CBitchX irc client    [34m[1;44m[40m[47m[40m[0m [34m[1;44m[40m[0m");
put_it("[13C-by Panasync[8C[34m[1;44m[40m[0m [34m[1;44m[40m[47m[0m");
put_it("[36C[34m[1;44m[40m[47m[40m[0m");
put_it("[37C[34m[1m[44m߱[40m[0m");
put_it(" ");
			break;
		case 7:
put_it("[0;1;31;41m[40m[41m[40m[41m[40m[41m[40m[41m۲[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m۲[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m۲[40m[41m[40m[41m[40m[41m[40m[41m[40m[41m[40m");
put_it("[41m[40m");
put_it("[41m[40m");
put_it("[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[0;31m[1;41m[40m");
put_it("[0;31m[1;37m[47m[40m [0;31m [34m[1;44m[0;34m[31m [1;37m[47m[40m [0;31m [1;37m[47m[40m [0;31m [1;37m[47m[40m [0;31m");
put_it("[1;37m[47m[40m[47m[40m [0;31m [34m[1;44m[0;34m[1;44m[0;34m [1;37m[47m[40m[47m[40m [0;31m[1;37m[47m[40m[47m[40m[5C[47m[40m[47m[1C[40m[47m[40m[47m[40m [0;31m");
put_it("[37m[1;47m[0m[1;47m[0m [31m [1;37;47m[0m [1;47m[1C[0m[1;47m[0m[1;47m[0m  [1;47m[6C[40m [0m[1;47m[0m[1;47m[0m");
put_it("[1;47m[0m[1;47m[5C[0m[1;47m[0m [1;47m[0m[1;47m[0m[1;47m[0m [1;47m[0m[1;47m[11C[0m[1;47m[0m[1;47m[7C[0m [1;47m[0m[1;47m[5C[0m[1;47m[0m");
put_it("[6C   [11C[6C [6C");
put_it("[36m[1;46m[6C[1C[0;36m[1;46m[2C[0;36m[1;46m[6C[1C[0;36m[1;46m[6C[1C[0;36m[1;46m[6C[40m");
put_it("[46m[40m    [46m[40m [0;36m[1;46m[40m [46m[40m    [46m[40m [46m[40m    [46m[40m [46m[40m    [46m[40m");
put_it(" [46m۲۲[40m[46m[40m   [46m[40m[46m[40m[46m[40m[46m[40m  [46m۲۲[40m[46m[40m [37mnd[36m[46m۲۲[40m[46m[40m   [46m۲۲[2C[40m[46m[40m");
put_it(" ");
put_it("[32C[31m[41m[40m    [0;31m[1;41m[0;31m");
put_it("[34C[1;41m[40m [0;31m[1;41m[0;31m");
put_it("[32C[1m[0;31m[1;41m[40m[0;31m");
put_it("[30C[1m[41m[40m [41m[40m");
put_it("[28C[41m[40m    [0;31m[1;41m[0;31m");
put_it("[27C[1m[9C[0;31m");

			break;
		case 8:
put_it("[0m[1;25;30;40m,--[0;36;40m-[1;30m--[0;36;40m---[1;30m-[0;36;40m----[1m-[0;36;40m---[1m--[0;36;40m-[1m---------------[0;36;40m-[1m----[0;36;40m--[1m--[0;36;40m----[1;30m--[0;36;40m---[1;30m---[0;36;40m-[0m [1;30m--[0m [1;30m-[0m");
put_it("[1;30m|[0m[42C[34m:[0m[15C[36m,a%%$$$$n,[0m");
put_it("[36m|[0m[42C[1;34m;[0m[13C[36m,[1ma%%$$$$%%$$$[0;36;40m$,[0m");
put_it("[1;30m|[0m[10C[1;30m([0m [36mB[0m   [36mi[0m   [1;36mt[0m   [1;36mc[0m   [36mh[0m   [36mX[0m [1;30m)[0m[7C[1;36m%%[0m[12C[36m,aP`[0m    [36m`$[1m$[37m$[36m$[0;36;40m$,[0m");
put_it("[1;30m|[0m[30C[1;30m-[0m [1;30m-[0;36;40m-[0m [1;30m-[0;36;40m--[0m [1;36m--%%[37m%%[36m%%[37m-[0m  [36m,a%%$%%,[0m[5C[36m,%%$%%n,[0m [36m$[1m$[37m$[36m$[0;36;40m$[0m");
put_it("[36m|[0m   [36m$$$$$&n,[0m[9C[36m,-,[0m[12C[36md[1m%%n[0;36;40m,[0m   [1;36m%%[0m    [36m$[1m$$$$$[0;36;40m,[0m   [36m,[1m$$$$$[0;36;40m$[0m [36m$[1m$[37m$[36m$[0;36;40m$[0m");
put_it("[36m|[0m   [36m$[1m$[37m$[0m  [1;36m$$[0;36;40m$[0m  [36m,a,[0m [36m([1m$$[37m$$$[36m$$[0;36;40m)[0m[10C[36m$[1m$[0;36;40m$[0m   [1;34m;[0m    [36m`$[1m$[37m$$$[36m$[0;36;40m,[0m [36m,[1m$$[37m$[36m$$[0;36;40m$`[0m [36m$[1m$[37m$[36m$[0;36;40m$[0m");
put_it("[36m'[0m   [36m$[1m$[37m$[0m  [1;36m$$[0;36;40m$[0m  [36m`[1m_[0;36;40m'[0m   [36m`$[1m$[0;36;40m$'[0m  [36m,a%%P\"Y%%n,[0m [36m$[1m$[0;36;40m$[0m   [34m'[0m[6C[36m`$[1m$[37m$[36m$[0;36;40m%%[0m [36m%%[1m$$$[0;36;40m$`[0m  [36m$[1m$[37m$[36m$[0;36;40m$'[0m");
put_it("[1;36m|[0m  [1;30m.[0;36;40m$[1mP[37m`.d[36m$[0;36;40mP'[0m  [36m,[1m-[0;36;40m,[0m    [36m$[1m$[0;36;40m$[0m   [36m$[1m$[37m$[0m   [1m$[36m$[0;36;40m$ $[1m$[0;36;40m$,a$n,[0m[7C[36m`$[1m$$[37m%%[36m$$[0;36;40m$`[0m   [36m$[1m$$[0;36;40m$`[0m");
put_it("[36m|[0m  [1;30m`[0;36;40m$[1mb[37m,`Y[36m$[0;36;40mb,[0m  [36m$[1m$[0;36;40m$[0m    [36m$[1m$[0;36;40m$[0m   [36m$[1m$[37m$[0m   [1m`[36m-[0;36;40m'[0m [36m$[1m$[37m$[0m  [1m$$[36m$[0;36;40mn[0m[6C[36m,$[1m$[0;36;40m$%%$[1m$[0;36;40m$,[0m  [36m$[1m$[0;36;40mP'[0m");
put_it("[1;36m'[0m   [36m$[1m$[37m$[0m  [1m$[36m$[0;36;40m$[0m  [36m$[1m$[0;36;40m$[0m    [36m$[1m$[0;36;40m$[0m   [36m$[1m$[37m$[0m   [1m,[36m-[0;36;40m,[0m [36m$[1m$[37m$[0m  [1m$$[36m$[0;36;40m$[0m    [36m,$[1m$[37m$[36m$[0;36;40m%%[0m [36m%%[1;37m$$[36m$[0;36;40m$,`[0m");
put_it("[1;36m|[0m   [36m$[1m$[37m$[0m  [1m$[36m$[0;36;40m$[0m  [36m$[1m$[0;36;40m$[0m    [36m$[1m$[0;36;40m$[0m   [36m$[1m$[37m$ [0m  [1m$[36m$[0;36;40m$[0m [36m$[1m$[37m$[0m  [1m$$[36m$[0;36;40m$[0m  [36m,$[1m$$[37m$[36m$[0;36;40m$[0m   [36m$[1m$[37m$$[36m$[0;36;40m$,[0m");
put_it("[1;36m'[0m   [36m$$$$$%%P'[0m  [36m$$$[0m    [36m$$$[0m   [36m`Y$b,d$$P,$$$n[0m [36m$$P'[0m  [36m$[1m$$$$[0;36;40m$[0m[5C[36m$[1m$$$$[0;36;40m$[0m tM!");
put_it("[48C[36m`#%%$%%'[0m[5C[36m'%%$%%#`[0m");
put_it("[7C[1;30m-[0m [36m-[1m-[0m [34mb[0m [1;34my[0m   [1;34mp [37ma[0m [1mn[0m [1ma[0m [1ms[0m [1my[0m [1mn[0m [1mc[0m [1;36m-[0;36;40m-[0m [1;30m-[0m [1m([0;36;40mc[1;37m)[0m [1;36m1997[0m");
			break;
		case 9:
put_it("[63C[31m[37m");
put_it(" [30mbitchx!        [37m[16C[30m[37m [1m[35m[0;35m [37m[8C[31m[37m[13C[31m[37m");
put_it("[3C[1;30m [0;35m [1m[0;35m [1;30m[0m[4C[1;35m[37m[35m[45m[40m[0;35m [1;30m[0;35m  [31m[35m [1;30m[0;35m [1m[0;35m   [1;30m[0m  [1;30m[0m[3C[1;30m[0;35m [1;30m [0m");
put_it("[6C[1;45m[40m[45m[35;40m[0m  [35m    [1;37m[45m[40m[35m[0;35m [1m[45m[0;35m [30;45m[35;40m [37m[6C[35m [1m[0;35m    [1m[37;45m[40m[35m[0m");
put_it(" [31m [1m [0;31m[35m  [1;45m۲۲[0;35m  [1m[45m[40m[0;35m [37m [1;45m[35;40m[45m۲[0;35m  [30;45m[35;40m[30;45m [35;40m   [37m[1;35m[45m[40m[0;30;45m[1;35m[40m[37;45m[35m[0;35m  [1m[45m[40m[0;31m  [37m");
put_it(" [30;41m[1;31;40m[0;30;41m۲[35;40m [1;45m  [0;35m [30;45m[1;35m߲[40m[0;35m [1m[45m[0;35m     [1m[45m[0;35m[30;45m[35;40m [30;45m[35;40m[1;45m  [0;35m  [1;45m[0;35m   [1;45m  ߲[40m[0;35m    [37m");
put_it("[7C[35m[47m[46m[40m [1;45m[0;35m  [30;45m[35;40m [1;45m۱[0;35m [30;45m[35;40m   [31m[35m    [30;45m[35;40m[1;45m [0;30;45m[35;40m  [30;45m[37;40m");
put_it("[4C[35m [30;45m[35;40m[30;45m[35;40m  [30;45m[35;40m[46m[40m [46m[40m[30;45m[35;40m  [30;45m[35;40m [31m[35m    [30;45m [35;40m[30;45m[35;40m[30;45m[35;40m   [37m");
put_it("[12C[30;41m[37;40m[9C[30;45m[35;46m[30;45m[35;40m[37m [1;32m      [0;35m [30;45m[35;40m[30;45m [35;40m [37m[6C[31m[35m  [30;45m[37;40m");
put_it("[6C[30m     [37m[13C[30;45m[35;40m [30;45m[1;40m sty[0;30m [1m(twilght.  [0;31m[37m [1;30m [0m  [30;45m[37;40m [1;30m        [0m [31m[37m");
put_it("[44C[31m[37m  [30m                        [37m");
			break;
		default:
			break;
	}
strip_ansi_in_echo = i;
}

/*
 * parse_args: parse command line arguments for irc, and sets all initial
 * flags, etc. 
 *
 * major rewrite 12/22/94 -jfn
 *
 *
 * Im going to break backwards compatability here:  I think that im 
 * safer in doing this becuase there are a lot less shell script with
 * the command line flags then there are ircII scripts with old commands/
 * syntax that would be a nasty thing to break..
 *
 * Sanity check:
 *   Supported flags: -b, -l, -v, -c, -p, -f, -F, -L, -a, -S, -z
 *   New (changed) flags: -s, -I, -i, -n
 *
 * Rules:
 *   Each flag must be included by a hyphen:  -lb <filename> is not the
 * 		same as -l <filename> -b  any more...
 *   Each flag may or may not have a space between the flag and the argument.
 *   		-lfoo  is the same as -l foo
 *   Anything surrounded by quotation marks is honored as one word.
 *   The -c, -p, -L, -l, -s, -z flags all take arguments.  If no arguments
 *		are given between the flag and the next flag, an error
 * 		message is printed and the program is halted.
 *		Exception: the -s flag will be accepted without a argument.
 *		(ick: backwards compatability sucks. ;-)
 *   Arguments occuring after a flag that does not take an argument
 * 		will be parsed in the following way: the first instance
 *		will be an assumed nickname, and the second instance will
 *		will be an assumed server. (some semblance of back compat.)
 *   The -bl sequence will emit a depreciated feature warning.
 *   The -I flag forces you to become invisible <NOT YET SUPPORTED>
 *   The -i flag forces you to become visible <NOT YET SUPPORTED>
 *   The -X flag forces ircII to become an X application <NOT YET SUPPORTED>
 *   The -n flag means "nickname"
 *
 * Bugs:
 *   The -s flag is hard to use without an argument unless youre careful.
 */
static	char	*parse_args (char *argv[], int argc)
{

	int ac;
#ifdef CLOAKED
	int optind;
#endif
	int add_servers = 0;
	struct passwd *entry;
	char *channel = NULL;
	char *ptr = NULL;
	struct hostent * hp;

	*nickname = 0;

	for ( ac = 1; ac < argc; ac++ )
	{
		if (argv[ac][0] == '-')
		{
		    switch (argv[ac][1]) {

			case 'v': /* Output ircII version */
			{
				show_version();
				/* NOTREACHED */
			}

			case 'c': /* Default channel to join */
			{
				char *what = empty_string;

				if (argv[ac][2])
					what = &(argv[ac][2]);
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
				{
					fprintf(stderr, "Missing paramater after -c\n");
					exit(1);
				}
				malloc_strcpy(&channel, what);
				break;
			}

			case 'p': /* Default port to use */
			{
				char *what = empty_string;

				if (argv[ac][2])
					what = &argv[ac][2];
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
				{
					fprintf(stderr, "Missing paramater after -p\n");
					exit(1);
				}
				irc_port = my_atol(what);
				break;
			}
#ifndef WINNT
			case 'f': /* Use flow control */
			{
				use_flow_control = 1;
				if (argv[ac][2])
					fprintf(stderr, "Ignoring junk after -f\n");
				break;
			}

			case 'F': /* dont use flow control */
			{
				use_flow_control = 0;
				if (argv[ac][2])
					fprintf(stderr, "Ignoring junk after -F\n");
				break;
			}
#endif
			case 'd': /* use dumb mode */
			{
				dumb = 1;
				if (argv[ac][2])
					fprintf(stderr, "Ignoring junk after -d\n");
				break;
			}

			case 'l': /* Load some file instead of ~/.ircrc */
			{
				char *what = empty_string;

				if (argv[ac][2])
					what = &argv[ac][2];
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
				{
					fprintf(stderr, "Missing argument to -l\n");
					exit(1);
				}
				malloc_strcpy(&ircrc_file, what);
				break;
			}

			case 'L': /* load and expand */
			{
				char *what = empty_string;

				if (argv[ac][2])
					what = &argv[ac][2];
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
				{
					fprintf(stderr, "Missing argument to -L\n");
					exit(1);
				}
				malloc_strcpy(&ircrc_file, what);
				malloc_strcat(&ircrc_file, " -");
				break;
			}

			case 'r': /* Load list of servers from this file */
			{
				char *what = empty_string;

				if (argv[ac][2])
					what = &argv[ac][2];
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
					fprintf(stderr, "Missing argument to -r\n");

				if (*what)
				{
					add_servers = 1;
					malloc_strcpy(&ircservers_file, what);
				}
				break;
			}

			case 'a': /* add server, not replace */
			{
				add_servers = 1;
				if (argv[ac][2])
					fprintf(stderr, "Ignoring junk after -a\n");
				break;
			}

			case 'q': /* quick startup -- no .ircrc */
			{
				quick_startup = 1;
				if (argv[ac][2])
					fprintf(stderr, "Ignoring junk after -q\n");
				break;
			}

			case 'b':
			{
				bflag = 0;
				break;
			}

			case 'B':
			{
				if (argv[ac][2] && argv[ac][2] != 'l')
					fprintf(stderr, "Ignoring junk after -B\n");
				else if (argv[ac][2] == 'l')
				{
					fprintf(stderr, "Usage of -bl is decprecated: use -b -l instead.\n");
					exit(1);
				}
				dumb = 1;
				use_input = 0;
				background = 1;
				break;
			}
			case 'n':
			{
				char *what = empty_string;

				if (argv[ac][2])
					what = &(argv[ac][2]);
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
				{
					fprintf(stderr,"Missing argument for -n\n");
					exit(1);
				}
				strmcpy(nickname, what, NICKNAME_LEN);
				break;
			}

			case 'x': /* set server debug */
			{
				x_debug = (unsigned long)0xffffffff;
				if (argv[ac][2])
					fprintf(stderr, "Ignoring junk after -x\n");
				break;
			}

			case 'z':
			{
				char *what;
				if (argv[ac][2])
					what = &argv[ac][2];
				else if (argv[ac+1] && argv[ac+1][0] != '-')
				{
					what = argv[ac+1];
					ac++;
				}
				else
					break;
				strmcpy(username, what, NAME_LEN);
				break;
			}

			case '\0': break;	/* ignore - alone */

			default:
			{
				fprintf(stderr, "Unknown flag: %s\n",argv[ac]);
				fprintf(stderr, "%s%s%s", switch_help, switch_help_b, switch_help_l);
				exit(1);
			}
		   } /* End of switch */
		}
		else
		{
			if (*nickname)
				build_server_list(argv[ac]);
			else
				strmcpy(nickname, argv[ac], NICKNAME_LEN);
		}
	}


	if (!ircservers_file)
#ifdef WINNT
		malloc_strcpy(&ircservers_file, "irc-serv");
#else
		malloc_strcpy(&ircservers_file, ".ircservers");
#endif
	/* v-- right there was a '!' that should not have been there. */
	if ((ptr = getenv("IRCLIB")))
	{
		malloc_strcpy(&irc_lib, ptr);
		malloc_strcat(&irc_lib, "/");
	}
	else
		malloc_strcpy(&irc_lib, IRCLIB);

	if (!ircrc_file && (ptr = getenv("IRCRC")))
		malloc_strcpy(&ircrc_file, ptr);

	if (!*nickname && (ptr = getenv("IRCNICK")))
		strmcpy(nickname, ptr, NICKNAME_LEN);
	if ((ptr = getenv("IRCUMODE")))
		malloc_strcpy(&send_umode, ptr);

	if ((ptr = getenv("IRCNAME")))
		strmcpy(realname, ptr, REALNAME_LEN);
	else if ((ptr = getenv("NAME")))
		strmcpy(realname, ptr, REALNAME_LEN);

	if ((ptr = getenv("IRCPATH")))
		malloc_strcpy(&irc_path, ptr);
	else
	{
#ifdef IRCPATH
		malloc_strcpy(&irc_path, IRCPATH);
#else
		malloc_strcpy(&irc_path, ".:~/.irc:");
		malloc_strcat(&irc_path, irc_lib);
		malloc_strcat(&irc_path, "script");
#endif
	}

	set_string_var(LOAD_PATH_VAR, irc_path);
	new_free(&irc_path);
	
#ifndef WINNT
	if ((entry = getpwuid(getuid())))
	{
		if (!*realname && entry->pw_gecos && *(entry->pw_gecos))
		{
#ifdef GECOS_DELIMITER
			if ((ptr = index(entry->pw_gecos, GECOS_DELIMITER)))
				*ptr = (char) 0;
#endif
			if ((ptr = strchr(entry->pw_gecos, '&')) == NULL)
				strmcpy(realname, entry->pw_gecos, REALNAME_LEN);
			else {
				int len = ptr - entry->pw_gecos;

				if (len < REALNAME_LEN && *(entry->pw_name)) {
					char *q = realname + len;

					strmcpy(realname, entry->pw_gecos, len);
					strmcat(realname, entry->pw_name, REALNAME_LEN);
					strmcat(realname, ptr + 1, REALNAME_LEN);
					if (islower(*q) && (q == realname || isspace(*(q - 1))))
						*q = toupper(*q);
				} else
					strmcpy(realname, entry->pw_gecos, REALNAME_LEN);
			}
		}
		if (entry->pw_name && *(entry->pw_name) && !*username)
			strmcpy(username, entry->pw_name, NAME_LEN);
		if (entry->pw_dir && *(entry->pw_dir))
			malloc_strcpy(&my_path, entry->pw_dir);
	}
#else
	{
		u_long size=NAME_LEN+1;
		if (!(ptr = getenv("IRCUSER")))
			strcpy(username, "unknown");
		else
			strcpy(username,ptr);
	}
#endif

	if ((ptr = getenv("HOME")))
		malloc_strcpy(&my_path, ptr);
	else if (!my_path || !*my_path)
#ifdef WINNT
		malloc_strcpy(&my_path, empty_string);
#else
		malloc_strcpy(&my_path, "/");
#endif
	if (!*realname)
		strmcpy(realname, "*Unknown*", REALNAME_LEN);

       /*
        * Yes... this is EXACTLY what you think it is.  And if you don't know..
        * then I'm not about to tell you!           -- Jake [WinterHawk] Khuon
        */
	if ((ptr = getenv("IRCUSER"))) strmcpy(username, ptr, NAME_LEN);
	else if ((ptr = getenv("USER"))) strmcpy(username, ptr, NAME_LEN);
	else if (!*username)
	{
#ifdef IDENT_FAKE
		char *p = NULL, *q = NULL;
		FILE *f;
		malloc_sprintf(&p, "~/%s", get_string_var(IDENT_HACK_VAR));
		q = expand_twiddle(p);
		if ((f = fopen(q, "r")))
		{
			fgets(username, NAME_LEN, f);
			if (*username && strchr(username, '\n'))
				username[strlen(username)-1] = 0;
		}
		fclose(f);
		new_free(&p); new_free(&q);
		if (!*username)
#endif
			strmcpy(username, "Unknown", NAME_LEN); 

	}
	if ((ptr = getenv("IRC_HOST")) || (ptr = getenv("IRCHOST")))
		LocalHostName = m_strdup(ptr);

	if ((gethostname(hostname, sizeof(hostname))))
		if (!LocalHostName)
			exit(1);

	if (LocalHostName)
	{
		printf("Your hostname appears to be [%s]\n", LocalHostName);
		memset((void *)&LocalHostAddr, 0, sizeof(LocalHostAddr));
		if ((hp = gethostbyname(LocalHostName)))
			memcpy((void *)&LocalHostAddr, hp->h_addr, sizeof(LocalHostAddr));
	} 
	else
	{
		if ((hp = gethostbyname(hostname)))
			memcpy((char *) &MyHostAddr, hp->h_addr, sizeof(MyHostAddr));
	}

	if (!nickname || !*nickname)
		strmcpy(nickname, username, sizeof(nickname));

	if (!check_nickname(nickname))
	{
		fprintf(stderr, "Illegal nickname %s\n", nickname);
		fprintf(stderr, "Please restart IRC II with a valid nickname\n");
		exit(1);
	}
	if (ircrc_file == NULL)
	{
		ircrc_file = (char *) new_malloc(strlen(my_path) + strlen(IRCRC_NAME) + 1);
		strcpy(ircrc_file, my_path);
		strcat(ircrc_file, IRCRC_NAME);
	}
	if (bircrc_file == NULL)
#ifdef WINNT
		malloc_sprintf(&bircrc_file, "%s/bx-rc", my_path);
#else
		malloc_sprintf(&bircrc_file, "%s/.bitchxrc", my_path);
#endif

	if ((ptr = getenv("IRCPORT")))
		irc_port = my_atol(ptr);

	if ((ptr = getenv("IRCSERVER")))
		build_server_list(ptr);
	
	if (!server_list_size() || add_servers)
	{
		if (read_server_file(ircservers_file) || (server_list_size() == 0))
		{
			char *ptr = NULL;

#ifdef DEFAULT_SERVER
			malloc_strcpy(&ptr, DEFAULT_SERVER);
			build_server_list(ptr);
			new_free(&ptr);
#else
			ircpanic("DEFAULT_SERVER not defined -- no server list");
#endif
		}
	}

#ifdef CLOAKED
	for (optind = argc-1; optind >= 0;optind--)
		memset(argv[optind], 0, strlen(argv[optind]));
	strcpy(argv[0],CLOAKED);
#endif

	return (channel);
}



/* new irc_io modularized stuff */

/* 
 * GetLineStruct is what is "under" your current input line, and the function
 * we're supposed to call when you press return.  This is different from
 * AddWaitPrompt which does functionally the same thing but doesnt cause
 * recursive calls to io.
 */
struct GetLineStruct {
	int done;
	void (*func) _((char, char *));
	char *saved_input;
	char *saved_prompt;
	int recursive_call;
	struct GetLineStruct *prev;
	struct GetLineStruct *next;
};
typedef struct GetLineStruct GetLine;
GetLine *GetLineStack = NULL;

/* when you press return, you call this. */
extern void get_line_return (char unused, char *not_used)
{
	GetLine *stuff;

	if (dumb)
		ircpanic("get_line_return() called in dumb mode\n");

	/* get the last item on the stack */
	if ((stuff = GetLineStack) == NULL)
		return;
		
	/* 
	   If we're NOT the main() call, then undo all that we 
	       messed up coming in. 
	   If stuff->done gets set to 1 when recursive_call is 
	       zero, then something is VERY wrong.
	   We can set stuff->prev->next to null because the call
		to get_line() holds a pointer to stuff, so when it
		unrecurses, it will free it.
	 */
	if (stuff->func)
		(stuff->func)(unused, not_used);

	if (stuff->recursive_call)
	{
		stuff->done = 1;
		set_input(stuff->saved_input);
		set_input_prompt(curr_scr_win, stuff->saved_prompt, 0);
		new_free(&(stuff->saved_input));
		new_free(&(stuff->saved_prompt));
		stuff->next->prev = NULL;
		GetLineStack = stuff->next;
	}

	update_input(UPDATE_ALL);

	/* We cant delete stuff here becuase the get_line function
	 * still needs to look at stuff->done.  So we let it delete
	 * the items off the list.  But we removed it from the list,
	 * so we wont accidentally use it later.
	 */
	return;
}

/* This is a wrapper for io().  Only two functions at any time are allowed
 * to call it, and main() is one of those two.  When you call it, you have
 * the option to change the input prompt and the input buffer.  You also
 * give it a function to call when it gets a return.  Only main() is 
 * allowed to call it with an new_input of -1, which tells it that it is
 * at the lowest level of parsing, by which i mean that noone is waiting
 * for anything, since there is no recursion going on.
 */
void get_line (char *prompt, int new_input, void (*func) _((char, char *)))
{
	GetLine *stuff;

	/* if we're in dumb mode, we dont do anything, we just let 
	 * io() have all the fun.  Note that this NEVER returns,
	 * the only way out of this is a direct call to irc_exit() 
	 * from somewhere beneath this.
	 */
	while (dumb)
		io("dumb_mode");

	if (GetLineStack && new_input == -1)
		ircpanic("Illegal call to get_line\n");

	/* initialize the new item. */
	stuff = (GetLine *)new_malloc(sizeof(GetLine));
	stuff->done = 0;
	stuff->func = func;
	stuff->recursive_call = (new_input == -1) ? 0 : 1;
	stuff->saved_input = NULL;
	stuff->saved_prompt = NULL;
	stuff->prev = NULL;
	stuff->next = NULL;
	malloc_strcpy(&(stuff->saved_input), get_input());
	malloc_strcpy(&(stuff->saved_prompt), get_input_prompt());

	/* put it on the stack */
	if (GetLineStack)
	{
		stuff->next = GetLineStack;
		GetLineStack->prev = stuff;
	}
	GetLineStack = stuff;
	
	/* if its a global call, get the input prompt */
	if (new_input == -1)
		set_input_prompt(curr_scr_win, get_string_var(INPUT_PROMPT_VAR), 0);
	else
		set_input_prompt(curr_scr_win, prompt, 0);
	set_input(empty_string);

	/* ok.  we call io() until the user presses return, ending 
	 * the input line.  get_line_return will then set get_line_done
	 * to one, and we will stop getting characters and drop out.
	 * get_line_done NEVER sets this to one if we are in our call
	 * from main().  NEVER.
	 */
	while (!stuff->done)
		io("get line");

	if (new_input == -1)
		ircpanic("get_line: input == -1 is illegal value");

	/* By the time we get here, stuff->done has been set to 1,
	 * which means that get_line_return has already freed the
	 * interesting items in stuff and removed it from the list.
	 * Noone but us has a pointer to it, so we free it here.
	 */
	new_free(&stuff->saved_input);
	new_free(&stuff->saved_prompt);
	new_free((char **)&stuff);
}

/* This simply waits for a key to be pressed before it unrecurses.
 * It doesnt do anyting in particular with that key (it will go to 
 * the input buffer, actually)
 */
char get_a_char _((void))
{
	key_pressed = 0;
	while (!key_pressed)
		io("get a char");
	update_input(UPDATE_ALL);
	return key_pressed;
}

extern int timed_server _((void *));
extern int in_timed_server;
/* 
 * io() is a ONE TIME THROUGH loop!  It simply does ONE check on the
 * file descriptors, and if there is nothing waiting, it will time
 * out and drop out.  It does everything as far as checking for exec,
 * dcc, ttys, notify, the whole ball o wax, but it does NOT iterate!
 * 
 * You should usually NOT call io() unless you are specifically waiting
 * for something from a file descriptor.  It doesnt look like bad things
 * will happen if you call this elsewhere, but its long time behavior has
 * not been observed.  It *does* however, appear to be much more reliable
 * then the old irc_io, and i even know how this works. >;-)
 */
extern void set_screens _((fd_set *, fd_set *));

void io _((const char *what))
{
	static	int	first_time = 1,	
			level = 0;
	static	struct	timeval cursor_timeout, 
			clock_timeout, 
			right_away, 
			timer, 
			*timeptr = NULL;
	int	hold_over;
	fd_set	rd, 
		wd;
	static int old_level = 0;
	Screen	*screen, 
		*old_current_screen = current_screen;
	static	const	char	*caller[51] = { NULL }; /* XXXX */
	static	int last_warn = 0;
	time_t	now = time(NULL);

	level++;

	if (x_debug & DEBUG_WAITS)
	{
		if (level != old_level)
		{
			yell("Moving from io level [%d] to level [%d] from [%s]", old_level, level, what);
			old_level = level;
		}
	}


	if (level && (level - last_warn == 5))
	{
		last_warn = level;
		yell("io's nesting level is [%d],  [%s]<-[%s]<-[%s]<-[%s]<-[%s]<-[%s]", level, what, caller[level-1], caller[level-2], caller[level-3], caller[level-4]);
		if (level % 50 == 0)
			ircpanic("Ahoy there matey!  Abandon ship!");
		return;
	}
	else if (level  && (last_warn -level == 5))
		last_warn -= 5;

	caller[level] = what;

	/* first time we run this function, set up the timeouts */
	if (first_time)
	{
		first_time = 0;

		/* time before cursor jumps from display area to input line */
		cursor_timeout.tv_usec = 0L;
		cursor_timeout.tv_sec = 1L;

		/*
		 * time delay for updating of internal clock
		 *
		 * Instead of looking every 15 seconds and seeing if
		 * the clock has changed, we now figure out how much
		 * time there is to the next clock change and then wait
		 * until then.  There is a small performance penalty 
		 * in actually calculating when the next minute will tick, 
		 * but that will be offset by the fact that we will only
		 * call select() once a minute instead of 4 times.
		 */
		clock_timeout.tv_usec = 0L;

		right_away.tv_usec = 0L;
		right_away.tv_sec = 0L;

		timer.tv_usec = 0L;
	}

	/* SET UP TIMEOUTS USED IN SELECTING */
/*	clock_timeout.tv_sec = time_to_next_minute();*/

	/* CHECK FOR CPU SAVER MODE */
	if (!cpu_saver && get_int_var(CPU_SAVER_AFTER_VAR))
		if (now - idle_time > get_int_var(CPU_SAVER_AFTER_VAR) * 60)
			cpu_saver_on(0, NULL);

	rd = readables;
	wd = writables;

	FD_ZERO(&wd);
	FD_ZERO(&rd);

	set_screens(&rd, &wd);				
	set_dcc_bits(&rd, &wd);
	set_server_bits(&rd, &wd);
	set_process_bits(&rd);	
	set_socket_read(&rd, &wd);


	clock_timeout.tv_sec = 60 - now % 60;
	if (cpu_saver && get_int_var(CPU_SAVER_EVERY_VAR))
		clock_timeout.tv_sec += (get_int_var(CPU_SAVER_EVERY_VAR) - 1) * 60;

	if (!timeptr)
		timeptr = &clock_timeout;
	timer.tv_sec = TimerTimeout();
	if (timer.tv_sec <= timeptr->tv_sec)
		timeptr = &timer;
	if ((hold_over = unhold_windows()) != 0)
		timeptr = &right_away;


	/* GO AHEAD AND WAIT FOR SOME DATA TO COME IN */
	switch (new_select(&rd, &wd, timeptr))
	{
		case 0:
			break;
		case -1:
		{
			/* if we just got a sigint */
			if (cntl_c_hit)
			{
				key_pressed = 3;
				edit_char('\003');
				cntl_c_hit = 0;
			}
			else if (errno != EINTR)
				yell("Select failed with [%s]", strerror(errno));
			break;

		}

		/* we got something on one of the descriptors */
		default:
		{
			set_current_screen(last_input_screen);
			dcc_check(&rd, &wd);
			do_server(&rd, &wd);
			do_processes(&rd);
			do_screens(&rd);
			do_clones(&rd, &wd);
			dcc_sendfrom_queue();
			dcc_check_idle();
			scan_sockets(&rd, &wd);
			set_current_screen(old_current_screen);
			break;
		} 
	}
	ExecuteTimers();
#ifdef WANT_TCL
	check_utimers();
#endif	
	while (child_dead)
	{
		check_wait_status(-1);
		child_dead--;
	}

	if (!hold_over)
		cursor_to_input();
	timeptr = &clock_timeout;

	for (screen = screen_list; screen; screen = screen->next)
		if (screen->alive && is_cursor_in_display(screen))
			timeptr = &cursor_timeout;

	if (get_int_var(LLOOK_VAR) && from_server > -1 && !server_list[from_server].link_look) 
	{
		if (time(NULL) - server_list[from_server].link_look_time > get_int_var(LLOOK_DELAY_VAR)) 
		{
			server_list[from_server].link_look++;
			my_send_to_server(from_server, "LINKS");
			server_list[from_server].link_look_time = time(NULL);
		}
	}
	if (update_clock(0))
	{
		do_notify();
#ifdef WANT_TCL
		check_timers();
#endif
		clean_whowas_chan_list();
		clean_whowas_list();
		if (get_int_var(CLOCK_VAR) || check_mail_status())
		{
			status_update(1);
			cursor_to_input();
		}
	}

	/* (set in term.c) -- we should redraw the screen here */
	if (term_reset_flag)
	{
		refresh_screen(0, NULL);
		term_reset_flag = 0;
	}
	if (primary_server == -1 && !connected_to_server && !in_timed_server)
	{
		add_timer("", 10, timed_server, m_strdup("0"), NULL);
		in_timed_server++;
	}
#ifdef __GNUC__
	alloca(0);
#endif
	caller[level] = NULL;
	level--;
	return;
}

int main(int argc, char *argv[], char *envp[])
{
	char	*channel;

	srand((unsigned)time(NULL));
	time(&start_time);
	time(&idle_time);

#ifdef SOCKS
	SOCKSinit(argv[0]);
#endif

#ifdef TDEBUG
	*cx_file = 0;
	cx_line = 0;
	*cx_function = 0;
#endif
	printf("Process [%d]", getpid());
	if (isatty(0))
		printf(" connected to tty [%s]", ttyname(0));
	else
		dumb = 1;
	printf("\n");
	
	
	channel = parse_args(argv, argc);
	
	FD_ZERO(&readables);
	FD_ZERO(&writables);
	

	if (!use_input && !no_fork && fork())
		_exit(0);

#ifndef BITCHX_DEBUG
	my_signal(SIGSEGV, coredump, 0);
	my_signal(SIGBUS, coredump, 0);
#endif
	my_signal(SIGQUIT, SIG_IGN, 0);
	my_signal(SIGHUP, irc_exit_old, 0);
	my_signal(SIGTERM, irc_exit_old, 0);
	my_signal(SIGPIPE, SIG_IGN, 0);
	my_signal(SIGINT, cntl_c, 0);
	my_signal(SIGCHLD, child_reap, 0);
	my_signal(SIGALRM, nothing, 0);
	my_signal(SIGUSR1, sig_user1, 0);

	if (!dumb && init_screen() == 0) 
	{
		my_signal(SIGCONT, term_cont, 0);
#ifndef WINNT
		my_signal(SIGWINCH, sig_refresh_screen, 0);
#endif
        }   
	else
	{
		if (background)
		{
			my_signal(SIGHUP, SIG_IGN, 0);
			freopen("/dev/null", "w", stdout);
		}
		dumb = 1;               /* Just in case */
		new_window();
	}


	init_keys_1();
	init_variables();

	if (!dumb)
	{
		build_status(curr_scr_win, NULL, 0);
		update_input(UPDATE_ALL);
	}

	global_all_off[0] = ALL_OFF;
	global_all_off[1] = '\0';
	display_bitchx(-1);
	if (bflag)
		load_scripts();

#ifdef WANT_TCL
	tcl_init();
#endif

	reinit_autoresponse(curr_scr_win, NULL, 0);
	get_connected(0);

	if (channel)
	{
		set_channel_by_refnum(0, channel);
		add_channel(channel, primary_server);
		new_free(&channel);
	}
	set_input(empty_string);
	get_line(NULL, -1, send_line);
	ircpanic("get_line() returned");
	return 0;
}
