/*
 * notice.c: special stuff for parsing NOTICEs
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1991
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#include "irc.h"

#include "whois.h"
#include "ctcp.h"
#include "window.h"
#include "lastlog.h"
#include "flood.h"
#include "vars.h"
#include "ircaux.h"
#include "hook.h"
#include "ignore.h"
#include "server.h"
#include "funny.h"
#include "output.h"
#include "names.h"
#include "parse.h"
#include "notify.h"
#include "misc.h"
#include "screen.h"
#include "status.h"
#include "hash2.h"

extern	char	*FromUserHost;
static	void	parse_server_notice _((char *, char *));
extern void reload_save _((char *, char *, char *));
int	doing_notice = 0;

long	oper_kills = 0,
	nick_collisions = 0,
	serv_fakes = 0,
	serv_unauth = 0,
	serv_split = 0,
	serv_rejoin = 0,
	serv_squits = 0,
	serv_connects = 0,
	client_connects = 0,
	serv_rehash = 0,
	client_exits = 0,
	serv_klines = 0,
	client_floods = 0,
	client_invalid = 0,
	stats_req = 0,
	client_bot = 0,
	client_bot_alarm = 0,
	oper_requests = 0;

#define NEWNET_IRCOP

#if 0	
char	* PasteNoticeArgs(char **Args, int StartPoint)
{
	int	i;

	for (; StartPoint; Args++, StartPoint--)
		if (!*Args)
			return NULL;
	for (i = 0; Args[i] && Args[i+1]; i++)
		Args[i][strlen(Args[i])] = ' ';
	Args[1] = NULL;
	return Args[0];
}

/*
 * BreakArgs: breaks up the line from the server, in to where its from,
 * setting FromUserHost if it should be, and returns all the arguements
 * that are there.   Re-written by phone, dec 1992.
 */
#define space ' '

int BreakNoticeArgs(char *Input, char **OutPut)
{
	int	ArgCount = 0;

	/*
	 * Now we go through the argument list...
	 */
	for (;;)
	{
		while (*Input && *Input == space)
			Input++;

		if (!*Input)
			break;

		if (*Input == ':')
		{
			OutPut[ArgCount++] = ++Input;
			break;
		}

		OutPut[ArgCount++] = Input;
		if (ArgCount >= MAXNOTICEPARA)
			break;

		while (*Input && *Input != space)
			(void) *Input++;
		if (*Input == space)
			*Input++ = 0;
	}
	OutPut[ArgCount] = NULL;
	return ArgCount;
}
#endif

static	int  handle_oper_vision(char *from, char *line, int *up_status)
{
	char *fr, *for_, *temp, *temp2;
	char newline[BIG_BUFFER_SIZE+1];
	char **newargs = NULL;
	char *TrueArgs[MAXPARA+1] = { NULL };
	
	char *p;
	int done_one = 0;
	int i;

	fr = for_ = temp = temp2 = NULL;
	
	if (!strstr(line, "Notice --") && !strstr(line, "\002Notice\002 --"))
		return 0;

	newargs = TrueArgs;
	strcpy(newline, line);

	i = BreakArgs(newline, NULL, newargs, 1);

	if ((i > 11) && !my_stricmp("KILL", *(newargs + 4)))
	/*strstr(line, "-- Received KILL message for"))*/
	{
		char *q;
		if (!get_int_var(SHOW_SERVER_KILLS_VAR))
			goto done;  	

		PasteArgs(newargs, 12);
		for_ = *(newargs + 7);
		temp2 = *(newargs + 11);
		q = temp = *(newargs + 12);
		if (temp)
		{
			chop(temp, 1);
			q = temp+1;
		}
		fr = *(newargs + 9);
		
		if (match("%.%", fr))
		{
			serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_NICK_COLLISION_VAR), "%s %s %s %s", update_clock(GET_TIME), fr, for_, q));
			nick_collisions++;
		}
		else 
		{
			int loc_check = 0;
			char *p = temp2;
			if (p)
				loc_check = charcount(temp2, '!');
			
			if (!loc_check || loc_check == 1)
				serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_KILL_LOCAL_VAR), "%s %s %s %s", update_clock(GET_TIME), fr, for_, q));
			else
				serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_KILL_VAR), "%s %s %s %s", update_clock(GET_TIME), fr, for_, q));
#if 0
			if (!my_stricmp(get_server_nickname(from_server), for_)) 
				logmsg(0, LOG_KILL, "!", from, fr, for_, 0, NULL);
#endif
			oper_kills++;
		}
		(*up_status)++;
		done_one++;
	}
	else if ((i >= 5) && !my_strnicmp("Nick", *(newargs+3), 4) && (!my_stricmp("collision", *(newargs+4)) || !my_stricmp("collision", *(newargs+5))) )
	{
		if (!get_int_var(SHOW_SERVER_KILLS_VAR))
			goto done;  	
#if 0
[:irc.cs.cmu.edu NOTICE pana-2 :*** Notice -- Nick collision on
          _NaTe(_NaTe <- irc2.uiuc.edu[@128.174.5.43])(newer killed)J]
#endif          
		if (!my_stricmp(*(newargs+4), "change"))
		{
			PasteArgs(newargs, 7);
			p = *(newargs + 7);
		}
		else
		{
			PasteArgs(newargs, 6);
			p = *(newargs + 6);
		}
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_NICK_COLLISION_VAR), "%s %s", update_clock(GET_TIME), p));
		nick_collisions++;
		(*up_status)++;
		done_one++;
	}
	else if ((i > 6) && !my_stricmp("IP#", *(newargs+3)))
	{
		if (!get_int_var(SHOW_UNAUTHS_VAR))
			goto done;  	
		PasteArgs(newargs, 5);
		for_ = *(newargs + 5);
		serversay(1, "%s", convert_output_format("IP Mismatch %C$1-", "%s %s", update_clock(GET_TIME), for_));
		done_one++;
	}
	else if ((i > 5) && !my_stricmp("Identd", *(newargs + 3)))
	{
		if (!get_int_var(SHOW_UNAUTHS_VAR))
			goto done;  	
		PasteArgs(newargs, 6);
		for_ = *(newargs + 6);
		serversay(1, "%s", convert_output_format("Identd response differs %K[%C$1-%K]", "%s %s", update_clock(GET_TIME), for_));
		done_one++;
	}
  	else if (match(line, "% % -- Fake: %")) /* MODE */
  	{
		serv_fakes++;
		if (!get_int_var(SHOW_FAKES_VAR))
			goto done;
		PasteArgs(newargs, 7);
		fr = *(newargs + 6);
		temp = *(newargs + 7);		
		if (lookup_channel(fr, from_server, CHAN_NOUNLINK))
			serversay(0, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_FAKE_VAR), "%s %s %s", update_clock(GET_TIME), fr, temp));
		else 
			serversay(0, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_FAKE_VAR), "%s %s %s", update_clock(GET_TIME), fr, temp));
		done_one++;
  	}
  	else if ((i > 3) && !my_stricmp("Unauth", *(newargs+3)))
  	{
		serv_unauth++;
		if (!get_int_var(SHOW_UNAUTHS_VAR))
			goto done;
#if 0
$1 = 0xbffff26f "*** Notice -- Unauthorized connection from [Zi][LALA@cmodem58.lancite.net]."
#endif
		for_ = *(newargs + 6);
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_UNAUTH_VAR), "%s %s", update_clock(GET_TIME), for_));
		done_one++;
	}
	else if (strstr(line, "-- Entering") || strstr(line, "-- Still high-traffic"))
	{
		char *q;
 		serv_split++;
		if (!get_int_var(SHOW_TRAFFIC_VAR))
			goto done;
		if (!my_stricmp("Entering", *(newargs+3)))
		{
			PasteArgs(newargs, 8);
		
			for_ = *(newargs + 7);
			for_++;
			q = temp2 = *(newargs + 8);
			if (temp2)
			{
				chop(temp2, 1);
				q = temp2+1;
			}
		}
		else
		{
			PasteArgs(newargs, 9);
		
			for_ = *(newargs + 8);
			q = temp2 = *(newargs + 9);
			if (temp2)
			{
				chop(temp2, 1);
				q = temp2+1;
			}
		}
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_TRAFFIC_HIGH_VAR), "%s %s %s", update_clock(GET_TIME), for_, q));
		done_one++;
	}
	else if (strstr(line, "-- Resuming standard operation"))
	{
		serv_rejoin++;
		if (!get_int_var(SHOW_TRAFFIC_VAR))
			goto done;

		for_ = *(newargs + 7);
		temp = *(newargs + 8);
		temp2 = *(newargs + 9);

		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_TRAFFIC_NORM_VAR), "%s %s %s %s", update_clock(GET_TIME), for_, temp, temp2));
		done_one++;
	}
	else if (strstr(line, "is rehashing Server config file"))
	{
		serv_rehash++;
		for_ = *(newargs + 3);
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_REHASH_VAR), "%s %s", update_clock(GET_TIME), for_));
		done_one++;
	}
	else if (strstr(line, "added K-Line for"))
	{
		serv_klines++;

		for_ = *(newargs + 3);
		temp2 = *(newargs + 7);
		if (++temp2)
			chop(temp2, 2);
		PasteArgs(newargs, 8);
		temp = *(newargs + 8);

		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_KLINE_VAR), "%s %s %s %s", update_clock(GET_TIME), for_, temp2, temp));
		done_one++;
	}
	else if (strstr(line, "Possible bot"))
	{
		client_bot++;
		if (!get_int_var(SHOW_BOTS_VAR))
			goto done;

		for_ = *(newargs + 5);
		temp2 = *(newargs +6);
		if (temp2)
			chop(temp2, 1);

		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_BOT_VAR), "%s %s %s", update_clock(GET_TIME), for_, temp2));
		done_one++;
	}
	else if (match(line, "% % -- Possible % bot"))
	{
/*	
*** Notice -- Possible eggdrop bot: root (root@panasync.canu
*/
		char *possible = NULL;
		client_bot++;
		if (!get_int_var(SHOW_BOTS_VAR))
			goto done;

		possible = *(newargs + 4);
		for_ = *(newargs + 6);
		temp2 = *(newargs + 7);
		if (temp2)
		{
			chop(temp2, 1);
			*temp2 = ' ';
		}
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_BOT1_VAR), "%s %s %s %s", update_clock(GET_TIME), possible?possible:"Unknown", for_, temp2));
		done_one++;
	}
	else if (match("% % -- JohBot alarm activated", line) || match("% % -- % alarm activated", line) || match("% % -- % % alarm activated", line) || match("% % -- Eggdrop % alarm % activated", line))
	{
		char *possible;
		client_bot_alarm++;
		if (!get_int_var(SHOW_BOTS_VAR))
			goto done;
/*	
*** Notice -- Possible eggdrop bot: root (root@panasync.canu
*/
		possible = *(newargs + 4);
		for_ = *(newargs + 6);
		PasteArgs(newargs, 7);
		temp2 = *(newargs + 7);

		if (temp2)
		{
			chop(temp2, 1);
			*temp2 = ' ';
		}
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_BOT_ALARM_VAR), "%s %s %s %s", update_clock(GET_TIME), possible?possible:"Unknown", for_, temp));
		done_one++;
	}
	else if (stristr(line, "is now operator"))
	{
		oper_requests++;
		fr = *(newargs + 3);
		temp2 = *(newargs + 4);
		if (temp2)
		{
			chop(temp2, 1);
			if (*temp2 == '(')
				*temp2 = ' ';
		}
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_OPER_VAR), "%s %s %s", update_clock(GET_TIME), fr, temp2));
		if (!my_stricmp(fr, get_server_nickname(from_server)) && get_string_var(OPER_MODES_VAR))
			send_to_server("MODE %s %s", fr, get_string_var(OPER_MODES_VAR));
		done_one++;
	} 
	else if (strstr(line, "Received SQUIT"))
	{
/*
!irc.stanford.edu!! Received SQUIT irc.best.net from Taner (this is lame)
*/
		fr = *(newargs + 7);
		for_ = *(newargs + 5);
		PasteArgs(newargs, 8); 
		temp2 = *(newargs + 8);
		if (temp2)
		{
			chop(temp2, 1);
			if (*temp2 == '(')
				*temp2 = ' ';
		}
		serversay(1, "%s", convert_output_format("SQUIT of $1 from $2 %K[%R$3-%K]", "%s %s %s %s", update_clock(GET_TIME), for_, fr, temp2));
		done_one++;
	} 
	else if (strstr(line, "Remote CONNECT"))
	{
/*
!ircd.concentric.net!! Remote CONNECT irc2.uiuc.edu 6666 from moogle
*/
		for_ = *(newargs + 5);
		fr = *(newargs + 8);
		temp2 = *(newargs + 6);
		serversay(1, "%s", convert_output_format("Remote Connect of $1:$2 from $3", "%s %s %s %s", update_clock(GET_TIME), for_, fr, temp2));
		done_one++;
	}
	else if ((i > 4) && !my_stricmp("Client", *(newargs+3)))
	/*strstr(line, "-- Client connecting"))*/
	{
		char *q = empty_string, *p = NULL;
		int conn = !my_strnicmp("connect", *(newargs+4), 7) ? 1 : 0;
		int dalnet = (i > 7) ? 1 : 0;
		if (conn)
			client_connects++;
		else 
			client_exits++;
		if (!get_int_var(SHOW_CLIENT_VAR))
			goto done;
#if 0
<Anybody> irc.klis.com *** Notice -- Client connecting: <DarkSun!anybody@ppp42.ocws.com>
dalnet There itc Client connecting on port 7000:
#endif          
		if (!dalnet || (dalnet && !conn))
		{
			for_ = *(newargs + 5);
			q = temp2 = *(newargs + 6);
		
			if (temp2)
			{
				chop(temp2, 1);
				q = temp2+1;
			}
		} 
		else if (conn && dalnet)
		{
			for_ = *(newargs + 8);
			q = temp2 = *(newargs + 9);
			p = *(newargs + 7);
			chop(p, 1);
			if (temp2)
			{
				chop(temp2, 1);
				q = temp2+1;
			}
		}
		serversay(1, "%s", convert_output_format(get_string_var(conn ? FORMAT_SERVER_NOTICE_CLIENT_CONNECT_VAR : FORMAT_SERVER_NOTICE_CLIENT_EXIT_VAR), "%s %s %s %s", update_clock(GET_TIME), for_, q, p?p:empty_string));
		done_one++;
	}
	else if (strstr(line, "Terminating client for excess"))
	{
		char *q;
		client_floods++;
		if (!get_int_var(SHOW_CLIENT_VAR))
			goto done;

		for_ = *(newargs + 8);
		q = temp2 = *(newargs + 9);
		if (temp2)
		{
			chop(temp2, 1);
			q = temp2+1;
		}
		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_CLIENT_TERM_VAR), "%s %s %s", update_clock(GET_TIME), for_, q));
		done_one++;
	}
	else if (strstr(line, "Invalid username"))
	{
		client_invalid++;
		if (!get_int_var(SHOW_CLIENT_VAR))
			goto done;

		for_ = *(newargs + 5);
		temp2 = *(newargs + 6);
		if (temp2)
			chop(temp2, 1);

		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_CLIENT_INVALID_VAR), "%s %s %s", update_clock(GET_TIME), for_, temp2));
		done_one++;
	}
	else if (strstr(line, "Notice -- STATS "))
	{
		stats_req++;
		if (!get_int_var(SHOW_CLIENT_VAR))
			goto done;
/*	
*** Notice -- STATS k requested by root (root@panasync.canu
*/
		temp = *(newargs + 4);
		for_ = *(newargs + 7);
		temp2 = *(newargs + 8);

		if (++temp2)
			chop(temp2, 1);

		serversay(1, "%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_STATS_VAR), "%s %s %s %s", update_clock(GET_TIME), temp, for_, temp2));
		done_one++;
	}
	else if ((i > 7) && strstr(line, "Nick flooding detected by:"))
	{
/*
!ingenue.EECS.Berkeley.EDU Nick flooding detected by: KiNGPiN0 (falzar@204.174.128.37)
*/          
		if (!get_int_var(SHOW_CLIENT_VAR))
			goto done;
		for_ = *(newargs + 7);
		PasteArgs(newargs, 7);
		serversay(1, "%s", convert_output_format("Nick Flooding %K[%B$1-%K]", "%s %s", update_clock(GET_TIME), for_));
		done_one++;
	}
	else if ((i > 5) && (!strcmp(*(newargs + 3), "Kill") || !my_stricmp(*(newargs + 4), "K-line")))
/*	strstr(line, "Kill line active for"))*/
	{
/*
!opus.bridge.net Kill line active for SS3[taqi@168.187.104.37]
!irc.cs.cmu.edu -- K-line active for o0Lm8Jup5[tfb1@crown11.crown.net]
!irc.cs.cmu.edu -- K-line active for m1Upf4a8Q[tfb1@crown11.crown.net]
*/
		if (!get_int_var(SHOW_CLIENT_VAR))
			goto done;
		PasteArgs(newargs, 7);
		for_ = *(newargs + 7);
		serversay(1, "%s", convert_output_format("Kill line for $1 active", "%s %s", update_clock(GET_TIME), for_));
		done_one++;
	}
#ifdef NEWNET_IRCOP
	else if ((i > 8) && !my_stricmp(*(newargs + 3), "HACK:"))
	{
		PasteArgs(newargs, 6);
		serversay(1, "%s", convert_output_format("Hack Mode $0 by $1 $2", "%s", *(newargs+6)));
		done_one++;
	}
	else if ((i > 6) && !my_stricmp(*(newargs + 4), "break:"))
	{
		PasteArgs(newargs, 5);
		serversay(1, "%s", convert_output_format("NetSplit $0 $1: $2-", "%s", *(newargs+5)));
		done_one++;
	}
	else if ((i > 5) && !my_stricmp(*(newargs + 4), "junction:"))
	{
		PasteArgs(newargs, 5);
		serversay(1, "%s", convert_output_format("NetJoin $0 by $1", "%s", *(newargs+5)));
		done_one++;
	}
/*
!ircd.acilink.net!! HACK: thenew.gamesbbs.com MODE #just4fun +tno StarGate 830229003
!irc.klis.com -- Net break: hub.eskimo.com thenew.gamesbbs.com (Ping timeout)
!irc.klis.com -- Net junction: hub.eskimo.com irc.accessus.net
!services.newnet.net!! <LadyBear!ladybear@ladybear.acilink.net> requested:
          mode #hottub +o LadyBear
*/          
#endif
	else 
	{

		if (!get_int_var(SHOW_SERVER_CRAP_VAR))
			goto done;
		PasteArgs(newargs, 2);
		put_it("%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_VAR), "%s %s %s", update_clock(GET_TIME), from, stripansicodes(*(newargs+2))));
		add_last_type(&last_servermsg[0], MAX_LAST_MSG, NULL, NULL, NULL, *(newargs + 2));
		done_one++;
	} 
done:
	return done_one;
}

static	void parse_server_notice(char *from, char *line)
{
	int	lastlog_level = 0;
	int	flag = 0;
	int	up_status = 0;
	
				
	
	if (!from || !*from)
		from = server_list[from_server].itsname ?
			server_list[from_server].itsname :
			server_list[from_server].name;
	if (!strncmp(line, "*** Notice --", 13))
	{
		message_from(NULL, LOG_OPNOTE);
		lastlog_level = set_lastlog_msg_level(LOG_OPNOTE);
	}

	message_from(NULL, LOG_SNOTE);
	lastlog_level = set_lastlog_msg_level(LOG_SNOTE);
	
	if (*line != '*'  && *line != '#' && strncmp(line, "MOTD ", 4))
		flag = 1;
	else
		flag = 0;

	if (do_hook(SERVER_NOTICE_LIST, flag?"%s *** %s":"%s %s", from, line))
	{
		if (handle_oper_vision(from, line, &up_status))
			;
		else if (strstr(line, "***"))
		{
			if (!get_int_var(SHOW_SERVER_CRAP_VAR))
				goto done1;
			if (do_hook(SERVER_NOTICE_LIST, flag ? "%s *** %s" : "%s %s", from, line))
			{
				char *for_;
				for_ = next_arg(line,&line);
				put_it("%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_VAR), "%s %s %s", update_clock(GET_TIME), from, stripansicodes(line)));
				add_last_type(&last_servermsg[0], MAX_LAST_MSG, NULL, NULL, NULL, line);
			}
		}
		else
		{
			if (!get_int_var(SHOW_SERVER_CRAP_VAR))
				goto done1;  	
			if (do_hook(SERVER_NOTICE_LIST, flag ? "%s *** %s" : "%s %s", from, line))
				put_it("%s", convert_output_format(get_string_var(FORMAT_SERVER_NOTICE_VAR), "%s %s %s", update_clock(GET_TIME), from, stripansicodes(line)));
			add_last_type(&last_servermsg[0], MAX_LAST_MSG, NULL, NULL, NULL, line);
		}
	}
	if (up_status)
		update_all_status(curr_scr_win, NULL, 0);
done1:
	if (lastlog_level)
	{
		set_lastlog_msg_level(lastlog_level);
		message_from(NULL, lastlog_level);
	}
}

void parse_notice(char *from, char **Args)
{
	int	level,
		type;
	char	*to;
	int	no_flooding;
	int	flag;
	char	*high,
		not_from_server = 1;
	char	*line;

	NickList *nick = NULL;	
	ChannelList *tmpc;

		
	PasteArgs(Args, 1);
	to = Args[0];
	line = Args[1];
	if (!to || !line)
		return;
	doing_notice = 1;
	
	if (*to)
	{
		if (is_channel(to))
		{
			message_from(to, LOG_NOTICE);
			type = PUBLIC_NOTICE_LIST;
		}
		else
		{
			message_from(from, LOG_NOTICE);
			type = NOTICE_LIST;
		}
		if ((tmpc = lookup_channel(to, from_server, CHAN_NOUNLINK)))
			nick = find_nicklist_in_channellist(from, tmpc, 0);
		update_stats(NOTICELIST, to, nick, tmpc, 0);		
		if (from && *from && strcmp(get_server_itsname(from_server), from))
		{
			int not_reply = 0;
			char *newline = NULL;
			if (check_auto_reply(line))
				not_reply++;
			switch ((flag = check_ignore(from, FromUserHost, to, IGNORE_NOTICES, line)))
			{
				case IGNORED:
				{
					doing_notice = 0;
					return;
				}
				case HIGHLIGHTED:
					high = highlight_char;
					break;
				default:
					high = empty_string;
			}
		/*
		 * only dots in servernames, right ?
		 *
		 * But a server name doesn't nessicarily have to have
		 * a 'dot' in it..  - phone, jan 1993.
		 */
			if (strchr(from, '.'))
				not_from_server = 0;
			line = do_notice_ctcp(from, to, line);
			if (!line || !*line)
			{
				doing_notice = 0;
				return;
			}
			level = set_lastlog_msg_level(LOG_NOTICE);
			no_flooding = check_flooding(from, NOTICE_FLOOD, line, NULL);
			
			if (sed == 1)
			{
				if (do_hook(ENCRYPTED_NOTICE_LIST, "%s %s %s", from, to, line))
					put_it("%s", convert_output_format(get_string_var(FORMAT_ENCRYPTED_NOTICE_VAR), "%s %s %s %s", update_clock(GET_TIME), from, FromUserHost, line));
				sed = 0;
			}
			else
			{
				char *free_me = NULL;
				free_me = newline = stripansi(line);

				if (no_flooding)
				{
					if (match("[*Wall*", line))
					{
						char *channel = NULL, *p, *q;
						if (do_hook(type, "%s %s", from, line))
						{
							q = p = next_arg(newline, &newline);
							if ((p = strchr(p, '/')))
							{
								channel = m_strdup(++p);
								if ((p = strchr(channel, ']')))
									*p++ = 0;
								q = channel;
							} 
							put_it("%s", convert_output_format(get_string_var(FORMAT_BWALL_VAR), "%s %s %s %s %s", update_clock(GET_TIME), q, from, FromUserHost, newline));
						}
						add_last_type(&last_wall[0], 1, from, FromUserHost, NULL, line);
						logmsg(0, LOG_WALL, "-", from, line, FromUserHost, 0, tmpc);
						new_free(&channel);
					}
					else if (type == NOTICE_LIST)
					{
						logmsg(0, LOG_NOTICE, "-", from, line, FromUserHost, 0, tmpc);
						if (do_hook(type, "%s %s", from, line))
						put_it("%s", convert_output_format(get_string_var(FORMAT_NOTICE_VAR), "%s %s %s %s", update_clock(GET_TIME), from, FromUserHost, newline));
						add_last_type(&last_notice[0], MAX_LAST_MSG, from, FromUserHost, to, line);
					}
					else
					{
						if (do_hook(type, "%s %s %s", from, to, line))
							put_it("%s", convert_output_format(get_string_var(not_reply?FORMAT_PUBLIC_NOTICE_AR_VAR:FORMAT_PUBLIC_NOTICE_VAR), "%s %s %s %s %s", update_clock(GET_TIME), from, FromUserHost, to, newline));
						if (beep_on_level & LOG_NOTICE)
							beep_em(1);
						add_last_type(&last_notice[0], MAX_LAST_MSG, from, FromUserHost, to, line);
					}
				}
				new_free(&free_me);
				set_lastlog_msg_level(level);
				if (not_from_server)
					notify_mark(from, 1, 0);
			}
		}
		else 
			parse_server_notice(from, line);
	}
	else
		put_it("%s", convert_output_format(get_string_var(FORMAT_SERVER_MSG2_VAR), "%s %s %s", update_clock(GET_TIME), from, line+1));
	doing_notice = 0;
	message_from(NULL, LOG_CRAP);
}


void load_scripts(void)
{
	char buffer[BIG_BUFFER_SIZE+1];
	static int done = 0;
	if (!done++)
	{
		
		strcpy(buffer, "bxglobal");
		never_connected = 0;

		loading_global = 1;
		load("LOAD", buffer, empty_string);
		loading_global = 0;

		/* read the .ircrc file */
		if (access(bircrc_file, R_OK) == 0 && !quick_startup)
			load("LOAD", bircrc_file, empty_string);
		else if (access(ircrc_file, R_OK) == 0 && !quick_startup)
			load("LOAD", ircrc_file, empty_string);
		if (!quick_startup)
			reload_save(NULL, NULL, NULL);
	}
	if (get_server_away(from_server) /*server_list[from_server].away*/)
		set_server_away(from_server, get_server_away(from_server) /*server_list[from_server].away*/);
}

/*
 * got_initial_version_28: this is called when ircii gets the serial
 * number 004 reply.  We do this becuase the 004 numeric gives us the
 * server name and version in a very easy to use fashion, and doesnt
 * rely on the syntax or construction of the 002 numeric.
 *
 * Hacked as neccesary by jfn, May 1995
 */
extern void got_initial_version_28 (char **ArgList)
{
	char *server, *sversion;

	server = ArgList[0];
	sversion = ArgList[1];
	
#if 0
	attempting_to_connect--;
	set_server_motd(from_server, 1);
	server_is_connected(from_server, 1);
#endif

	if (!strncmp(version, "2.8", 3))
	{
		if (strstr(version, "mu") || strstr(version, "me"))
			set_server_version(from_server, Server_u2_8);
		else
			set_server_version(from_server, Server2_8);
	}
	else if (!strncmp(version, "u2.9", 4))
		set_server_version(from_server, Server_u2_9);
	else if (!strncmp(version, "u2.10", 4))
		set_server_version(from_server, Server_u2_10);
	else if (!strncmp(version, "u3.0", 4))
		set_server_version(from_server, Server_u3_0);
	else
		set_server_version(from_server, Server2_8);

	malloc_strcpy(&server_list[from_server].version_string, sversion);
	set_server_itsname(from_server, server);
	reconnect_all_channels(from_server);
	reinstate_user_modes();

	update_all_status(curr_scr_win, NULL, 0);
	do_hook(CONNECT_LIST, "%s %d", get_server_name(from_server), get_server_port(from_server));
}
