# 
# Defs [ vr2 ] Add-On for eclipse.irc v2.00 and greater

@ decl = [\(:eD:\)]
@ devers = [vr2]
^set EXEC_PROTECTION off

alias declip {^xecho -level crap $decl $0-}

if (![$evers]) {
  echo !WARNING! You cannot load defs.ecl without eclipse.irc! !WARNING!
  echo !WARNING!  Shutting down to avoid errors and conflicts  !WARNING!
  //QUIT Error: 603 \(Loaded defs.ecl without eclipse.irc\)
}{
  declip Loading defs.ecl [ $devers ] on $evermsg\...
  if ([$ecldefs]!=[yes]) {
    if ([$ecladd]) {@ ecladd = [$ecladd + Defs]}{@ ecladd = [Defs]}
    ^set CLIENT_INFORMATION ${CLIENT_INFORMATION} + Defs
  }
  @ ecldefs = [yes]
  ^set_su
}

alias defs {
  echo  ,s-=-----------------------------------------------------------------=-s.
  echo |    -=- Defs Add-On for eclipse.irc v1.02 and greater -- DEF HELP -=-    |
  echo ,`-=-------------------------------------------------------------------=-'.
  echo | /DEFADD <word> <definition> -=- Adds word to definition list -> <word>  |
  echo | /DEFREM <word/all>              -=- Removes a word from list -> <word>  |
  echo | /DEFLIST                    -=- Lists your list of definitions          |
  echo | /DEFREP [<on/off>]          -=- Toggles reply-on-definition-request     |
  echo | /DEFINE <location/-> <word> -=- Defines a word                          |
  echo |   -=- Note - /DEFINE #channel something                                 |
  echo |               ^-- would define "something" to #channel                  |
  echo |            - /DEFINE - eclipse                                          |
  echo |               ^-- would echo the definition of "eclipse"                |
  echo | /DEFSAVE                    -=- Saves definitions                       |
  echo  `-----------------------------------------------------------------------'
}

if ([$edloaded]!=[yes]) {
@ edloaded = [yes]
@ edefs = 0
@ defrep = [ON]
EVAL ^exec -name edefs cat >> $HOME/.eclipse.defs
}

EVAL ^load $HOME/.eclipse.defs

alias defrep {
  if ([$0]) {@ defrep = [$onoff($0)]}
  declip Reply-on-definition-request is $toupper($defrep)
}

alias defadd {
  if ([$1]) {
    @ edefadd = [$0]
    @ defok = [yes]
    foreach edef aa {
      if ([$word(0 $edef[$aa])]==[$edefadd]) {@ defok = [no]}
    }
    ^assign -aa
    if ([$defok]==[yes]) {
      @ edefs = edefs + 1
      @ edef[$edefs] = [$0 $encode($1-)]
      declip Added "$0": $1-
    }{declip Word "$edefadd" is already defined}
  }{declip Use: /DEFADD <word> <definition>}
}
alias defrem {
  if ([$0]) {
    if ([$edefs]>[0]) {
      @ defrem = [$0]
      if ([$defrem]!=[all]) {
        @ defound = [no]
        foreach edef aa {
          if ([$word(0 $edef[$aa])]==[$defrem]) {
            declip Removed "$defrem": $decode($word(1 $edef[$aa]))
            @ defcnt = 1
            @ deftotal = [$aa]
            ^assign -edef[$aa]
            while ([$defcnt]<=[$edefs]) {
              if ([$defcnt]>[$aa]) {
                @ edef[${defcnt - 1}] = [$edef[$defcnt]]
                ^assign -edef[$defcnt]
              }
              @ defcnt = defcnt + 1
            }
            @ edefs = edefs - 1
            @ defound = [yes]
          }
        }
        ^assign -aa
        if ([$defound]==[no]) {declip No definition for "$defrem" found}
      }{
        foreach edef aa {^assign -edef[$aa]}
        ^assign -aa
        @ edefs = 0
        declip Definition list cleared
      }
    }{declip Definition list is empty}
  }{declip Use: /DEFREM <word>}
}
alias deflist {
  if ([$edefs]>[0]) {
    @ edeflist = 0
    declip Definition List:
    foreach edef aa {
      @ edeflist = edeflist + 1
      declip !${word(0 $edef[$aa])}! $decode($word(1 $edef[$aa]))
    }
    ^assign -aa
    declip End of $edeflist defined words
  }{declip Definition list is empty}
}

alias define {
  if ([$1]) {
    @ defto = [$0]
    @ defword = [$1]
    @ defgave = [no]
    if ([$0]==[-]) {
      foreach edef aa {
        if ([$word(0 $edef[$aa])]==[$defword]) {
          declip !${defword}! $decode($word(1 $edef[$aa]))
          @ defgave = [yes]
        }
      }
      ^assign -aa
      if ([$defgave]==[no]) {declip !No definition for "${defword}"!}
    }
  }{declip Use: /DEFINE <location/-> <word>}
}

alias defsave {
  ^exec -close %edefs
  EVAL ^exec -name remdef rm -rf $HOME/.eclipse.defs
  wait %remdef
  EVAL ^exec -name edefs cat >> $HOME/.eclipse.defs
  ^msg %edefs @ edefs = [$edefs]
  foreach edef aa {^msg %edefs @ edef[$aa] = [$edef[$aa]]}
  ^assign -aa
  declip Saved definition list
}

EVAL declip defs.ecl [ $devers ] has been loaded successfully
declip Use /DEFS for the list of commands
