# 
# Mail [ vr3 ] Add-On for eclipse.irc v1.02 and greater

@ mecl = [\(:eM:\)]
@ mevers = [vr1]
^set EXEC_PROTECTION off

if ([$mloaded]!=[yes]) {
@ mloaded = [yes]
@ mailfile = [$HOME/.mailbox]
}

alias meclip {^xecho -level crap $mecl $0-}

if (![$evers]) {
  echo !WARNING! You cannot load mail.ecl without eclipse.irc! !WARNING!
  echo !WARNING!  Shutting down to avoid errors and conflicts  !WARNING!
  //QUIT Error: 600 \(Loaded mail.ecl without eclipse.irc\)
}{
  meclip Loading mail.ecl [ $mevers ] on $evermsg\...
  if ([$eclmail]!=[yes]) {
    if ([$ecladd]) {@ ecladd = [$ecladd + Mail]}{@ ecladd = [Mail]}
    ^set CLIENT_INFORMATION ${CLIENT_INFORMATION} + Mail
  }
  @ eclmail = [yes]
  ^set_su
}

alias emhelp {
  echo  ,s-=-----------------------------------------------------------------=-s.
  echo |   -=- Mail Add-On for eclipse.irc v1.02 and greater -=- MAIL HELP -=-   |
  echo ,`-=-------------------------------------------------------------------=-'.
  echo | /READMAIL [<mailfile>]        - Reads mail -> <mailfile>                |
  echo | /SETMAIL <file>               - Sets default mailfile -> <file>         |
  echo | /SENDMAIL <address> <subject> - Sends an email -> <address>             |
  echo  `-----------------------------------------------------------------------'
}

on ^exec "mail *" {
  if ([$match(** $1)]) {
    if ([$justnewmail]==[yes]) {
      @ mails = mails + 1
      @ mailout[$mails] = [yup yup yup]
      @ hlines = 0
      @ lines = 0
      @ mailhead = [yes]
    }
    @ justnewmail = [yes]
  }{
    @ justnewmail = [no]
    if ([$mailhead]==[yes]) {
      if ([$1]==[From:]) {@ mailfrom[$mails] = [$2-]}
      {
        if ([$1]==[Date:]) {@ maildate[$mails] = [$2-]}
        {
          if ([$1]==[To:]) {@ mailto[$mails] = [$2-]}
          {
            if ([$1]==[Subject:]) {@ mailsubject[$mails] = [$2-]}
            {if (![$1]) {@ mailhead = [no]}}
          }
        }
      }
    }{
      @ lines = lines + 1
      @ mailline[$mails][$lines] = [$1-]
    }
  }
}
on ^exec_exit "mail*" {
  foreach mailout aa {
    if (![$mailline[$aa][1]]) {^assign -mailout[$aa]}
  }
  ^assign -aa;^assign -justnewmail
  /SCANMAIL
}
alias readmail {
  @ mails = 0;@ justnewmail = [yes]
  if ([$0]) {@ rmfilenow = [$0]}{@ rmfilenow = [$mailfile]}
  EVAL ^exec -name mail cat $rmfilenow
  meclip Getting mail headers...
}
alias scanmail {
  if ([$mails]>[0]) {
    meclip Your mail is as follows:
    @ mailup = 1
    while ([$mailup]<=[$mails]) {
      @ mailout[$mailup] = [yup yup yup]
      @ mailup = mailup + 1
    }
    ^assign -mailup;@ mailcount = 0
    foreach mailout aa {
      @ mailcount = mailcount + 1
      if ([$mailfrom[$aa]]) {@ mailmsg = [$mailmsg] ## [From: $mailfrom[$aa] - ]}
      if ([$mailsubject[$aa]]) {@ mailmsg = [$mailmsg] ## [Subject: $mailsubject[$aa]]}
      meclip #$[4]aa - $mailmsg
      if ([$match(*0 $mailcount)]==[1]) {pause}
      ^assign -mailmsg
    }
    ^assign -aa;^assign -readmail
    @ readmail = [$"Read which e-mail? \(1-$mailcount\)? "]
    if (([$isnum($readmail)])&&([$readmail]>[0])&&([$readmail]<=[$mails])) {
      meclip Mail #$readmail\:
      if ([$mailfrom[$readmail]]) {echo [$readmail]    From: $mailfrom[$readmail]}
      if ([$mailto[$readmail]]) {echo [$readmail]      To: $mailto[$readmail]}
      if ([$maildate[$readmail]]) {echo [$readmail]    Date: $maildate[$readmail]}
      if ([$mailsubject[$readmail]]) {echo [$readmail] Subject: $mailsubject[$readmail]}
      foreach mailline[$readmail] aa {
        echo $mailline[$readmail][$aa]
        if ([$match(*0 $aa)]==[1]) {pause}
      }
      ^assign -aa
      meclip End of mail #$readmail
    }{
      if ([$readmail]!=[]) {meclip Sorry, mail #$readmail does not exist}
      {meclip Mail reading aborted}
    }
  }{meclip Sorry, your mailbox is empty}
  @ erasemail = [$"Erase ALL of your e-mails now? > (y/N) "]
  if ([$match(y* $erasemail)]==[1]) {EVAL ^exec rm -rf $rmfilenow}
  ^assign -erasemail
  foreach mailfrom aa {^assign -mailfrom[$aa]}
  foreach mailto aa {^assign -mailto[$aa]}
  foreach maildate aa {^assign -maildate[$aa]}
  foreach mailout aa {^assign -mailout[$aa]}
  foreach mailsubject aa {^assign -mailsubject[$aa]}
  ^assign -mailhead
  @ mails = 0
}
alias setmail if ([$0]) {
  meclip Mailfile set to $0
  @ mailfile = [$0]
}{meclip Use: /SETMAIL <file>}
alias sendmail {
  if ([$1]) {
    @ smaddress = [$0]
    @ smsubject = [$1]
    /GOMAIL
  }{meclip Use: /SENDMAIL <address> <subject>}
}
alias gomail {
  meclip Sending mail, enter "/S" on a line to send or "/Q" to abort
  ^assign -newtext
  @ mailline = [1]
  while ([$newtext]!=[/Q]) {
    @ newtext = [$"[Line $mailline][/Q,/S]> "]
    if ([$newtext]!=[/S]) {
      if ([$newtext]!=[/Q]) {
        ^exec echo "$newtext" >> $HOME/.eclipse.smail
        @ mailline = mailline + 1
      }
    }{@ newtext = [/Q];@ smabort = [NO]}
  }
  if ([$smabort]==[no]) {
    meclip Please wait while sending mail...
    ^exec -name smgo mailx -s "$smsubject" $smaddress < $HOME/.eclipse.smail
    ^wait %smgo
    ^exec -name rsmgo rm -rf $HOME/.eclipse.smail
    ^wait %rsmgo
    meclip Mail send complete
  }{meclip Mailing canceled}
  ^assign -newtext;^assign -mailline;^assign -smabort;^assign -smaddress;^assign -smsubject
}

EVAL meclip mail.ecl [ $mevers ] has been loaded successfully
meclip Use /EMHELP for the list of commands
