# 
# Text [ vr10 ] Add-On for eclipse.irc v1.02 and greater

@ tecl = [\(:eT:\)]
@ tevers = [vr6]
^set EXEC_PROTECTION off

alias teclip {^xecho -level crap $tecl $0-}

if (![$evers]) {
  echo !WARNING! You cannot load text.ecl without eclipse.irc! !WARNING!
  echo !WARNING!  Shutting down to avoid errors and conflicts  !WARNING!
  //QUIT Error: 596 \(Loaded text.ecl without eclipse.irc\)
}{
  teclip Loading text.ecl [ $tevers ] on $evermsg\...
  if ([$ecltext]!=[yes]) {
    if ([$ecladd]) {@ ecladd = [$ecladd + Text]}{@ ecladd = [Text]}
    ^set CLIENT_INFORMATION ${CLIENT_INFORMATION} + Text
  }
  @ ecltext = [yes]
  ^set_su
}

alias ethelp {
  echo ,s-=----------------------------------------------------------------------=-s.
  echo |     -=- Text Add-On for eclipse.irc v1.02 and greater -- TEXT HELP -=-     |
  echo ,`-=----------------------------------------------------------------------=-'.
  echo | /STRETCH <location> <text> - Sends stretched <text> -> <location>          |
  echo | /EREET <location> <text>   - Sends 3R33T message -> <location>             |
  echo | /FBOLD <location> <text>   - Sends <text> in on and off bold -> <location> |
  echo | /FLBI <location> <text>    - Sends <text> in inverse/bold -> <location>    |
  echo | /SCREAM <location> <text>  - Screams <text> -> <location>                  |
  echo | /REPSAY <arguments>        - Says <text> repeatedly -> <location>          |
  echo |   -=- Note - Use "/REPSAY" alone for <arguments>                           |
  echo | /ENVIEW <encoded text>     - Decodes text -> <encoded text>                |
  echo | /ENSEND <lctn> <dcdd text> - Encodes and sends text -> <decoded text>      |
  echo | /SCVIEW <scrambled text>   - Unscrambles test -> <scrambled text>          |
  echo | /SCSEND <lctn> <text>      - Sends scrambled text -> <text>                |
  echo | /BACKW <location> <text>   - Sends text backwards -> <text>                |
  echo | /BW <location> <text>      - Big writes <text> -> <location>               |
  echo |   -=- Note - This requires "SYSVBANNER" (I am too lazy to write an alias)  |
  echo |   -=- Note - This will print up to 7 characters, the rest will be cut off  |
  echo  `--------------------------------------------------------------------------'
  echo 
}

alias enview {
  if ([$0]) {teclip Decoded: $decode($0-)}
  {teclip Use: /ENVIEW <encoded text>}
}
alias ensend {
  if ([$1]) {msg $0 Encoded: $encode($1-)}
  {teclip Use: /ENSEND <location> <decoded text>}
}

on ^exec_error "bw *" teclip Sorry, your UNIX system is not equipped with SYSVBANNER
alias bw {^exec -name bw -msg $0 banner "$1-"}

alias backw {
  if ([$1]) {//msg $0 $bwtext($1-)}
  {teclip Use: /BACKW <location> <text>}
}
alias bwtext {
  @ bwtext = [$0-]
  @ bwlen = [$@bwtext]
  @ bwgo = 0
  while ([$bwgo]<[$bwlen]) {
    @ bwout = [$mid($bwgo 1 $bwtext)] ## [$bwout]
    @ bwgo = bwgo + 1
  }
  ^assign -bwtext;^assign -bwlen;^assign -bwgo
  @ FUNCTION_RETURN = [$bwout]
  ^assign -bwout
}

alias stretch {
  if ([$1]) {
    @ strloc = [$0]
    @ strtext = [$1-]
    @ strlen = [$@strtext]
    @ strgo = 0
    while ([$strgo]<[$strlen]) {
      @ strcheck = [$mid($strgo 1 $strtext)]
      if ([$strcheck]==[ ]) {@ strout = [$strout] ## [   ]}
      {
        if ([$strout]) {@ strout = [$strout] ## [ $strcheck]}
        {@ strout = [$strcheck]}
      }
      @ strgo = strgo + 1
    }
    //msg $strloc $strout
    ^assign -strloc;^assign -strtext;^assign -strlen;^assign -strgo
    ^assign -strout
  }{teclip Use: /STRETCH <location> <text>}
}

@ ereet.0.0 = [A]
@ ereet.0 = [4]
@ ereet.1 = [|3]
@ ereet.2 = [<]
@ ereet.3 = [|>]
@ ereet.4 = [3]
@ ereet.5 = [f]
@ ereet.6 = [g]
@ ereet.7 = [|-|]
@ ereet.8 = [1]
@ ereet.9 = [J]
@ ereet.10 = [|<]
@ ereet.11 = [|_]
@ ereet.12 = [/\\/\\]
@ ereet.13 = [|\\|]
@ ereet.14 = [0]
@ ereet.15 = [P]
@ ereet.16 = [q]
@ ereet.17 = [R]
@ ereet.18 = [s]
@ ereet.19 = [T]
@ ereet.20 = [|_|]
@ ereet.21 = [\\/]
@ ereet.22 = [\\|\\|]
@ ereet.23 = [><]
@ ereet.24 = [y]
@ ereet.25 = [Z]
@ ereet.xx = [abcdefghijklmnopqrstuvwxyz]
alias ereet {
  if ([$1]) {
    ^assign -ereetout
    @ ereetloc = [$0]
    @ ereet = [$1-]
    @ ereetlen = [$@ereet]
    @ ereetgo = 0
    while ([$ereetgo]<[$ereetlen]) {
      @ ereetcheck = [$mid($ereetgo 1 $ereet)]
      if ([$ereetcheck]==[ ]) {@ ereetout = [$ereetout] ## [ ]}
      {
        if ([$index($tolower($ereetcheck) $ereet[xx])]>[-1]) {@ ereetout = [$ereetout] ## [$ereet[$index($tolower($ereetcheck) $ereet[xx])]]}
        {@ ereetout = [$ereetout] ## [$ereetcheck]}
      }
      @ ereetgo = ereetgo + 1
    }
    //msg $ereetloc $ereetout
    ^assign -ereetloc;^assign -ereet;^assign -ereetlen;^assign -ereetgo;^assign -ereetout
  }{teclip Use: /EREET <location> <text>}
}

alias fbold {
  if ([$1]) {
    @ fboldloc = [$0]
    @ fboldtxt = [$1-]
    @ fboldlen = [$@fboldtxt]
    @ fboldgo = 0
    while ([$fboldgo]<[$fboldlen]) {
      @ fboldout = [$fboldout] ## [$mid($fboldgo 1 $fboldtxt)] ## []
      @ fboldgo = fboldgo + 1
    }
    //msg $fboldloc $fboldout
  }{teclip Use: /FBOLD <location> <text>}
  ^assign -fboldloc;^assign -fboldtxt;^assign -fboldlen;^assign -fboldgo
  ^assign -fboldout
}
alias flbi {
  if ([$1]) {
    @ flbiloc = [$0]
    @ flbitxt = [$1-]
    @ flbilen = [$@flbitxt]
    @ flbigo = 0
    @ flbilast = [BOLD]
    @ flbiout = []
    while ([$flbigo]<[$flbilen]) {
      if ([$flbilast]==[BOLD]) {
        @ flbiout = [$flbiout] ## [$mid($flbigo 1 $flbitxt)] ## []
        @ flbilast = [INVERSE]
      }{
        @ flbiout = [$flbiout] ## [$mid($flbigo 1 $flbitxt)] ## []
        @ flbilast = [BOLD]
      }
      @ flbigo = flbigo + 1
    }
    //msg $flbiloc $flbiout
  }{teclip Use: /FLBI <location> <text>}
  ^assign -flbiloc;^assign -flbitxt;^assign -flbilen;^assign -flbigo
  ^assign -flbiout
}

^assign screamout !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

alias scream {
  if ([$1]) {
    //MSG $0 $toupper($1-)${screamout}
  }{teclip Use: /SCREAM <location> <text>}
}

alias repsay {
  if ([$2]) {
    if ([$match(*n* $0)]==[1]) {@ repsaytyp = [NOSPACE]}
    {@ repsaytyp = [SPACE]}
    @ repsayloc = [$1]
    @ repsaytms = [$2]
    @ repsayz = [$3-]
    @ repsaygo = 1
    while ([$repsaygo]<=[$repsaytms]) {
      if ([$repsayout]) {
        if ([$repsaytyp]==[SPACE]) {@ repsayout = [$repsayout] ## [ $repsayz]}
        {@ repsayout = [$repsayout] ## [$repsayz]}
      }{@ repsayout = [$repsayz]}
      @ repsaygo = repsaygo + 1
    }
    ^assign -repsaytms;^assign -repsayz;^assign -repsaygo
    //msg $repsayloc $repsayout
    ^assign -repsayloc;^assign -repsayout;^assign -repsaytyp
  }{
    teclip Use: /REPSAY <-[type]> <location> <times> <text>
    teclip <-[type]>'s:
    teclip   -space   = Spaces between repeats
    teclip  -nospace  = No spaces between repeats
  }
}

@ scram.in = [abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890`~!@#\$%^&*\(\)_-+=\{\[\]\}\\|\;:"',<.>/?]
@ scram.out = [\]Fynx`?6G\[1E\}5b~wH8\{fmDI!\\vZ4o/h7J=@dCKupL#B|j9Y\$MtzN+Aa\;3O%>Xlq:P^=gW&iQ"*0s'\(k2V\)Rr,e_SU<cT.]
alias eclscram {
  @ scsin = [$0-]
  @ scslen = [$@scsin]
  @ scsgo = 0
  while ([$scsgo]<[$scslen]) {
    @ scscheck = [$mid($scsgo 1 $scsin)]
    if ([$scscheck]==[ ]) {@ scsout = [$scsout] ## [ ]}
    {
      @ scslook = [$index($scscheck $scram[in])]
      @ scssend = [$mid($scslook 1 $scram[out])]
      @ scsout = [$scsout] ## [$scssend]
    }
    @ scsgo = scsgo + 1
  }
  @ FUNCTION_RETURN = [$scsout]
  ^assign -scsin;^assign -scslen;^assign -scsgo;^assign -scscheck
  ^assign -scslook;^assign -scssend;^assign -scsout
}
alias ecldscram {
  @ dscsin = [$0-]
  @ dscslen = [$@dscsin]
  @ dscsgo = 0
  while ([$dscsgo]<[$dscslen]) {
    @ dscscheck = [$mid($dscsgo 1 $dscsin)]
    if ([$dscscheck]==[ ]) {@ dscsout = [$dscsout] ## [ ]}
    {
      @ dscslook = [$index($dscscheck $scram[out])]
      @ dscssend = [$mid($dscslook 1 $scram[in])]
      @ dscsout = [$dscsout] ## [$dscssend]
    }
    @ dscsgo = dscsgo + 1
  }
  @ FUNCTION_RETURN = [$dscsout]
  ^assign -dscsin;^assign -dscslen;^assign -dscsgo;^assign -dscscheck
  ^assign -dscslook;^assign -dscssend;^assign -dscsout
}
alias scsend {
  if ([$1]) {//msg $0 $eclscram($1-)}
  {teclip Use: /SCSEND <location> <text>}
}
alias scview {
  if ([$0]) {EVAL teclip Unscrambled: $ecldscram($0-)}
  {teclip Use: /SCVIEW <scrambled text>}
}


EVAL teclip text.ecl [ $tevers ] has been loaded successfully
teclip Use /ETHELP for the list of text commands
