# 
# XDCC [ vr2 ] Add-On for eclipse.irc v2.00 and greater

@ xecl = [\[XDCC\]]
@ xevers = [vr1]
^set EXEC_PROTECTION off

alias xeclip {^xecho -level crap $xecl $0-}

if (![$evers]) {
  echo !WARNING! You cannot load xdcc.ecl without eclipse.irc! !WARNING!
  echo !WARNING!  Shutting down to avoid errors and conflicts  !WARNING!
  //QUIT Error: 603 \(Loaded xdcc.ecl without eclipse.irc\)
}{
  xeclip Loading xdcc.ecl [ $xevers ] on $evermsg\...
  if ([$eclxdcc]!=[yes]) {
    if ([$ecladd]) {@ ecladd = [$ecladd + XDCC]}{@ ecladd = [XDCC]}
    ^set CLIENT_INFORMATION ${CLIENT_INFORMATION} + XDCC
  }
  @ eclxdcc = [yes]
  ^set_su
}

if ([$xdccloaded]!=[yes]) {
@ xdccloaded = [yes]
EVAL ^exec -name xdccsave cat >> $HOME/.eclipse.xdcc
@ xdccs = 0
}

EVAL ^load $HOME/.eclipse.xdcc

alias xhelp {
  echo  ,s-=-----------------------------------------------------------------=-s.
  echo |     -=- XDCC Add-On for eclipse.irc v1.02 and greater -- COLORS  -=-    |
  echo ,`-=-------------------------------------------------------------------=-'.
  echo | /XDCC <-a|-d|-l|-o> [<options>]     -=- Executes an XDCC option         |
  echo |  -=-  -a = add a file    --- options = <filename> <location> <comment>  |
  echo |  -=-  -d = delete a file --- options = <filename/#/all>                 |
  echo |  -=-  -l = list files    --- no options                                 |
  echo |  -=-  -o = offer files   --- options = [<nick/channel>]                 |
  echo | /XDCCSAVE                           -=- Saves XDCC list                 |
  echo | /XTOG <on/off>                      -=- Toggles XDCC sending <on/off>   |
  echo  `-----------------------------------------------------------------------'
}

on ^exec "xdccstat *" {
  if ([$isnum($5)]) {
    @ filesize = [$5]
    @ xdccs = xdccs + 1
    @ xdccfile[$xdccs] = [$xdccname $xdccadd $encode($xdccnote) $5 0]
    xeclip XDCC file #$xdccs added as: $xdccname - $xdccnote \(${filesize / 1024}kb\)
    ^assign -xdccadd
  }{
    xeclip Basic "DIR" command failed, attempting back-up command...
    ^exec -name xdccstat2 ls -l $xdccadd
  }
}
on ^exec_error "xdccstat *" {
  xeclip Basic "DIR" command failed, attempting back-up command...
  ^exec -name xdccstat2 ls -l $xdccadd
}
on ^exec "xdccstat2 *" {
  if ([$isnum($5)]) {
    @ filesize = [$5]
    @ xdccs = xdccs + 1
    @ xdccfile[$xdccs] = [$xdccname $xdccadd $encode($xdccnote) $5 0]
    xeclip XDCC file #$xdccs added as: $xdccname - $xdccnote \(${filesize / 1024}kb\)
    ^assign -xdccadd
  }{xeclip Back-up command failed, xdcc.ecl will not work with your system}
  ^assign -xdccadd
}
on ^exec_error "xdccstat2 *" {
  xeclip Back-up command failed, xdcc.ecl will not work with your system
  ^assign -xdccadd
}

alias xdcc {
  if ([$0]) {
    if ([$0]==[-a]) {
      if (![$xdccadd]) {
        if ([$2]) {
          @ xdccname = [$1]
          @ xdccadd = [$2]
          if ([$3]) {@ xdccnote = [$3-]}{@ xdccnote = [<No Comment>]}
          xeclip Attempting to gather XDCC information on $1\...
          EVAL ^exec -name xdccstat dir $2
        }{xeclip Use /XHELP to see the /XDCC command syntax}
      }{xeclip Attempt to add an XDCC file already in progress, please wait...}
    }{
      if ([$0]==[-d]) {
        if ([$xdccs]>[0]) {
          if ([$1]) {
            if ([$1]==[all]) {
              foreach xdccfile aa {^assign -xdccfile[$aa]}
              ^assign -aa
              @ xdccs = 0
              xeclip XDCC file list cleared
            }{
              if ([$isnum($1)]) {
                if ([$xdccs]>=[$1]) {
                  xeclip Removed XDCC file #$1
                  @ xdccdel = [$1]
                  @ xdccdgo = xdccdel + 1
                  ^assign -xdccfile[$xdccdel]
                  while ([$xdccdgo]<=[$xdccs]) {
                    @ xdccfile[${xdccdgo - 1}] = [$xdccfile[$xdccdgo]]
                    @ xdccdgo = xdccdgo + 1
                  }
                  ^assign -xdccdgo;^assign -xdccdel
                  @ xdccs = xdccs - 1
                }{xeclip XDCC file #$1 does not exist}
              }{
                @ xdccstr = [$1]
                foreach xdccfile aa {
                  if ([$word(0 $xdccfile[$aa])]==[$xdccstr]) {^xdcc -d $aa}
                }
                ^assign -aa;^assign -xdccstr
              }
            }
          }{xeclip Use /XHELP to see the /XDCC command syntax}
        }{xeclip XDCC list is empty}
      }{
        if ([$0]==[-l]) {
          if ([$xdccs]>[0]) {
            @ xdcclist = 1
            xeclip XDCC List:
            while ([$xdcclist]<=[$xdccs]) {
              @ xdccsize = [${word(3 $xdccfile[$xdcclist]) / 1024}kb]
              @ xdccgets = [${word(4 $xdccfile[$xdcclist]}x]
              xeclip [$[-3]xdcclist\][$[-8]xdccsize\][$[-4]xdccgets\] $word(0 $xdccfile[$xdcclist]) - $decode($word(2 $xdccfile[$xdcclist]))
              xeclip [Location: $word(1 $xdccfile[$xdcclist])]
              @ xdcclist = xdcclist + 1
            }
            xeclip End of list
            ^assign -xdcclist
          }{xeclip XDCC list is empty}
        }{
          if ([$0]==[-o]) {
            if ([$xdccs]>[0]) {
              if ([$1]) {
                @ xdccto = [$1]
                @ xdccoffer = 1
                if ([$ischannel($xdccto)]==[1]) {//msg $1 [XDCC File Offer] Get File: /MSG $N XGET <#>}
                {^msg $1 [XDCC File Offer] Get File: /MSG $N XGET <#>}
                while ([$xdccoffer]<=[$xdccs]) {
                  @ xdccsize = [${word(3 $xdccfile[$xdccoffer]) / 1024}kb]
                  @ xdccgets = [${word(4 $xdccfile[$xdccoffer]}x]
                  if ([$ischannel($xdccto)]==[1]) {//msg $xdccto [$[-3]xdccoffer\][$[-8]xdccsize\][$[-4]xdccgets\] $word(0 $xdccfile[$xdccoffer]) - $decode($word(2 $xdccfile[$xdccoffer]))}
                  {^msg $xdccto [$[-3]xdccoffer\][$[-8]xdccsize\][$[-4]xdccgets\] $word(0 $xdccfile[$xdccoffer]) - $decode($word(2 $xdccfile[$xdccoffer]))}
                  @ xdccoffer = xdccoffer + 1
                }
                ^assign -xdccoffer;^assign -xdccto
              }{
                if ([$C]) {
                  @ xdccto = [$C]
                  @ xdccoffer = 1
                  //msg $C [XDCC File Offer] Get File: /MSG $N XGET <#>
                  while ([$xdccoffer]<=[$xdccs]) {
                    @ xdccsize = [${word(3 $xdccfile[$xdccoffer]) / 1024}kb]
                    @ xdccgets = [${word(4 $xdccfile[$xdccoffer]}x]
                    //msg $xdccto [$[-3]xdccoffer\][$[-8]xdccsize\][$[-4]xdccgets\] $word(0 $xdccfile[$xdccoffer]) - $decode($word(2 $xdccfile[$xdccoffer]))
                    @ xdccoffer = xdccoffer + 1
                  }
                  ^assign -xdccoffer;^assign -xdccto
                }{xeclip No target for XDCC offer}
              }
            }{xeclip No XDCC files to offer}
          }
        }
      }
    }
  }{xeclip Use /XHELP to see the /XDCC command syntax}
}

alias savexdcc /XDCCSAVE
alias xdccsave {
  ^exec -close %xdccsave
  EVAL ^exec -name delxdcc rm -rf $HOME/.eclipse.xdcc
  wait %delxdcc
  EVAL ^exec -name xdccsave cat >> $HOME/.eclipse.xdcc
  ^msg %xdccsave @ xdccs = [$xdccs]
  foreach xdccfile aa {^msg %xdccsave @ xdccfile[$aa] = [$xdccfile[$aa]]}
  ^assign -aa
  xeclip XDCC file list saved
}
  
EVAL xeclip xdcc.ecl [ $xevers ] has been loaded successfully
xeclip Use /XHELP for the list of XDCC commands
