
#include <janbot.h>
#include <config.h>


/* Function: Prepares a child process, frees up memory. */
void init_child(struct chat_t *user)
{
	struct chat_t *tmp;
	int idx;
	
	parent=user->ipc[1];

#ifdef DEBUG
	signal(SIGTERM,child_signal_handler);
	signal(SIGINT,child_signal_handler);
	signal(SIGSEGV,child_signal_handler);
	signal(SIGBUS,child_signal_handler);
	signal(SIGQUIT,child_signal_handler);
#else
	signal(SIGTERM,SIG_DFL);
	signal(SIGINT,SIG_DFL);
	signal(SIGSEGV,SIG_DFL);
	signal(SIGBUS,SIG_DFL);
	signal(SIGQUIT,SIG_DFL);
#endif /* DEBUG */
	signal(SIGHUP,SIG_IGN);

	/* We ignore the SIGPIPE signal to prevent the process from */
	/* dying when people close DCCs using the /DCC CLOSE command. */
	signal(SIGPIPE,SIG_IGN);


	fcntl(parent,F_SETFL,O_NONBLOCK);

	/* Close some file descriptors. */
	close(user->ipc[0]);
	close(userfd);
	close(sconn.servfd);
	close(logfd);

	free_users(&users);
	while ((tmp=chatlist)!=NULL)
	{
		kill_chat(tmp,&chatlist);
	}

	for (idx=0;idx<p_argc;idx++)
	{
		bzero(p_argv[idx],strlen(p_argv[idx]));
	}	
	sprintf(p_argv[0],"%s%s",cfg.nick,DCC_CHAT_CHILD);

	dcclist=NULL;
}

/* Function: Do whatever the child process needs to do. */
int process_child()
{
	fd_set fdvar;
	struct timeval tval={0,0};
	struct childmsg_t m;
	int idx;

	ENTER0(2,"process_child()\n");
	
	/* Check with our parent. ("Mommy, can I go out and play?") */
	
	FD_ZERO(&fdvar);
	FD_SET(parent,&fdvar);

	if (select(parent+1,&fdvar,(fd_set *)0,(fd_set *)0,&tval))
	{
		/* New input arrived. */
		idx=0;

		if (!read(parent,&m,sizeof(struct childmsg_t)))
		{
			kill_child();
			LEAVE(2);
			return(0);
		}		
		parse_parent_message(m.type,m.msg);
	}
	check_dcc();
	LEAVE(2);
	return(1);
}


void kill_child()
{
	struct dcc_t *tmp;
	struct dccqueue_t *dq;

	/* No connection. ("Mom! Where are you!?") */
	close(parent);
	/* Get rid of dcc's. (Well, not yet.) */

	for (tmp=dcclist;tmp!=NULL;tmp=tmp->next)
	{
		close(tmp->sockfd);
		close(tmp->filefd);
		put_on_deathrow(tmp);
	}
	clear_deathrow();	

	for (dq=dccqueue;dccqueue!=NULL;dq=dccqueue)
	{
		dccqueue=dq->next;
		free(dq);
	}	
			
	/* Commit suicide. */
}

void parse_parent_message(int message,char *msgtext)
{
	ENTER2(1,"parse_parent_message(%d,\"%s\")\n",message,msgtext);
	switch (message)
	{
	case SEND:	if (autodcc&&(dcc_count()<dcclimit)) process_outgoing_file(msgtext,D_SEND);
			else put_on_dccqueue(D_SEND,msgtext);
			DEBUG1("C: %s\n",msgtext);
			break;
	case TAR:	if (autodcc&&(dcc_count()<dcclimit)) process_outgoing_file(msgtext,D_TAR);
			else put_on_dccqueue(D_TAR,msgtext);
			break;
	case GET:	if (autodcc&&(dcc_count()<dcclimit)) process_incoming_file(msgtext);
			else put_on_dccqueue(D_GET,msgtext);
			break;
	case NUM:	sscanf(msgtext,"%d",&dcclimit);
			break;
	case LIST:	show_dcc_list(msgtext);
			break;
	case QLIST:	show_dcc_queue(msgtext);
			break;
	case KILL:	remove_dcc(msgtext);
			break;
	case QKILL:	remove_queued(msgtext);
			break;
	case AUTO:	sscanf(msgtext,"%d %d",&autodcc,&resume);
			break;
	case NEXT:	process_next(msgtext);
			break;
	case RESUME:	process_resume(msgtext);
			break;
#ifdef USE_RATIOS
	case RATIO:	parse_parent_ratio(msgtext);
			break;
#endif
	default:	send_to_parent(ERROR,"This does not compute.");
	}
	LEAVE(1);
}

void send_to_parent(int msg,char *fmt,...)
{
	va_list ap;
	struct childmsg_t m;
	m.type=msg;
	va_start(ap,fmt);
	vsprintf(m.msg,fmt,ap);
	va_end(ap);
	ENTER2(1,"send_to_parent(%d,\"%s\")\n",m.type,m.msg);
	write(parent,&m,sizeof(struct childmsg_t));
	LEAVE(1);
}

#ifdef DEBUG
/* Function: Handle some of the possible signals and print it out. */
void child_signal_handler(int sig)
{
	char *signame;
	signal(SIGTERM,SIG_IGN);
	signal(SIGINT,SIG_IGN);
	signal(SIGSEGV,SIG_IGN);
	signal(SIGBUS,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	
	switch(sig)
	{
	case SIGTERM:
		signame="SIGTERM";
		break;
	case SIGINT:
		signame="SIGINT";
		break;
	case SIGSEGV:
		signame="SIGSEGV";
		break;
	case SIGBUS:
		signame="SIGBUS";
		break;
	case SIGQUIT:
		signame="SIGQUIT";
		break;
	default:
		signame="Unknown";
		break;
	}
	DEBUG2("Chat child (pid %d) signal: %s\n",getpid(),signame);
	exit(0);
}
#endif /* DEBUG */

/* Function: Parses the RATIO info. */
#ifdef USE_RATIOS
void parse_parent_ratio(char *msgtext)
{
	char *cmd,*data;

	if (((cmd=strtok(msgtext," "))==NULL)||((data=strtok(NULL," "))==NULL))
	{
		return;
	}
	if (!strcasecmp(cmd,"RATIO"))
	{
		sscanf(data,"%d",&ratio);
	}
	else if (!strcasecmp(cmd,"UL"))
	{
		sscanf(data,"%llu",&ul);
	}
	else if (!strcasecmp(cmd,"DL"))
	{
		sscanf(data,"%llu",&dl);
	}
	else if (!strcasecmp(cmd,"CRED"))
	{
		sscanf(data,"%llu",&cred);
	}
}
#endif
