#include <config.h>
#include <janbot.h>

struct cfgfunc_t cfgfunc[]={
{ "Nick",		cfg_nick		},
{ "UserInfo",		cfg_userinfo		},
{ "Server",		cfg_server		},
{ "BotHome",		cfg_bothome		},
{ "FileDir",		cfg_filedir		},
{ "UserFile",		cfg_userfile		},
{ "LogFile",		cfg_logfile		},
{ "HelpFile",		cfg_helpfile		},
{ "MotdFile",		cfg_motdfile		},
{ "TarPath",		cfg_tarpath		},
{ "Reconnect",		cfg_reconnect		},
{ "ServerWalking",	cfg_serverwalking	},
{ "Overwrite",		cfg_overwrite		},
{ "TightArsedSecurity",	cfg_tightarsedsecurity	},
{ "PublicAccess",	cfg_publicaccess	},
{ "LogLevel",		cfg_loglevel		},
{ "DCCTimeout",		cfg_dcctimeout		},
{ "ChatTimeout",	cfg_chattimeout		},
{ "PingTimeout",	cfg_pingtimeout		},
{ "DCCLimit",		cfg_dcclimit		},
{ "DCCBlockSize",	cfg_dccblocksize	},
{ "ScheduledWrite",	cfg_scheduledwrite	},
{ "DefaultFlags",	cfg_defaultflags	},
#ifdef USE_RATIOS
{ "DefaultRatio",	cfg_defaultratio	},
#else
{ "DefaultRatio",	NULL			},
#endif /* USE_RATIOS */
{ NULL,			NULL			}
};


/* Function: Initializes the config structure with default values. */
void init_config(char *cfgfile,struct chat_t *u)
{
	static int rehashed=0;

	/* Set up the default values. */

	/* This is a bit kludgy, I think... Oh well. */
	if (!rehashed)
	{
		if (cfgfile!=NULL)
		{
			strcpy(cfg.configfile,cfgfile);
			purify_path(cfg.configfile);
		}
		else
		{
			strcpy(cfg.configfile,gethomepath());
			strcat(cfg.configfile,"/"CONFIGFILE);
		}
	}

#ifdef RECONNECT
	cfg.reconnect=1;
#else
	cfg.reconnect=0;
#endif
#ifdef SERVER_WALKING
	cfg.walking=1;
#else
	cfg.walking=0;
#endif
#ifdef OVERWRITE
	cfg.overwrite=1;
#else
	cfg.overwrite=0;
#endif
	cfg.loglevel=ALL;

#ifdef PUBLIC_ACCESS
	cfg.publicaccess=1;
#else
	cfg.publicaccess=0;
#endif

#ifdef TIGHT_ARSED_SECURITY
	cfg.tightarsedsecurity=1;
#else
	cfg.tightarsedsecurity=0;
#endif

	strcpy(cfg.nick,NICK);
	strcpy(cfg.userinfo,USERINFO);

	if (!rehashed)
	{
		strcpy(cfg.bothome,expand_tilde(BOTHOME));
		strcpy(cfg.filedir,expand_tilde(FILEDIR));
		strcpy(cfg.userfile,expand_tilde(USERFILE));
		strcpy(cfg.logfile,expand_tilde(LOGFILE));
		strcpy(cfg.helpfile,expand_tilde(HELPFILE));
		strcpy(cfg.motdfile,expand_tilde(MOTDFILE));
		purify_path(cfg.bothome);
		purify_path(cfg.filedir);
		purify_path(cfg.userfile);
		purify_path(cfg.logfile);
		purify_path(cfg.helpfile);
		purify_path(cfg.motdfile);
	}
	strcpy(cfg.tarpath,expand_tilde(TARPATH));
	purify_path(cfg.tarpath);
	if (!rehashed)
	{
		cfg.servlist=NULL;
	}
	cfg.dcctimeout=DCC_TIMEOUT;
	cfg.chattimeout=CHAT_TIMEOUT;
	cfg.pingtimeout=PING_TIMEOUT;
	cfg.dcclimit=DCCLIMIT;
	cfg.dccblocksize=DCC_BLOCK_SIZE;
	cfg.scheduledwrite=SCHEDULED_WRITE;
	cfg.defaultflags=DEFAULT_FLAGS;
	cfg.defaultratio=DEFAULT_RATIO;
	if (!read_configfile(u))
	{
		if (u!=NULL)
		{
			tell_user(u,"Unable to open config file! Using default values.\n");
		}
		else
		{
			fprintf(stderr,"Unable to open config file! Using default values.\n");
		}
	}

	if (cfg.servlist==NULL)
	{
		if ((cfg.servlist=(struct server_t *)malloc(sizeof(struct server_t)))==NULL)
		{
			/* This hardly ever happens. */
			fprintf(stderr,"Aigh! Unable to allocate memory! (This is bad.)\n");
			exit(1);
		}
		bzero(cfg.servlist,sizeof(struct server_t));
		strcpy(cfg.servlist->name,SERVER);
		cfg.servlist->port=PORT;
		cfg.servlist->next=NULL;
	}
	rehashed=1;
}


/* Function: Read and interprete the config file. */
int read_configfile(struct chat_t *u)
{
	int cfgfd,linenum=1;
	static int rehashed=0;
	long fsize;
	char *memptr,*end,*p,*q;

	if ((cfgfd=open(cfg.configfile,O_RDONLY))<0)
	{
		return(0);
	}
	fsize=lseek(cfgfd,0,SEEK_END); /* Check the file size */
	lseek(cfgfd,0,SEEK_SET);

	if ((memptr=(char *)malloc(fsize+1))==NULL)
	{
		close(cfgfd);
		return(0);
	}
	end=memptr+fsize;
	read(cfgfd,memptr,fsize);
	close(cfgfd);
	p=q=memptr;
	
	/* Remove those annoying tabs. */
	while (q<end)
	{
		if (*q=='\t') *q=' ';
		q++;	
	}
	
	while (p<end)
	{
		/* Find first non-whitespace character. */
		while (p<end&&*p==' ') p++;

		if (*p=='\n')
		{
			p++;
			linenum++;
		}
		else if (*p=='#')
		{
			while(p<end&&*p!='\n') p++; /* Seek to end of line. */
		}
		else
		{
			q=p;
			while(p<end&&*p!='\n') p++; /* Seek to end of line */
			while(p>q&&(*p==' '||*p=='\n')) p--; /* Seek backwards */
			if (p>q)
			{
				*++p='\0'; /* Mark end of line. */
				p++; /* Point to first character after end of line. */
				if (!parse_config_line(q,rehashed))
				{
					if (u!=NULL)
					{
						tell_user(u,"Config error at line %d: %s\n",linenum,q);
					}
					else
					{
						fprintf(stderr,"Config error at line %d: %s\n",linenum,q);
					}
				}
			}
			linenum++;
		}
	}
	free(memptr);
	rehashed=1;
	return(1);
}

/* Function: Parses a single line from the config file. */
int parse_config_line(char *line,int r)
{
	char buf[100];
	char *c=buf,*d;
	int idx;

	strncpy(buf,line,100);
	while(*c==' ') c++;
	if (*c=='\0') return(0);
	d=c;
	while (*d!=' '&&*d!='\0') d++;
	if (*d=='\0') return(0);
	*d++='\0';
	while(*d==' ') d++;

	for (idx=0;cfgfunc[idx].tag!=NULL&&strcasecmp(c,cfgfunc[idx].tag);idx++);
	if (cfgfunc[idx].tag==NULL) return(0);

	if (cfgfunc[idx].func!=NULL) return(cfgfunc[idx].func(d,r));

	return(1);
}

/* Function: Expands any occurrences of tilde (~) to full path. */
char *expand_tilde(char *in)
{
	static char out[NAME_MAX+1],buf[NAME_MAX+1],*p;
	struct passwd *pw;

	strcpy(buf,in+1);
	if (in[0]!='~')
	{
		strcpy(out,in);
	}
	else if (in[1]=='/')
	{
		if ((pw=getpwuid(getuid()))==NULL)
		{
			strcpy(out,in);
		}
		else
		{
			strcpy(out,pw->pw_dir);
			strcat(out,&in[1]);
		}
	}
	else if (((p=strtok(buf,"/"))==NULL))
	{
		strcpy(out,in);
	}
	else if ((pw=getpwnam(p))==NULL)
	{
		strcpy(out,in);
	}
	else
	{
		strcpy(out,pw->pw_dir);
		strcat(out,strstr(in,"/"));
	}
	return(out);
}

int cfg_nick(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	if (!isvalidnick(x)) return(0);
	strncpy(cfg.nick,x,NICK_LEN);
	return(1);
}

int cfg_userinfo(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	strncpy(cfg.userinfo,d,USERINFO_LEN);
	return(1);
}

int cfg_server(char *d,int r)
{
	int tmp;
	char *c,*e;

	if ((c=strtok(d," "))==NULL) return(0);
	if ((e=strtok(NULL," "))!=NULL)
	{
		tmp=atoi(e);
		if (tmp<1||tmp>65535) return(0);
	}
	else tmp=PORT; /* If no port is given, use the default. */
	add_server(c,tmp);
	return(1);
}

int cfg_bothome(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	if (!r) strncpy(cfg.bothome,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_filedir(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	if (!r) strncpy(cfg.filedir,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_userfile(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	if (!r) strncpy(cfg.userfile,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_logfile(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	if (!r) strncpy(cfg.logfile,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_helpfile(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	if (!r) strncpy(cfg.helpfile,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_motdfile(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	if (!r) strncpy(cfg.motdfile,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_tarpath(char *d,int r)
{
	char *x;

	if ((x=strtok(d," "))==NULL) return(0);
	purify_path(x);
	strncpy(cfg.tarpath,expand_tilde(x),NAME_MAX);
	return(1);
}

int cfg_reconnect(char *d,int r)
{
	if (!strcasecmp(d,"Yes"))
	{
		cfg.reconnect=1;
		return(1);
	}
	else if (!strcasecmp(d,"No"))
	{
		cfg.reconnect=0;
		return(1);
	}
	else return(0);
}

int cfg_serverwalking(char *d,int r)
{
	if (!strcasecmp(d,"Yes"))
	{
		cfg.walking=1;
		return(1);
	}
	else if (!strcasecmp(d,"No"))
	{
		cfg.walking=0;
		return(1);
	}
	else return(0);
}

int cfg_overwrite(char *d,int r)
{
	if (!strcasecmp(d,"Yes"))
	{
		cfg.overwrite=1;
		return(1);
	}
	else if (!strcasecmp(d,"No"))
	{
		cfg.overwrite=0;
		return(1);
	}
	else return(0);
}

int cfg_publicaccess(char *d,int r)
{
	if (!strcasecmp(d,"Yes"))
	{
		cfg.publicaccess=1;
		return(1);
	}
	else if (!strcasecmp(d,"No"))
	{
		cfg.publicaccess=0;
		return(1);
	}
	else return(0);
}

int cfg_tightarsedsecurity(char *d,int r)
{
	if (!strcasecmp(d,"Yes"))
	{
		cfg.tightarsedsecurity=1;
		return(1);
	}
	else if (!strcasecmp(d,"No"))
	{
		cfg.tightarsedsecurity=0;
		return(1);
	}
	else return(0);
}

int cfg_loglevel(char *d,int r)
{
	unsigned long tmp2=0;
	char *c=d;

	while((d=strtok(c," "))!=NULL)
	{
		c=NULL;
		if (!strcasecmp(d,"ALL"))        tmp2  = ALL;
		else if (!strcasecmp(d,"NONE"))  tmp2  = NONE;
		else if (!strcasecmp(d,"CMD"))   tmp2 |= CMD;
		else if (!strcasecmp(d,"SERV"))  tmp2 |= SERV;
		else if (!strcasecmp(d,"DCC"))   tmp2 |= DCC;
		else if (!strcasecmp(d,"CTCP"))  tmp2 |= CTCP;
		else if (!strcasecmp(d,"SIG"))	 tmp2 |= SIG;
		else if (!strcasecmp(d,"MSG"))	 tmp2 |= MSG;
		else if (!strcasecmp(d,"CRAP"))	 tmp2 |= CRAP;
		else if (!strcasecmp(d,"-CMD"))  tmp2 &= ~CMD;
		else if (!strcasecmp(d,"-SERV")) tmp2 &= ~SERV;
		else if (!strcasecmp(d,"-DCC"))  tmp2 &= ~DCC;
		else if (!strcasecmp(d,"-CTCP")) tmp2 &= ~CTCP;
		else if (!strcasecmp(d,"-SIG"))  tmp2 &= ~SIG;
		else if (!strcasecmp(d,"-MSG"))  tmp2 &= ~MSG;
		else if (!strcasecmp(d,"-CRAP")) tmp2 &= ~CRAP;
		else return(0);
	}
	cfg.loglevel=tmp2;
	return(1);
}

int cfg_dcctimeout(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.dcctimeout=tmp*60;
	return(1);
}

int cfg_chattimeout(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.chattimeout=tmp*60;
	return(1);
}

int cfg_pingtimeout(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.pingtimeout=tmp;
	return(1);
}

int cfg_dcclimit(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.dcclimit=dcclimit=tmp;
	return(1);
}

int cfg_dccblocksize(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.dccblocksize=tmp<BIG_BUFFER_SIZE?BIG_BUFFER_SIZE:tmp;
	return(1);
}

int cfg_scheduledwrite(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.scheduledwrite=tmp;
	return(1);
}

int cfg_defaultflags(char *d,int r)
{
	int tmp2=0;
	char *c=d;

	while((d=strtok(c," "))!=NULL)
	{
		c=NULL;
		if (!strcasecmp(d,"ALL"))        tmp2  = F_ALL;
		else if (!strcasecmp(d,"NONE"))  tmp2  = F_NONE;
		else if (!strcasecmp(d,"AUTO"))   tmp2 |= F_AUTO;
		else if (!strcasecmp(d,"SORT"))  tmp2 |= F_SORT;
		else if (!strcasecmp(d,"MOTD"))   tmp2 |= F_MOTD;
		else if (!strcasecmp(d,"RSUM"))  tmp2 |= F_RSUM;
		else if (!strcasecmp(d,"TAR"))	 tmp2 |= F_TAR;
		else if (!strcasecmp(d,"-AUTO"))  tmp2 &= ~F_AUTO;
		else if (!strcasecmp(d,"-SORT")) tmp2 &= ~F_SORT;
		else if (!strcasecmp(d,"-MOTD"))  tmp2 &= ~F_MOTD;
		else if (!strcasecmp(d,"-RSUM")) tmp2 &= ~F_RSUM;
		else if (!strcasecmp(d,"-TAR"))  tmp2 &= ~F_TAR;
		else return(0);
	}
	cfg.defaultflags=tmp2;
	return(1);
}

#ifdef USE_RATIOS
int cfg_defaultratio(char *d,int r)
{
	int tmp;

	if ((tmp=atoi(d))<0)
	{
		return(0);
	}
	cfg.defaultratio=tmp;
	return(1);
}
#endif /* USE_RATIOS */

