
/********************************************************
*                                                       *
*   General configuration file for JanBot.              *
*                                                       *
*   You should know what you're doing before changing   *
*   these values. I know what I'm doing ;)              *
*                                                       *
********************************************************/

/*
 * If you enable/disable USE_RATIOS, be sure to run 'make clean'
 * before running 'make', or you'll get errors while recompiling.
 */

/* Undefine this if you do not want your bot to use the ratio system. */
#undef USE_RATIOS

/* Some initial values. Most of these can be overridden in the config file. */

/* There's not really much point in undefining these... */
#define RECONNECT
#define SERVER_WALKING
#define OVERWRITE

/* The standard nick for this bot. */
#define NICK "JanBot"
/* The userinfo for the bot. */
#define USERINFO "/CTCP JanBot HELP"
/* The default server and port. If any servers are found */
/* in the config file, this server will be skipped. */
#define SERVER "irc.pasta.no"
#define PORT 6667

/* Bot homedir and filedir. These must be absolute paths. */
#define BOTHOME "/home/janbot"
#define FILEDIR "/home/janbot/files"

/* Some filenames */
#define USERFILE "janbot.usr"
#define LOGFILE "janbot.log"
#define HELPFILE "janbot.hlp"
#define MOTDFILE "janbot.msg"

/* Absolute path to the tar binary. */
#define TARPATH "/bin/tar"

/* CHANGES BELOW THIS LINE WILL VOID WARRANTY! */

/* The name of the defalt config file. It must */
/* be located in the users $HOME directory. */
#define CONFIGFILE ".janbotrc"

/* Some sizes, should not be changed unless you know what you're doing. */
#define NICK_LEN 9
#define USERHOST_LEN 50
#define USERDIR_LEN 50
#define SERVER_LEN 40
#define USERINFO_LEN 30
/* How many seconds should the bot offer a DCC CHAT/SEND before closing it? */
#define DCC_TIMEOUT 60*2 /* Currently 2 minutes */
/* How many seconds can a user be idle with 0 DCCs before closing the chat? */
#define CHAT_TIMEOUT 60*15 /* Currently 15 minutes */
/* How many seconds should we allow the server to be idle until we switch? */
#define PING_TIMEOUT 60*3 /* Currently 3 minutes */
/* Default DCC limit for each user. Can be changed at run time. */
#define DCCLIMIT 5
/* Default time (in seconds) between every time the userfile is written. */
#define SCHEDULED_WRITE 600
/* Default flags for new users. */
#define DEFAULT_FLAGS F_AUTO|F_SORT|F_MOTD|F_RSUM
/* Default Upload/Download ratio. */
#define DEFAULT_RATIO 5
/* Define if you want the bot to be publically accessible by default. */
#undef PUBLIC_ACCESS

/* This is not ready yet.
#ifdef USE_RATIOS
# define R_TEST
#else
# define R_TEST (!(0x0010&lvl))
#endif
*/ 
