#include <config.h>
#include <janbot.h>
#include <fcntl.h>


/* Function: Runs the show. */
void main(int argc,char **argv)
{
	int idx,manual_useradd=0;
#ifdef _BSD_
	int ttyfd;
#endif
	char *cfgfile=NULL;

	/* Others might want to use this. */
	p_argc=argc;
	p_argv=argv;

	/* Seed the random generator. The PID is likely not to be the same */
	/* twice, so it's fairly safe to do this. It doesn't really matter. */
	srand((int)getpid());

	/* Let's find our own ip, might get handy for DCC... */
	gethostname(hostname,sizeof(hostname));	
	if ((local_hp = gethostbyname(hostname)) != NULL)
	{
		bcopy(local_hp->h_addr,(char *)&hostaddr,sizeof(hostaddr));
		/* Okay, store ip in network order, to save time. */
		local_ip=htonl(hostaddr.s_addr);
	}

	/* Let's parse the command line. */
	for (idx=1;idx<argc;idx++)
	{
		if ((argv[idx][0]=='-')&&(strlen(argv[idx])==2))
		{
			switch (argv[idx][1])
			{
#ifdef DEBUG
			case 'd':	background=0;
					traceflag++;
					break;
#endif
			case 'l':	if (argv[++idx]!=NULL)
					{
						cfgfile=expand_tilde(argv[idx]);
					}
					else
					{
						show_cli_help();
						exit(1);
					}
					break;
			case 'm':	manual_useradd=1;
					break;
			default:	show_cli_help();
					exit(1);
			}
		}
	}

	init_config(cfgfile,NULL);

	/* Let's switch to our home directory... */
	if (chdir(cfg.bothome)==-1)
	{
		fprintf(stderr,"Unable to switch home directory!\n");
		exit(1);
	}

	umask(0); /* This allows us to create files with any permissions. */

	if (!initusers())
	{
		fprintf(stderr,"Unable to open user database. Try parameter -m.\n");
		exit(1);
	}

	if ((logfd=open(cfg.logfile,O_WRONLY|O_APPEND|O_CREAT,0600))<0)
	{
		fprintf(stderr,"Unable to open logfile: %s\n",cfg.logfile);
		exit(1);
	}
	log(ALL,"*** LOG STARTED ***");

	if (manual_useradd)
	{
		enter_new_user();
		free_users(&users);
		exit(0);
	}

	for (idx=0;idx<argc;idx++)
	{
		bzero(argv[idx],strlen(argv[idx]));
	}	
	strcpy(argv[0],cfg.nick);

	read_users(&users);

	/* Set up some signal handling. */
	signal(SIGTERM,signal_handler);
	signal(SIGINT,signal_handler);
	signal(SIGSEGV,signal_handler);
	signal(SIGBUS,signal_handler);
	signal(SIGQUIT,signal_handler);
	signal(SIGHUP,sighup_handler);
	signal(SIGPIPE,SIG_IGN);
#ifdef SIGTTOU
	signal(SIGTTOU,SIG_IGN);
#endif
#ifdef SIGTTIN
	signal(SIGTTIN,SIG_IGN);
#endif
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif

	/* If not debug mode, fork to background. */
	if (background&&fork()!=0)
	{
		close(userfd);
		free_users(&users);
		exit(0);
	}
	else
	{
#ifdef _BSD_
		setpgrp(0,getpid());
		if ((ttyfd=open("/dev/tty",O_RDWR))>=0)
		{
			ioctl(ttyfd,TIOCNOTTY,(char *)0);
			close(ttyfd);
		}
#else
		setpgrp();
#endif
	}


	/* We're up. */
	bot_uptime=time(NULL);

	/* The main loop. */
	do
	{
		while(!server_connect(next_server()));
		server_init();
	}
	while (do_bot_things());

	close(sconn.servfd);
	close(userfd);
	close(logfd);
	free_users(&users);
}

int do_bot_things()
{
	char buf[MSG_LEN+1];
	while (read_server_line(buf)>-1)
	{
		if (strlen(buf)>0) parse_server_line(buf);

		if (cfg.pingtimeout&&(sconn.lastrecv+cfg.pingtimeout)<time(NULL))
		{
			log(SERV,"Nothing received from server in %d seconds; switching server.",cfg.pingtimeout);
			DEBUG0("Ping timeout.\n");
			close(sconn.servfd);
		}

		/* Active PING is maybe not too smart, but it works. */
		if ((sconn.lastping+cfg.pingtimeout/2)<time(NULL))
		{
			send_to_server("PING :%s\n",cfg.nick);
			time(&sconn.lastping);
		}

		check_chat(&chatlist);

		write_scheduled(&users);

		ms_delay(10); 	/* This will keep the bot from surfing */
				/* on the top cpu usage list... =) */
	}
	return(cfg.reconnect);
}


void show_cli_help()
{
	fprintf(stderr,"Usage: %s [options]\n\n",*p_argv);
#ifdef DEBUG
	fprintf(stderr,"   -d               Run in debug mode.\n");
#endif
	fprintf(stderr,"   -l <configfile>  Use another config file.\n");
	fprintf(stderr,"   -m               Manually add a new user.\n");
}

/* Function: Handle some of the possible signals, and inform the users. */
void signal_handler(int sig)
{
	struct chat_t *tmp;
	char buf[MSG_LEN+1];

	signal(SIGTERM,SIG_IGN);
	signal(SIGINT,SIG_IGN);
	signal(SIGSEGV,SIG_IGN);
	signal(SIGBUS,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	
	switch(sig)
	{
	case SIGTERM:
		sprintf(buf,"I have been brutally SIGTERM'ed. Terminating connection.\n");
		log(ALL,"Exiting on signal: SIGTERM");
		break;
	case SIGINT:
		sprintf(buf,"I have been brutally SIGINT'ed. Terminating connection.\n");
		log(ALL,"Exiting on signal: SIGINT");
		DEBUG0("Caught SIGINT. Please wait while shutting down.\n");
		break;
	case SIGSEGV:
		sprintf(buf,"I seem to have caused a SIGSEGV. Terminating connection.\n");
		log(ALL,"Exiting on signal: SIGSEGV");
		break;
	case SIGBUS:
		sprintf(buf,"I seem to have encountered a SIGBUS. Terminating connection.\n");
		log(ALL,"Exiting on signal: SIGBUS");
		break;
	case SIGQUIT:
		sprintf(buf,"I have been brutally SIGQUIT'ed. Terminating connection.\n");
		log(ALL,"Exiting on signal: SIGQUIT");
		break;
	default:
		sprintf(buf,"Caught an unknown signal. Terminating connection.\n");
		log(ALL,"Exiting on unknown signal.");
		break;
	}
	/* write_users(&users); This does more harm than good. */
	
	for (tmp=chatlist;tmp!=NULL;tmp=tmp->next)
	{
		write(tmp->sockfd,buf,strlen(buf));
	}
	log(ALL,"***  LOG ENDED  ***");
	exit(0);
}

/* Function: Handles the SIGHUP signal and rehashes the config file. */
void sighup_handler(int sig)
{
	signal(SIGHUP,SIG_IGN);
	log(SIG,"Caught signal SIGHUP, rehashing config file.");
	init_config(NULL,NULL);
	signal(SIGHUP,sighup_handler);
}	
