
#include <config.h>
#include <janbot.h>


/* Function: waits for a given number of milliseconds, then returns. */
void ms_delay(int msec)
{
	struct timeval tval={0,(long)(msec*1000)};
	select(0,(fd_set *)0,(fd_set *)0,(fd_set *)0,&tval);
}

/* Function: Returns nickname from nick!user@host id string. */
char *getnick(char *origin)
{
	static char thenick[NICK_LEN+1];
	char *tmp,*tmp2;
	for (tmp=origin,tmp2=thenick;*tmp!='!';tmp++) *(tmp2++)=*tmp;
	*tmp2='\0';
	return(thenick);
}

/* Function: Returns user@host from nick!user@host id string */
char *getuserhost(char *origin)
{
	static char theuserhost[USERHOST_LEN+1];
	char *tmp;
	for (tmp=origin;*tmp!='!';tmp++);
	strcpy(theuserhost,++tmp);
	return(theuserhost);
}

/* Function: Returns a pointer to a funny comment. :) */
char *toolow()
{
	int index;
	for (index=0;toolowlist[index]!=NULL;index++);
	return(toolowlist[rand()%index]);
}

/* Function: Returns the base filename of a path. */
char *base_name(char *path)
{
	static char base[256];
	char *tmp;
	if ((tmp=strrchr(path,'/'))!=NULL)
	{
		strcpy(base,tmp+1);
	}
	else
	{
		strcpy(base,path);
	}	
	return(base);
}


/* Function: Converts a mode_t to a string representation. Still broken. */
char *mode2str(unsigned int md)
{
	static char str[11];

	str[0]='-';	
	str[1]=(md & S_IRUSR) ? 'r' : '-';
	str[2]=(md & S_IWUSR) ? 'w' : '-';
	str[3]=(md & S_IXUSR) ? 'x' : '-';
	str[4]=(md & S_IRGRP) ? 'r' : '-';
	str[5]=(md & S_IWGRP) ? 'w' : '-';
	str[6]=(md & S_IXGRP) ? 'x' : '-';
	str[7]=(md & S_IROTH) ? 'r' : '-';
	str[8]=(md & S_IWOTH) ? 'w' : '-';
	str[9]=(md & S_IXOTH) ? 'x' : '-';
	str[10]='\0';

	str[3]=(md & S_ISUID) ? 'S' : str[3];
	str[6]=(md & S_ISGID) ? 'S' : str[6];
	str[9]=(md & S_ISUID) ? 'T' : str[9];

	if (md & S_IFLNK) *str='l';
	if (md & S_IFREG) *str='-';
	if (md & S_IFDIR) *str='d';

/* Actually, we don't care about these, they are device dependant. */
/*
	if (md & S_IFCHR) *str='c';
	if (md & S_IFBLK) *str='b';
	if (md & S_IFIFO) *str='f';
	if (md & S_IFSOCK) *str='s';
*/	

	return(str);
}



/* Function: Creates or erases a sorted list of files in a directory. */
struct dirlist_t *create_dirlist(DIR *thedir)
{
	struct dirent *entry;
	static struct dirlist_t *dlist;
	struct dirlist_t *p,*tmp;

	/* If the argument is NULL, let's delete the list. */
	
	if (thedir==NULL)
	{
		for (p=dlist;p!=NULL;p=dlist)
		{
			dlist=p->next;
			free(p);
		}
	}
	else
	while ((entry=readdir(thedir))!=NULL)
	{
		if ((*entry->d_name)!='.')
		{
			if ((tmp=(struct dirlist_t *)malloc(sizeof(struct dirlist_t)))==NULL)
			{
				break;
			}
			bzero(tmp,sizeof(struct dirlist_t));
			strcpy(tmp->name,entry->d_name);
			
			if (dlist==NULL)
			{
				tmp->next=NULL;
				dlist=tmp;
			}
			else
			if (dlist->next==NULL)
			{
				if (strcmp(tmp->name,dlist->name)<0)
				{
					tmp->next=dlist;
					dlist=tmp;
				}
				else
				{
					tmp->next=NULL;
					dlist->next=tmp;
				}
			}
			else if (strcmp(tmp->name,dlist->name)<0)
			{
				tmp->next=dlist;
				dlist=tmp;
			}
			else
			{
				for (p=dlist;(p->next!=NULL)&&(strcmp(tmp->name,p->next->name)>0);p=p->next);
				tmp->next=p->next;
				p->next=tmp;
			}
		}
	}
	return(dlist);
}

/* Function: Generate a recursed listing of a directory. */
struct file_t *create_reclist(char *dir)
{
	DIR *d;
	struct dirent *e;
	struct file_t *p=NULL,*q=NULL,*r;
	struct list_t *s=NULL,*t;
	struct stat st;
	char name[NAME_MAX+1];

	if (!stat(dir,&st)&&st.st_mode&S_IFREG)
	{
		if ((q=(struct file_t *)malloc(sizeof(struct file_t)))!=NULL)
		{
			q->date=st.st_mtime;
			q->size=st.st_size;
			strcpy(q->name,name);
			q->next=NULL;
		}
		return(q);
	}			
	if ((d=opendir(dir))==NULL)
	{
		return(NULL);
	}
	readdir(d); /* Get rid of ".." */
	readdir(d); /* ...and "." */
	while ((e=readdir(d))!=NULL)
	{
		if ((t=(struct list_t *)mymalloc(sizeof(struct list_t)))!=NULL)
		{
			strcpy(t->str,e->d_name);
			if (s==NULL)
			{
				t->next=NULL;
			}
			else
			{
				t->next=s;
			}
			s=t;
		}
		DEBUG0("Check 3\n");
	}
	closedir(d);
	for (t=s;t!=NULL;s=t,t=t->next,free(s))
	{
		sprintf(name,"%s/%s",dir,t->str);
		if (!stat(name,&st)&&st.st_mode&S_IFDIR&&(r=create_reclist(name))!=NULL)
		{
			if (p==NULL)
			{
				p=r;
			}
			else
			{
				for (q=p;q->next!=NULL;q=q->next);
				q->next=r;
			}
		}
		else if ((q=(struct file_t *)malloc(sizeof(struct file_t)))!=NULL)
		{
			q->date=st.st_mtime;
			q->size=st.st_size;
			strcpy(q->name,name);
			q->next=NULL;
			if (p==NULL)
			{
				p=q;
			}
			else
			{
				for (r=p;r->next!=NULL;r=r->next);
				r->next=q;
			}
		}
	}
	return(p);
}


/* Function: Converts a time_t to a string representation. */
char *convert_date(time_t t)
{
	static char date[18];
	struct tm *ltm;
	char *months[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	
	if ((ltm=localtime(&t))==NULL)
	{
		strcpy(date,"??? ?? ???? ??:??");
	}
	else
	{
		sprintf(date,"%s %2d %4d %.2d:%.2d",months[ltm->tm_mon],ltm->tm_mday,1900+ltm->tm_year,ltm->tm_hour,ltm->tm_min);
	}
	return(date);
}


/* Function: Converts idletime into hours:minutes:seconds */
char *convert_idle(time_t t)
{
	static char idle[12];
	sprintf(idle,"%.2u:%.2u:%.2u",(unsigned int)t/3600,(unsigned int)(t/60)%60,(unsigned int)t%60);
	return(idle);
}

/* Function: Converts uptime into a suitable format */
char *convert_uptime(time_t t)
{
	static char upt[20];
	if (t/3600/24)
	{
		sprintf(upt,"%ud %uh %um",(unsigned int)t/3600/24,(unsigned int)(t/3600)%24,(unsigned int)(t/60)%60);
	}
	else if (t/3600)
	{
		sprintf(upt,"%uh %um",((unsigned int)t/3600)%24,(unsigned int)(t/60)%60);
	}
	else
	{
		sprintf(upt,"%um",(unsigned int)(t/60)%60);
	}
	return(upt);
}


/* Function: Verifies the existance of a directory */
int check_dir(char *dirname)
{
	char newdir[256];
	DIR *thedir;
	
	strcpy(newdir,cfg.filedir);
	strcat(newdir,dirname);
	
	if ((thedir=opendir(newdir))!=NULL)
	{
		closedir(thedir);
		return(0);
	}
	else
	{
		return(1);
	}
}


/* Function: Creates a suitable hostmask from a hostname or ip. */
char *create_hostmask(char *h)
{
	static char mask[USERHOST_LEN+1];
	int c=0,v;
	char *t[10]; /* This is hopefully enough. */
	
	do
	{
		if (c==0)
		{
			t[c]=strtok(h,".");
		}
		else
		{
			t[c]=strtok(NULL,".");
		}
	}
	while (t[c++]!=NULL);
	c--;	

	if (c==4) /* This could be an ip address. */
	{
		if ((sscanf(t[0],"%d",&v)!=0)&&(sscanf(t[1],"%d",&v)!=0)&&(sscanf(t[2],"%d",&v)!=0)&&(sscanf(t[3],"%d",&v)!=0))
		{
			/* It is an ip address. */
			sprintf(mask,"%s.%s.%s.*",t[0],t[1],t[2]);
			return(mask);
		}
	}
	if (c==2) /* We won't mask a 2 segment hostname. */
	{
		sprintf(mask,"%s.%s",t[0],t[1]);
		return(mask);
	}
	if (c==1) /* We definitely won't mask a 1 segment hostname. */
	{
		strcat(mask,t[0]);
		return(mask);
	}
	strcpy(mask,"*");
	for (v=1;v<c;v++)
	{
		strcat(mask,".");
		strcat(mask,t[v]);
	}
	return(mask);
}

/* Function: Displays help about a certain command. */
void showhelp(struct chat_t *usr,char *topic)
{
	int helpfd,idx,lvl;
	char helpfile[256],helpline[100],*top,*lvlstr;
	
	strcpy(helpfile,cfg.bothome);
	strcat(helpfile,"/");
	strcat(helpfile,cfg.helpfile);
	
	if ((helpfd=open(helpfile,O_RDONLY))==-1)
	{
		tell_user(usr,"Unable to open help file!\n");
		return;
	}

	idx=0;
	while(read_line(helpfd,helpline))
	{
		if (strlen(helpline)!=0)
		{
			top=strtok(helpline,":");
			lvlstr=strtok(NULL,"|");
			sscanf(lvlstr,"%d",&lvl);
			if ((strcasecmp(topic,top)==0)&&((1<<usr->chatter->level)&lvl))
			{
				tell_user(usr,"%s\n",strtok(NULL,"|"));
			}
		}
	}
	close(helpfd);
}


/* Function: Reads one line from a file. */
int read_line(int ffd,char *buffer)
{
        int duh=0;
	
        while (read(ffd,&buffer[duh],1)>0)
        {
                if (buffer[duh]=='\n')
                {
                        buffer[duh]='\0';
                        return(++duh);
                }
                duh++;
        }
        return(duh);
}



/* Function: Writes something to the logfile. */
void log(unsigned long logflag,char *fmt,...)
{
	va_list ap;
	char buf[MSG_LEN+1];
	struct tm *ltm;
	char *months[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	time_t t;
	
	if (logflag&cfg.loglevel)
	{
		time(&t);
		if ((ltm=localtime(&t))==NULL)
		{
			sprintf(buf,"[??? ?? ??:??] ");
		}
		else
		{
			sprintf(buf,"[%s %2d %.2d:%.2d:%.2d] ",months[ltm->tm_mon],ltm->tm_mday,ltm->tm_hour,ltm->tm_min,ltm->tm_sec);
		}
		write(logfd,buf,strlen(buf));
		va_start(ap,fmt);
		vsprintf(buf,fmt,ap);
		strcat(buf,"\n");
		va_end(ap);
		write(logfd,buf,strlen(buf));
	}	
}

/* Function: Returns a legal port number. */
unsigned int next_port()
{
	static unsigned int port;
	while (port++<1024);
	return(port);
}

/* Function: Compares two directory entries by date and if required, name. */
int dirlist_compare(void *void1,void *void2)
{
	struct dirlist_t **ent1,**ent2;
	ent1=(struct dirlist_t **)void1;
	ent2=(struct dirlist_t **)void2;
	if ((*ent1)->sbuf.st_mtime<(*ent2)->sbuf.st_mtime ||
	   ((*ent1)->sbuf.st_mtime==(*ent2)->sbuf.st_mtime &&
	    strcmp((*ent1)->name,(*ent2)->name)>0)) return(1);	
	else return(-1);
}

/* Function: Calculates the storage size of a tar archive. */
unsigned long calculate_tarsize(char *dir)
{
	DIR *current;
	struct dirent *ent;
	struct stat sb;
	char newname[NAME_MAX+1];
	unsigned long total=512; /* 512 bytes for the current directory. */

	if ((current=opendir(dir))==NULL)
	{
		return(0);
	}

	while((ent=readdir(current))!=NULL)
	{
		if (strcmp(ent->d_name,".")&&strcmp(ent->d_name,".."))
		{
			sprintf(newname,"%s/%s",dir,ent->d_name);
			stat(newname,&sb); /* If it's broken, fuck it. */
			if (sb.st_mode&S_IFDIR)
			{
				total+=calculate_tarsize(newname);
			}
			else
			{
				total+=((unsigned long)sb.st_size)+(unsigned long)((sb.st_size%512)?(1024-(sb.st_size%512)):512);
			}
		}
	}
	closedir(current);
	return(total);
}

#ifdef USE_REGEX
/* Function: Checks a string for a match with the given expression.*/
int regex_match(char *expr,char *str)
{

	regex_t p;
	if (regcomp(&p,expr,REG_EXTENDED|REG_NOSUB))
	{
		return(0);
	}

	if (regexec(&p,str,0,(regmatch_t *)0,0))
	{
		return(0);
	}
	else
	{
		return(1);
	}

}
#endif

/* Function: Returns the full path to the user's home directory. */
char *gethomepath()
{
	static char home[NAME_MAX+1];
	char *p;
	struct passwd *pw;
	
	if ((p=getenv("HOME"))!=NULL)
	{
		strcpy(home,p);
	}
	else if ((pw=getpwuid(getuid()))!=NULL)
	{
		strcpy(home,pw->pw_dir);
	}
	else
	{
		strcpy(home,"");
	}
	return(home);
}

/* Function: Determines the validity of a nick. */
int isvalidnick(char *n)
{
	int i;
	for (i=0;i<strlen(n);i++)
	{
		if (	(n[i]<'A' || n[i]>'}') &&
			(n[i]<'0' || n[i]>'9') &&
			n[i]!='_' && n[i]!='-') return(0);
	}
	return(1);
}

/* Function: Checks a single file descriptor for incoming data. */
int readytoread(int fd)
{
	fd_set set;
	struct timeval t={0,0};

	FD_ZERO(&set);
	FD_SET(fd,&set);
	if (select(fd+1,&set,(fd_set *)0,(fd_set *)0,&t)<1) return(0);
	return(1);
}

/* Function: Removes redundant slashes in path strings. */
void purify_path(char *path)
{
	char tmp[NAME_MAX+1],*t,*u;

	if (!strcmp(path,"/")) return;
	t=path;
	*tmp='\0';
	while ((u=strtok(t,"/"))!=NULL)
	{
		strcat(tmp,"/");
		strcat(tmp,u);
		t=NULL;
	}
	t=tmp;
	if (*path!='/') t++;
	strcpy(path,t);
}

/* Function: Allocates the requested amount of memory. */
void *mymalloc(size_t size)
{
	void *r;
	r=malloc(size);
	return(r);
}

/* These functions are merely present for debugging purposes. */
#ifdef DEBUG
void new_function_level()
{
	int space;
	for (space=0;space<(function_level*2);space++)
	{
		printf(" ");
	}
	printf("-> ");
	function_level++;
}

void old_function_level()
{
	int space;
	function_level--;
	for (space=0;space<(function_level*2);space++)
	{
		printf(" ");
	}
	printf("<-\n");
}
#endif
