//   $Id: kvi_bandlg.h,v 1.2 1998/09/20 20:22:06 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_BANDLG_H_INCLUDED_
#define _KVI_BANDLG_H_INCLUDED_

#include "kvi_types.h"

#include <ktablistbox.h>
#include <kseparator.h>

#include <qdialog.h>
#include <qlist.h>

class KviChanWnd;
class KviFrame;

class KviBanDialog:public QDialog{
	Q_OBJECT
public:
	KviBanDialog(KviChanWnd *lpWnd,KviFrame *lpFrame);
	~KviBanDialog();
public:
	KviFrame	*m_lpFrm;
	KviChanWnd	*m_lpChan;
	KTabListBox *m_lpBox;
	KSeparator  *m_lpSep;
	QList<KviBanEntry> *m_lpTempList;
	QList<KviBanEntry> *m_lpUnbanList;

	QPushButton *m_lpOk;
	QPushButton *m_lpCancel;
	QPushButton *m_lpUnban;
	QPushButton *m_lpUnbanAll;

protected:
	virtual void resizeEvent(QResizeEvent *e);
protected slots:
	void doChanges();
	void slotUnban();
	void slotUnbanAll();
};

#endif //_KVI_BANDLG_H_INCLUDED_
