//   $Id: kvi_chan.h,v 1.2 1998/09/20 20:22:10 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_CHAN_H_INCLUDED_
#define _KVI_CHAN_H_INCLUDED_

#include "kvi_types.h"
#include "kvi_child.h"
#include "kvi_nick.h"

#include <knewpanner.h>

#include <qdatetime.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlist.h>

class KviInput;
class KviListBox;

class KviTopicLabel : public QLabel{
	Q_OBJECT
public:
	KviTopicLabel(const char *text,QWidget *parent);
	~KviTopicLabel();
protected:
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
signals:
	void doubleClicked();
};

class KviTopicLineEdit : public QLineEdit{
	Q_OBJECT
public:
	KviTopicLineEdit(QWidget *parent);
	~KviTopicLineEdit();
protected:
	virtual void focusOutEvent(QFocusEvent *e);
signals:
	void lostFocus();
};

class KviPushButton : public QPushButton{
	Q_OBJECT
public:
	KviPushButton(const char *text,QWidget *parent);
	~KviPushButton();
public:
	virtual void drawButton(QPainter *paint);
};

class KviModeLabel:public QFrame{
	Q_OBJECT
public:
	KviModeLabel(QWidget *parent);
	~KviModeLabel();
public:
	KviPushButton *m_lpP;
	KviPushButton *m_lpT;
	KviPushButton *m_lpN;
	KviPushButton *m_lpS;
	KviPushButton *m_lpM;
	KviPushButton *m_lpI;
	QLabel *m_lpLabel;
public:
	void getMode(QString &szMode);
	void setMode(char mode,bool bAdd);
protected:
	virtual void resizeEvent(QResizeEvent *e);
public:
	virtual void setPalette(const QPalette &palette);
	virtual void setBackgroundPixmap(const QPixmap &pixmap);
	virtual void setBackgroundColor(const QColor &color);
	virtual void setEnabled(bool bEnabled);
protected slots:
	void modeTPressed();
	void modeSPressed();
	void modePPressed();
	void modeNPressed();
	void modeIPressed();
	void modeMPressed();
signals:
	void modeChanged(const char *mode);
};

class KviChanWnd : public KviMdiChild
{
	Q_OBJECT
public:	
	KviChanWnd(KviMdiManager *parent,KviFrame *frame,const char *aname,int aid);
	~KviChanWnd();
	
	KNewPanner		*m_lpPanner;
	KviInput		*m_lpInput;
//	KviView			*m_lpOutput;
	KviListBox		*m_lpListBox;
	KNewPanner		*m_lpLabelPanner;
	KviTopicLabel	*m_lpTopicLabel;
	KNewPanner		*m_lpInfoPanner;
	KviModeLabel	*m_lpModeLabel;
	QLabel			*m_lpUserLabel;
	QTimer			*m_lpUserHostTimer;

	KviTopicLineEdit *m_lpTopicInput;
	QList<KviBanEntry> *m_lpBanList;
	QList<KviListBoxEntry>  *m_lpTempList;
	QTimer			*m_lpCloneTimer;
	bool		m_bIsMeOp;
	bool        m_bInScan;
	int         m_iB;
	bool		m_bAutoUpdateUsers;
	bool		m_bHasAllNames;
	bool        m_bHasBanList;
	bool        m_bSentBanList;

	//events OnMass*
	QString     m_szLastOper;
	QString     m_szLastDeoper;
	QString     m_szLastBanner;
	QString     m_szLastKicker;
	QString     m_szLastFlooder;

	QList<QTime> *m_timeLastOp;
	QList<QTime> *m_timeLastDeop;
	QList<QTime> *m_timeLastBan;
	QList<QTime> *m_timeLastKick;
	QList<QTime> *m_timeLastFlood;

	uint        m_uMassOpCnt;
	uint        m_uMassDeopCnt;
	uint        m_uMassKickCnt;
	uint        m_uMassBanCnt;
	uint        m_uPublicFloodCnt;

public:
	bool checkMassOp(QString &szNick);
	bool checkMassDeop(QString &szNick);
	bool checkMassKick(QString &szNick);
	bool checkMassBan(QString &szNick);
	bool checkPublicFlood(QString &szNick);
public:
	KviListBoxEntry * getNickEntry(const char *szNick);

	void nickJoin(KviNewNick &kN,bool bOp=false,bool bVoice=false);
	void nickJoin(QString &szN);
	void nickJoin(const char *szN);

	void nickPart(KviNewNick &kN);
	void nickPart(QString &szN);
	void nickPart(const char *szN);

	KviNewNick * getNick(KviNewNick &kN);
	KviNewNick * getNick(QString &szN);
	KviNewNick * getNick(const char *szN);

	void nickOp(KviNewNick &kN,bool bOp);
	void nickOp(QString &szN,bool bOp);
	void nickOp(const char *szN,bool bOp);

	void nickVoice(KviNewNick &kN,bool bVoice);
	void nickVoice(QString &szN,bool bVoice);
	void nickVoice(const char *szN,bool bVoice);

	void setTopic(const char *szTopic);
	void getTopic(QString &szTopic);

	void updateUsersLabel();

	void setMode(char szMode,bool bAdd);

	void changeBanList(const char *szBanSetBy,const char *szBanMask,bool bAdd);

	void doUserList();
	void setLabelsPalette();
	void applyOptions();
	void doFmtOutput(int nType,const char *szFmt,...);
	void doOutput(int nType,const char *szText);
	void startUpdateUserList();
	bool doSingleCloneScan(KviNewNick *lpN);
	void doGlobalCloneScan();
	bool isModeSet(char mode);
protected:
	virtual void resizeEvent(QResizeEvent *);
public slots:
//	void doChanDialog();
	void doBanDialog();
	void slotClose();
	void queryUserHost();
	void clonescanDoIt();
	void topicEditComplete();
	void allowTopicChange();
	void abortTopicEdit();
	void userChangedMode(const char *mode);
};


#endif // _KVI_STATUS_H_INCLUDED_
