//
//   File : kvi_chat.h (/usr/cvs/kvirc/kvirc/kvi_chat.h)
//   Last modified : Sun Dec 6 1998 02:26:35 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_CHAT_H_INCLUDED_
#define _KVI_CHAT_H_INCLUDED_

#include "kvi_child.h"

#include <qsocketnotifier.h>

class KviInput;
class KviListeningSocket;
class KviOptions;

class KviChatWnd : public KviMdiChild
{
	Q_OBJECT
public:	
	KviChatWnd(KviMdiManager *parent,KviFrame *frame,const char *aname,int aid);
	~KviChatWnd();
	
	KviInput			*m_lpInput;
	KviListeningSocket	*m_lpListeningSocket;
	int					m_Sock;
	KviOptions			*m_lpOpt;
	bool				m_bConnected;
	bool                m_bWaitForAck;
	QSocketNotifier		*m_lpReadNotifier;
	QSocketNotifier		*m_lpWriteNotifier;
	QString				m_szRemoteNick;
	QString				m_szLastIncompleteMessage;
	QString				m_szRemoteIp;
	QTimer				*m_lpTimer;
public:
	void applyOptions();
	void doFmtOutput(int nType,const char *szFmt,...);
	void doOutput(int nType,const char *szText);
	void sendData(const char *szData);
	bool requestChat(const char *szNick);
	void acceptChat(QString &szPort,QString &szIp,const char *szNick);
	void acceptConnectedChat(int sockFd,const char *szIp,const char *szNick);
	void connectToDaemon(QString &szPort,QString &szIp);
	bool parseMessage(QString &szMessage);
	void sendMotd();
	void killSock();
	void killNotifiers();
protected:
	void acceptFailed(const char *text);
	void requestFailed(const char *text);
	virtual void resizeEvent(QResizeEvent *);
public slots:
	void connectTimedOut();
	void closeSlot();
	void connectedSlot();
	void slotDataInBuffer(int);
	void slotConnected(int);
	void slotConnectedToDaemon(int);
};


#endif // _KVI_CHAT_H_INCLUDED_
