//   $Id: kvi_chng.cpp,v 1.5 1998/09/28 13:03:09 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
//#define _KVI_DEBUG_CLASS_NAME_ "KviChangers"
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_macros.h"
#include "kvi_chng.h"
#include "kvi_defs.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include <kfontdialog.h>


//============ KviNewColorChanger ============//

KviNewColorChanger::KviNewColorChanger(QTabDialog *dialog,QWidget *parent,const char *text,QColor *color)
:QWidget(parent,"KviNewColorChangerClass")
{
	_debug_entertrace("KviNewColorChanger");
	m_lpColor    =color;
	m_lpColorBtn =new KColorButton((*color),this);
	m_lpLabel =new QLabel(text,this);
	connect(dialog,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewColorChanger");
}

//============ ~KviNewColorChanger ============//

KviNewColorChanger::~KviNewColorChanger()
{
	_debug_entertrace("~KviNewColorChanger");
	_debug_leavetrace("~KviNewColorChanger");
}

//============ applySlot ============//

void KviNewColorChanger::applySlot()
{
	_debug_entertrace("applySlot");
	(*m_lpColor)=m_lpColorBtn->color();
	_debug_leavetrace("applySlot");
}

//============ resizeEvent ============//

void KviNewColorChanger::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	m_lpLabel->setGeometry(0,0,width()-100,height());
	m_lpColorBtn->setGeometry(width()-95,0,95,height());
	_debug_leavetrace("resizeEvent");
}

//============ sizeHint ============//

QSize KviNewColorChanger::sizeHint() const
{
	_debug_entertrace("sizeHint");
	QSize ret=m_lpLabel->sizeHint();
	ret.setWidth(ret.width()+100);
	if(ret.height() < 25)ret.setHeight(25);
	_debug_leavetrace("sizeHint");
	return ret;
}

//============ KviNewPixmapChanger ============//

KviNewPixmapChanger::KviNewPixmapChanger(QTabDialog *dialog,QWidget *parent,const char *text,QString *filename,QPixmap *pixmap)
:QWidget(parent,"KviNewPixmapChangerClass")
{
	_debug_entertrace("KviNewPixmapChanger");
	m_lpFileName =filename;
	m_lpPixmap   =pixmap;
	_range_valid(pixmap);
	_range_valid(filename);
	m_lpButton   =new KIconLoaderButton(this);
	bool bUsePixmap=(strcmp(m_lpFileName->data(),KVI_STR_NONE) != 0);
	if(bUsePixmap)m_lpButton->setIcon(m_lpFileName->data());
	m_lpCheckBox =new QCheckBox(text,this);
	m_lpCheckBox->setChecked(bUsePixmap);
	m_lpButton->setEnabled(bUsePixmap);
	m_lpIL=_macro_kviIconLoader;
	connect(m_lpCheckBox,SIGNAL(toggled(bool)),this,SLOT(checkBoxActivated(bool)));
	connect(dialog,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewPixmapChanger");
}

//============ ~KviNewPixmapChanger ============//

KviNewPixmapChanger::~KviNewPixmapChanger()
{
	_debug_entertrace("~KviNewPixmapChanger");
	_debug_leavetrace("~KviNewPixmapChanger");
}

//============ applySlot ============//

void KviNewPixmapChanger::applySlot()
{
	_debug_entertrace("applySlot");
	if(m_lpCheckBox->isChecked()){
		const char *szFile=m_lpButton->icon();
		if(!strcmp(szFile,KVI_STR_NONE)){
			m_lpPixmap->resize(0,0);
			(*m_lpFileName)=KVI_STR_NONE;
		} else {
			QPixmap pix=m_lpIL->loadIcon(szFile);
			if(!pix.isNull()){
				(*m_lpPixmap)=pix;
				(*m_lpFileName)=szFile;
			} else {
				m_lpPixmap->resize(0,0);
				(*m_lpFileName)=KVI_STR_NONE;
			}
		}
	} else {
		m_lpPixmap->resize(0,0);
		(*m_lpFileName)=KVI_STR_NONE;
	}
	_debug_leavetrace("applySlot");
}

//============ checkBoxActivated ============//

void KviNewPixmapChanger::checkBoxActivated(bool bActive)
{
	_debug_entertrace("checkBoxActivated");
	if(!bActive)m_lpButton->setIcon(""); //no icon
	m_lpButton->setEnabled(bActive);
	_debug_leavetrace("checkBoxActivated");
}

//============ resizeEvent ============//

void KviNewPixmapChanger::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	int h=m_lpCheckBox->sizeHint().height();
	m_lpCheckBox->setGeometry(0,0,width(),h);
	m_lpButton->setGeometry(0,h+2,width(),height()-(h+2));
	_debug_leavetrace("resizeEvent");
}

//============ sizeHint ============//

QSize KviNewPixmapChanger::sizeHint() const
{
	_debug_entertrace("sizeHint");
	QSize ret=m_lpCheckBox->sizeHint();
	ret.setHeight(ret.height()+100);
	_debug_leavetrace("sizeHint");
	return ret;
}

//============ KviNewFontChanger ============//

KviNewFontChanger::KviNewFontChanger(QTabDialog *dialog,QWidget *parent,const char *text,QFont *font)
:QWidget(parent,"KviNewFontChangerClass")
{
	_debug_entertrace("KviNewFontChanger");
	m_lpFont=font;
	m_lpButton=new QPushButton(i18n("Sample"),this);
	m_lpButton->setFont(*font);
	m_lpButton->repaint();
	connect(m_lpButton,SIGNAL(clicked()),this,SLOT(buttonPressed()));
	m_lpLabel=new QLabel(text,this);
	connect(dialog,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewFontChanger");
}

//============ ~KviNewFontChanger ============//

KviNewFontChanger::~KviNewFontChanger()
{
	_debug_entertrace("~KviNewFontChanger");
	_debug_leavetrace("~KviNewFontChanger");
}

//============ applySlot ============//

void KviNewFontChanger::applySlot()
{
	_debug_entertrace("applySlot");
	(*m_lpFont)=m_lpButton->font();
	_debug_leavetrace("applySlot");
}

//============ buttonPressed ============//

void KviNewFontChanger::buttonPressed()
{
	_debug_entertrace("buttonPressed");
	KFontDialog aDialog(this,"KviFontChanger",true);
	aDialog.setFont(m_lpButton->font());
	if(aDialog.exec()==QDialog::Accepted){
		m_lpButton->setFont(aDialog.font());
		m_lpButton->repaint();
	}
	_debug_leavetrace("buttonPressed");
}

//============ resizeEvent ============//

void KviNewFontChanger::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	m_lpLabel->setGeometry(0,0,width()-100,height());
	m_lpButton->setGeometry(width()-95,0,95,height());
	_debug_leavetrace("resizeEvent");
}

//============ sizeHint ============//

QSize KviNewFontChanger::sizeHint() const
{
	_debug_entertrace("sizeHint");
	QSize ret=m_lpLabel->sizeHint();
	ret.setWidth(ret.width()+100);
	if(ret.height() < 25)ret.setHeight(25);
	_debug_leavetrace("sizeHint");
	return ret;
}


//============ KviNewBoolChanger ============//

KviNewBoolChanger::KviNewBoolChanger(QTabDialog *lpDlg,QWidget *parent,const char *text,bool *lpBool,bool bEnabled)
:QCheckBox(text,parent)
{
	_debug_entertrace("KviNewBoolChanger");
	m_lpBool=lpBool;
	setChecked(*m_lpBool);
	setEnabled(bEnabled);
	connect(lpDlg,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewBoolChanger");
}

//============ ~KviNewBoolChanger ============//

KviNewBoolChanger::~KviNewBoolChanger()
{
	_debug_entertrace("~KviNewBoolChanger");
	_debug_leavetrace("~KviNewBoolChanger");
}

//=========== applySlot ============//

void KviNewBoolChanger::applySlot()
{
	_debug_entertrace("applySlot");
	(*m_lpBool)=isChecked();
	_debug_leavetrace("applySlot");
}

//============ setNotEnabled ============//

void KviNewBoolChanger::setNotEnabled(bool bNotEnabled)
{
	_debug_entertrace("setNotEnabled");
	setEnabled(!bNotEnabled);
	_debug_leavetrace("setNotEnabled");
}


//============ KviNewIntChanger ============//

KviNewIntChanger::KviNewIntChanger(QTabDialog *lpDlg,QWidget *parent,int *lpVal,bool bEnabled,int low,int high)
:KIntegerLine(parent)
{
	_debug_entertrace("KviNewIntChanger");
	m_lpVal=lpVal;
	m_iLowLimit=low;
	m_iHighLimit=high;
	setValue(*m_lpVal);
	setEnabled(bEnabled);
	connect(lpDlg,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewIntChanger");
}

//============ ~KviNewIntChanger ============//

KviNewIntChanger::~KviNewIntChanger()
{
	_debug_entertrace("~KviNewIntChanger");
	_debug_leavetrace("~KviNewIntChanger");
}

//=========== applySlot ============//

void KviNewIntChanger::applySlot()
{
	_debug_entertrace("applySlot");
	(*m_lpVal)=value();
	if(m_iLowLimit > -1){
		if((*m_lpVal)<m_iLowLimit)(*m_lpVal)=m_iLowLimit;
	}
	if(m_iHighLimit > -1){
		if((*m_lpVal)>m_iHighLimit)(*m_lpVal)=m_iHighLimit;
	}
	_debug_leavetrace("applySlot");
}


//============ setNotEnabled ============//

void KviNewIntChanger::setNotEnabled(bool bNotEnabled)
{
	_debug_entertrace("setNotEnabled");
	setEnabled(!bNotEnabled);
	_debug_leavetrace("setNotEnabled");
}

//============ KviNewUIntChanger ============//

KviNewUIntChanger::KviNewUIntChanger(QTabDialog *lpDlg,QWidget *parent,uint *lpVal,bool bEnabled,int low,int high)
:KIntegerLine(parent)
{
	_debug_entertrace("KviNewUIntChanger");
	m_lpVal=lpVal;
	m_iLowLimit=low;
	m_iHighLimit=high;
	setValue(*m_lpVal);
	setEnabled(bEnabled);
	connect(lpDlg,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewUIntChanger");
}

//============ ~KviNewUIntChanger ============//

KviNewUIntChanger::~KviNewUIntChanger()
{
	_debug_entertrace("~KviNewUIntChanger");
	_debug_leavetrace("~KviNewUIntChanger");
}

//=========== applySlot ============//

void KviNewUIntChanger::applySlot()
{
	_debug_entertrace("applySlot");
	(*m_lpVal)=value();
	if(m_iLowLimit > -1){
		if((*m_lpVal)<((uint)m_iLowLimit))(*m_lpVal)=m_iLowLimit;
	}
	if(m_iHighLimit > -1){
		if((*m_lpVal)>((uint)m_iHighLimit))(*m_lpVal)=m_iHighLimit;
	}
	_debug_leavetrace("applySlot");
}


//============ setNotEnabled ============//

void KviNewUIntChanger::setNotEnabled(bool bNotEnabled)
{
	_debug_entertrace("setNotEnabled");
	setEnabled(!bNotEnabled);
	_debug_leavetrace("setNotEnabled");
}


//============ KviNewShortIntChanger ============//

KviNewShortIntChanger::KviNewShortIntChanger(QTabDialog *lpDlg,QWidget *parent,unsigned short int *lpVal,bool bEnabled,int low,int high)
:KRestrictedLine(parent,"0123456789")
{
	_debug_entertrace("KviNewShortIntChanger");
	m_lpVal=lpVal;
	m_iLowLimit=low;
	m_iHighLimit=high;
	QString szT;
	szT.setNum((*m_lpVal));
	setText(szT.data());
	setEnabled(bEnabled);
	connect(lpDlg,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewShortIntChanger");
}

//============ ~KviNewShortIntChanger ============//

KviNewShortIntChanger::~KviNewShortIntChanger()
{
	_debug_entertrace("~KviNewShortIntChanger");
	_debug_leavetrace("~KviNewShortIntChanger");
}

//=========== applySlot ============//

void KviNewShortIntChanger::applySlot()
{
	_debug_entertrace("applySlot");
	QString data=text();
	bool bOk=false;
	unsigned short int val=data.toUShort(&bOk);
	if(!bOk)(*m_lpVal)=(unsigned short int)m_iLowLimit;
	else {
		(*m_lpVal)=val;
		if(m_iLowLimit > -1){
			if((*m_lpVal)<m_iLowLimit)(*m_lpVal)=(unsigned short int)m_iLowLimit;
		}
		if(m_iHighLimit > -1){
			if((*m_lpVal)>m_iHighLimit)(*m_lpVal)=(unsigned short int)m_iHighLimit;
		}
	}
	_debug_leavetrace("applySlot");
}


//============ setNotEnabled ============//

void KviNewShortIntChanger::setNotEnabled(bool bNotEnabled)
{
	_debug_entertrace("setNotEnabled");
	setEnabled(!bNotEnabled);
	_debug_leavetrace("setNotEnabled");
}

//============ KviNewNumericValueSelector ============//

KviNewNumericValueSelector::KviNewNumericValueSelector(QTabDialog *lpDlg,QWidget *parent,int *lpVal,QString szValues,QString szTexts,int iDefVal,bool bEnabled)
:QComboBox(parent)
{
	//szValues="138229 321892 32899 2198 0 3 1223 28 9 0..."
	//szTexts= "suffix for numbers : 1248 (sec.)"
	_debug_entertrace("KviNewNumericValueSelector");
	m_lpVal=lpVal;
	m_iDefValue=iDefVal;
	m_szValues=szValues.data();
	int idx;
	QString szVal;
	int id=0;
	int select=0;
	while(!szValues.isEmpty()){
		idx=szValues.find(' ');
		if(idx != -1){
			szVal=szValues.left(idx);
			szValues.remove(0,idx+1);
		} else {
			szVal=szValues.data();
			szValues="";
		}
		bool bOk;
		int val=szVal.toInt(&bOk);
		szVal+=' ';
		szVal+=szTexts.data();
		insertItem(szVal.data());
		if(val==(*m_lpVal))select=id;
		id++;
	}
	setCurrentItem(select);
	setEnabled(bEnabled);
	connect(lpDlg,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewNumericValueSelector");
}

//============ ~KviNewNumericValueSelector ============//

KviNewNumericValueSelector::~KviNewNumericValueSelector()
{
	_debug_entertrace("~KviNewNumericValueSelector");
	_debug_leavetrace("~KviNewNumericValueSelector");
}

//=========== applySlot ============//

void KviNewNumericValueSelector::applySlot()
{
	_debug_entertrace("applySlot");
	int sel=currentItem();
	if(sel>=0){
		QString szVal=text(sel);
		if(!szVal.isEmpty()){
			int idx=szVal.find(' ');
			if(idx!= -1){
				QString szV=szVal.left(idx);
				bool bOk;
				int val=szV.toInt(&bOk);
				if(bOk)(*m_lpVal)=val;
				return;
			}
		}
	}
	debug("Warning , value not in range , resetting to def value");
	(*m_lpVal)=m_iDefValue;
	_debug_leavetrace("applySlot");
}

//============ setNotEnabled ============//

void KviNewNumericValueSelector::setNotEnabled(bool bNotEnabled)
{
	_debug_entertrace("setNotEnabled");
	setEnabled(!bNotEnabled);
	_debug_leavetrace("setNotEnabled");
}
//********************OLD CLASSES : To be discarded********************//

KviBoolChanger::KviBoolChanger(QTabDialog *lpDlg,QWidget *parent,
									int x,int y,int w,int h,
									const char *szText,bool *lpBool)
			:QCheckBox(szText,parent){
	m_lpBool=lpBool;
	setGeometry(x,y,w,h);
	setChecked((*m_lpBool));
	connect(lpDlg,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
}
KviBoolChanger::~KviBoolChanger(){
}

void KviBoolChanger::applySlot(){
	(*m_lpBool)=isChecked();
}


#include "m_kvi_chng.moc"

//
// $Log: kvi_chng.cpp,v $
// Revision 1.5  1998/09/28 13:03:09  pragma
// Moved to geometry management.
// New Changer classes.
//
