//   $Id: kvi_chng.h,v 1.3 1998/09/28 13:03:08 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_CHNG_H_INCLUDED_
#define _KVI_CHNG_H_INCLUDED_

#include <kcolorbtn.h>
#include <kiconloader.h>
#include <kiconloaderdialog.h>
#include <kintegerline.h>
#include <krestrictedline.h>

#include <qwidget.h>
#include <qtabdialog.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlineedit.h>

//**********new Classes*************//
class KviNewColorChanger : public QWidget{
	Q_OBJECT
public:
	KviNewColorChanger(QTabDialog *dialog,QWidget *parent,const char *text,QColor *color);
	~KviNewColorChanger();
public:
	QColor *m_lpColor;
	KColorButton *m_lpColorBtn;
	QLabel *m_lpLabel;
public slots:
	void applySlot();
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual QSize sizeHint() const;
};

class KviNewPixmapChanger : public QWidget{
	Q_OBJECT
public:
	KviNewPixmapChanger(QTabDialog *dialog,QWidget *parent,const char *text,QString *filename,QPixmap *pixmap);
	~KviNewPixmapChanger();
public:
	QPixmap           *m_lpPixmap;
	KIconLoaderButton *m_lpButton;
	KIconLoader       *m_lpIL;
	QCheckBox         *m_lpCheckBox;
	QString           *m_lpFileName;
public slots:
	void applySlot();
	void checkBoxActivated(bool bActive);
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual QSize sizeHint() const;	
};


class KviNewFontChanger : public QWidget{
	Q_OBJECT
public:
	KviNewFontChanger(QTabDialog *dialog,QWidget *parent,const char *text,QFont *font);
	~KviNewFontChanger();
public:
//	QWidget *m_lpOldFocusProxy;
//	QTabDialog *m_lpParent;
	QFont *m_lpFont;
	QLabel *m_lpLabel;
	QPushButton *m_lpButton;
public slots:
	void applySlot();
	void buttonPressed();
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual QSize sizeHint() const;
};

class KviNewBoolChanger : public QCheckBox
{
	Q_OBJECT
public:
	KviNewBoolChanger(QTabDialog *lpDlg,QWidget *parent,const char *szText,bool *lpBool,bool bEnabled=true);
	~KviNewBoolChanger();
public:
	bool *m_lpBool;
public slots:
	void applySlot();
	void setNotEnabled(bool bNotEnabled);
};


//TEMPLATE THIS ?
class KviNewIntChanger : public KIntegerLine
{
	Q_OBJECT
public:
	KviNewIntChanger(QTabDialog *lpDlg,QWidget *parent,int *lpVal,bool bEnabled=true,int low=-1,int high=-1);
	~KviNewIntChanger();
public:
	int *m_lpVal;
	int m_iLowLimit;
	int m_iHighLimit;
public slots:
	void applySlot();
	void setNotEnabled(bool bNotEnabled);
};

class KviNewUIntChanger : public KIntegerLine
{
	Q_OBJECT
public:
	KviNewUIntChanger(QTabDialog *lpDlg,QWidget *parent,uint *lpVal,bool bEnabled=true,int low=-1,int high=-1);
	~KviNewUIntChanger();
public:
	uint *m_lpVal;
	int m_iLowLimit;
	int m_iHighLimit;
public slots:
	void applySlot();
	void setNotEnabled(bool bNotEnabled);
};

class KviNewShortIntChanger : public KRestrictedLine
{
	Q_OBJECT
public:
	KviNewShortIntChanger(QTabDialog *lpDlg,QWidget *parent,unsigned short int *lpVal,bool bEnabled=true,int low=-1,int high=-1);
	~KviNewShortIntChanger();
public:
	unsigned short int *m_lpVal;
	int m_iLowLimit;
	int m_iHighLimit;
public slots:
	void applySlot();
	void setNotEnabled(bool bNotEnabled);
};

class KviNewNumericValueSelector : public QComboBox
{
	Q_OBJECT
public:
	KviNewNumericValueSelector(QTabDialog *lpDlg,QWidget *parent,int *lpVal,QString szValues,QString szTexts,int iDefVal,bool bEnabled=true);
	~KviNewNumericValueSelector();
public:
	QString m_szValues;
	int *m_lpVal;
	int m_iDefValue;
public slots:
	void applySlot();
	void setNotEnabled(bool bNotEnabled);
};

class KviBoolChanger : public QCheckBox{
	Q_OBJECT
public:
	KviBoolChanger(QTabDialog *lpDlg,QWidget *parent,int x,int y,int w,int h,
							const char *szText,bool *lpBool);
	~KviBoolChanger();
public:
	bool			*m_lpBool;
public slots:
	void applySlot();
};

#endif //_KVI_CHNG_H_INCLUDED_
