//
//   File : kvi_dccd.h (/usr/cvs/kvirc/kvirc/kvi_dccd.h)
//   Last modified : Sat Dec 5 1998 02:04:51 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_DCCD_H_INCLUDED_
#define _KVI_DCCD_H_INCLUDED_

class KviOptions;
class KviFrame;
class KviCTCP;

#include <qobject.h>
#include <qsocketnotifier.h>
#include <qlist.h>
#include <qtimer.h>

class KviDCCDaemon;

class KviDCCMajorDomo : public QObject
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDCCMajorDomo(KviFrame *lpFrm,KviDCCDaemon *dccd,int sockFd,const char *szIp);
	~KviDCCMajorDomo();
public:		// Fields
	QString m_szRemoteIp;
	int     m_iSock;
	KviDCCDaemon *m_lpDCCD;
	KviCTCP      *m_lpCTCP;
	QSocketNotifier *m_lpSocketNotifier;
	KviFrame *m_lpFrm;
	QTimer *m_lpTimer;
private:		// Methods
	void handleDCCSend(const char *fromNick,QString &szFileName,uint iFileSize);
	void handleDCCChat(const char *fromNick);
	void doOutput(const char *text);
	void doError(const char *text);
protected slots:	// Protected methods
	void dataInBuffer(int);
	void timedOut();
	void requestRejected();
	void serviceNotAvailable();
};


class KviDCCDaemon : public QObject
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDCCDaemon(KviFrame *lpFrm,KviOptions *lpOpt);
	~KviDCCDaemon();
public:		// Fields
	KviOptions *m_lpOpt;
	KviFrame   *m_lpFrm;
	QSocketNotifier *m_lpSocketNotifier;
	int         m_iSock;
	int         m_iPort;
	QList<KviDCCMajorDomo> *m_lpMajorDomoList;
public:		// Methods
	void doOutput(const char *text);
	void doError(const char *text);
	bool start(unsigned short int iPort);
	void stop();
	bool isActive();
	void terminateIfRunning();
	void killMajorDomo(KviDCCMajorDomo *james);
protected slots:	// Protected methods
	void connectionRequest(int);
};

#endif //_KVI_DCCD_H_INCLUDED_
