//
//   File : kvi_defs.h (/usr/cvs/kvirc/kvirc/kvi_defs.h)
//   Last modified : Thu Nov 26 1998 01:08:08 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//--------------------------------------------------------------------------
//Please avoid editing this file unless you *REALLY* know what you're doing.
//--------------------------------------------------------------------------

#ifndef _KVI_DEFS_H_INCLUDED_
#define _KVI_DEFS_H_INCLUDED_

#ifdef HAVE_CONFIG_H
	#include "../config.h"
#else
	#define VERSION "?.?.?"
#endif

#define KVI_STATUS_DEFAULT_TEXT "KVirc " ## VERSION ## " by <Pragma!kvirc@tin.it>"
#define KVI_VERSION "KVirc " ## VERSION ## " by Szymon 'Pragma@ircnet' Stefanek <kvirc@tin.it>"
#define KVI_HELP_ABOUT_STRING "KVirc " ## VERSION ## "\nby Szymon Stefanek\nbugs and suggestions to :\nkvirc@tin.it"
#define KVI_CLIENTINFO "KVirc " ## VERSION ## " on Linux KDE XSystem"
#define KVI_CTCP_SOURCE_REPLY "KVirc " ## VERSION ## " : Homepage http://www.kvirc.org"
#define KVI_DEFAULT_SCRIPT_VER "No script"
#define KVI_STATUS_MSG_TIMER_TIMEOUT 10000

#define KVI_UINT_VERSION (unsigned int)0
#define KVI_UINT_REVISION (unsigned int)9

#define KVI_DEFAULT_REAL_NAME "KVirc " ## VERSION ## " http://www.kvirc.org"
#define KVI_DEFAULT_USER_NAME "kvirc"
#define KVI_DEFAULT_NICK "[nick-1]"
#define KVI_DEFAULT_ALT_NICK "[nick-2]"

#define KVI_DEFAULT_CAPTION_STRING "KVirc " ## VERSION ## " by <kvirc@tin.it> http://www.kvirc.org"
#define KVI_DEFAULT_QUIT_MSG "Segmentation fault : $_version"
#define KVI_DEFAULT_PART_MSG "Bye : $_version"
#define KVI_DEFAULT_KICK_MSG "Go sit in a corner..."
#define KVI_DEFAULT_AWAY_MSG "Not behind the keyboard since $_time $_date"
#define KVI_DEFAULT_FINGER_MSG "$_version : $_mymask"
#define KVI_DEFAULT_USERINFO_MSG "User : $_myusername = $_myrealname : WOW!"

#define KVI_EMPTY_PASSWORD "#NO_PASSWORD#"
#define KVI_EMPTY_IP "*.*.*.*"

#define KVI_IMPOSSIBLE_NICKNAME "* *,* *"
#define KVI_STR_NONE "[__ NONE __]"

#define KVI_DEFAULT_LOCAL_IP "127.0.0.1"


#define KVI_MDI_CHILD_MIN_WIDTH 150
#define KVI_MDI_CHILD_MIN_HEIGHT 80
#define KVI_MDI_CHILD_BORDER 3
#define KVI_MDI_CHILD_SYSBTN_SIZE 19
#define KVI_MDI_CHILD_SYSBTN_SEP 1
#define KVI_MDI_CHILD_MIN_VISIBLE_EDGE 40
#define KVI_MDI_CHILD_RESIZE_BORDER 5
#define KVI_MDI_CHILD_SEP 2
#define KVI_MDI_CHILD_CASCADE_WIDTH 400
#define KVI_MDI_CHILD_CASCADE_HEIGHT 250
#define KVI_MDI_CHILD_CASCADE_STEP 24
#define KVI_MDI_CHILD_CASCADE_JUMPX 180
#define KVI_PROGRESS_HEIGHT 30

#define KVI_TASKBAR_VERTICAL_WIDTH 120
#define KVI_TASKBAR_SIDE_BORDER 10
#define KVI_TASKBAR_TOP_BORDER 2

#define KVI_INPUT_MAX_COMMANDS 20
#define KVI_INPUT_MAX_LENGTH 250
#define KVI_INPUT_BLINK_TIME 500
#define KVI_INPUT_SCROLL_TIME 100
//Colors
#define KVI_WHITE 0
#define KVI_BLACK 1
#define KVI_DARKBLUE 2
#define KVI_DARKGREEN 3
#define KVI_RED 4
#define KVI_DARKRED 5
#define KVI_DARKVIOLET 6
#define KVI_ORANGE 7
#define KVI_YELLOW 8
#define KVI_LIGHTGREEN 9
#define KVI_BLUEMARINE 10
#define KVI_LIGHTBLUE 11
#define KVI_BLUE 12
#define KVI_LIGHTVIOLET 13
#define KVI_DARKGRAY 14
#define KVI_LIGHTGRAY 15
#define KVI_TRANSPARENT 100
//mIrc control codes
//31 (0000 0000 0001 1111)
#define KVI_TEXT_UNDERLINE 0x1f
//2  (0000 0000 0000 0010)
#define KVI_TEXT_BOLD 0x02
//15 (0000 0000 0000 1111)
#define KVI_TEXT_RESET 0x0f
//22 (0000 0000 0001 0110)
#define KVI_TEXT_REVERSE 0x16
//3  (0000 0000 0000 0011)
#define KVI_TEXT_COLOR 0x03
//more control codes....url highliting
#define KVI_TEXT_URL_HIGHLIGHT 0x04
#define KVI_TEXT_URL_UNHIGHLIGHT 0x05

#define KVI_STATUS_WND_NAME "[*_Status_console_*]"
#define KVI_LINKS_WND_NAME "[*_Server_links_*]"
#define KVI_CHANLIST_WND_NAME "[*_Channel_list_*]"

#define KVI_NUM_PIXMAPS 44

#define KVI_OUT_INTERNAL 0
#define KVI_OUT_KVIRC 1
#define KVI_OUT_ERROR 2
#define KVI_OUT_HELP 3
#define KVI_OUT_MOTD 4
#define KVI_OUT_QUIT 5
#define KVI_OUT_KICK 6
#define KVI_OUT_INFO 7
#define KVI_OUT_JOIN 8
#define KVI_OUT_PART 9
#define KVI_OUT_OP 10
#define KVI_OUT_DEOP 11
#define KVI_OUT_BAN 12
#define KVI_OUT_UNBAN 13
#define KVI_OUT_VOICE 14
#define KVI_OUT_DEVOICE 15
#define KVI_OUT_SERVER 16
#define KVI_OUT_CONNECT 17
#define KVI_OUT_DISCONNECT 18
#define KVI_OUT_CLONE 19
#define KVI_OUT_CHANMODE 20
#define KVI_OUT_CTCP 21
#define KVI_OUT_NICK 22
#define KVI_OUT_PING 23
#define KVI_OUT_RPLERR 24
#define KVI_OUT_TOPIC 25
#define KVI_OUT_OWN 26
#define KVI_OUT_ECHO 27
#define KVI_OUT_PRIVMSG 28
#define KVI_OUT_NOTICE 29
#define KVI_OUT_RAW 30
#define KVI_OUT_ACTION 31
#define KVI_OUT_FLOOD 32
#define KVI_OUT_WHO 33
#define KVI_OUT_TIME 34
#define KVI_OUT_STDOUT 35
#define KVI_OUT_STDERR 36
#define KVI_OUT_STDIN 37
#define KVI_OUT_AWAY 38
#define KVI_OUT_BACK 39
#define KVI_OUT_DNS 40
#define KVI_OUT_INVITE 41
#define KVI_OUT_SOUND 42
#define KVI_OUT_DCCD 43
#define KVI_OUT_NORMAL 100
#define KVI_OUT_NONE 100

#define KVI_WND_TYPE_STATUS 0
#define KVI_WND_TYPE_CHAN 1
#define KVI_WND_TYPE_QUERY 2
#define KVI_WND_TYPE_CHAT 3
#define KVI_WND_TYPE_SEND 4
#define KVI_WND_TYPE_USER 5
#define KVI_WND_TYPE_LINKS 6
#define KVI_WND_TYPE_CHANLIST 7
#define KVI_WND_TYPE_VOICE 8
#define KVI_NUM_WND_TYPES 9

#define KVI_VIEW_BORDER 2
#define KVI_MDI_VIEW_SEP 2
#define KVI_DOUBLE_VIEW_BORDER_PLUS_SCROLLBAR 21
#define KVI_VIEW_BORDER_MINUS_ONE 1

//This is the output selection repaint timeout... 
//(KviView::m_lpSelectionTimer sets it...)
// If you are on a fast machine (>233 mhz)
// try decrementing it...
// (decrement by 10 msec each time and test by selecting
// some huge text...if it works well try to decrement again...)
// I think that the lower limit is 50-60 msec
// under 50 msec you will see no speed increase... :) 
#define KVI_VIEW_REPAINT_INTERVAL 100

#define KVI_DESTROY_TIMEOUT 500

#define KVI_STR_NULL "\x016_?\2null\2?_\x0f"
#define KVI_STR_FALSE "\x016_?\2false\2?_\x0f"
#define KVI_STR_TRUE "\x016_?\2true\2?_\x0f"
#define KVI_LENGTH_OF_STR_NULL 12

#define KVI_CHAR_BEGIN '<'
#define KVI_CHAR_END '>'

#endif //_KVI_DEFS_H_INCLUDED_
