//   $Id: kvi_dns.cpp,v 1.3 1998/09/23 12:41:36 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_dns.h"
#include "kvi_debug.h"

//============ KviDns ============//

KviDns::KviDns() : QObject(0,0)
{
	_debug_entertrace("KviDns");
	m_lpDnsList = new QList<KviDnsStruct>;
	m_lpDnsList->setAutoDelete(true);
	_debug_leavetrace("KviDns");
}

//============ ~KviDns ============//

KviDns::~KviDns()
{
	_debug_entertrace("~KviDns");
	while(!m_lpDnsList->isEmpty()){
		KviDnsStruct *lpS=m_lpDnsList->first();
		delete lpS->proc;
		m_lpDnsList->removeFirst();
	}
	_debug_leavetrace("~KviDns");
}

//============ queryDns ============//

bool KviDns::queryDns(const char *szHost)
{
	_debug_entertrace("queryDns");
	KProcess *proc=new KProcess();
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(dnsExited(KProcess *)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(dnsOutput(KProcess *,char *,int)));
	(*proc)<<"kvidns"<<szHost;
	KviDnsStruct *strct=new KviDnsStruct;
	strct->proc=proc;
	strct->szResult="";
	m_lpDnsList->append(strct); 
	if(!proc->start(KProcess::NotifyOnExit,KProcess::Stdout)){
		delete proc;
		m_lpDnsList->removeRef(strct);
		return false;
	}
	_debug_leavetrace("queryDns");
	return true;
}

//============ dnsExited ============//

void KviDns::dnsExited(KProcess *proc)
{
	_debug_entertrace("dnsExited");
	KviDnsStruct *lpS=0;
	for(lpS=m_lpDnsList->first();lpS;lpS=m_lpDnsList->next()){
		if(lpS->proc==proc){
			emit dnsDone(lpS->szResult.data());
			delete lpS->proc;
			m_lpDnsList->removeRef(lpS);
			return;
		}
	}
	_debug_leavetrace("dnsExited");
}

//============ dnsOutput ============//

void KviDns::dnsOutput(KProcess *proc,char *buffer,int buflen)
{
	_debug_entertrace("dnsOutput");
	KviDnsStruct *lpS=0;
	for(lpS=m_lpDnsList->first();lpS;lpS=m_lpDnsList->next()){
		if(lpS->proc==proc){
			lpS->szResult+=QString(buffer,buflen+1);
			return;
		}
	}
	_debug_leavetrace("dnsOutput");
}

//============ getResult ============//

bool KviDns::getResult(const char *szResult,KviDnsResultStruct *lpStruct)
{
	_debug_entertrace("getResult");
	QString szRes(szResult);
	int idx=szRes.find(':');
	if(idx != -1){
		QString szRType=szRes.left(idx);
		szRes.remove(0,idx+1);
		idx=szRes.find(':');
		if(idx != -1){
			lpStruct->szQuery=szRes.left(idx);
			szRes.remove(0,idx+1);
			if(szRType=="ERR"){
				lpStruct->szError=szRes.copy();
				return false;
			} else { //DNS
				idx=szRes.find(':');
				if(idx != -1){
					lpStruct->szHostName=szRes.left(idx);
					szRes.remove(0,idx+1);
					idx=szRes.find(':');
					if(idx != -1){
						lpStruct->szIp=szRes.left(idx);
						szRes.remove(0,idx+1);
						idx=szRes.find(':');
						if(idx != -1){
							lpStruct->szAlias1=szRes.left(idx);
							szRes.remove(0,idx+1);
							lpStruct->szAlias2=szRes.copy();
							return true;
						} else { //unreadable result
							lpStruct->szAlias1="Unknown [Internal error]";
							lpStruct->szAlias2="Unknown [Internal error]";
							lpStruct->szError="Unreadable DNS result";
							return false;
						}	
					} else { //unreadable result
						lpStruct->szIp="Unknown [Internal error]";
						lpStruct->szError="Unreadable DNS result";
						return false;
					}	
				} else { //unreadable result
					lpStruct->szHostName="Unknown [Internal error]";
					lpStruct->szError="Unreadable DNS result";
					return false;
				}	
			}
		} else { //unreadable result
			lpStruct->szQuery="Unknown [Internal error]";
			lpStruct->szError="Unreadable DNS result";
			return false;
		}
	} else { //unreadable result
		lpStruct->szQuery="Unknown [Internal error]";
		lpStruct->szError="Unreadable DNS result";
		return false;
	}
	_debug_leavetrace("getResult");
}
#include "m_kvi_dns.moc"
