//   $Id: kvi_evedlg.cpp,v 1.4 1998/09/20 20:22:25 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_evedlg.h"
#include "kvi_frame.h"
#include "kvi_mlined.h"
#include "kvi_debug.h"

#include <kapp.h>
#include <kwm.h>

#include <qpushbutton.h>

//============ KviEventDialog ============//

KviEventDialog::KviEventDialog(KviFrame *lpFrame):QDialog(lpFrame,"KviEventDialog",true)
{
	m_lpFrm=lpFrame;
	m_lpEventManager=lpFrame->m_lpEventManager;

	//make a local copy of data
	for(int i=0;i<KVI_EVENTS_NUMBER;i++){
		lpEvent[i]=new KviEventStruct;
		lpEvent[i]->szName=m_lpEventManager->lpEvent[i]->szName.data();
		lpEvent[i]->szBuffer=m_lpEventManager->lpEvent[i]->szBuffer.data();
		lpEvent[i]->bEnabled=m_lpEventManager->lpEvent[i]->bEnabled;
	}

	setCaption(i18n("Events"));
	setMinimumWidth(400);
	setMinimumHeight(280);

	m_lpEdit    = new KviMultiLineEdit(this,lpFrame);
	m_lpDone    = new QPushButton(i18n("OK"),this);
	m_lpCancel  = new QPushButton(i18n("Cancel"),this);
	m_lpHelp    = new QPushButton(i18n("Help"),this);
	m_lpBox     = new QComboBox(false,this);
	m_lpCheck   = new QCheckBox(i18n("Enabled"),this);
	m_lpSyntax  = new QLabel(this);

	m_lpSyntax->setFrameStyle(QFrame::Sunken | QFrame::Panel);

	connect(m_lpDone,SIGNAL(clicked()),this,SLOT(okPressed()));
	connect(m_lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(m_lpHelp,SIGNAL(clicked()),this,SLOT(invokeHelp()));
	connect(m_lpBox,SIGNAL(activated(int)),this,SLOT(selectionChanged(int)));
	connect(m_lpCheck,SIGNAL(toggled(bool)),this,SLOT(activeChanged(bool)));

	fillBox();
	if(!m_lpEventManager->m_lastGeometry.isEmpty())setGeometry(KWM::setProperties(winId(),m_lpEventManager->m_lastGeometry));
	else resize(400,400);
}

//============ ~KviEventDialog ============//

KviEventDialog::~KviEventDialog()
{
	//delete local data
	for(int i=0;i<KVI_EVENTS_NUMBER;i++)delete lpEvent[i];
	//delete our child widgets....
	//TOFIX : Remove unnecessary deletes when possible
	//        Here are all child widgets , with no particular deletion order requested.
	delete m_lpEdit;
	delete m_lpDone;
	delete m_lpCancel;
	delete m_lpHelp;
	delete m_lpBox;
	delete m_lpSyntax;
}

//============ okPressed ============//

void KviEventDialog::okPressed()
{
	_debug_entertrace("okPressed");
	selectionChanged(-1);
	//copy the data to the global struct
	for(int i=0;i<KVI_EVENTS_NUMBER;i++){
		m_lpEventManager->lpEvent[i]->szName=lpEvent[i]->szName.data();
		m_lpEventManager->lpEvent[i]->szBuffer=lpEvent[i]->szBuffer.data();
		m_lpEventManager->lpEvent[i]->bEnabled=lpEvent[i]->bEnabled;
	}
	//save our position and last edited index
	m_lpEventManager->m_iLastEdited=m_lpBox->currentItem();
	m_lpEventManager->m_lastGeometry=KWM::getProperties(winId());
	//and store to file
	m_lpEventManager->saveToFile();
	accept();
	_debug_leavetrace("okPressed");
}

//============ invokeHelp ============//

void KviEventDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	//nothing by now...add code here when have the help pages
	_debug_leavetrace("invokeHelp");
}

//============ resizeEvent ============//

void KviEventDialog::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	int aux=height()-30;
	m_lpCancel->setGeometry(width()-100,aux,95,25);
	m_lpDone->setGeometry(width()-200,aux,95,25);
	m_lpHelp->setGeometry(width()-300,aux,95,25);
	aux=width()/4;
	m_lpBox->setGeometry(5,5,width()-10,25);
	m_lpCheck->setGeometry(5,40,aux,25);
	m_lpSyntax->setGeometry(10+aux,40,width()-(15+aux),25);
	m_lpEdit->setGeometry(5,70,width()-10,height()-105);
	_debug_leavetrace("resizeEvent");
}

//============ fillBox ============//

void KviEventDialog::fillBox()
{
	_debug_entertrace("fillBox");
	//assume that this is called only once to setup the dialog
	for(int i=0;i<KVI_EVENTS_NUMBER;i++){
		m_lpBox->insertItem(lpEvent[i]->szName.data());
	}
	m_iLastSelection=-1;
	if((m_lpEventManager->m_iLastEdited>=0)&&(m_lpEventManager->m_iLastEdited<((int)m_lpBox->count()))){
		m_lpBox->setCurrentItem(m_lpEventManager->m_iLastEdited);
		selectionChanged(m_lpEventManager->m_iLastEdited);
	} else {
		m_lpBox->setCurrentItem(0);
		selectionChanged(0);
	}
	_debug_leavetrace("fillBox");
}

//============ selectionChanged ============//

void KviEventDialog::selectionChanged(int idx)
{
	_debug_entertrace("selectionChanged");
	//copy the last edited one (if any)
	if(m_iLastSelection>=0){
		lpEvent[m_iLastSelection]->szBuffer=m_lpEdit->text();
		lpEvent[m_iLastSelection]->bEnabled=m_lpCheck->isChecked();
	}
	m_iLastSelection=idx;
	//and show the new selection
	if(m_iLastSelection>=0){
		m_lpSyntax->setText(m_lpEventManager->appStr[(idx*2)+1]);
		m_lpEdit->setText(lpEvent[m_iLastSelection]->szBuffer.data());
		m_lpCheck->setChecked(lpEvent[m_iLastSelection]->bEnabled);
		m_lpEdit->setEnabled(lpEvent[m_iLastSelection]->bEnabled);
		m_lpSyntax->setEnabled(lpEvent[m_iLastSelection]->bEnabled);
		m_lpEdit->setFocus();
	}
	_debug_leavetrace("selectionChanged");
}

//============ activeChanged ============//

void KviEventDialog::activeChanged(bool bOn)
{
	_debug_entertrace("activeChanged");
	int curSel=m_lpBox->currentItem();
	if(curSel != -1)lpEvent[curSel]->bEnabled=bOn;
	m_lpEdit->setEnabled(bOn);
	if(bOn)m_lpEdit->setFocus();
	m_lpSyntax->setEnabled(bOn);
	_debug_leavetrace("activeChanged");
}

#include "m_kvi_evedlg.moc"

//
// $Log: kvi_evedlg.cpp,v $
// Revision 1.4  1998/09/20 20:22:25  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/18 03:44:47  fritz
// Unified OK-Buttons (some had been 'Ok', most are 'OK'). Now all are 'OK'
// Work on the Server-Dialog. Still not satisfied, but it works.
//
// Revision 1.2  1998/09/16 12:59:34  pragma
// Added 'Cancel' and 'Help' button.
// The dialog now operates on a local copy of data.
//
//
