//   $Id: kvi_event.h,v 1.2 1998/09/20 20:22:28 fritz Exp $
//
//   This file is part of the KVIrc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_EVENT_H_INCLUDED_
#define _KVI_EVENT_H_INCLUDED_

#include "kvi_types.h"

#include <qstring.h>

#define KVI_EVENTS_NUMBER 50

#define KVI_Event_OnStartup 0
#define KVI_Event_OnShutdown 1
#define KVI_Event_OnConnect 2
#define KVI_Event_OnDisconnect 3
#define KVI_Event_OnLoggedIn 4
#define KVI_Event_OnMeJoin 5
#define KVI_Event_OnMePart 6
#define KVI_Event_OnJoin 7
#define KVI_Event_OnPart 8
#define KVI_Event_OnTopicChange 9
#define KVI_Event_OnMeKick 10
#define KVI_Event_OnKick 11
#define KVI_Event_OnNick 12

#define KVI_Event_OnOp 13
#define KVI_Event_OnDeop 14
#define KVI_Event_OnVoice 15
#define KVI_Event_OnDevoice 16
#define KVI_Event_OnBan 17
#define KVI_Event_OnUnban 18

#define KVI_Event_OnQuit 19

#define KVI_Event_OnCtcpRequest 20
#define KVI_Event_OnCtcpReply 21
#define KVI_Event_OnCtcpFlood 22

#define KVI_Event_OnClone 23

#define KVI_Event_OnMeOp 24
#define KVI_Event_OnMeDeop 25
#define KVI_Event_OnMeVoice 26
#define KVI_Event_OnMeDevoice 27
#define KVI_Event_OnMeBan 28
#define KVI_Event_OnMeUnban 29

#define KVI_Event_OnProcessStarted 30
#define KVI_Event_OnProcessExited 31
#define KVI_Event_OnProcessStdout 32
#define KVI_Event_OnProcessStderr 33

#define KVI_Event_OnUnhandledServerReply 34
#define KVI_Event_OnUnhandledServerError 35

#define KVI_Event_OnChannelPrivmsg 36
#define KVI_Event_OnMePrivmsg 37
#define KVI_Event_OnChannelNotice 38
#define KVI_Event_OnMeNotice 39
#define KVI_Event_OnServerNotice 40

#define KVI_Event_OnDCCChatText 41

#define KVI_Event_OnUserWndInput 42

#define KVI_Event_OnMassOp 43
#define KVI_Event_OnMassDeop 44
#define KVI_Event_OnMassKick 45
#define KVI_Event_OnMassBan 46
#define KVI_Event_OnPublicFlood 47

#define KVI_Event_OnMeAwayChange 48

#define KVI_Event_OnMiddleDoubleClick 49

class KviEventManager{
public:
	KviEventManager();
	~KviEventManager();
public:
	static const char * appStr[KVI_EVENTS_NUMBER*2];
	QString m_lastGeometry;
	int m_iLastEdited;
	KviEventStruct *lpEvent[KVI_EVENTS_NUMBER];
public:
	void saveToFile();
private:
	void readFromFile();
	void setEventNames();
	void cantWriteError();
	void cantReadError();
	void internalError();
};

#endif //_KVI_EVENT_H_INCLUDED_
