//
//   File : kvi_frame.cpp (/usr/cvs/kvirc/kvirc/kvi_frame.cpp)
//   Last modified : Thu Nov 26 1998 01:08:53 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviFrame"

#include "kvi_app.h"

#include "kvi_defs.h"
#include "kvi_macros.h"

#include "kvi_support.h"

#include "kvi_ascii.h"
#include "kvi_dns.h"
#include "kvi_script.h"
#include "kvi_scrdlg.h"
#include "kvi_setup.h"
#include "kvi_about.h"
#include "kvi_translate.h"
#include "kvi_netscape.h"
#include "kvi_srvdlg.h"
#include "kvi_toolbar.h"

#include "kvi_frame.h"
#include "kvi_debug.h"
#include "kvi_mirc.h"
#include "kvi_int.h"
#include "kvi_usr.h"
#include "kvi_srv.h"
#include "kvi_global.h"
#include "kvi_opt.h"
#include "kvi_uparser.h"
#include "kvi_alias.h"
#include "kvi_event.h"
#include "kvi_popup.h"
#include "kvi_audio.h"
#include "kvi_status.h"
#include "kvi_sparser.h"
#include "kvi_mdi.h"
#include "kvi_socket.h"
#include "kvi_stbar.h"
#include "kvi_link.h"
#include "kvi_chan.h"
#include "kvi_chat.h"
#include "kvi_query.h"
#include "kvi_send.h"
#include "kvi_userwnd.h"
#include "kvi_view.h"
#include "kvi_popdlg.h"
#include "kvi_alidlg.h"
#include "kvi_intdlg.h"
#include "kvi_evedlg.h"
#include "kvi_optdlg.h"
#include "kvi_listbox.h"
#include "kvi_usrdlg.h"
#include "kvi_mirdlg.h"
#include "kvi_voice.h"
#include "kvi_ident.h"
#include "kvi_ulist.h"
#include "kvi_uldlg.h"
#include "kvi_proxy.h"
#include "kvi_chlist.h"
#include "kvi_taskbar.h"
#include "kvi_uglobal.h"
#include "kvi_dccd.h"

#include <kwm.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include <qobjectlist.h>

#include <arpa/inet.h>

iconTable KviFrame::icoTab[KVI_NUM_WND_TYPES]={
	{ KVI_WND_TYPE_STATUS   , "kvi_wnd_stat.gif" },
	{ KVI_WND_TYPE_CHAN     , "kvi_wnd_chan.gif" },
	{ KVI_WND_TYPE_QUERY    , "kvi_wnd_qery.gif" },
	{ KVI_WND_TYPE_CHAT     , "kvi_wnd_chat.gif" },
	{ KVI_WND_TYPE_SEND     , "kvi_wnd_send.gif" },
	{ KVI_WND_TYPE_USER     , "kvi_wnd_user.gif" },
	{ KVI_WND_TYPE_LINKS    , "kvi_wnd_link.gif" },
	{ KVI_WND_TYPE_CHANLIST , "kvi_wnd_chls.gif" },
	{ KVI_WND_TYPE_VOICE    , "kvi_wnd_talk.gif" }
};

// False i18n for xgettext
#define __i18n__(___text) ___text

pixmapTable KviFrame::pixTab[KVI_NUM_PIXMAPS]={
	{ KVI_OUT_INTERNAL  , "kvi_intrn.gif"  ,__i18n__("Internal messages")    },
	{ KVI_OUT_KVIRC     , "kvi_kvirc.gif"  ,__i18n__("KVirc version")        },
	{ KVI_OUT_ERROR     , "kvi_error.gif"  ,__i18n__("Errors")               },
	{ KVI_OUT_HELP      , "kvi_help.gif"   ,__i18n__("Help messages")        },
	{ KVI_OUT_MOTD      , "kvi_motd.gif"   ,__i18n__("Server MOTD")          },
	{ KVI_OUT_QUIT      , "kvi_quit.gif"   ,__i18n__("Quit messages")        },
	{ KVI_OUT_KICK      , "kvi_kick.gif"   ,__i18n__("Channel kicks")        },
	{ KVI_OUT_INFO      , "kvi_info.gif"   ,__i18n__("Server informations")  },
	{ KVI_OUT_JOIN      , "kvi_join.gif"   ,__i18n__("Channel joins")        },
	{ KVI_OUT_PART      , "kvi_part.gif"   ,__i18n__("Channel parts")        },
	{ KVI_OUT_OP        , "kvi_op.gif"     ,__i18n__("Op messages")          },
	{ KVI_OUT_DEOP      , "kvi_deop.gif"   ,__i18n__("Deop messages")        },
	{ KVI_OUT_BAN       , "kvi_ban.gif"    ,__i18n__("Bans")                 },
	{ KVI_OUT_UNBAN     , "kvi_unban.gif"  ,__i18n__("Unbans")               },
	{ KVI_OUT_VOICE     , "kvi_voice.gif"  ,__i18n__("Voice mode changes")   },
	{ KVI_OUT_DEVOICE   , "kvi_devoi.gif"  ,__i18n__("Devoice mode changes") },
	{ KVI_OUT_SERVER    , "kvi_serv.gif"   ,__i18n__("Server messages")      },
	{ KVI_OUT_CONNECT   , "kvi_conn.gif"   ,__i18n__("Connect")              },
	{ KVI_OUT_DISCONNECT, "kvi_disc.gif"   ,__i18n__("Disconnect")           },
	{ KVI_OUT_CLONE     , "kvi_clone.gif"  ,__i18n__("Clone warnings")       },
	{ KVI_OUT_CHANMODE  , "kvi_chmod.gif"  ,__i18n__("Channel modes")        },
	{ KVI_OUT_CTCP      , "kvi_ctcp.gif"   ,__i18n__("CTCP")                 },
	{ KVI_OUT_NICK      , "kvi_nick.gif"   ,__i18n__("Nick changes")         },
	{ KVI_OUT_PING      , "kvi_ping.gif"   ,__i18n__("Server pings")         },
	{ KVI_OUT_RPLERR    , "kvi_rpler.gif"  ,__i18n__("Server error replies") },
	{ KVI_OUT_TOPIC     , "kvi_topic.gif"  ,__i18n__("Topic changes")        },
	{ KVI_OUT_OWN       , "kvi_own.gif"    ,__i18n__("Own channel text")     },
	{ KVI_OUT_ECHO      , "kvi_echo.gif"   ,__i18n__("Echo")                 },
	{ KVI_OUT_PRIVMSG   , "kvi_privm.gif"  ,__i18n__("Private messages")     },
	{ KVI_OUT_NOTICE    , "kvi_notic.gif"  ,__i18n__("Notices")              },
	{ KVI_OUT_RAW       , "kvi_raw.gif"    ,__i18n__("Raw messages")         },
	{ KVI_OUT_ACTION    , "kvi_act.gif"    ,__i18n__("Actions (CTCP)")       },
	{ KVI_OUT_FLOOD     , "kvi_flood.gif"  ,__i18n__("Flood warnings")       },
	{ KVI_OUT_WHO       , "kvi_who.gif"    ,__i18n__("Whois messages")       },
	{ KVI_OUT_TIME      , "kvi_time.gif"   ,__i18n__("Time")                 },
	{ KVI_OUT_STDOUT    , "kvi_stdo.gif"   ,__i18n__("Process stdout")       },
	{ KVI_OUT_STDERR    , "kvi_stde.gif"   ,__i18n__("Process stderr")       },
	{ KVI_OUT_STDIN     , "kvi_stdi.gif"   ,__i18n__("Process stdin")        },
	{ KVI_OUT_AWAY      , "kvi_away.gif"   ,__i18n__("Away message")         },
	{ KVI_OUT_BACK      , "kvi_back.gif"   ,__i18n__("Back message")         },
	{ KVI_OUT_DNS       , "kvi_dns.gif"    ,__i18n__("DNS query")            },
	{ KVI_OUT_INVITE    , "kvi_invite.gif" ,__i18n__("Invite messages")      },
	{ KVI_OUT_SOUND     , "kvi_sound.gif"  ,__i18n__("CTCP Sound messages")  },
	{ KVI_OUT_DCCD      , "kvi_dccd.gif"   ,__i18n__("DCC Daemon messages")  }
};

//============ KviFrame ============//
KviFrame::KviFrame() : KTMainWindow()
{
	_debug_entertrace("KviFrame");

	m_lpSetup          = new KviSetup();
	m_lpSetup->setup();

	readSettings();
	createPixmaps();

	m_bFocusManagingEnabled=true;
	m_bRestarting=false;

	m_lpGlobalUserList = new KviGlobalUserList();
	m_lpClr            = new KviMircColors(this); //creates the this->m_lpColor[16] colors!!!
	m_lpInt            = new KviInterface();
	m_lpUsr            = new KviUser();
	m_lpSrv            = new KviServerManager();
	m_lpGlb            = new KviGlobals();
	m_lpOpt            = new KviOptions();
	m_lpUserParser     = new KviUserParser();
	m_lpAliasManager   = new KviAliasManager();
	m_lpEventManager   = new KviEventManager();
	m_lpPopupManager   = new KviPopupManager();
	m_lpAudio          = new KviAudio(m_lpOpt);
	m_lpTranslator     = new KviTranslator();
	m_lpNetscape       = new KviNetscapeController();
	m_lpDns            = new KviDns();
	m_lpAsciiPlayer    = new KviAsciiPlayer(this);
	m_lpUserManager    = new KviUserManager();

	connect(m_lpDns,SIGNAL(dnsDone(const char *)),this,SLOT(dnsQueryDone(const char *)));

	m_lpScriptManager  = new KviScriptManager(this);
	//set the translation file
	if(m_lpOpt->bUseTranslation){
		if(!strcasecmp(m_lpOpt->szTranslationFile,KVI_STR_NONE))m_lpOpt->bUseTranslation=false;
		else {
			if(!m_lpTranslator->setTranslationMap(m_lpOpt->szTranslationFile.data())){
				m_lpOpt->bUseTranslation=false;
				m_lpOpt->szTranslationFile=KVI_STR_NONE;
			}
		}
	}

	connect(m_lpPopupManager->m_lpUserNickListPopup,SIGNAL(actionSelected(const char *)),this,SLOT(nickListUserSlot(const char *)));
	connect(m_lpPopupManager->m_lpUserChanPopup,SIGNAL(actionSelected(const char *)),this,SLOT(chanUserSlot(const char *)));
	connect(m_lpPopupManager->m_lpUserActionPopup,SIGNAL(actionSelected(const char *)),this,SLOT(slotUserAction(const char *)));
	connect(m_lpPopupManager->m_lpUserChatPopup,SIGNAL(actionSelected(const char *)),this,SLOT(chatUserSlot(const char *)));
	connect(m_lpPopupManager->m_lpUserQueryPopup,SIGNAL(actionSelected(const char *)),this,SLOT(queryUserSlot(const char *)));

	createToolbarsPopup();
	createStatusBar();
	createMdiManager();

	createNickListPopup();
	createNotifyListPopup();
	createStatusPopup();
	createChanPopup();
	createMenuBar();

	m_lpToolBar = new KviToolBar(this);
	addToolBar(m_lpToolBar);
	m_lpToolBar->setItemEnabled(2,false);	

//	setCaption((m_lpOpt->szCaption.isEmpty() ? KVI_FRAME_CAPTION : m_lpOpt->szCaption.data()));
	setFocusPolicy(QWidget::StrongFocus);
	setFocusTargetRecursive(this,m_lpMdi);

	m_lpConsole        = new KviStatusWnd(m_lpMdi,this);
	m_lpMdi->addChild(m_lpConsole);
	m_lpConsole->setGeometry(m_statusWndRect);
	m_lpConsole->m_bMaximized=m_bStatusWndMaximized;

	m_lpServerParser   = new KviServerParser(this);
	m_lpSock           = new KviIrcSocket(this);
	m_lpProxy          = new KviProxy(m_lpSock,this);
	m_lpServerParser->activate(m_lpSock);
	m_lpUserParser->activate(this);

	m_lpDCCD=new KviDCCDaemon(this,m_lpOpt);
	startDCCDaemon();

	m_lpStatusBar->activate(m_lpUserParser->m_lpIdentifiers);
	m_lpStatusBar->setDefaultLabelText(m_lpOpt->szStatusMsg.data());

	m_iCurHostIdx=0;
	m_bCanReconnect=true;
	m_bReconnecting=false;

	m_iNextChildIdx=0;

	m_lpIsOnList       = new QList<KviIsonStruct>;
	m_lpIsOnList->setAutoDelete(true);

	m_lpReconnectTimer = new QTimer();
	m_lpNotifyTimer    = new QTimer();
	m_lpUserHostTimer  = new QTimer();
	m_lpDestroyTimer   = new QTimer();

	connect(m_lpDestroyTimer,SIGNAL(timeout()),this,SLOT(destroySlot()));
	connect(m_lpNotifyTimer,SIGNAL(timeout()),this,SLOT(checkNotifyList()));
	connect(m_lpReconnectTimer,SIGNAL(timeout()),this,SLOT(reconnectionSlot()));
	connect(m_lpUserHostTimer,SIGNAL(timeout()),this,SLOT(doUserHost()));

	m_szNextUserHostQuery="";
	applyOptions();
	clearHostDescription();
	m_lpLastChildToDestroy=0;
	setWindowCaption();
	setBarPositions();
	show();
	//call the Startup Event now...
	if(m_lpEventManager->lpEvent[KVI_Event_OnStartup]->bEnabled){
			QString szPara=KVI_VERSION;
			m_lpUserParser->executeEvent(m_lpConsole,m_lpEventManager->lpEvent[KVI_Event_OnStartup],szPara);
	}
	m_lpLinksWindow=0;
	m_lpVoiceWnd=0;
	m_lpChanListWindow=0;
	m_lpGlb->szNick		= m_lpUsr->szNick.copy();
	if(m_lpGlb->szNick.isEmpty())m_lpGlb->szNick=KVI_STR_NULL; //No nickname specified
	_debug_leavetrace("KviFrame");
}
//============ ~KviFrame ============//
KviFrame::~KviFrame()
{
	_debug_entertrace("~KviFrame");
	if(!m_bRestarting){
		if(m_lpEventManager->lpEvent[KVI_Event_OnShutdown]->bEnabled){
				QString szPara=KVI_VERSION;
				m_lpUserParser->executeEvent(m_lpConsole,m_lpEventManager->lpEvent[KVI_Event_OnShutdown],szPara);
		}
	}
	_macro_kviApplication->processEvents();
	saveSettings();
	if(m_lpUserHostTimer->isActive())m_lpUserHostTimer->stop();
	while(!m_lpIsOnList->isEmpty())m_lpIsOnList->removeLast();
	delete m_lpIsOnList;
	if(m_lpDestroyTimer->isActive())m_lpDestroyTimer->stop();
	if(m_lpReconnectTimer->isActive())m_lpReconnectTimer->stop();
	if(m_lpNotifyTimer->isActive())m_lpNotifyTimer->stop();
	//Kill the notifiers for DCC Chats&Sends (this to avoid the segfault when chatting to loopback (127.0.0.1))
	for(KviMdiChild *lpC=m_lpMdi->m_lpChildList->first();lpC;lpC=m_lpMdi->m_lpChildList->next()){
		if(lpC->type()==KVI_WND_TYPE_CHAT){
			((KviChatWnd *)lpC)->killNotifiers();
		} else {
			if(lpC->type()==KVI_WND_TYPE_SEND){
				((KviSendWnd *)lpC)->killNotifiers();
			}
		}
	}
	delete m_lpDCCD;
	delete m_lpUserManager;
	delete m_lpUserHostTimer;
	delete m_lpNotifyTimer;
	delete m_lpAsciiPlayer;
	delete m_lpSock; //first kill the socket...
	delete m_lpProxy;
	delete m_lpToolbarsPopup;
	delete m_lpStatusBar;
	delete m_lpMenuBar;
		delete m_lpSettingsPopup;
		delete m_lpMainPopup;
		delete m_lpActionsPopup;
		delete m_lpUModePopup;
	delete m_lpNotifyListPopup;
	delete m_lpNickListPopup;
		delete m_lpControlPopup;
		delete m_lpCTCPPopup;
		delete m_lpDCCPopup;
		delete m_lpInfoPopup;
		delete m_lpToolPopup;
	delete m_lpStatusPopup;
		delete m_lpStatsPopup;
	if(m_lpVoiceWnd)delete m_lpVoiceWnd;
	delete m_lpPopupManager;
	delete m_lpChanPopup;
	delete m_lpToolBar;
	delete m_lpMdi;
	delete m_lpInt;
	delete m_lpUsr;
	delete m_lpSrv;
	delete m_lpGlb;
	delete m_lpOpt;
	delete m_lpServerParser;
	delete m_lpAliasManager;
	delete m_lpEventManager;
	delete m_lpAudio;
	delete m_lpTranslator;
	delete m_lpNetscape;
	delete m_lpSetup;
	delete m_lpClr; //destroys the colors!!!!!!!
	delete m_lpDns;
	destroyPixmaps();
	delete m_lpScriptManager;
	delete m_lpUserParser;
	delete m_lpGlobalUserList;
	delete m_lpVoicePixmap;
	delete m_lpOpPixmap;
	_debug_leavetrace("~KviFrame");
}
//============ setBarPositions ============//
void KviFrame::setBarPositions()
{
	_debug_entertrace("setBarPositions");
	KConfig *lpCfg=_macro_kviConfig;
	lpCfg->setGroup("KviToolBars");
	QString szStr=lpCfg->readEntry("taskBarPosition","Bottom");
	setBarPosition(szStr,m_lpMdi->m_lpTaskBar);
	if(lpCfg->readNumEntry("taskBarVisible",true)){
		m_lpMdi->m_lpTaskBar->show();
		m_lpToolbarsPopup->setItemChecked(1,true);
	} else m_lpMdi->m_lpTaskBar->hide();
	szStr=lpCfg->readEntry("toolBarPosition","Top");
	setBarPosition(szStr,m_lpToolBar);
	if(lpCfg->readNumEntry("toolBarVisible",true)){
		m_lpToolBar->show();
		m_lpToolbarsPopup->setItemChecked(0,true);
	} else m_lpToolBar->hide();
	szStr=lpCfg->readEntry("statusBarPosition","Bottom");
	setBarPosition(szStr,m_lpStatusBar);
	if(lpCfg->readNumEntry("statusBarVisible",true)){
		m_lpStatusBar->show();
		m_lpToolbarsPopup->setItemChecked(2,true);
	} else m_lpStatusBar->hide();
	_debug_leavetrace("setBarPositions");
}
//============ createToolbarsPopup ============//
void KviFrame::createToolbarsPopup()
{
	_debug_entertrace("createToolbarsPopup");
	m_lpToolbarsPopup=new QPopupMenu();
	m_lpToolbarsPopup->insertItem(i18n("&Show ToolBar"),this,SLOT(toggleToolBar()),0,0);
	m_lpToolbarsPopup->insertItem(i18n("Show &TaskBar"),this,SLOT(toggleTaskBar()),0,1);
	m_lpToolbarsPopup->insertItem(i18n("Show Status&Bar"),this,SLOT(toggleStatusBar()),0,2);
	_debug_leavetrace("createToolbarsPopup");
}
//============ toggleToolBar ============//
void KviFrame::toggleToolBar()
{
	_debug_entertrace("toggleToolBar");
	if(m_lpToolBar->isVisible()){
		m_lpToolBar->hide();
		m_lpToolbarsPopup->setItemChecked(0,false);
	} else {
		m_lpToolBar->show();
		m_lpToolbarsPopup->setItemChecked(0,true);
	}
	updateRects();
	_debug_leavetrace("toggleToolBar");
}
//============ toggleTaskBar ============//
void KviFrame::toggleTaskBar()
{
	_debug_entertrace("toggleTaskBar");
	if(m_lpMdi->m_lpTaskBar->isVisible()){
		m_lpMdi->m_lpTaskBar->hide();
		m_lpToolbarsPopup->setItemChecked(1,false);
	} else {
		m_lpMdi->m_lpTaskBar->show();
		m_lpToolbarsPopup->setItemChecked(1,true);
	}
	updateRects();
	_debug_leavetrace("toggleTaskBar");
}
//============ toggleStatusBar ============//
void KviFrame::toggleStatusBar()
{
	_debug_entertrace("toggleStatusBar");
	if(m_lpStatusBar->isVisible()){
		m_lpStatusBar->hide();
		m_lpToolbarsPopup->setItemChecked(2,false);
	} else {
		m_lpStatusBar->show();
		m_lpToolbarsPopup->setItemChecked(2,true);
	}
	updateRects();
	_debug_leavetrace("toggleStatusBar");
}
//============ setWindowCaption ============//
void KviFrame::setWindowCaption()
{
	_debug_entertrace("setWindowCaption");
	QString szCaption=i18n("[ no connection ] - ");
	if(m_lpSock){
		if(m_lpSock->m_bConnected){
			szCaption="[";
			szCaption+=m_lpGlb->szNick.data();
			szCaption+=i18n(" on ");
			szCaption+=m_lpGlb->szServerName.data();
			szCaption+="] - ";
		}
	}
	szCaption+=m_lpOpt->szCaption.data();
	setCaption(szCaption.data());
	_debug_leavetrace("setWindowCaption");
}
//============ doLinksWindow ============//
void KviFrame::doLinksWindow()
{
	_debug_entertrace("doLinksWindow");
	if(m_lpLinksWindow)return;
	if(!m_lpSock->m_bConnected)return;
	m_iNextChildIdx++;
	m_lpLinksWindow=new KviLinkWnd(m_lpMdi,this,m_iNextChildIdx);
	m_lpMdi->addChild(m_lpLinksWindow);
	m_lpToolBar->setItemEnabled(2,false);	
	_debug_leavetrace("doLinksWindow");
}
//============ doChansWindow ============//
void KviFrame::doChansWindow()
{
	_debug_entertrace("doChansWindow");
	if(m_lpChanListWindow)return;
	if(m_lpSock->m_bConnected){
		if(KMsgBox::yesNo(this,i18n("Channel list"),i18n("Request new channel list from server\nor use the latest list saved?")
			,KMsgBox::QUESTION,i18n("Request new list"),i18n("Use the latest list"))==1){
			//request the links
			m_lpSock->sendData("LIST");
			m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,"Sent /LIST command. Waiting for reply...");
			return;
		}
	}
	createChanListWindow(true);
	_debug_leavetrace("doChansWindow");
}
//============ createChanListWindow ============//
void KviFrame::createChanListWindow(bool bReadFromFile)
{
	_debug_entertrace("createChanListWindow");
	m_iNextChildIdx++;
	m_lpChanListWindow=new KviChanListWnd(m_lpMdi,this,m_iNextChildIdx,bReadFromFile);
	m_lpMdi->addChild(m_lpChanListWindow);
	m_lpToolBar->setItemEnabled(3,false);
	_debug_leavetrace("createChanListWindow");
}
//============ linksWindowClosed ============//
void KviFrame::linksWindowClosed()
{
	_debug_entertrace("linksWindowClosed");
	m_lpLinksWindow=0;
	if(m_lpSock->m_bConnected)m_lpToolBar->setItemEnabled(2,true);	
	_debug_leavetrace("linksWindowClosed");
}
//============ chanListWindowClosed ============//
void KviFrame::chanListWindowClosed()
{
	_debug_entertrace("chanListWindowClosed");
	m_lpChanListWindow=0;
	m_lpToolBar->setItemEnabled(3,true);	
	_debug_leavetrace("chanListWindowClosed");
}
//============ formatNickOutputString ============//
void KviFrame::formatNickOutputString(QString &szResult,QString &szNick)
{
	_debug_entertrace("formatNickOutputString");
	if(m_lpOpt->bInverseNick){
		szResult="<\x016";
		szResult+=szNick;
		szResult+="\x0f>";
		if(m_lpOpt->bAlignText){
			if(szResult.length()<14){
				szResult.setExpand(11,(m_lpOpt->bPrefixMsg ? ':' : ' '));
			} else szResult+=(m_lpOpt->bPrefixMsg ? ':' : ' ');
		} else {
			szResult+=(m_lpOpt->bPrefixMsg ? ':' : ' ');
		}
	} else {
		szResult="<";
		szResult+=szNick;
		szResult+=">";
		if(m_lpOpt->bAlignText){
			if(szResult.length()<12){
				szResult.setExpand(11,(m_lpOpt->bPrefixMsg ? ':' : ' '));
			} else szResult+=(m_lpOpt->bPrefixMsg ? ':' : ' ');
		} else {
			szResult+=(m_lpOpt->bPrefixMsg ? ':' : ' ');
		}
	}
	_debug_leavetrace("formatNickOutputString");
}
//============ setBarPosition ============//
void KviFrame::setBarPosition(QString &szString,KToolBar *bar)
{
	_debug_entertrace("setBarPosition");
	if(szString=="Top"){
		bar->setBarPos(KToolBar::Top);
		return;
	}
	if(szString=="Bottom"){
		bar->setBarPos(KToolBar::Bottom);
		return;
	}
	if(szString=="Left"){
		bar->setBarPos(KToolBar::Left);
		return;
	}
	if(szString=="Right"){
		bar->setBarPos(KToolBar::Right);
		return;
	}
	if(szString=="Floating"){
		bar->setBarPos(KToolBar::Floating);
		return;
	}
//	if(szString=="Flat"){
//		bar->setBarPos(KToolBar::Flat);
//	}
//	_macro_kviApplication->processEvents();
//	if(!szGeometry.isEmpty())setGeometry(KWM::setProperties(bar->winId(),szGeometry));
	_debug_leavetrace("setBarPosition");
}
//============ getBarPositionString ============//
void KviFrame::getBarPositionString(QString &szString,KToolBar *bar)
{
	_debug_entertrace("getBarPositionString");
	switch(bar->barPos()){
		case KToolBar::Top:
			szString="Top";
			break;
		case KToolBar::Bottom:
			szString="Bottom";
			break;
		case KToolBar::Right:
			szString="Right";
			break;
		case KToolBar::Left:
			szString="Left";
			break;
		case KToolBar::Floating:
			szString="Floating";
			break;
		case KToolBar::Flat:
			szString="Top";
			break;
	}
	_debug_leavetrace("getBarPositionString");
}
//============ saveSettings ============//
void KviFrame::saveSettings()
{
	_debug_entertrace("saveSettings");
	KConfig *lpCfg=_macro_kviConfig;
	lpCfg->setGroup("KviFrame");
	lpCfg->writeEntry("geometry", KWM::getProperties(winId()));
	lpCfg->writeEntry("statusWnd",m_lpConsole->rect());
	lpCfg->writeEntry("statusWndMax",m_lpConsole->m_bMaximized);
	lpCfg->writeEntry("lastChanPannerPosition",m_iLastChanPannerPosition);
	lpCfg->setGroup("KviToolBars");
	lpCfg->writeEntry("taskBarVisible",m_lpMdi->m_lpTaskBar->isVisible());
	QString szPos;
	getBarPositionString(szPos,m_lpMdi->m_lpTaskBar);
	lpCfg->writeEntry("taskBarPosition",szPos.data());
//	lpCfg->writeEntry("taskBarGeometry",KWM::getProperties(m_lpMdi->m_lpTaskBar->winId()));
	lpCfg->writeEntry("toolBarVisible",m_lpToolBar->isVisible());
	getBarPositionString(szPos,m_lpToolBar);
	lpCfg->writeEntry("toolBarPosition",szPos.data());
//	lpCfg->writeEntry("toolBarGeometry",KWM::getProperties(m_lpToolBar->winId()));
	lpCfg->writeEntry("statusBarVisible",m_lpStatusBar->isVisible());
	getBarPositionString(szPos,m_lpStatusBar);
	lpCfg->writeEntry("statusBarPosition",szPos.data());
//	lpCfg->writeEntry("statusBarGeometry",KWM::getProperties(m_lpStatusBar->winId()));
	_debug_leavetrace("saveSettings");
}
//============ readSettings ============//
void KviFrame::readSettings()
{
	_debug_entertrace("readSettings");
	KConfig *lpCfg=_macro_kviConfig;
	lpCfg->setGroup("KviFrame");
	QRect rct(0,0,650,350);
	m_statusWndRect= lpCfg->readRectEntry("statusWnd",&rct);
	m_bStatusWndMaximized=lpCfg->readNumEntry("statusWndMax",false);
	m_iLastChanPannerPosition=lpCfg->readNumEntry("lastChanPannerPosition",70);
	if((m_iLastChanPannerPosition > 95)||(m_iLastChanPannerPosition <= 0))m_iLastChanPannerPosition=95;
    // Use KWM for window properties
    QString geom = lpCfg->readEntry("geometry");
    if(!geom.isEmpty())setGeometry(KWM::setProperties(winId(),geom));
	else setGeometry(0,0,750,500);
	_debug_leavetrace("readSettings");
}
//============ viewDoubleClicked ============//
void KviFrame::viewDoubleClicked(QString &szString)
{
	_debug_entertrace("viewDoubleClicked");
	if(m_lpOpt->bRunBrowserOnUrl){
		//check for a url in the selectioin
		int idxUrl=szString.find("http:/");
		if(idxUrl<0){
			idxUrl=szString.find("ftp:/");
			if(idxUrl<0){
				idxUrl=szString.find("www");
				if(idxUrl<0){
					idxUrl=szString.find("ftp");
					if(idxUrl<0){
						idxUrl=szString.find("file:/");
					}
				}
			}
		}
		if(idxUrl>=0){
			szString.remove(0,idxUrl);
			if(m_lpOpt->bUseNetscape){
				if(!m_lpNetscape->openURL(szString.data())){
					m_lpConsole->doOutput(KVI_OUT_ERROR,i18n("[URLCatcher]:Unable to execute the openURL command on the remote Netscape."));
				}
			} else {
				if(!m_lpOpt->szBrowserCmdLine.isEmpty()){
					QString szCmd=m_lpOpt->szBrowserCmdLine.copy();
					if(_macro_boolSubstitutePercent(szCmd,szString)){
						if(!_macro_boolRunThroughShell(szCmd)){
							m_lpConsole->doFmtOutput(KVI_OUT_ERROR,i18n("[URLCatcher]:Unable to run the requested browser [%s]"),m_lpOpt->szBrowserCmdLine.data());
						}
					} else {
						m_lpConsole->doOutput(KVI_OUT_ERROR,i18n("[URLCatcher]:Browser commandline syntax error.The commandline must contain a '%'"));
					}
				} else {
					m_lpConsole->doOutput(KVI_OUT_ERROR,i18n("[URLCatcher]:Browser commandline empty. Don't know which browser to run."));
				}
			}
		}	
	}	
	_debug_leavetrace("viewDoubleClicked");
}
//============ applyOptions ============//
void KviFrame::applyOptions()
{
	_debug_entertrace("applyOptions");
	m_lpMdi->applyOptions();
	_debug_leavetrace("applyOptions");
}
//============ createMdiManager ============//
void KviFrame::createMdiManager()
{
	_debug_entertrace("createMdiManager");
	m_lpMdi = new KviMdiManager(this);
	setView(m_lpMdi);
	_debug_leavetrace("createMdiManager");
}
//============ createPixmaps ============//
void KviFrame::createPixmaps()
{
	_debug_entertrace("createPixmaps");
	KIconLoader *lpI=_macro_kviIconLoader;
	QPixmap pixmappa;
	for(int i=0;i<KVI_NUM_PIXMAPS;i++){
		pixmappa=lpI->loadIcon(pixTab[i].szPixName);
		if(!pixmappa.isNull())m_lpPixmap[pixTab[i].index]=new QPixmap(pixmappa);
		else _debug_fatal(i18n("Cannot find the base pixmaps...did you forget make install?"));
	}
	pixmappa=lpI->loadIcon("kvib_op.gif");
	if(pixmappa.isNull())m_lpOpPixmap=new QPixmap(*m_lpPixmap[KVI_OUT_OP]);
	else m_lpOpPixmap=new QPixmap(pixmappa);
	pixmappa=lpI->loadIcon("kvib_voice.gif");
	if(pixmappa.isNull())m_lpVoicePixmap=new QPixmap(*m_lpPixmap[KVI_OUT_VOICE]);
	else m_lpVoicePixmap=new QPixmap(pixmappa);

	for(int k=0;k<KVI_NUM_WND_TYPES;k++){
		pixmappa=lpI->loadIcon(icoTab[k].szPixName);
		if(!pixmappa.isNull())m_lpIcon[icoTab[k].index]=new QPixmap(pixmappa);
		else _debug_fatal(i18n("Cannot find the base pixmaps...did you forget make install?"));
	}
	_debug_leavetrace("createPixmaps");
}
//============ destroyPixmaps ============//
void KviFrame::destroyPixmaps()
{
	_debug_entertrace("destroyPixmaps");
	for(int i=0;i<KVI_NUM_PIXMAPS;i++)delete m_lpPixmap[i];
	for(int k=0;k<KVI_NUM_WND_TYPES;k++)delete m_lpIcon[k];
	_debug_leavetrace("destroyPixmaps");
}
//============ createChanWnd ============//
KviChanWnd * KviFrame::createChanWnd(const char *szName)
{
	_debug_entertrace("createChanWnd");
	m_iNextChildIdx++;
	KviChanWnd *lpW=new KviChanWnd(m_lpMdi,this,szName,m_iNextChildIdx);
	m_lpMdi->addChild(lpW);
	if(m_lpOpt->bAutoLogChannels)lpW->autoLog();
	_debug_leavetrace("createChanWnd");
	return lpW;
}
//============ createChatWnd ============//
KviChatWnd * KviFrame::createChatWnd(const char *szName)
{
	_debug_entertrace("createChatWnd");
	m_iNextChildIdx++;
	KviChatWnd *lpW=new KviChatWnd(m_lpMdi,this,szName,m_iNextChildIdx);
	m_lpMdi->addChild(lpW);
	if(m_lpOpt->bAutoLogChats)lpW->autoLog();
	_debug_leavetrace("createChatWnd");
	return lpW;
}
//============ createVoiceWnd ============//
KviVoiceWnd * KviFrame::createVoiceWnd(const char *szName)
{
	_debug_entertrace("createVoiceWnd");
	if(m_lpVoiceWnd)return 0;
	m_iNextChildIdx++;
	m_lpVoiceWnd=new KviVoiceWnd(m_lpMdi,this,szName,m_iNextChildIdx);
	m_lpMdi->addChild(m_lpVoiceWnd);
	_debug_leavetrace("createVoiceWnd");
	return m_lpVoiceWnd;
}

//============ createQueryWnd ============//
KviQueryWnd * KviFrame::createQueryWnd(const char *szName)
{
	_debug_entertrace("createQueryWnd");
	m_iNextChildIdx++;
	KviQueryWnd *lpW=new KviQueryWnd(m_lpMdi,this,szName,m_iNextChildIdx);
	if(m_lpOpt->bMinimizeQuery)m_lpMdi->addChildMinimized(lpW);
	else m_lpMdi->addChild(lpW);
	if(m_lpOpt->bAutoLogQueries)lpW->autoLog();
	_debug_leavetrace("createQueryWnd");
	return lpW;
}
//============ createSendWnd ============//
KviSendWnd * KviFrame::createSendWnd(const char *szName,bool bMinimized)
{
	_debug_entertrace("createSendWnd");
	m_iNextChildIdx++;
	KviSendWnd *lpW=new KviSendWnd(m_lpMdi,this,szName,m_iNextChildIdx);
	if(bMinimized)m_lpMdi->addChildMinimized(lpW);
	else m_lpMdi->addChild(lpW);
	_debug_leavetrace("createSendWnd");
	return lpW;
}
//============ createUserWnd ============//
KviUserWnd * KviFrame::createUserWnd(const char *szName,bool bMinimized,bool bHasInput,
								const char *szImage,QRect *geom)
{
	_debug_entertrace("createUserWnd");
	m_iNextChildIdx++;
	KviUserWnd *lpW=new KviUserWnd(m_lpMdi,this,bHasInput,szName,m_iNextChildIdx);
	bool bGeom=(geom ? false : true);
	if(geom)lpW->setGeometry((*geom));
	if(szImage)lpW->m_lpOutput->setUserBackground(szImage);
	if(bMinimized)m_lpMdi->addChildMinimized(lpW,bGeom);
	else m_lpMdi->addChild(lpW,bGeom);
	_debug_leavetrace("createUserWnd");
	return lpW;
}
//============ createStatusPopup ============//
void KviFrame::createStatusPopup()
{
	_debug_entertrace("createStatusPopup");
	m_lpStatusPopup = new QPopupMenu();
	m_lpStatsPopup  = new QPopupMenu();
	KIconLoader *lpI=_macro_kviIconLoader;
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_motd.gif"),i18n("View Message of the day"),this,SLOT(slotStatusMotd()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_kvirc.gif"),i18n("Query server version"),this,SLOT(slotStatusVersion()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_time.gif"),i18n("Query server's local time"),this,SLOT(slotStatusTime()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_info.gif"),i18n("Query server's info"),this,SLOT(slotStatusInfo()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_invite.gif"),i18n("Query admininstator e-mail"),this,SLOT(slotStatusAdmin()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvii_usr.gif"),i18n("Query users list"),this,SLOT(slotStatusUsers()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_info.gif"),i18n("Query users statistics"),this,SLOT(slotStatusLusers()));
	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_links.gif"),i18n("Query links"),this,SLOT(doLinksWindow()));
	
	m_lpStatsPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Query registered servers"),this,SLOT(slotStatusStatsC()));
	m_lpStatsPopup->insertItem(lpI->loadIcon("kvi_kline.gif"),i18n("Query K-Lines"),this,SLOT(slotStatusStatsK()));
	m_lpStatsPopup->insertItem(lpI->loadIcon("kvi_time.gif"),i18n("Query server's live time"),this,SLOT(slotStatusStatsU()));
	m_lpStatsPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Query commands supported"),this,SLOT(slotStatusStatsM()));

	m_lpStatusPopup->insertItem(lpI->loadIcon("kvi_info.gif"),i18n("Stats"),m_lpStatsPopup);
	_debug_leavetrace("createStatusPopup");
}
//============ Status Slots ============//
void KviFrame::slotStatusStatsM() {statusSlot("STATS m");}
void KviFrame::slotStatusStatsU() {statusSlot("STATS u");}
void KviFrame::slotStatusStatsK() {statusSlot("STATS k");}
void KviFrame::slotStatusStatsC() {statusSlot("STATS c");}
void KviFrame::slotStatusLusers() {statusSlot("LUSERS");}
void KviFrame::slotStatusUsers()  {statusSlot("USERS");}
void KviFrame::slotStatusAdmin()  {statusSlot("ADMIN");}
void KviFrame::slotStatusInfo()   {statusSlot("INFO");}
void KviFrame::slotStatusMotd()   {statusSlot("MOTD");}
void KviFrame::slotStatusVersion(){statusSlot("VERSION");}
void KviFrame::slotStatusTime()   {statusSlot("TIME");}
//============ statusSlot ============//
void KviFrame::statusSlot(const char *sendData)
{
	_debug_entertrace("statusSlot");
	if(m_lpSock->m_bConnected)m_lpSock->sendData(sendData);
	_debug_leavetrace("statusSlot");
}
//============ createNotifyListPopup ============//
void KviFrame::createNotifyListPopup()
{
	_debug_entertrace("createNotifyListPopup");
	m_lpNotifyListPopup = new QPopupMenu();
	KIconLoader *lpI=_macro_kviIconLoader;
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvi_who.gif"),i18n("Whois"),this,SLOT(slotNotifyWhois()));
	m_lpNotifyListPopup->insertSeparator();
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvi_ping.gif"),i18n("Ping"),this,SLOT(slotNotifyPing()));
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvi_kvirc.gif"),i18n("Version"),this,SLOT(slotNotifyVersion()));
	m_lpNotifyListPopup->insertSeparator();
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvii_qery.gif"),i18n("Query"),this,SLOT(slotNotifyQuery()));
	m_lpNotifyListPopup->insertSeparator();
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvii_chat.gif"),i18n("DCC Chat"),this,SLOT(slotNotifyDCCChat()));
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvii_send.gif"),i18n("DCC Send"),this,SLOT(slotNotifyDCCSend()));
	m_lpNotifyListPopup->insertItem(lpI->loadIcon("kvii_voice.gif"),i18n("DCC Voice"),this,SLOT(slotNotifyDCCVoice()));
	_debug_leavetrace("createNotifyListPopup");
}
//============ createNickListPopup ============//
void KviFrame::createNickListPopup()
{
	_debug_entertrace("createNickListPopup");
	m_lpNickListPopup = new QPopupMenu();
	m_lpControlPopup  = new QPopupMenu();
	m_lpCTCPPopup     = new QPopupMenu();
	m_lpDCCPopup      = new QPopupMenu();
	m_lpInfoPopup     = new QPopupMenu();
	m_lpToolPopup     = new QPopupMenu();
	KIconLoader *lpI=_macro_kviIconLoader;
	m_lpControlPopup->insertItem(lpI->loadIcon("kvi_op.gif"),i18n("Op"),this,SLOT(slotOp()));
	m_lpControlPopup->insertItem(lpI->loadIcon("kvi_deop.gif"),i18n("Deop"),this,SLOT(slotDeop()));
	m_lpControlPopup->insertItem(lpI->loadIcon("kvi_voice.gif"),i18n("Voice"),this,SLOT(slotVoice()));
	m_lpControlPopup->insertItem(lpI->loadIcon("kvi_devoi.gif"),i18n("Devoice"),this,SLOT(slotDevoice()));
	m_lpControlPopup->insertItem(lpI->loadIcon("kvi_kick.gif"),i18n("Kick"),this,SLOT(slotKick()));
	m_lpControlPopup->insertItem(lpI->loadIcon("kvi_ban.gif"),i18n("Kick & ban"),this,SLOT(slotKBan()));

	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_ping.gif"),i18n("Ping"),this,SLOT(slotPing()));
	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_kvirc.gif"),i18n("Version"),this,SLOT(slotVersion()));
	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_time.gif"),i18n("Time"),this,SLOT(slotTime()));
	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Clientinfo"),this,SLOT(slotClientinfo()));
	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_who.gif"),i18n("Userinfo"),this,SLOT(slotUserinfo()));
	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Finger"),this,SLOT(slotFinger()));
	m_lpCTCPPopup->insertItem(lpI->loadIcon("kvi_kvirc.gif"),i18n("Source"),this,SLOT(slotSource()));

	m_lpInfoPopup->insertItem(lpI->loadIcon("kvi_who.gif"),i18n("Whois"),this,SLOT(slotWhois()));

	m_lpInfoPopup->insertItem(lpI->loadIcon("kvi_who.gif"),i18n("Whois with idle time"),this,SLOT(slotWhoWho()));
	m_lpInfoPopup->insertItem(lpI->loadIcon("kvi_who.gif"),i18n("Whowas"),this,SLOT(slotWhowas()));
	m_lpInfoPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Userlist entry"),this,SLOT(slotUserlist()));

	m_lpDCCPopup->insertItem(lpI->loadIcon("kvii_chat.gif"),i18n("Chat"),this,SLOT(slotChat()));
	m_lpDCCPopup->insertItem(lpI->loadIcon("kvii_send.gif"),i18n("Send"),this,SLOT(slotDCCSend()));
	m_lpDCCPopup->insertItem(lpI->loadIcon("kvii_voice.gif"),i18n("Voice"),this,SLOT(slotDCCVoice()));

	m_lpToolPopup->insertItem(lpI->loadIcon("kvi_clone.gif"),i18n("Clonescan"),this,SLOT(slotClonescan()));

	m_lpNickListPopup->insertItem(lpI->loadIcon("kvi_own.gif"),i18n("Control..."),m_lpControlPopup,1);
	m_lpNickListPopup->insertItem(lpI->loadIcon("kvi_ctcp.gif"),i18n("Ctcp..."),m_lpCTCPPopup,2);
	m_lpNickListPopup->insertItem(lpI->loadIcon("kvi_conn.gif"),i18n("Dcc..."),m_lpDCCPopup,3);
	m_lpNickListPopup->insertSeparator();
	m_lpNickListPopup->insertItem(lpI->loadIcon("kvi_info.gif"),i18n("Info..."),m_lpInfoPopup,4);
	m_lpNickListPopup->insertSeparator();
	m_lpNickListPopup->insertItem(lpI->loadIcon("kvi_raw.gif"),i18n("Tools..."),m_lpToolPopup,5);
	m_lpNickListPopup->insertSeparator();
	m_lpNickListPopup->insertItem(lpI->loadIcon("kvii_qery.gif"),i18n("Query"),this,SLOT(slotQuery()),0,6);
	m_lpNickListPopup->insertSeparator();
	m_lpNickListPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),m_lpPopupManager->szNickListPopup.data(),
														m_lpPopupManager->m_lpUserNickListPopup,7);

	_debug_leavetrace("createNickListPopup");
}
//============ createChanPopup ============//
void KviFrame::createChanPopup()
{
	_debug_entertrace("createChanPopup");
	m_lpChanPopup=new QPopupMenu();
	KIconLoader *lpI=_macro_kviIconLoader;
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_kvirc.gif"),i18n("KVirc"),this,SLOT(slotChanKvirc()),0,1);
	m_lpChanPopup->insertSeparator();
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_ban.gif"),i18n("Edit ban list"),this,SLOT(slotChanBanlist()),0,3);
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_who.gif"),i18n("View userlist"),this,SLOT(slotChanUserlist()),0,4);
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_clone.gif"),i18n("Clonescan"),this,SLOT(slotChanClonescan()),0,5);
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_sound.gif"),i18n("Play sound"),this,SLOT(slotChanSound()),0,6);
	m_lpChanPopup->insertSeparator();
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_part.gif"),i18n("Part channel"),this,SLOT(slotChanPart()),0,7);
	m_lpChanPopup->insertSeparator();
	m_lpChanPopup->insertItem(lpI->loadIcon("kvi_echo.gif"),m_lpPopupManager->szChanPopup.data(),
															m_lpPopupManager->m_lpUserChanPopup,8);
	_debug_leavetrace("createChanPopup");
}
//============ slotChanSound ============//
void KviFrame::slotChanSound()
{
	_debug_entertrace("slotChanSound");
	QString szToDo="/SOUND";
	if(m_lpGlb->lpCurrentChan)m_lpUserParser->parseUserInput(m_lpGlb->lpCurrentChan,KVI_WND_TYPE_CHAN,m_lpGlb->lpCurrentChan->name(),szToDo);
	_debug_leavetrace("slotChanSound");
}
//============ requestChanPopup ============//
void KviFrame::requestChanPopup(QPoint pnt)
{
	_debug_entertrace("requestChanPopup");
	if(m_lpGlb->lpCurrentChan)m_lpChanPopup->popup(pnt);
	_debug_leavetrace("requestChanPopup");
}
//============ requestChatPopup ============//
void KviFrame::requestChatPopup(QPoint pnt)
{
	_debug_entertrace("requestChatPopup");
	if(m_lpGlb->lpCurrentChat)m_lpPopupManager->m_lpUserChatPopup->popup(pnt);
	_debug_leavetrace("requestChatPopup");
}
//============ requestQueryPopup ============//
void KviFrame::requestQueryPopup(QPoint pnt)
{
	_debug_entertrace("requestQueryPopup");
	if(m_lpGlb->lpCurrentQuery)m_lpPopupManager->m_lpUserQueryPopup->popup(pnt);
	_debug_leavetrace("requestQueryPopup");
}
//============ requestStatusPopup ============//
void KviFrame::requestStatusPopup(QPoint pnt)
{
	_debug_entertrace("requestStatusPopup");
	if(m_lpSock->m_bConnected){
		m_lpStatusPopup->popup(pnt);
	} else {
		m_lpMainPopup->popup(pnt);
	}
	_debug_leavetrace("requestStatusPopup");
}
//Popup slots
void KviFrame::slotOp(){            nickListSlot("/OP");}
void KviFrame::slotDeop(){          nickListSlot("/DEOP");}
void KviFrame::slotVoice(){         nickListSlot("/VOICE");}
void KviFrame::slotDevoice(){       nickListSlot("/DEVOICE");}
void KviFrame::slotQuery(){         nickListSlot("/QUERY");}
void KviFrame::slotPing(){          nickListSlot("/CTCP PING");}
void KviFrame::slotChat(){          nickListSlot("/CHAT");}
void KviFrame::slotVersion(){       nickListSlot("/CTCP VERSION");}
void KviFrame::slotTime(){          nickListSlot("/CTCP TIME");}
void KviFrame::slotClientinfo(){    nickListSlot("/CTCP CLIENTINFO");}
void KviFrame::slotUserinfo(){      nickListSlot("/CTCP USERINFO");}
void KviFrame::slotFinger(){        nickListSlot("/CTCP FINGER");}
void KviFrame::slotSource(){        nickListSlot("/CTCP SOURCE");}
void KviFrame::slotWhois(){         nickListSlot("/WHOIS");}
void KviFrame::slotKick(){          nickListSlot("/KICK");}
void KviFrame::slotDCCSend(){       nickListSlot("/SEND");}
void KviFrame::slotDCCVoice(){      nickListSlot("/TALK");}
void KviFrame::slotKBan(){          nickListSlot("/KBAN");}
void KviFrame::slotWhowas(){        nickListSlot("/WHOWAS");}
void KviFrame::slotWhoWho(){        nickListSlot("/WHOIS -i");}
void KviFrame::slotUserlist(){      nickListSlot("/USERLIST");}
void KviFrame::slotClonescan(){     nickListSlot("/CLONESCAN");}
void KviFrame::slotNotifyWhois(){   notifyListSlot("/WHOIS");}
void KviFrame::slotNotifyPing(){    notifyListSlot("/CTCP PING");}
void KviFrame::slotNotifyDCCChat(){ notifyListSlot("/CHAT");}
void KviFrame::slotNotifyDCCSend(){ notifyListSlot("/SEND");}
void KviFrame::slotNotifyDCCVoice(){notifyListSlot("/TALK");}
void KviFrame::slotNotifyVersion(){ notifyListSlot("/CTCP VERSION");}
void KviFrame::slotNotifyQuery(){   notifyListSlot("/QUERY");}
//============ slotChanClonescan ============//
void KviFrame::slotChanClonescan()
{
	_debug_entertrace("slotChanClonescan");
	QString szToDo="/CLONESCAN";
	if(m_lpGlb->lpCurrentChan)m_lpUserParser->parseUserInput(m_lpGlb->lpCurrentChan,KVI_WND_TYPE_CHAN,m_lpGlb->lpCurrentChan->name(),szToDo);
	_debug_leavetrace("slotChanClonescan");
}
//============ slotChanKvirc ============//
void KviFrame::slotChanKvirc()
{
	_debug_entertrace("slotChanKvirc");
	QString szToDo="$_version";
	if(m_lpGlb->lpCurrentChan)m_lpUserParser->parseUserInput(m_lpGlb->lpCurrentChan,KVI_WND_TYPE_CHAN,m_lpGlb->lpCurrentChan->name(),szToDo);
	_debug_leavetrace("slotChanKvirc");
}
//============ slotChanUserlist ============//
void KviFrame::slotChanUserlist()
{
	_debug_entertrace("slotChanUserlist");
	if(m_lpGlb->lpCurrentChan)m_lpGlb->lpCurrentChan->doUserList();
	_debug_leavetrace("slotChanUserlist");
}
//============ slotChanPart ============//
void KviFrame::slotChanPart()
{
	_debug_entertrace("slotChanPart");
	if(m_lpGlb->lpCurrentChan)m_lpGlb->lpCurrentChan->slotClose();
	_debug_leavetrace("slotChanPart");
}
//============ slotChanBanlist ============//
void KviFrame::slotChanBanlist()
{
	_debug_entertrace("slotChanBanlist");
	m_bFocusManagingEnabled=false;
	if(m_lpGlb->lpCurrentChan)m_lpGlb->lpCurrentChan->doBanDialog();
	m_bFocusManagingEnabled=true;
	_debug_leavetrace("slotChanBanlist");
}

//============ nickListSlot ============//
void KviFrame::nickListSlot(const char *szCommand){
	if(!m_lpGlb->szCurrentSelection.isEmpty() && m_lpGlb->lpCurrentChan){
		QString szToDo=szCommand;
		szToDo+=' ';
		szToDo+=m_lpGlb->szCurrentSelection;
		m_lpUserParser->parseUserInput(m_lpGlb->lpCurrentChan,KVI_WND_TYPE_CHAN,m_lpGlb->lpCurrentChan->name(),szToDo);
	}
}
//============ nickListUserSlot ============//
void KviFrame::nickListUserSlot(const char *szCommand)
{
	_debug_entertrace("nickListUserSlot");
	if(!m_lpGlb->szCurrentSelection.isEmpty() && m_lpGlb->lpCurrentChan){
		QString szToDo=szCommand;
		m_lpUserParser->executePopup(m_lpGlb->lpCurrentChan,szToDo);
	}
	_debug_leavetrace("nickListUserSlot");
}
//=========== chanUserSlot =============//
void KviFrame::chanUserSlot(const char *szCommand)
{
	_debug_entertrace("chanUserSlot");
	if(m_lpGlb->lpCurrentChan){
		QString szToDo=szCommand;
		m_lpUserParser->executePopup(m_lpGlb->lpCurrentChan,szToDo);
	}
	_debug_leavetrace("chanUserSlot");
}
//=========== chatUserSlot =============//
void KviFrame::chatUserSlot(const char *szCommand)
{
	_debug_entertrace("chatUserSlot");
	if(m_lpGlb->lpCurrentChat){
		QString szToDo=szCommand;
		m_lpUserParser->executePopup(m_lpGlb->lpCurrentChat,szToDo);
	}
	_debug_leavetrace("chatUserSlot");
}
//=========== queryUserSlot =============//
void KviFrame::queryUserSlot(const char *szCommand)
{
	_debug_entertrace("queryUserSlot");
	if(m_lpGlb->lpCurrentQuery){
		QString szToDo=szCommand;
		m_lpUserParser->executePopup(m_lpGlb->lpCurrentQuery,szToDo);
	}
	_debug_leavetrace("queryUserSlot");
}
//============ slotUserAction ============//
void KviFrame::slotUserAction(const char *szAction)
{
	_debug_entertrace("slotUserAction");
	QString szToDo=szAction;
	m_lpUserParser->executePopup(m_lpConsole,szToDo);
	_debug_leavetrace("slotUserAction");
}
//============ notifyListSlot ============//
void KviFrame::notifyListSlot(const char *szCommand){
	if(!m_lpGlb->szCurrentNotifySelection.isEmpty()){
		QString szToDo=szCommand;
		szToDo+=' ';
		szToDo+=m_lpGlb->szCurrentNotifySelection;
		m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	}
}
//============ createMenuBar ============//
void KviFrame::createMenuBar()
{
	_debug_entertrace("createMenuBar");
	m_lpMenuBar = new KMenuBar(this,"KviMenuBar");
	KIconLoader *lpI=_macro_kviIconLoader;
	m_lpSettingsPopup = new QPopupMenu();
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_usr.gif"),i18n("User..."),this,SLOT(doUserDialog()));
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_srv.gif"),i18n("Servers and proxy..."),this,SLOT(doServerDialog()));
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_opt.gif"),i18n("Misc options..."),this,SLOT(doOptionsDialog()));
	m_lpSettingsPopup->insertSeparator();
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_int.gif"),i18n("Interface..."),this,SLOT(doInterfaceDialog()));
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_clr.gif"),i18n("Irc colors..."),this,SLOT(doIrcColorsDialog()));
	m_lpSettingsPopup->insertSeparator();
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_alias.gif"),i18n("Aliases..."),this,SLOT(doAliasDialog()));
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_event.gif"),i18n("Events..."),this,SLOT(doEventDialog()));
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_pop.gif"),i18n("Popups..."),this,SLOT(doPopupDialog()));
	m_lpSettingsPopup->insertSeparator();
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_save.gif"),i18n("Save settings"),this,SLOT(saveAllOptions()));
	m_lpSettingsPopup->insertSeparator();
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_load.gif"),i18n("Load a script"),this,SLOT(loadScript()));
	m_lpSettingsPopup->insertItem(lpI->loadIcon("kvii_save.gif"),i18n("Save current script"),this,SLOT(saveScript()));
	
	m_lpMainPopup = new QPopupMenu();
	m_lpMainPopup->insertItem(lpI->loadIcon("kvii_conn.gif"),i18n("Connect"),this,SLOT(connectionSlot()));
	m_lpMainPopup->insertSeparator();
	m_lpMainPopup->insertItem(lpI->loadIcon("kvi_kvirc.gif"),i18n("New KVirc window"),this,SLOT(newWindow()));
	m_lpMainPopup->insertSeparator();
	m_lpMainPopup->insertItem(lpI->loadIcon("kvi_disc.gif"),i18n("Quit"),_macro_kviApplication,SLOT(quit()));
	m_lpMainPopup->setId(0,0);

	m_lpUModePopup=new QPopupMenu();
	m_lpUModePopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Invisible"),this,SLOT(slotUModeI()));
	m_lpUModePopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Server notices"),this,SLOT(slotUModeS()));
	m_lpUModePopup->insertItem(lpI->loadIcon("kvi_echo.gif"),i18n("Wallops"),this,SLOT(slotUModeW()));

	m_lpActionsPopup=new QPopupMenu();
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvii_srv.gif"),i18n("Server info"),m_lpStatusPopup);
	m_lpActionsPopup->insertSeparator();
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvi_join.gif"),i18n("Join channel"),this,SLOT(slotActJoin()));
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvi_part.gif"),i18n("Part channel"),this,SLOT(slotActPart()));
	m_lpActionsPopup->insertSeparator();
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvii_qery.gif"),i18n("Query user"),this,SLOT(slotActQuery()));
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvii_chat.gif"),i18n("DCC Chat"),this,SLOT(slotActChat()));
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvii_send.gif"),i18n("DCC Send"),this,SLOT(slotActSend()));
	m_lpActionsPopup->insertSeparator();
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvi_away.gif"),i18n("Set AWAY"),this,SLOT(slotActAway()));
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvi_back.gif"),i18n("Unset AWAY"),this,SLOT(slotActUnaway()));
	m_lpActionsPopup->insertSeparator();
	m_lpActionsPopup->insertItem(lpI->loadIcon("kvi_chmod.gif"),i18n("Set user mode"),m_lpUModePopup);
	
	m_lpMenuBar->insertItem(i18n("&Main"),m_lpMainPopup,1);
	m_lpMenuBar->insertItem(i18n("&Settings"),m_lpSettingsPopup,2);
	m_lpMenuBar->insertItem(i18n("&Actions"),m_lpActionsPopup,3);
	m_lpMenuBar->insertItem(m_lpPopupManager->szActionPopup.data(),m_lpPopupManager->m_lpUserActionPopup,4);
	m_lpMenuBar->insertItem(i18n("&Window"),m_lpMdi->m_lpWinListPopup,5);
	m_lpMenuBar->insertItem(i18n("&Help"),_macro_kviApplication->getHelpMenu(false,KVI_HELP_ABOUT_STRING),6);

	setMenu(m_lpMenuBar);

	m_lpMenuBar->setItemEnabled(3,false);
	m_lpMenuBar->setMenuBarPos(KMenuBar::Top);
	//m_lpMenuBar->setStyle(MotifStyle); //No focus grabbing,thanx...
	m_lpMenuBar->setFocusPolicy(QWidget::NoFocus);
	m_lpMenuBar->setFocusProxy(m_lpMdi);
	QObjectList *lpL=m_lpMenuBar->queryList("QWidget");
	if(lpL){
		QObjectListIt it(*lpL);
		QObject *obj=0;
		while( (obj=it.current()) != 0){
			++it;
			//((QWidget *)obj)->setStyle(MotifStyle);
			// The above command is the ONLY way that I found to avoid ANNOYING
			// focus grabbing by the QMenuBar...
			((QWidget *)obj)->setFocusPolicy(NoFocus);
			((QWidget *)obj)->setFocusProxy(m_lpMdi);
		}
	} else _debug_warning("queryList returns NULL!");
	delete lpL;
	_debug_leavetrace("createMenuBar");
}
//============ saveScript ============//
void KviFrame::saveScript()
{
	_debug_entertrace("saveScript");
	KviScriptSaveDialog theDlg(this);
	m_bFocusManagingEnabled=false;
	theDlg.exec();
	m_bFocusManagingEnabled=true;
	_debug_leavetrace("saveScript");
}
//============ loadScript ============//
void KviFrame::loadScript()
{
	_debug_entertrace("loadScript");
	QString szHome=_macro_getKVircHomeDirectory("Scripts");
	QString szFileName=_macro_getOpenFileName(i18n("Open script file..."),szHome.data(),
			i18n("*.kvs|Kvirc scripts (*.kvs)\n*.*|All files (*.*)"));
	if(szFileName.isEmpty())return;
	m_bFocusManagingEnabled=false;
	KviScriptDescription d;
	if(!m_lpScriptManager->preloadHeaderAndCheckFile(szFileName.data(),&d)){
		KMsgBox::message(this,i18n("Script loading error"),i18n("The file is corrupted or unreadable.\nCan't load the script."));
		m_bFocusManagingEnabled=true;
		return;
	}
	KviScriptLoadDialog theDlg(this,&d,szFileName.data());
	if(!theDlg.exec()){
		m_bFocusManagingEnabled=true;
		return;
	}
	saveAllOptions();
	m_bRestarting=true;
	KMsgBox::message(this,i18n("Script succesfully loaded"),i18n("The settings need to be re-readed.\nKVirc will restart now."));
	m_bFocusManagingEnabled=true;
	_macro_kviApplication->m_bRestart=true;
	_macro_kviApplication->quit();
	_debug_leavetrace("loadScript");
}
//============ saveAllOptions ============//
void KviFrame::saveAllOptions()
{
	_debug_entertrace("saveAllOptions");
	m_lpAliasManager->saveToFile();
	m_lpEventManager->saveToFile();
	m_lpPopupManager->saveToFile();
	m_lpUserManager->saveToFile();
	m_lpInt->saveSettings();
	m_lpClr->saveSettings();
	m_lpUsr->saveSettings();
	m_lpSrv->saveSettings();
	m_lpOpt->saveSettings();
	_debug_leavetrace("saveAllOptions");
}
//============ newWindow ============//
void KviFrame::newWindow()
{
	_debug_entertrace("newWindow");
	//By now just run a new KVIrc application executable
	saveSettings();
	saveAllOptions();
	KProcess *proc=new KProcess();
	*proc << "kvirc";
	proc->start(KProcess::DontCare,KProcess::NoCommunication);
	delete proc;
	_debug_leavetrace("newWindow");
}
//============ slotUModeI ============//
void KviFrame::slotUModeI()
{ if(m_lpSock->m_bConnected)m_lpSock->sendFmtData("MODE %s +i",m_lpGlb->szNick.data());}
//============ slotUModeW ============//
void KviFrame::slotUModeW()
{ if(m_lpSock->m_bConnected)m_lpSock->sendFmtData("MODE %s +w",m_lpGlb->szNick.data());}
//============ slotUModeS ============//
void KviFrame::slotUModeS()
{ if(m_lpSock->m_bConnected)m_lpSock->sendFmtData("MODE %s +s",m_lpGlb->szNick.data());}
//============ slotActJoin ============//
void KviFrame::slotActJoin()
{
	_debug_entertrace("slotActJoin");
	QString szToDo="/SET $i.n.t $%box_input[" + QString(i18n("Enter the channel to join")) + "];if ($i.n.t) JOIN $i.n.t;UNSET $i.n.t";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActJoin");
}
//============ slotActQuery ============//
void KviFrame::slotActQuery()
{
	_debug_entertrace("slotActQuery");
	QString szToDo="/SET $i.n.t $%box_input[" + QString(i18n("Enter the nickname to query")) + "];if ($i.n.t) QUERY $i.n.t;UNSET $i.n.t";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActQuery");
}
//============ slotActChat ============//
void KviFrame::slotActChat()
{
	_debug_entertrace("slotActChat");
	QString szToDo="/SET $i.n.t $%box_input[" + QString(i18n("Enter the nickname to request DCC Chat")) + "];if ($i.n.t) CHAT $i.n.t;UNSET $i.n.t";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActChat");
}
//============ slotActAway ============//
void KviFrame::slotActAway()
{
	_debug_entertrace("slotActAway");
	QString szToDo="/AWAY";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActAway");
}
//============ slotActUnaway ============//
void KviFrame::slotActUnaway()
{
	_debug_entertrace("slotActUnaway");
	QString szToDo="/BACK";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActUnaway");
}
//============ slotActSend ============//
void KviFrame::slotActSend()
{
	_debug_entertrace("slotActSend");
	QString szToDo="/SET $i.n.t $%box_input[" + QString(i18n("Enter the nickname to request DCC Send")) + "];if ($i.n.t) SEND $i.n.t;UNSET $i.n.t";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActSend");
}
//============ slotActPart ============//
void KviFrame::slotActPart()
{
	_debug_entertrace("slotActPart");
	QString szToDo="/SET $i.n.t $%box_input[" + QString(i18n("Enter the channel to part")) + "];";
	szToDo+="if ($i.n.t)< set $i.n.d $%box_input[" + QString(i18n("Enter the part message")) + "];";
	szToDo+="if ($i.n.d) part $i.n.t $i.n.d;>; unset $i.n.t ; unset $i.n.d";
	m_lpUserParser->parseUserInput(m_lpConsole,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,szToDo);
	_debug_leavetrace("slotActPart");
}
//============ setFocusTargetRecursive ============//
void KviFrame::setFocusTargetRecursive(QWidget *lpW,QWidget *lpTrg)
{
	_debug_entertrace("setFocusTargetRecursive");
	if(lpW != lpTrg){
		QList<QObject> *list = (QList<QObject> *)(lpW->children());
		if(list){
			for (unsigned int i=0; i< list->count(); i++){
				QObject *w = list->at(i);
				if(w->inherits("QWidget")){
					setFocusTargetRecursive(((QWidget *)w),lpTrg);
				}
			}
		}
		if(lpW != this)lpW->setFocusPolicy(QWidget::NoFocus);
		lpW->setFocusProxy(lpTrg);
	}
	_debug_leavetrace("setFocusTargetRecursive");
}
//============ dnsQueryDone ============//
void KviFrame::dnsQueryDone(const char *szResult)
{
	_debug_entertrace("dnsQueryDone");
	KviDnsResultStruct dr;
	KviMdiChild *lpC=m_lpMdi->topChildInZOrder();
	if(!lpC)lpC=m_lpConsole;
	if(m_lpDns->getResult(szResult,&dr)){
		lpC->doFmtOutput(KVI_OUT_DNS,i18n("[DNS] : query  : %s"),dr.szQuery.data());
		lpC->doFmtOutput(KVI_OUT_DNS,"[DNS] : host   : %s",dr.szHostName.data());
		lpC->doFmtOutput(KVI_OUT_DNS,"[DNS] : ip     : %s",dr.szIp.data());
		if((dr.szAlias1.length()>6)||(strncasecmp(dr.szAlias1.data(),i18n("none"),4)))
			lpC->doFmtOutput(KVI_OUT_DNS,"[DNS] : alias1 : %s",dr.szAlias1.data());
		if((dr.szAlias2.length()>6)||(strncasecmp(dr.szAlias2.data(),i18n("none"),4)))
			lpC->doFmtOutput(KVI_OUT_DNS,"[DNS] : alias2 : %s",dr.szAlias2.data());
	} else {
		lpC->doFmtOutput(KVI_OUT_DNS,i18n("[DNS] : query  : %s"),dr.szQuery.data());
		lpC->doFmtOutput(KVI_OUT_DNS,i18n("[DNS] : error  : %s"),dr.szError.data());
	}
	_debug_leavetrace("dnsQueryDone");
}
//============ createStatusBar ============//
void KviFrame::createStatusBar()
{
	_debug_entertrace("createStatusBar");
	m_lpStatusBar = new KviStatusBar(this,"KviStatusBarClass");
	addToolBar(m_lpStatusBar);
//	m_lpStatusBar->setBarPos(KToolBar::Bottom);
	_debug_leavetrace("createStatusBar");
}
//============ queryExternalDestroy ============//
void KviFrame::queryExternalDestroy(KviMdiChild *lpC)
{
	_debug_entertrace("queryExternalDestroy");
	if(m_lpDestroyTimer->isActive())destroySlot();
	m_lpLastChildToDestroy=lpC;
	m_lpDestroyTimer->start(KVI_DESTROY_TIMEOUT);
	_debug_leavetrace("queryExternalDestroy");
}
//============ destroySlot ============//
void KviFrame::destroySlot()
{
	_debug_entertrace("destroySlot");
	m_lpDestroyTimer->stop();
	if(m_lpLastChildToDestroy==m_lpLinksWindow)linksWindowClosed();
	else {
		if(m_lpLastChildToDestroy==m_lpVoiceWnd)m_lpVoiceWnd=0;
		else if(m_lpLastChildToDestroy==m_lpChanListWindow)chanListWindowClosed();
	}
	m_lpLastChildToDestroy->killWindow();
	m_lpLastChildToDestroy=0;
	_debug_leavetrace("destroySlot");
}
//============ setStatus ============//
void KviFrame::setStatusText(const char *szText)
{
	_debug_entertrace("setStatusText");
	m_lpStatusBar->setLabelText(szText);
	_debug_leavetrace("setStatusText");
}
//============ slotAboutKvirc ============//
void KviFrame::slotAboutKvirc()
{
	_debug_entertrace("slotAboutKvirc");
	KviAboutDialog *pDlg=new KviAboutDialog(this);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	_debug_leavetrace("slotAboutKvirc");
}
//============ doPopupDialog ============//
void KviFrame::doPopupDialog()
{
	_debug_entertrace("doPopupDialog");
	KviPopupDialog *pDlg=new KviPopupDialog(this,m_lpPopupManager);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	m_lpMenuBar->changeItem(m_lpPopupManager->szActionPopup.data(),4);
	m_lpChanPopup->changeItem(m_lpPopupManager->szChanPopup.data(),8);
	m_lpNickListPopup->changeItem(m_lpPopupManager->szNickListPopup.data(),7);
	_debug_leavetrace("doPopupDialog");
}
//============ doServerDialog ============//
void KviFrame::doServerDialog()
{
	_debug_entertrace("doServerDialog");
	KviSrvDialog *pDlg=new KviSrvDialog(this,m_lpSrv);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	_debug_leavetrace("doServerDialog");
}
//============ doAliasDialog ============//
void KviFrame::doAliasDialog()
{
	_debug_entertrace("doAliasDialog");
	KviAliasDialog *pDlg=new KviAliasDialog(this);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	_debug_leavetrace("doAliasDialog");
}
//============ slot doSettingsDialog ============//
void KviFrame::doInterfaceDialog()
{
	_debug_entertrace("doInterfaceDialog");
	KviInterfaceDialog *pDlg=new KviInterfaceDialog(this,m_lpInt);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	applyOptions();
	_debug_leavetrace("doInterfaceDialog");
}
//============ doEventDialog ============//
void KviFrame::doEventDialog()
{
	_debug_entertrace("doEventDialog");
	KviEventDialog *pDlg=new KviEventDialog(this);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	_debug_leavetrace("doEventDialog");
}
//============ doOptionsDialog ============//
void KviFrame::doOptionsDialog()
{
	_debug_entertrace("doOptionsDialog");
	KviNewOptDialog *pDlg=new KviNewOptDialog(this,m_lpOpt);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	setWindowCaption();
	m_lpStatusBar->setDefaultLabelText(m_lpOpt->szStatusMsg.data());
	applyOptions();
	_debug_leavetrace("doOptionsDialog");
}
//============ doDccOptionsDialog ============//
void KviFrame::doDccOptionsDialog()
{
	_debug_entertrace("doOptionsDialog");
	KviNewDccOptDialog *pDlg=new KviNewDccOptDialog(this,m_lpOpt);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	startDCCDaemon();
	applyOptions();
	_debug_leavetrace("doOptionsDialog");
}
//============ doUserListDialog ============//
void KviFrame::doUserListDialog()
{
	_debug_entertrace("doUserListDialog");
	KviUserListDialog *pDlg=new KviUserListDialog(this,m_lpUserManager,m_lpOpt);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	if(m_bLoggedIn && m_lpSock->m_bConnected)startNotifyList();
	_debug_leavetrace("doUserListDialog");
}
//============ startDCCDaemon ============//
void KviFrame::startDCCDaemon()
{
	_debug_entertrace("startDCCDaemon");
	if(m_lpOpt->bUseDCCDaemon){
		if(m_lpDCCD->isActive()){
			//Check the port that it is already running on...if nothing changed return.
			if(m_lpOpt->iDCCDaemonPort==m_lpDCCD->m_iPort)return;
		}
		m_lpDCCD->start(m_lpOpt->iDCCDaemonPort);
	} else m_lpDCCD->terminateIfRunning(); //Just write that we're stopped
	_debug_leavetrace("startDCCDaemon");
}
//============ startNotifyList ============//
void KviFrame::startNotifyList()
{
	_debug_entertrace("startNotifyList");
	m_szNotifyString="";
	m_lpConsole->m_lpNotifyList->removeAll();
	while(!m_lpIsOnList->isEmpty())m_lpIsOnList->removeLast();
	KviUserStruct *lpU=0;
	for(lpU=m_lpUserManager->m_lpUserList->first();lpU;lpU=m_lpUserManager->m_lpUserList->next()){
		if(lpU->bNotify){
			bool bAlreadyThere=false;
			KviIsonStruct *pIs=0;
			for(pIs=m_lpIsOnList->first();pIs;pIs=m_lpIsOnList->next()){
				if(!strcasecmp(pIs->szNick.data(),lpU->szNick.data())){
					bAlreadyThere=true;
					break;
				}
			}
			if(!bAlreadyThere){
				if(!m_szNotifyString.isEmpty())m_szNotifyString+=' ';
				KviIsonStruct *lpIs=new KviIsonStruct;
				lpIs->szNick=lpU->szNick.data();
				lpIs->isOn=false;
				lpIs->lpUserStruct=lpU;
				m_lpIsOnList->append(lpIs);
				m_szNotifyString+=lpU->szNick.data();
			}
		}
	}
	if(m_szNotifyString.length()>500)m_szNotifyString.resize(501);
	if(m_lpNotifyTimer->isActive())m_lpNotifyTimer->stop();
//#warning "TODO : If the notify string is empty , or the notify list is disabled"
//#warning "find another way to get lag time...(if it is enabled)"
	if((!m_lpSock->m_bConnected) ||(!m_bLoggedIn) 
				|| (!m_lpOpt->bEnableNotifyList) || (m_szNotifyString.isEmpty()))return;
	m_bGotLastReply=true; //can check now
	checkNotifyList();
	m_lpNotifyTimer->start(m_lpOpt->iNotifyTimer * 1000);
	_debug_leavetrace("startNotifyList");
}
//============ findUserStruct ============//
KviUserStruct * KviFrame::findUserStruct(QString &szNick,QString &szMask)
{
	_debug_entertrace("findUserStruct");
	KviUserStruct *lpU=0;
	QString szmk=szMask.data();
	if(szmk.find('!') == -1){
		szmk.prepend("!");
		szmk.prepend(szNick.data());
	}
	for(lpU=m_lpUserManager->m_lpUserList->first();lpU;lpU=m_lpUserManager->m_lpUserList->next()){
		if(!strcasecmp(lpU->szNick.data(),szNick.data())){
			KviNewNick nk(szmk);
			if(nk.matches(lpU->szMask.data()))return lpU;
		}
	}
	_debug_leavetrace("findUserStruct");
	return lpU;
}
//============ checkNotifyList ============//
void KviFrame::checkNotifyList()
{
	_debug_entertrace("checkNotifyList");
	if((!m_lpSock->m_bConnected) || (!m_lpOpt->bEnableNotifyList) || (m_szNotifyString.isEmpty())){
		if(m_lpNotifyTimer->isActive())m_lpNotifyTimer->stop();
		m_lpConsole->m_lpNotifyList->removeAll();
		return;
	}
	if(m_bGotLastReply){ //if got a reply for the last one
		m_lastNotifyCheck=QTime::currentTime();
		m_bGotLastReply=false; //stop checking until we have a reply
		m_lpSock->sendFmtData("ISON %s",m_szNotifyString.data());
	}
	_debug_leavetrace("checkNotifyList");
}
//============ slot doUserDialog ============//
void KviFrame::doUserDialog()
{
	_debug_entertrace("doUserDialog");
	KviUserDialog *pDlg=new KviUserDialog(this,m_lpUsr);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	_debug_leavetrace("doUserDialog");
}
//============ doIrcColorsDialog ============//
void KviFrame::doIrcColorsDialog()
{
	_debug_entertrace("doIrcColorsDialog");
	KviMircColorsDialog *pDlg=new KviMircColorsDialog(this,m_lpClr);
	m_bFocusManagingEnabled=false;
	pDlg->exec();
	m_bFocusManagingEnabled=true;
	delete pDlg;
	_debug_leavetrace("doIrcColorsDialog");
}
//============ focusInEvent ============//
void KviFrame::focusInEvent(QFocusEvent *)
{
	_debug_entertrace("focusInEvent");
	if(!m_bFocusManagingEnabled)return;
	m_lpMdi->focusTopChild();
	_debug_leavetrace("focusInEvent");
}
//============ handleConnectedToServer ============//
void KviFrame::handleConnectedToServer()
{
	_debug_entertrace("handleConnectedToServer");
	m_bLoggedIn=false;
	m_bUsingAltNick=false;
	if(!m_lpLinksWindow)m_lpToolBar->setItemEnabled(2,true);	

	m_lpGlb->szNetworkName	= m_szCurNetwork.copy();
	m_lpGlb->szServerName	= m_hostDescription.szName.copy();
	m_lpGlb->szServerIp		= m_hostDescription.szIp.copy();
	m_lpGlb->szPort.sprintf("%d",m_hostDescription.iPort);
	m_lpGlb->startTime		= time(0);
	m_lpGlb->endTime		= time(0);

	m_lpConsole->doFmtOutput(KVI_OUT_CONNECT,i18n("Connected to %s (%s:%d)"),
		m_hostDescription.szName.data(),m_hostDescription.szIp.data(),m_hostDescription.iPort);
	//Get local host here...
	if(m_lpSock->getLocalHostIp(m_lpGlb->szLocalHostIp)==KVI_SOCKERR_SUCCESS){
		m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,"Localhost %s",m_lpGlb->szLocalHostIp.data());
	} else {
		if(!m_lpOpt->szLocalIp.isEmpty())m_lpGlb->szLocalHostIp="127.0.0.1";
		else m_lpGlb->szLocalHostIp=m_lpOpt->szLocalIp.copy();
		m_lpConsole->doFmtOutput(KVI_OUT_ERROR,i18n("Unable to resolve local host (using %s)"),m_lpGlb->szLocalHostIp.data());
	}
	if(m_lpEventManager->lpEvent[KVI_Event_OnConnect]->bEnabled){
			QString szPara=m_lpGlb->szServerName+" "+m_lpGlb->szServerIp+" "+m_lpGlb->szNetworkName+" ";
			szPara+=m_lpGlb->szPort+" "+m_lpGlb->szLocalHostIp;
			m_lpUserParser->executeEvent(m_lpConsole,m_lpEventManager->lpEvent[KVI_Event_OnConnect],szPara);
	}
	if(!(m_szPassword.isEmpty())){
		m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("Sending %s as password"),m_szPassword.data());
		m_lpSock->sendFmtData("PASS %s",m_szPassword.data());
	}
	if(m_lpUsr->szNick.isEmpty())m_lpUsr->szNick=i18n("unknown");
	if(m_lpUsr->szRealName.isEmpty())m_lpUsr->szRealName=i18n("unknown");
	if(m_lpUsr->szUserName.isEmpty())m_lpUsr->szUserName=i18n("unknown");
	m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("Logging in as %s (%s , %s)"),m_lpUsr->szNick.data(),
						m_lpUsr->szUserName.data(),m_lpUsr->szRealName.data());
	m_lpGlb->szNick		= m_lpUsr->szNick.copy();
	m_lpGlb->szUserName	= m_lpUsr->szUserName.copy();
	m_lpGlb->szRealName	= m_lpUsr->szRealName.copy();
	m_lpSock->sendFmtData("USER %s %s %s :%s",m_lpUsr->szUserName.data(),m_lpGlb->szLocalHostIp.data(),
				m_lpGlb->szServerName.data(),m_lpUsr->szRealName.data());
	m_lpSock->sendFmtData("NICK %s",m_lpUsr->szNick.data());
	m_lpMenuBar->setItemEnabled(3,true);
	m_lpMenuBar->repaint();
	setWindowCaption();
	_debug_leavetrace("handleConnectedToServer");
}
//============ handleProxyReply ============//
void KviFrame::handleProxyReply(unsigned char replycode)
{
	_debug_entertrace("handleProxyReply");
	QString reply;
	bool bAccepted=m_lpProxy->getProxyReply(replycode,reply);
	m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("[ SOCKS ] : Received response : %s"),reply.data());
	if(bAccepted)handleConnectedToServer();
	m_lpProxy->clear(); //set proxy inactive
	_debug_leavetrace("handleProxyReply");
}
//============ handleSocketConnected ============//
void KviFrame::handleSocketConnected()
{
	_debug_entertrace("handleSocketConnected");
	m_lpGlobalUserList->clear(); //new connection
	if(m_lpProxy->isActive()){
		QString szStat=i18n("Connected to ")+m_lpProxy->m_host.szName;
		setStatusText(szStat.data());
		m_lpConsole->doFmtOutput(KVI_OUT_CONNECT,i18n("[ SOCKS ] : Connected to %s (%s:%d)"),
			m_lpProxy->m_host.szName.data(),m_lpProxy->m_host.szIp.data(),m_lpProxy->m_host.iPort);
		m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("[ SOCKS ] : Negotiating connection to %s"),m_hostDescription.szName.data());
		//write data to proxy
		m_lpProxy->beginNegotiate(&m_hostDescription,m_lpProxyEntry->szUsername,m_lpProxyEntry->szPassword);
		//and wait until someone calls handleProxyReply or we fail.
	} else {
		QString szStat=i18n("Connected to ")+m_hostDescription.szName;
		setStatusText(szStat.data());
		handleConnectedToServer();
	}
	_debug_leavetrace("handleSocketConnected");
}

//============ handleConnectFailed ============//
void KviFrame::handleConnectFailed()
{
	_debug_entertrace("handleConnectFailed");
	setStatusText(i18n("Connect failed"));
	if(m_lpProxy->isActive())m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("[ SOCKS ] : Proxy connection failed [ %s (%s:%d) ]"),
			m_lpProxy->m_host.szName.data(),m_lpProxy->m_host.szIp.data(),m_lpProxy->m_host.iPort);
	m_lpStatusBar->resetLedState();
	m_lpConsole->doFmtOutput(KVI_OUT_ERROR,i18n("Connect failed [ %s (%s:%d) ]"),
			m_hostDescription.szName.data(),m_hostDescription.szIp.data(),m_hostDescription.iPort);
	m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_conn.gif"),i18n("Connect"),0);
	m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_conn.gif"));
	m_lpProxy->clear();
	if(m_bCanReconnect){
		if(m_lpSrv->reconnectOnConnectFailed){
			m_iCurHostIdx++;
			if(m_lpSrv->getServer(m_iCurHostIdx)){
				m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("New connection attempt in 5 secs. (Hit 'abort' to stop)"));
				m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_disc.gif"),i18n("Abort"),0);	
				m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_disc.gif"));	
				m_bReconnecting=true;
				m_lpReconnectTimer->start(5000);
			} else m_lpConsole->doOutput(KVI_OUT_ERROR,i18n("Can't hop server: No more servers available"));
		}
	}
	_debug_leavetrace("handleConnectFailed");
}
//============ handleSocketDisconnected ============//
void KviFrame::handleSocketDisconnected()
{
	_debug_entertrace("handleSocketDisconnected");
	m_lpStatusBar->resetLedState();
	setStatusText("Disconnected");

	if(m_lpUserHostTimer->isActive())m_lpUserHostTimer->stop();
	if(m_lpNotifyTimer->isActive())m_lpNotifyTimer->stop();
	m_lpConsole->m_lpNotifyList->removeAll();

	m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_conn.gif"),i18n("Connect"),0);
	m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_conn.gif"));
	m_lpMenuBar->setItemEnabled(3,false);
	m_lpToolBar->setItemEnabled(2,false);
	m_lpMenuBar->repaint();

	m_lpProxy->clear();
	m_lpGlb->endTime		= time(0);
	KviMdiChild *lpC=0;
	QList<KviMdiChild> *list = new QList<KviMdiChild>;
	for(lpC=m_lpMdi->m_lpChildList->first();lpC;lpC=m_lpMdi->m_lpChildList->next()){
		if((lpC->type()==KVI_WND_TYPE_CHAN) ||(lpC->type()==KVI_WND_TYPE_QUERY)
			||(lpC->type()==KVI_WND_TYPE_LINKS)){
			list->append(lpC);
		}
	}
	list->setAutoDelete(false);
	while(!list->isEmpty()){
		lpC=list->first();
		m_lpMdi->removeWindow(lpC);
		list->removeRef(lpC);
	}
	delete list;
	m_lpLinksWindow=0;
	m_lpConsole->setFocus();
	m_lpConsole->doFmtOutput(KVI_OUT_DISCONNECT,i18n("Connection terminated [ %s (%s:%d) ]"),
			m_hostDescription.szName.data(),m_hostDescription.szIp.data(),m_hostDescription.iPort);

	if(m_lpEventManager->lpEvent[KVI_Event_OnDisconnect]->bEnabled){
			QString szPara=m_hostDescription.szName+" "+m_hostDescription.szIp+" ";
			m_lpUserParser->executeEvent(m_lpConsole,m_lpEventManager->lpEvent[KVI_Event_OnDisconnect],szPara);
	}
	if(m_bCanReconnect){
		if(m_lpSrv->reconnectOnDisconnect){
			m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("New connection attempt in 5 secs. (Hit 'abort' to stop)"));
			m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_disc.gif"),i18n("Abort"),0);	
			m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_disc.gif"));
			m_bReconnecting=true;
			m_lpReconnectTimer->start(5000);
		}
	}
	setWindowCaption();
	_debug_leavetrace("handleSocketDisconnected");
}
//============ handleSocketError ============//
void KviFrame::handleSocketError(int nErr)
{
	_debug_entertrace("handleSocketError");
	QString szError;
	m_lpSock->getErr(nErr,szError);
	m_lpConsole->doFmtOutput(KVI_OUT_ERROR,i18n("[SOCKET ERROR]:%s"),szError.data());
	_debug_leavetrace("handleSocketError");
}
//============ fillProxyAddress ============//
bool KviFrame::fillProxyAddress(bool bUseProtoV5)
{
	_debug_entertrace("fillProxyAddress");
	if(m_lpSrv->m_lpProxyList->isEmpty())return false;
	m_lpProxyEntry =m_lpSrv->m_lpProxyList->first();
	return m_lpProxy->setup(bUseProtoV5,m_lpProxyEntry->szAddress,m_lpProxyEntry->szIp,m_lpProxyEntry->iPort);
	_debug_leavetrace("fillProxyAddress");
}
//============ connectToCurrentServer ============//
void KviFrame::connectToCurrentServer()
{
	_debug_entertrace("connectToCurrentServer");
	//Setup
	if(m_lpUsr->szNick.isEmpty() || m_lpUsr->szUserName.isEmpty() || (!m_lpSrv->getServer(m_iCurHostIdx))){
		m_lpConsole->doOutput(KVI_OUT_ERROR,i18n("Can't connect: Please select settings/User from the menu bar"));
		return;
	}

	m_lpProxy->clear(); //clear proxy data. set state to KVI_PROXY_INACTIVE
	//Get the server to connect to
//	QString szSrv(m_lpSrv->serverList.at(m_iCurHostIdx));
//	KviServer kS(szSrv);
	KviServerEntry *lpE=m_lpSrv->getServer(m_iCurHostIdx);

	QString szNet;
	m_lpSrv->getCurNetworkName(szNet);
	m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("Attempting connection to %s (%s) on port %d"),lpE->szAddress.data(),
								szNet.data(),lpE->iPort);

	if(m_lpSrv->bUseProxy){
		if(!fillProxyAddress(m_lpSrv->bUseSocksV5)){
			m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("Unable to use proxy protocol : resuming direct connection"));
 			m_lpSrv->bUseProxy=false;	
		} else m_lpProxyEntry->szIp=m_lpProxy->m_host.szIp.copy();
	}

	m_bCanReconnect=true;
	m_bReconnecting=false;
	clearHostDescription();

	m_szCurNetwork=szNet.data();

	m_szPassword=((lpE->szPassword.isEmpty()||(lpE->szPassword==KVI_EMPTY_PASSWORD)) ? "" : lpE->szPassword.data());
	QString szStat=i18n("Looking up host ")+lpE->szAddress;
	setStatusText(szStat.data());
	m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("Looking up host %s"),lpE->szAddress.data());

	_macro_kviApplication->processEvents();
	bool bDone=false;
	if(m_lpSrv->cacheLookup && (!lpE->szIp.isEmpty()) && (lpE->szIp != KVI_EMPTY_IP)){ // Fritz: check!!!
		if(inet_aton(lpE->szIp.data(),&(m_hostDescription.iAddress))){
			bDone=true;
			m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("Server hostname resolved (address found in cache)."));
			m_hostDescription.szName	=lpE->szAddress.data();
			m_hostDescription.szAlias1	=i18n("unknown");
			m_hostDescription.szAlias2	=i18n("unknown");
			m_hostDescription.szIp		=lpE->szIp.data();
			m_hostDescription.iPort		=lpE->iPort;
		} 
	} 
    if(!bDone){
		int nErr=m_lpSock->getHostByName(lpE->szAddress.data(),&m_hostDescription);
		if(nErr != KVI_SOCKERR_SUCCESS){
			handleSocketError(nErr);
			m_hostDescription.szName	=lpE->szAddress.data();
			m_hostDescription.szIp		=lpE->szIp.data();
			m_hostDescription.iPort		=lpE->iPort;
			handleConnectFailed();
			clearHostDescription();
			return;
		} else {
			if(m_lpSrv->cacheLookup){
				lpE->szIp	=m_hostDescription.szIp.data();
//				m_lpSrv->serverList.remove(m_iCurHostIdx); //not the first!!!
//				QString szS;
//				kS.toString(szS);
//				m_lpSrv->serverList.insert(m_iCurHostIdx,szS.data());
				m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("Server hostname resolved (lookup cached)"));
			} else {
				m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("Server hostname resolved"));
			}
			m_hostDescription.iPort=lpE->iPort;
		}
	}
	connectToServer();
	_debug_leavetrace("connectToCurrentServer");
}
//============ clearHostDescription ============//
void KviFrame::clearHostDescription()
{
	_debug_entertrace("clearHostDescription");
	m_hostDescription.szName	=i18n("none");
	m_hostDescription.szAlias1	=i18n("none");
	m_hostDescription.szAlias2	=i18n("none");
	m_hostDescription.szIp		=i18n("none");
	m_hostDescription.iPort		=0;
	_debug_leavetrace("clearHostDescription");
}
//============ connectTo ============//
void KviFrame::connectToServer()
{
	_debug_entertrace("connectToServer");
	m_bLoggedIn=false;
	m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_disc.gif"),i18n("Disconnect"),0);
	m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_disc.gif"));
	int nErr;
	if(m_lpProxy->isActive()){
		QString szStat;
		szStat.sprintf(i18n("Connecting to %s (%s:%d)"),m_lpProxy->m_host.szName.data(),
				m_lpProxy->m_host.szIp.data(),m_lpProxy->m_host.iPort);
		setStatusText(szStat.data());
		m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("[ SOCKS ] : %s"),szStat.data());
		nErr=m_lpSock->connectTo(m_lpProxy->m_host.iAddress,m_lpProxy->m_host.iPort);
		if(nErr != KVI_SOCKERR_SUCCESS){
			QString szError;
			m_lpSock->getErr(nErr,szError);
			m_lpConsole->doFmtOutput(KVI_OUT_INTERNAL,i18n("[ SOCKS ] : Connect call exited with error : %s"),szError.data());
		} else m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("[ SOCKS ] : Connect call succesfull"));
	} else {
		QString szStat=i18n("Connecting to ")+m_hostDescription.szName+" ("+m_hostDescription.szIp+":";
		QString szPort;
		szPort.setNum(m_hostDescription.iPort);
		szStat+=szPort+")";
		setStatusText(szStat.data());
		nErr=m_lpSock->connectTo(m_hostDescription.iAddress,m_hostDescription.iPort);
	}
	if(nErr != KVI_SOCKERR_SUCCESS){
		handleSocketError(nErr);
		handleConnectFailed();
		return;
	}
	_debug_leavetrace("connectToServer");
}
//============ disconnectFromServer ============//
void KviFrame::disconnectFromServer()
{
	_debug_entertrace("disconnectFromServer");
	if( ! (m_lpSock->m_bInProgress || m_lpSock->m_bConnected))return;
	if(m_lpSock->m_bConnected){
		QString szQuit=( m_lpOpt->szQuitMsg.isEmpty() ? i18n("Leaving") : m_lpOpt->szQuitMsg.data() );
		m_lpUserParser->m_lpIdentifiers->substitute(m_lpConsole,szQuit,0);
		m_lpSock->sendFmtData("QUIT :%s",szQuit.data());
	}
	m_bCanReconnect=false;
	m_iCurHostIdx=0;
	m_lpSock->disconnect();
	_debug_leavetrace("disconnectFromServer");
}
//============ reconnectionSlot ============//
void KviFrame::reconnectionSlot()
{
	_debug_entertrace("reconnectionSlot");
	m_bReconnecting=false;
	m_lpReconnectTimer->stop();
	m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_conn.gif"),i18n("Connect"),0);
	m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_conn.gif"));
	connectToCurrentServer();
	_debug_leavetrace("reconnectionSlot");
}
//============ hopServer ============//
void KviFrame::hopServer(QString &szServer,int iPort)
{
	_debug_entertrace("hopServer");
	m_lpSrv->setCurrentServer(szServer,iPort);
	if(m_lpSock->m_bConnected || m_bReconnecting || m_lpSock->m_bInProgress){
		//allow returning the function before destroying windows....
		QTimer::singleShot(200,this,SLOT(hopServerSlot()));
		return;
	}
	m_iCurHostIdx=0;
	connectToCurrentServer();
	_debug_leavetrace("hopServer");
}
//============ hopServerSlot ============//
void KviFrame::hopServerSlot()
{
	_debug_entertrace("hopServerSlot");
	if(m_lpSock->m_bConnected || m_bReconnecting || m_lpSock->m_bInProgress){
		connectionSlot();
	}
	_macro_kviApplication->processEvents();
	m_iCurHostIdx=0;
	connectToCurrentServer();
	_debug_leavetrace("hopServerSlot");
}
//============ connectionSlot ============//
// Connected to the 'Connect' menu item
void KviFrame::connectionSlot()
{
	_debug_entertrace("connectionSlot");
	if(m_bReconnecting){ //Stop reconnecting
		if(m_lpReconnectTimer->isActive())m_lpReconnectTimer->stop();
		m_bReconnecting=false;
		m_bCanReconnect=false;
		m_lpMainPopup->changeItem(_macro_kviIconLoader->loadIcon("kvii_conn.gif"),i18n("Connect"),0);
		m_lpToolBar->setButtonPixmap(1,_macro_kviIconLoader->loadIcon("kvi_tlb_conn.gif"));
		m_lpConsole->doOutput(KVI_OUT_INTERNAL,i18n("Connection aborted"));
		return;
	}
	if(m_lpSock->m_bConnected || m_lpSock->m_bInProgress){ //Disconnect
		disconnectFromServer();
	} else { //Connect
		m_iCurHostIdx=0;
		connectToCurrentServer();
	}
	_debug_leavetrace("connectionSlot");
}
//============ requestNickListPopup ============//
void KviFrame::requestNickListPopup(QPoint pnt)
{
	_debug_entertrace("requestNickListPopup");
	if(m_lpGlb->lpCurrentChan && (!m_lpGlb->szCurrentSelection.isEmpty())){
		pnt.setX(pnt.x()-80);
		m_lpNickListPopup->popup(pnt);
	}
	_debug_leavetrace("requestNickListPopup");
}
//============ requestNotifyListPopup ============//
void KviFrame::requestNotifyListPopup(QPoint pnt)
{
	_debug_entertrace("requestNotifyListPopup");
	if(!m_lpGlb->szCurrentNotifySelection.isEmpty()){
		pnt.setX(pnt.x()-80);
		m_lpNotifyListPopup->popup(pnt);
	}
	_debug_leavetrace("requestNotifyListPopup");
}
//============ queryUserHost ============//
void KviFrame::queryUserHost(QString &szUserHost)
{
	_debug_entertrace("queryUserHost");
	if(m_szNextUserHostQuery.isEmpty()){
		m_szNextUserHostQuery=szUserHost.copy();
		if(!m_lpUserHostTimer->isActive()){
			m_lpUserHostTimer->start(m_lpOpt->iUserListUpdateTime * 1000);
			doUserHost();
		}
	}
	_debug_leavetrace("queryUserHost");
}
//============ doUserHost ============//
void KviFrame::doUserHost()
{
	_debug_entertrace("doUserHost");
	if(m_szNextUserHostQuery.isEmpty()||(!m_lpSock->m_bConnected)){
		if(m_lpUserHostTimer->isActive())m_lpUserHostTimer->stop();
	} else {
		m_lpSock->sendFmtData("USERHOST %s",m_szNextUserHostQuery.data());
		m_szNextUserHostQuery="";
	}
	_debug_leavetrace("doUserHost");
}
#include "m_kvi_frame.moc"

//
// $Log: kvi_frame.cpp,v $
// Revision 1.14  1998/10/06 14:42:15  pragma
// Tons of changes
//
// Revision 1.13  1998/09/28 13:46:10  pragma
// Added the channelList slot
//
// Revision 1.12  1998/09/25 15:58:28  pragma
// Moving ti use the KviProxy class.
//
// Revision 1.11  1998/09/23 23:15:06  pragma
// Ignore list. Still needs testing.
// Added some ASSERT-Like macros to kvi_chan.cpp and kvi_listbox.cpp
// to discover a strange bug :
// Sometimes the a single nick on a random channel gets wrong username...
// Just like a hollow pointer...but still can't guess how to reproduce it.
// It happened only a couple of times...
//
// Revision 1.10  1998/09/23 12:41:37  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.9  1998/09/20 20:22:31  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.8  1998/09/18 14:31:15  pragma
// Code arrangement:
// Moved the kvi_frame toolbar to a new KviToolBar class.
//
// Revision 1.7  1998/09/18 03:44:48  fritz
// Unified OK-Buttons (some had been 'Ok', most are 'OK'). Now all are 'OK'
// Work on the Server-Dialog. Still not satisfied, but it works.
//
// Revision 1.6  1998/09/17 19:29:59  fritz
// First translations.
// Fixed some typos and inconsistent messages.
//
// Revision 1.5  1998/09/17 16:14:32  pragma
// Moving to handle mp3 , au and mid files by external players.
//
// Revision 1.4  1998/09/17 02:18:13  pragma
// Moving incompatible i18n strings to i18n_incompatible.txt.
//
// Revision 1.3  1998/09/16 17:16:12  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:12  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
