//   $Id: kvi_global.cpp,v 1.2 1998/09/20 20:22:37 fritz Exp $
//
//   This file is part of the KVIrc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_defs.h"
#include "kvi_global.h"
#include "kvi_debug.h"

KviGlobals::KviGlobals()
{
	reset();
}
KviGlobals::~KviGlobals()
{
}

//============ reset ============//

void KviGlobals::reset()
{
	_debug_entertrace("reset");

	szServerName=KVI_STR_NULL;
	szServerIp=KVI_STR_NULL;
	szNetworkName=KVI_STR_NULL;
	szPort=KVI_STR_NULL;
	startTime=(time_t)0;
	endTime=(time_t)0;
	szLocalHostIp="127.0.0.1";

	szNick=KVI_STR_NULL;
	szUserName=KVI_STR_NULL;
	szRealName=KVI_STR_NULL;
	szMaskFromServer=KVI_STR_NULL;
	szHostName=KVI_STR_NULL;

	lpCurrentChan=0;
	lpCurrentChat=0;
	lpCurrentQuery=0;
	szCurrentSelection="";
	szCurrentNotifySelection="";
	_debug_leavetrace("reset");
}

