//   $Id: kvi_ident.cpp,v 1.6 1998/10/06 14:42:25 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviIdentifiers"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_ident.h"
#include "kvi_file.h"
#include "kvi_frame.h"
#include "kvi_debug.h"
#include "kvi_global.h"
#include "kvi_app.h"
//#include <kfiledialog.h>
//#include "kvi_file.h"
#include "kvi_child.h"
#include "kvi_chat.h"
#include "kvi_send.h"
#include "kvi_mdi.h"
#include "kvi_chan.h"
#include "kvi_nick.h"
#include "kvi_uparser.h"
#include "kvi_listbox.h"
#include "kvi_timer.h"
#include "kvi_status.h"

//#include <kfiledialog.h>
#include <kmsgbox.h>

#include <qpushbutton.h>

//
// Internal class KviInputBox
//

KviInputBox::KviInputBox(QWidget *parent,QString szText,QString *pRet):QDialog(parent,0,true)
{
	lpOk     = new QPushButton(i18n("OK"),this);
	lpCancel = new QPushButton(i18n("Cancel"),this);
	lpEdit   = new QMultiLineEdit(this);
	lpTxt    = new QLabel(szText.data(),this);
	lpEdit->setFocus();
	lpRet=pRet;
	(*lpRet)=KVI_STR_NULL;
	connect(lpOk,SIGNAL(clicked()),this,SLOT(okClicked()));
	connect(lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	resize(300,200);
}
KviInputBox::~KviInputBox()
{
	delete lpOk;
	delete lpCancel;
	delete lpEdit;
	delete lpTxt;
}
void KviInputBox::okClicked()
{
	(*lpRet)=lpEdit->text();
	accept();
}
void KviInputBox::resizeEvent(QResizeEvent *)
{
	lpTxt->setGeometry(10,10,width()-20,56);
	lpEdit->setGeometry(10,70,width()-20,height()-115);
	lpOk->setGeometry((width()/2)+2,height()-36,(width()/2)-12,26);
	lpCancel->setGeometry(10,height()-36,(width()/2)-12,26);
}
//
//
//
KviIdentifiers::KviIdentifiers(KviFrame *lpFrame,KviUserParser *lpParser)
{
	m_lpPar=lpParser;
	m_lpFrm=lpFrame;
	m_lpSock=lpFrame->m_lpSock;
	m_lpCons=lpFrame->m_lpConsole;
	m_lpMdi=lpFrame->m_lpMdi;
	m_lpGlb=lpFrame->m_lpGlb;
	m_lpOpt=lpFrame->m_lpOpt;
	m_lpVarList=lpParser->m_lpVarList;
//	m_lpCache=lpParser->m_lpCache;
}
KviIdentifiers::~KviIdentifiers()
{
}
//============ substituteIdentifiers ============//
#define _isIdn(__chidn,__chlen) (!strncasecmp(__chidn,pData,__chlen))
#define _doRplNrm(__chlen,__strng) szData.replace(idx,__chlen,__strng)
#define _doRplStr(__chlen,__strng) szData.replace(idx,__chlen,(__strng.isEmpty() ? KVI_STR_NULL : __strng.data()))
#define _doRplStrNoNull(__chlen,__strng) szData.replace(idx,__chlen,__strng.data())
#define _doRplDbl(__chlen,__strng) { szData.replace(idx,__chlen,__strng); idx-- ; }
void KviIdentifiers::substitute(KviMdiChild *lpC,QString &szData,KviAliasParams *pP)
{
	_debug_entertrace("substituteIdentifiers");
	if(szData.isEmpty())return;
	if(!lpC)lpC=m_lpCons;
	const char *pData=szData.data();
	const char *pC=strchr(pData,'$');
	int idx=0;

	while(pC){
		idx=(int)(pC-pData);
		// Point pData to the letter after '$'
		pData=pC+1;
		if(!pData)return;
//		debug("Substituting %s",pC);
		//
		// Check for alias parameters...$0 $1 $2 $X-
		//
		if(pP && (*pData>='0') && (*pData<='9')){
			int nIndex=(*pData)-'0';
			const char *pD=pData+1;
			if(*pD=='-'){
				pData++;
				QString szPrm="";
				for(int i=nIndex;i<10;i++){
					if(pP->param[i].isEmpty())break;
					else {
						if(i != nIndex)szPrm+=' ';
						szPrm+=pP->param[i];
					}
//					if(strcmp(pP->param[i],KVI_STR_NULL)){
//						if(i != nIndex)szPrm+=' ';
//						szPrm+=pP->param[i];
//					}
				}
				int idxS=szPrm.find('$');
				if(idxS != -1){
					while(idxS != -1){
						szPrm.remove(idxS,1); //remove all '$'
						idxS=szPrm.find('$');
					}
				}
				_doRplStrNoNull(3,szPrm);
			} else {
//				debug("pP->param[nIndex]==%s",pP->param[nIndex].data());
				int idxS=pP->param[nIndex].find('$');
				if(idxS != -1){
					QString szPara=pP->param[nIndex].copy();
					while(idxS != -1){
						szPara.remove(idxS,1); //remove all '$'
						idxS=szPara.find('$');
					}
					_doRplStrNoNull(2,szPara);
				} else _doRplStrNoNull(2,pP->param[nIndex]); 
			}
		// %_variable %^?[]
		//Check for system variables
		//
		} else if(*pData=='_'){
			if(_isIdn("_MY" , 3)){
					     if( _isIdn("_MYNICK"    , 7 ))_doRplStr(8 ,m_lpGlb->szNick);
					else if( _isIdn("_MYIP"      , 5 ))_doRplStr(6 ,m_lpGlb->szLocalHostIp);
					else if( _isIdn("_MYSERVERIP", 11))_doRplStr(12,m_lpGlb->szServerIp);
					else if( _isIdn("_MYSERVER"  , 9 ))_doRplStr(10,m_lpGlb->szServerName);
					else if( _isIdn("_MYADDRESS" , 10))_doRplStr(11,m_lpGlb->szHostName);
					else if( _isIdn("_MYNETWORK" , 10))_doRplStr(11,m_lpGlb->szNetworkName);
					else if( _isIdn("_MYPORT"    , 7 ))_doRplStr(8 ,m_lpGlb->szPort);
					else if( _isIdn("_MYREALNAME", 11))_doRplStr(12,m_lpGlb->szRealName);
					else if( _isIdn("_MYUSERNAME", 11))_doRplStr(12,m_lpGlb->szUserName);
					else if( _isIdn("_MYMASK"    , 7 )){
						if(m_lpGlb->szMaskFromServer.isEmpty())_doRplDbl(8 ,"$_mynick!$_myusername@$_myip")	
						else _doRplStr(8,m_lpGlb->szMaskFromServer);
					}
			} else if(_isIdn("_DIR",4)){
				if(_isIdn("_DIRHOME",8))_doRplNrm(9,QDir::homeDirPath().data());
				else if(_isIdn("_DIRKVIRC",9))_doRplNrm(10,_macro_getKVircHomeDirectory(0).data());
			} else if( _isIdn("_WINDOW"    , 7 ))_doRplNrm(8 ,lpC->name());
			else if( _isIdn("_VERSION"   , 8 ))_doRplNrm(9 ,KVI_VERSION);
			else if( _isIdn("_STATUS"    , 7 ))_doRplNrm(8 ,KVI_STATUS_WND_NAME);
			else if( _isIdn("_ACTIVEWND" , 10)){
				if(m_lpMdi->topChildInZOrder()){
					_doRplNrm(11,m_lpMdi->topChildInZOrder()->name());
				} else _doRplNrm(11,KVI_STR_NULL);
			} else if( _isIdn("_CHAN"      , 5 )){
				if(lpC->type()==KVI_WND_TYPE_CHAN)_doRplNrm(6 ,lpC->name());
				else _doRplNrm(6,KVI_STR_NULL);
			} else if( _isIdn("_FALSE"     , 6 ))_doRplNrm(7 ,KVI_STR_FALSE);
			else if( _isIdn("_NULL"      , 5 ))_doRplNrm(6 ,KVI_STR_NULL);
			else if( _isIdn("_TRUE"      , 5 ))_doRplNrm(6 ,KVI_STR_TRUE);
			else if( _isIdn("_$"         , 2 ))_doRplNrm(3 ,"$");
			else if( _isIdn("_:"         , 2 ))_doRplNrm(3 ,";");
			else if( _isIdn("_["         , 2 ))_doRplNrm(3 ,"<");
			else if( _isIdn("_]"         , 2 ))_doRplNrm(3 ,">");
			else if( _isIdn("_DATE"      , 5 ))_doRplNrm(6 ,QDate::currentDate().toString().data());
			else if( _isIdn("_TIME"      , 5 ))_doRplNrm(6 ,QTime::currentTime().toString().data());
			else if( _isIdn("_K"         , 2 ))_doRplNrm(3 ,"\3");
			else if( _isIdn("_R"         , 2 ))_doRplNrm(3 ,"\x16");
			else if( _isIdn("_O"         , 2 ))_doRplNrm(3 ,"\x0f");
			else if( _isIdn("_U"         , 2 ))_doRplNrm(3 ,"\x1f");
			else if( _isIdn("_B"         , 2 ))_doRplNrm(3 ,"\2");
			else if( _isIdn("_SELECTED"  , 9 ))_doRplStr(10,m_lpGlb->szCurrentSelection);
			else if( _isIdn("_TARGET"    , 7 )){
				switch(lpC->type()){
					case KVI_WND_TYPE_CHAN:
					case KVI_WND_TYPE_QUERY:
						_doRplNrm(8,lpC->name());
						break;
					case KVI_WND_TYPE_CHAT:
						_doRplStr(8,((KviChatWnd *)lpC)->m_szRemoteNick);
						break;
					case KVI_WND_TYPE_SEND:
						_doRplStr(8,((KviSendWnd *)lpC)->m_szRemoteNick);
						break;
					default:
						_doRplNrm(8,KVI_STR_NULL);
						break;
				}
			} else if( _isIdn("_ALL"       , 4 )){
				if( _isIdn("_ALLCHANS"  , 9 )){
					KviMdiChild *lpC=0;
					QString chans="";
					for(lpC=m_lpMdi->m_lpChildList->first();lpC;lpC=m_lpMdi->m_lpChildList->next()){
						if(lpC->type()==KVI_WND_TYPE_CHAN){ chans+=QString(lpC->name()); chans+=',';}
					}
					if(!chans.isEmpty())chans.remove((chans.length()-1),1);
					_doRplStr(10,chans);
				} else if(_isIdn("_ALLQUERIES",11)){
					KviMdiChild *lpC=0;
					QString qrs="";
					for(lpC=m_lpMdi->m_lpChildList->first();lpC;lpC=m_lpMdi->m_lpChildList->next()){
						if(lpC->type()==KVI_WND_TYPE_QUERY){ qrs+=QString(lpC->name()); qrs+=',';}
					}
					if(!qrs.isEmpty())qrs.remove((qrs.length()-1),1);
					_doRplStr(12,qrs);		
				} else if(_isIdn("_ALLCHATS",9)){
					KviMdiChild *lpC=0;
					QString chats="";
					for(lpC=m_lpMdi->m_lpChildList->first();lpC;lpC=m_lpMdi->m_lpChildList->next()){
						if(lpC->type()==KVI_WND_TYPE_CHAT){ chats+=QString(lpC->name()); chats+=',';}
					}
					if(!chats.isEmpty())chats.remove((chats.length()-1),1);
					_doRplStr(10,chats);		
				} else if(_isIdn("_ALLCHATTARGETS",15)){
					KviMdiChild *lpC=0;
					QString chats="";
					for(lpC=m_lpMdi->m_lpChildList->first();lpC;lpC=m_lpMdi->m_lpChildList->next()){
						if(lpC->type()==KVI_WND_TYPE_CHAT){ 
							chats+=((KviChatWnd *)lpC)->m_szRemoteNick; chats+=',';
						}
					}
					if(!chats.isEmpty())chats.remove((chats.length()-1),1);
					_doRplStr(16,chats);			
				}
			}
		} else if(*pData=='%'){
			const char *pDL=pData;
			while((*pDL) && (*pDL!='['))pDL++;
			if(*pDL){
				const char *pDR=(++pDL);
				int match=1;
				while((*pDR)&& match){
					pDR++;
					if(*pDR=='[')match++;
					else if(*pDR==']')match--;
				}
				if(*pDR){
					// something %^ident[something]something
					//            |      |        |
					//         pData    pDL       pDR
					QString szIdent(pData,(pDL-pData)+1);
					QString szIdPar(pDL,(pDR-pDL)+1);
					int nLen=(pDR-pData)+2;
					QString szRepl="";
					if(getReplacement(lpC,szIdent,szIdPar,szRepl,pP))_doRplStr(nLen,szRepl);
				}
			}
		} else { //Look in the user variables
			KviVariable *lpV=0;
			bool bFound=false;
			for(lpV=m_lpVarList->first();(lpV && (!bFound));lpV=m_lpVarList->next()){
				if(!strncasecmp(lpV->szName.data(),pC,strlen(lpV->szName.data()))){
					bFound=true;
					//checkl for loops here
					int idxS=lpV->szValue.find('$');
//					debug("found subs : %s",lpV->szValue.data());
					if(idxS != -1){
						QString szPara=lpV->szValue.copy();
						while(idxS != -1){
							szPara.remove(idxS,1); //remove all '$'
							idxS=szPara.find('$');
						}
						_doRplStr(strlen(lpV->szName.data()),szPara);
					} else _doRplStr(strlen(lpV->szName.data()),lpV->szValue);
				}
			}
			if(!bFound){ //replace with NOTHING up to space ,;])
				_doRplNrm(strcspn(pC," ,*^|&+-=/;])\n\t\r\x02\x03\x0f\x1f\x16"),"");
			}
		}
		pData=szData.data();
		pC=(pData+idx+1);
		if(!(*pC))return;
		pC = strchr(pC,'$');
	}
	_debug_leavetrace("substituteIdentifiers");
}

//============ getReplacement ============//

bool KviIdentifiers::getReplacement(KviMdiChild *lpC,QString &szIdn,QString &szPar,QString &szRepl,KviAliasParams *pP)
{
	_debug_entertrace("getReplacement");
	const char *pData=szIdn.data();
	if(_isIdn("%chn_",5)){
		substitute(lpC,szPar,pP);
		szPar=szPar.stripWhiteSpace();
		KviChanWnd *lpX=getChanWnd(szPar.data());
		if(_isIdn("%chn_opcount"    ,12)){
			if(lpX)szRepl.setNum(lpX->m_lpListBox->m_iOp);
			return true;
		}
		if(_isIdn("%chn_voicecount" ,15)){
			if(lpX)szRepl.setNum(lpX->m_lpListBox->m_iVoice);
			return true;
		}
		if(_isIdn("%chn_count"      ,10)){
			if(lpX)return szRepl.setNum(lpX->m_lpListBox->m_iTotal);
			return true;
		}
		if(_isIdn("%chn_nopcount"   ,13)){
			if(lpX)szRepl.setNum( (lpX->m_lpListBox->m_iTotal - lpX->m_lpListBox->m_iOp) );
			return true;
		}
		if(_isIdn("%chn_allonchan"  ,14)){
			if(lpX){
				KviNewNick *lpN;
				KviListBoxEntry *lpE;
				int len=0;
				for(lpE=lpX->m_lpListBox->m_lpNickList->first();lpE && (len<400);lpE=lpX->m_lpListBox->m_lpNickList->next()){
					lpN=lpE->lpNick;
					if(len)szRepl+=',';
					szRepl+=lpN->szNick;
					len+=strlen(lpN->szNick.data());
				}
			}
			return true;			
		}
		if(_isIdn("%chn_oponchan"   ,13)){
			if(lpX){
				KviListBoxEntry *lpN;
				int len=0;
				for(lpN=lpX->m_lpListBox->m_lpNickList->first();lpN && (len<400);lpN=lpX->m_lpListBox->m_lpNickList->next()){
					if(lpN->bOp){
						if(len)szRepl+=',';
						szRepl+=lpN->lpNick->szNick;
						len+=strlen(lpN->lpNick->szNick.data());
					}
				}		
			}
			return true;
		}
		if(_isIdn("%chn_voiceonchan",16)){
			if(lpX){
				KviListBoxEntry *lpN=0;
				int len=0;
				for(lpN=lpX->m_lpListBox->m_lpNickList->first();lpN && (len<400);lpN=lpX->m_lpListBox->m_lpNickList->next()){
					if(lpN->bVoice){
						if(len)szRepl+=',';
						szRepl+=lpN->lpNick->szNick;
						len+=strlen(lpN->lpNick->szNick.data());
					}
				}	
			}
			return true;
		}
		if(_isIdn("%chn_noponchan"  ,14)){
			if(lpX){
				KviListBoxEntry *lpN=0;
				int len=0;
				for(lpN=lpX->m_lpListBox->m_lpNickList->first();lpN && (len<400);lpN=lpX->m_lpListBox->m_lpNickList->next()){
					if(!lpN->bOp){
						if(len)szRepl+=',';
						szRepl+=lpN->lpNick->szNick;
						len+=strlen(lpN->lpNick->szNick.data());
					}
				}			
			}
			return true;
		}
		if(_isIdn("%chn_topic"      ,10 )){
			if(lpX)lpX->getTopic(szRepl);
			return true;
		}
		if(_isIdn("%chn_mode"       ,9 )){
			if(lpX){
				lpX->m_lpModeLabel->getMode(szRepl);
			}
			return true;
		}
		return false;
	}
	if(_isIdn("%nck_",5)){ //channel,nick (or nick in isme)
		if(_isIdn("%nck_isme",9)){
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			int idx=szPar.find('!');
			if(idx==-1){
				if(!strcasecmp(szPar.data(),m_lpGlb->szNick.data()))szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			} else {
				if(m_lpGlb->szMaskFromServer.isEmpty()){
					if(!strncasecmp(szPar.data(),m_lpGlb->szNick.data(),idx+1))szRepl=KVI_STR_TRUE;
					else szRepl=KVI_STR_FALSE;
				} else {
					KviNewNick nk(m_lpGlb->szMaskFromServer);
					if(nk.matches(szPar))szRepl=KVI_STR_TRUE;
					else szRepl=KVI_STR_FALSE;
				}		
			}
			return true;
		}
		int idx=szPar.find(',');
		if(idx==-1)return false;
		QString szChan=szPar.left(idx);
		szPar.remove(0,idx+1);
		substitute(lpC,szChan,pP);
		szChan=szChan.stripWhiteSpace();
		substitute(lpC,szPar,pP);
		szPar=szPar.stripWhiteSpace();
		KviChanWnd *lpX=getChanWnd(szChan.data());
		if(_isIdn("%nck_mask"    ,9 )){
			if(lpX){
				KviNewNick *lpN=lpX->getNick(szPar.data());
				if(lpN){
					if(_isIdn("%nck_mask0",10))lpN->mask(szRepl,0);
					else if(_isIdn("%nck_mask1",10))lpN->mask(szRepl,1);
					else if(_isIdn("%nck_mask2",10))lpN->mask(szRepl,2);
					else if(_isIdn("%nck_mask3",10))lpN->mask(szRepl,3);
					else if(_isIdn("%nck_mask4",10))lpN->mask(szRepl,4);
					else if(_isIdn("%nck_mask5",10))lpN->mask(szRepl,5);			
					else if(_isIdn("%nck_mask6",10))lpN->mask(szRepl,6);
					else if(_isIdn("%nck_mask7",10))lpN->mask(szRepl,7);
					else if(_isIdn("%nck_mask8",10))lpN->mask(szRepl,8);			
				}
			}
			return true;
		}
		if(_isIdn("%nck_match",10)){
			if(lpX){
				KviListBoxEntry *lpN=0;
				for(lpN=lpX->m_lpListBox->m_lpNickList->first();lpN;lpN=lpX->m_lpListBox->m_lpNickList->next()){
					if(strcmp(lpN->lpNick->szAddress.data(),KVI_STR_NULL)){ //we know the address
						if(lpN->lpNick->matches(szPar)){
							if(szRepl.isEmpty())szRepl=lpN->lpNick->szNick.copy();
							else {
								szRepl+=',';
								szRepl+=lpN->lpNick->szNick.copy();
							}
						}
					}
				}
			}
			if(szRepl.isEmpty())szRepl=KVI_STR_NULL;
			return true;
		}
		if(_isIdn("%nck_ison"    ,9 )){
			if(lpX){
				szRepl=(lpX->getNick(szPar.data()) ? KVI_STR_TRUE : KVI_STR_FALSE);
			}
			return true;
		}
		if(_isIdn("%nck_address" ,12)){
			if(lpX){
				KviNewNick *lpN=lpX->getNick(szPar.data());
				if(lpN){
					szRepl=lpN->szAddress.data();
				}		
			}
			return true;
		}
		if(_isIdn("%nck_isop"    ,9 )){
			if(lpX){
				KviListBoxEntry *lpN=lpX->getNickEntry(szPar.data());
				if(lpN){
					szRepl=(lpN->bOp ? KVI_STR_TRUE : KVI_STR_FALSE);	
				}		
			}
			return true;
		}
		if(_isIdn("%nck_isvoice" ,12)){
			if(lpX){
				KviListBoxEntry *lpN=lpX->getNickEntry(szPar.data());
				if(lpN){
					szRepl=(lpN->bVoice ? KVI_STR_TRUE : KVI_STR_FALSE);	
				}
			}
			return true;
		}
		return false;
	}
	//is_chan is_chat is_query
	if(_isIdn("%wnd_",5)){
		substitute(lpC,szPar,pP);
		szPar=szPar.stripWhiteSpace();
		KviMdiChild *lpX=m_lpMdi->findWindow(szPar.data());
		if(_isIdn("%wnd_ischan",11)){
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_CHAN)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			}
			return true;
		}
		if(_isIdn("%wnd_ischat",11)){
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_CHAT)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			}
			return true;
		}
		if(_isIdn("%wnd_isquery",12)){
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_QUERY)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			}
			return true;
		}
		if(_isIdn("%wnd_issend",11)){
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_SEND)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			}
			return true;
		}
		if(_isIdn("%wnd_isuserwnd",14)){
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_USER)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			}
			return true;
		}	
		if(_isIdn("%wnd_isstatus",13)){
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_STATUS)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			}
			return true;
		}	
		return false;
	}
	if(_isIdn("%str_",5)){
		if(_isIdn("%str_chr",8)){
			szRepl="";
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			QString szChar;
			while(!szPar.isEmpty()){
//				int Index=szPar.find(',');
//				if(Index==-1){
//					szChar=szPar.copy();
//					szPar="";
//				} else {
//					szChar=szPar.left(Index);
//					szPar.remove(0,Index+1);
//				}
				szChar=getStringToken(szPar,',');
				bool bOk=false;
				char chr=(char)(szChar.toLong(&bOk) % 256);
				if(!bOk)szRepl+=szChar;
				else szRepl+=chr;
			}
			return true;
		}
		int idx=szPar.find(',');
		if(idx==-1){ //string
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			if(_isIdn("%str_length",11)){
				int sln=strlen(szPar.data());
				if(sln==KVI_LENGTH_OF_STR_NULL){
					if(!strncmp(szPar.data(),KVI_STR_NULL,KVI_LENGTH_OF_STR_NULL))sln=0;
				}
				szRepl.setNum(sln);
				return true;
			}
			if(_isIdn("%str_lower",10)){
				szRepl=szPar.lower();
				return true;
			}
			if(_isIdn("%str_upper",10)){
				szRepl=szPar.upper();
				return true;
			}
			if(_isIdn("%str_isnum",10)){
				bool bOk=false;
				szPar.toLong(&bOk);
				if(bOk)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
				return true;
			}
		} else { //string1,string2
			QString szStr1=szPar.left(idx);
			szPar.remove(0,idx+1);
			substitute(lpC,szStr1,pP);
			szStr1=szStr1.stripWhiteSpace();
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			if(_isIdn("%str_equal",10)){
				if(!strcasecmp(szPar.data(),szStr1.data()))szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
				return true;
			}
			if(_isIdn("%str_nequal",11)){
				if(strcasecmp(szPar.data(),szStr1.data()))szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
				return true;	
			}
			if(_isIdn("%str_isin",9)){
				int idx=szPar.find(szStr1.data());
				if(idx==-1)szRepl=KVI_STR_FALSE;
				else szRepl=KVI_STR_TRUE;
				return true;
			}
			if(_isIdn("%str_find",9)){
				int idx=szPar.find(szStr1.data());
				if(idx!=-1)szRepl.setNum(idx);
				else szRepl=KVI_STR_NULL;
				return true;
			}
			if(_isIdn("%str_left",9)){
				bool bOK=false;
				int nLen=szStr1.toInt(&bOK);
				if(!bOK)return false;
				else szRepl=szPar.left(nLen);
				return true;
			}
			if(_isIdn("%str_right",10)){
				bool bOK=false;
				int nLen=szStr1.toInt(&bOK);
				if(!bOK)return false;
				else szRepl=szPar.right(nLen);
				return true;
			}
		}
		return false;
	}
//  if(_isIdn("%str_extract[<stirng-list>]"
//	if(_isIdn("^str_equal"
//  if(_isIdn("%str_cat"
//	if(_isIdn("%str_len"
//  if(_isIdn("%str_find"
//  if(_isIdn("%str_split"
//  if(_isIdn("%str_upper"
//  if(_isIdn("%str_lower"
//  if(_isIdn("%str_eval"
//	if(_isIdn("^eval"
//
// TODO:
//    $%lst_sort
//    $%lst_revsort
//
	if(_isIdn("%box_",5)){
		if(_isIdn("%box_ok",7)){
			substitute(lpC,szPar,pP);
			m_lpFrm->m_bFocusManagingEnabled=false;
			KMsgBox::message(m_lpFrm,KVI_VERSION,szPar.data());
			szRepl=KVI_STR_TRUE;
			m_lpFrm->m_bFocusManagingEnabled=true;
			return true;
		}
		if(_isIdn("%box_yesno",10)){
			substitute(lpC,szPar,pP);
			m_lpFrm->m_bFocusManagingEnabled=false;
			if(KMsgBox::yesNo(m_lpFrm,KVI_VERSION,szPar.data())==1)szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			m_lpFrm->m_bFocusManagingEnabled=true;
			return true;
		}
		if(_isIdn("%box_input",10)){
			substitute(lpC,szPar,pP);
			KviInputBox *theBox=new KviInputBox(m_lpFrm,szPar,&szRepl);
			m_lpFrm->m_bFocusManagingEnabled=false;
			theBox->exec();
			m_lpFrm->m_bFocusManagingEnabled=true;
			delete theBox;
			return true;
		}
		if(_isIdn("%box_openfile",13)){
			substitute(lpC,szPar,pP);
			if(szPar.isEmpty()||(szPar==KVI_STR_NULL)){
				szRepl=_macro_getOpenFileName(0,0,0);
			} else {
				szRepl=_macro_getOpenFileName(0,szPar.data(),0);
			}
			if(szRepl.isEmpty())szRepl=KVI_STR_NULL;
			return true;
		}
		if(_isIdn("%box_savefile",13)){
			substitute(lpC,szPar,pP);
			if(szPar.isEmpty()||(szPar==KVI_STR_NULL)){
				szRepl=_macro_getSaveFileName(0,0,0);
			} else {
				szRepl=_macro_getSaveFileName(0,szPar.data(),0);
			}
			if(szRepl.isEmpty())szRepl=KVI_STR_NULL;
			return true;
		}
		return false;
	}
	if(_isIdn("%fio_",5)){
		if(_isIdn("%fio_isopen",11)){
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			if(m_lpPar->m_lpFileManager->getFileStruct(szPar.data()))szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%fio_readln",11)){
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			if(!m_lpPar->m_lpFileManager->fileReadNextLine(szPar.data(),szRepl))szRepl=KVI_STR_NULL;
			substitute(lpC,szRepl,pP);
			return true;
		}
		if(_isIdn("%fio_randln",11)){
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			if(!m_lpPar->m_lpFileManager->fileReadRandLine(szPar.data(),szRepl))szRepl=KVI_STR_NULL;
			substitute(lpC,szRepl,pP);
			return true;
		}
		if(_isIdn("%fio_writeln",12)){
			substitute(lpC,szPar,pP);
			int idx=szPar.find(',');
			QString szIdent="";
			if(idx != -1){
				szIdent=szPar.left(idx);
				szPar.remove(0,idx+1);
				szIdent=szIdent.stripWhiteSpace();
			} else {
				szRepl=KVI_STR_NULL;
				return true;
			}			
			if(!m_lpPar->m_lpFileManager->fileWriteLine(szIdent.data(),szPar))szRepl=KVI_STR_FALSE;
			else szRepl=KVI_STR_TRUE;
			return true;
		}
		return false;
	}
	if(_isIdn("%cmp_",5)){
		int idx=szPar.find(',');
		if(idx==-1)return false;
		QString szLeft=szPar.left(idx);
		szPar.remove(0,idx+1);
		substitute(lpC,szLeft,pP);
		szLeft=szLeft.stripWhiteSpace();
		substitute(lpC,szPar,pP);
		szPar=szPar.stripWhiteSpace();
		bool bOk=false;
		long num1=szLeft.toLong(&bOk);
		if(!bOk){
			szRepl=KVI_STR_NULL;
			return true;
		}
		bOk=false;
		long num2=szPar.toLong(&bOk);
		if(!bOk){
			szRepl=KVI_STR_NULL;
			return true;
		}	
		if(_isIdn("%cmp_gt",7)){ //szLeft > szPar ?
			if(num1 > num2)szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%cmp_lt",7)){ //szLeft < szPar ?
			if(num1 < num2)szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%cmp_eq",7)){ //szLeft == szPar ?
			if(num1 == num2)szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%cmp_egt",8)){ //szLeft >= szPar ?
			if(num1 >= num2)szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%cmp_elt",8)){ //szLeft <= szPar ?
			if(num1 <= num2)szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		return false;
	}

	if(_isIdn("%cal_",5)){
		if(_isIdn("%cal_not",8)){ //~szLeft
			substitute(lpC,szPar,pP);
			bool bOk=false;
			long num1=szPar.toLong(&bOk);
			if(!bOk){
				szRepl=KVI_STR_NULL;
				return true;
			}
			szRepl.setNum(((long)~num1));
			return true;
		}
		int idx=szPar.find(',');
		if(idx==-1)return false;
		QString szLeft=szPar.left(idx);
		szPar.remove(0,idx+1);
		substitute(lpC,szLeft,pP);
		szLeft=szLeft.stripWhiteSpace();
		substitute(lpC,szPar,pP);
		szPar=szPar.stripWhiteSpace();
		bool bOk=false;
		long num1=szLeft.toLong(&bOk);
		if(!bOk){
			szRepl=KVI_STR_NULL;
			return true;
		}
		bOk=false;
		long num2=szPar.toLong(&bOk);
		if(!bOk){
			szRepl=KVI_STR_NULL;
			return true;
		}	
		if(_isIdn("%cal_add",8)){ //szLeft + szPar ?
			szRepl.setNum(((long)num1+num2));
			return true;
		}
		if(_isIdn("%cal_sub",8)){ //szLeft - szPar ?
			szRepl.setNum(((long)num1-num2));
			return true;
		}
		if(_isIdn("%cal_mul",8)){ //szLeft * szPar ?
			szRepl.setNum(((long)num1 * num2));
			return true;
		}
		if(_isIdn("%cal_div",8)){ //szLeft / szPar ?
			if(num2==0)szRepl="0";
			else szRepl.setNum(((long)num1 / num2));
			return true;
		}
		if(_isIdn("%cal_mod",8)){ //szLeft % szPar ?
			if(num2==0)szRepl="0";
			else szRepl.setNum(((long)num1 % num2));
			return true;
		}
		if(_isIdn("%cal_and",8)){ //szLeft & szPar ?
			szRepl.setNum(((long)num1 & num2));
			return true;
		}
		if(_isIdn("%cal_or",7)){ //szLeft | szPar ?
			szRepl.setNum(((long)num1 | num2));
			return true;
		}
		if(_isIdn("%cal_xor",8)){ //szLeft xor szPar ?
			szRepl.setNum(((long)num1 ^ num2));
			return true;
		}
		if(_isIdn("%cal_shl",8)){ //szLeft << szPar ?
			szRepl.setNum(((long)num1 << num2));
			return true;
		}
		if(_isIdn("%cal_shr",8)){ //szLeft >> szPar ?
			szRepl.setNum(((long)num1 >> num2));
			return true;
		}
		return false;
	}
	if(_isIdn("%ext_",5)){
		if(_isIdn("%ext_isset",10)){
			szPar=szPar.stripWhiteSpace();
			KviVariable *lpV=0;
			for(lpV=m_lpVarList->first();lpV;lpV=m_lpVarList->next()){
				if(!strcasecmp(lpV->szName.data(),szPar.data())){
					szRepl=KVI_STR_TRUE;
					return true;
				}
			}
			szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%ext_istimer",12)){
			szPar=szPar.stripWhiteSpace();
			if(m_lpPar->m_lpTimerManager->getTimer(szPar.data()))szRepl=KVI_STR_TRUE;
			else szRepl=KVI_STR_FALSE;
			return true;
		}
		if(_isIdn("%ext_ismeop",11)){
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			KviChanWnd *lpX=getChanWnd(szPar.data());
			if(lpX){
				if(lpX->m_bIsMeOp)szRepl=KVI_STR_TRUE;
				else szRepl=KVI_STR_FALSE;
			} else szRepl=KVI_STR_NULL;
			return true;
		}
		if(_isIdn("%ext_dynamic",12)){
			if(!szPar.isEmpty()){
				if(szPar[0]=='$'){
					szPar.remove(0,1);
					substitute(lpC,szPar,pP);
					szPar=szPar.stripWhiteSpace();
					szRepl="$";
					szRepl+=szPar;
					substitute(lpC,szRepl,pP);
				} else szRepl=KVI_STR_NULL;
			} else szRepl=KVI_STR_NULL;
			return true;
		}
		if(_isIdn("%ext_alias",9)){
			substitute(lpC,szPar,pP);
			szPar=szPar.stripWhiteSpace();
			if(!szPar.isEmpty()){
				const char *pC=szPar.data();
				KviAliasStruct *lpA;
				for(lpA=m_lpPar->m_lpAliasList->first();lpA;lpA=m_lpPar->m_lpAliasList->next()){
					int iLen=strlen(lpA->szName.data());
					if(!strncasecmp((pC),lpA->szName.data(),iLen)){
						const char *ptrToEnd=pC+iLen;
						if((*ptrToEnd==' ')||(*ptrToEnd=='\n')||(*ptrToEnd=='\t')||(!(*ptrToEnd))){
							pC=ptrToEnd;
							while((*pC) && ((*pC == ' ')||(*pC=='\n')||(*pC=='\t')))pC++;
							QString szParams="";
							if(*pC){
								//const char *rghPtr=pC;
								//_macro_skipUpToEndOfCmd(rghPtr);
								szParams=QString(pC);
								//m_lpIdentifiers->substitute(lpC,szParams,pP);
								//pC=rghPtr;
							}
							KviAliasParams *lpAliParams=new KviAliasParams;
							m_lpPar->executeAlias(lpC,lpA,szParams,lpAliParams);
							szRepl=lpAliParams->szReturn.copy();
							delete lpAliParams;
							return true;
						}
					}
				}
			} else szPar="None";
			szRepl=KVI_STR_NULL;
			lpC->doFmtOutput(KVI_OUT_ERROR,"[ALIAS FUNCTION] : Warning : alias %s not found.",szPar.data());
			return true;
		}
		return false;
	}
	if(_isIdn("%lst_",5)){ //lst_functionname[(string),string-list]
		if(_isIdn("%lst_count",10)){
			substitute(lpC,szPar,pP);
			int count=szPar.contains(',');
			if(count){
				count++;
				szRepl.setNum(count);
			} else {
				if(!strcmp(KVI_STR_NULL,szPar.data()))szRepl="0";
				else if(szPar.isEmpty())szRepl="0";
				else szRepl="1";
			}
			return true;
		}
		int idx=szPar.find(',');	
		QString szStr1=szPar.left(idx);
		szPar.remove(0,idx+1);
		substitute(lpC,szStr1,pP);
		szStr1=szStr1.stripWhiteSpace();
		substitute(lpC,szPar,pP);
		szPar=szPar.stripWhiteSpace();
		if(_isIdn("%lst_append",11)){
			if(!strcmp(KVI_STR_NULL,szPar.data())){
				szRepl=szStr1.copy();
			} else if(szPar.isEmpty()){
				szRepl=szStr1.copy();
			} else {
				szRepl=szPar.copy();
				szRepl+=',';
				szRepl+=szStr1;
			}
			return true;
		}
		if(_isIdn("%lst_prepend",12)){
			if(!strcmp(KVI_STR_NULL,szPar.data())){
				szRepl=szStr1.copy();
			} else if(szPar.isEmpty()){
				szRepl=szStr1.copy();
			} else {
				szRepl=szStr1.copy();
				szRepl+=',';
				szRepl+=szPar;
			}
			return true;
		}
		if(_isIdn("%lst_remove",11)){
			if(!strcmp(KVI_STR_NULL,szPar.data())){
				szRepl=KVI_STR_NULL;
			} else if(szPar.isEmpty()){
				szRepl=KVI_STR_NULL;
			} else {
				QString szDumPar=',';
				szDumPar+=szPar;
				szDumPar+=',';
				QString szDumStr1=',';
				szDumStr1+=szStr1;
				szDumStr1+=',';
				int idx=szDumPar.find(szDumStr1.data(),0,false);
				if(idx==-1)szRepl=szPar.copy();
				else { //need to remove that item from szPar
					if(idx==0){
						int idxc=szPar.find(',');
						if(idxc != -1){
							szRepl=szPar.remove(0,idxc+1).copy();
						} else {
							szRepl=KVI_STR_NULL;
						}
					} else { //somewhere in the middle
						szRepl=szPar.left(idx-1); //copy the left part
						int idxc=szPar.find(',',idx);
						if(idxc != -1){ //there are following elements
							szRepl+=szPar.remove(0,idxc);
						}
					}
				}
			}
			return true;	
		}
		if(_isIdn("%lst_item",9)){
			if(!strcmp(KVI_STR_NULL,szPar.data())){
				szRepl=KVI_STR_NULL;
			} else if(szPar.isEmpty()){
				szRepl=KVI_STR_NULL;
			} else {
				bool bOK=false;
				uint nIdx=szStr1.toUInt(&bOK);
				if(bOK){
					for(uint i=0;i<nIdx;i++){
						int idx=szPar.find(',');
						if(idx!=-1){
							szPar.remove(0,idx+1);
						} else {
							szRepl=KVI_STR_NULL;
							return true;
						}
					}
					int idx=szPar.find(',');
					if(idx!=-1){
						szRepl=szPar.left(idx);
					} else {
						if(szPar.isEmpty()){
							szRepl=KVI_STR_NULL;
							return true;
						}
						szRepl=szPar.copy();
						return true;
					}	
				} else {
					szRepl=KVI_STR_NULL;
				}
			}
			return true;
		}
		if(_isIdn("%lst_find",9)){
			if(!strcmp(KVI_STR_NULL,szPar.data())){
				szRepl=KVI_STR_NULL;
			} else if(szPar.isEmpty()){
				szRepl=KVI_STR_NULL;
			} else {
				QString szTmp;
				int index=0;
				while(!szPar.isEmpty()){
//					int idx=szPar.find(',');
//					if(idx!=-1){
//						szTmp=szPar.left(idx);
//						szPar.remove(0,idx+1);
//					} else {
//						szTmp=szPar.copy();
//						szPar="";
//					}
					szTmp=getStringToken(szPar,',');
					if(!strcasecmp(szTmp.data(),szStr1.data())){
						szRepl.setNum(index);
						return true;
					}
					index++;
				}
				szRepl=KVI_STR_NULL;
			}
			return true;
		}
		if(_isIdn("%lst_contains",13)){
			if(!strcmp(KVI_STR_NULL,szPar.data())){
				szRepl=KVI_STR_NULL;
			} else if(szPar.isEmpty()){
				szRepl=KVI_STR_NULL;
			} else {
				QString szTmp;
				while(!szPar.isEmpty()){
//					int idx=szPar.find(',');
//					if(idx!=-1){
//						szTmp=szPar.left(idx);
//						szPar.remove(0,idx+1);
//					} else {
//						szTmp=szPar.copy();
//						szPar="";
//					}
					szTmp=getStringToken(szPar,',');
					if(!strcasecmp(szTmp.data(),szStr1.data())){
						szRepl=KVI_STR_TRUE;
						return true;
					}
				}
				szRepl=KVI_STR_FALSE;
			}
			return true;
		}
		return false;
	}
	return false;
	_debug_leavetrace("getReplacement");
}


//============ getChanWnd ============//

KviChanWnd * KviIdentifiers::getChanWnd(const char *szName)
{
	_debug_entertrace("getChanWnd");
	KviMdiChild *lpW=m_lpMdi->findWindow(szName);
	if(lpW){
		if(lpW->type()==KVI_WND_TYPE_CHAN)return (KviChanWnd *)lpW;
		else return 0;
	} else return 0;
	_debug_leavetrace("getChanWnd");
}
#include "m_kvi_ident.moc"

//
// $Log: kvi_ident.cpp,v $
// Revision 1.6  1998/10/06 14:42:25  pragma
// Tons of changes
//
// Revision 1.5  1998/09/23 12:41:40  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.4  1998/09/20 20:22:44  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/16 17:16:21  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:14  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
