//   $Id: kvi_listen.cpp,v 1.2 1998/09/20 20:23:04 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviListeningSocket"

#include "kvi_listen.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_opt.h"
#include "kvi_support.h"

#include <qtimer.h>
#include <unistd.h>


KviListeningSocket::KviListeningSocket() : QObject(0,0)
{
	m_iPort=0;
	m_Sock=-1;
	m_lpSocketNotifier=0;
	m_bUsed=false;
	m_lpTimer=new QTimer();
	connect(m_lpTimer,SIGNAL(timeout()),this,SLOT(slotConnectTimedOut()));
}

KviListeningSocket::~KviListeningSocket()
{
	if(m_lpTimer->isActive())m_lpTimer->stop();
	delete m_lpTimer;
	stopListening();
}
//============ listenForConnection ============//
bool KviListeningSocket::listenForConnection(unsigned short int onPort,int *lpSock,KviFrame *lpFrm)
{
	_debug_entertrace("listenForConnection");
	if(m_bUsed){
		debug("Can't use two times the same soket..");
		ASSERT(false);
	}
	m_bUsed=true;
	m_lpSock=lpSock;
	m_iPort=onPort;
 	struct sockaddr_in sockAddress;
	bzero((char *) &sockAddress, sizeof(sockAddress));
	sockAddress.sin_family = AF_INET;
	sockAddress.sin_port   = htons(onPort);
	sockAddress.sin_addr.s_addr = INADDR_ANY;
	if((m_Sock = socket(PF_INET,SOCK_STREAM,0)) < 0)return false;
	if((bind(m_Sock,(struct sockaddr *) &sockAddress,sizeof(sockAddress))<0)||(listen(m_Sock,100)<0) ) {
		stopListening();
		return false;
	}
	ksize_t size=sizeof(sockAddress);
	getsockname(m_Sock, (struct sockaddr*)&sockAddress, &size );
	m_iPort = ntohs(sockAddress.sin_port);
	m_lpSocketNotifier=new QSocketNotifier(m_Sock, QSocketNotifier::Read, this);
	QObject::connect(m_lpSocketNotifier, SIGNAL(activated(int)), this, SLOT(slotGotConnection(int)));
	m_lpTimer->start(lpFrm->m_lpOpt->iDCCCHATTimeout * 1000);
	_debug_leavetrace("listenForConnection");
	return true;
}

//============ stopListening ============//

void KviListeningSocket::stopListening()
{
	_debug_entertrace("stopListening");
	if(m_lpSocketNotifier){
		delete m_lpSocketNotifier;
		m_lpSocketNotifier=0;
	}
	if(m_Sock != -1){
		::close(m_Sock);
		m_Sock=-1;
	}
	m_iPort=0;
	_debug_leavetrace("stopListening");
}
//============ slotConnectTimedOut ============//
void KviListeningSocket::slotConnectTimedOut()
{
	_debug_entertrace("slotConnectTimedOut");
	emit connectTimedOut();
	m_lpTimer->stop();
	stopListening();
	_debug_leavetrace("slotConnectTimedOut");
}
//============ slotGotConnection ============//
void KviListeningSocket::slotGotConnection(int)
{
	_debug_entertrace("slotGotConnection");
	ksize_t size = sizeof(connectedAddr);
	(*m_lpSock) = accept(m_Sock, (struct sockaddr*)&connectedAddr, &size);
	if((*m_lpSock)==-1){
		debug("warning : accept returns -1...waiting for the next notifier call (or timeout)");
	} else {
		if(m_lpTimer->isActive())m_lpTimer->stop();
		emit gotConnection();
		stopListening();
	}
	_debug_leavetrace("slotGotConnection");
}

#include "m_kvi_listen.moc"
