//
//   File : kvi_listen.h (/usr/cvs/kvirc/kvirc/kvi_listen.h)
//   Last modified : Sat Dec 5 1998 01:42:21 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_LISTEN_H_INCLUDED_
#define _KVI_LISTEN_H_INCLUDED_

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <qsocketnotifier.h>

class KviFrame;


class KviListeningSocket : public QObject{
	Q_OBJECT
public:
	KviListeningSocket();
	~KviListeningSocket();
public:
	struct sockaddr_in	connectedAddr;
	unsigned short int	m_iPort;
private:
	int					m_Sock;
	int					*m_lpSock;
	QSocketNotifier		*m_lpSocketNotifier;
	bool				m_bUsed;
	QTimer				*m_lpTimer;
public:
	bool listenForConnection(unsigned short int onPort,int *lpSock,KviFrame *lpFrm);
	void stopListening();
protected slots:
	void slotGotConnection(int);
	void slotConnectTimedOut();
signals:
	void gotConnection();
	void connectTimedOut();
};


#endif //_KVI_LISTEN_H_INCLUDED_
